unit colpickp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TColorPickPanel = class(TCustomPanel)
  private
    { Private declarations }
    FMouseIn: Boolean;
    FEnabled: Boolean;
    FUseDialog: Boolean;
    FColorDialog: TColorDialog;
  protected
    { Protected declarations }
    procedure CMMouseEnter(var Msg: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Msg: TMessage); message CM_MOUSELEAVE;
    procedure SetColorDialog(Value: TColorDialog);
    procedure Click; override;
    procedure SetEnabled(Value: Boolean);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    procedure Paint; override;
  published
    { Published declarations }
    property ColorDialog: TColorDialog read FColorDialog write SetColorDialog;
    property UseColorDialog: Boolean read FUseDialog write FUseDialog;
    property Align;
    property Color;
    property Ctl3D;
    property Cursor;
    property DragCursor;
    property DragMode;
    property Enabled: Boolean read FEnabled write SetEnabled;
    property Font;
    property Height;
    property HelpContext;
    property Hint;
    property Left;
    property Locked;
    property Name;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Tag;
    property Top;
    property Visible;
    property Width;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnResize;
    property OnStartDrag;
  end;

procedure Register;

implementation

constructor TColorPickPanel.Create(AOwner: TComponent);
begin
 inherited;
 FMouseIn := False;
 FEnabled := True;
 FUseDialog := False;
 Height := 21;
 Width := 21;
end;

procedure TColorPickPanel.SetEnabled(Value: Boolean);
begin
 FEnabled := Value;
 Invalidate;
end;

procedure TColorPickPanel.SetColorDialog(Value: TColorDialog);
begin
 if FColorDialog <> Value
  then FColorDialog := Value;
end;

procedure TColorPickPanel.Click;
begin
 if FUseDialog and (FColorDialog <> nil) and Enabled
  then
   begin
    FColorDialog.Color := Color;
    if FColorDialog.Execute
     then Color := FColorDialog.Color;
   end;
 Repaint;
 Invalidate;
 inherited;
end;

procedure TColorPickPanel.CMMouseEnter(var Msg: TMessage);
begin
  inherited;
  FMouseIn := True;
  Repaint;
end;

procedure TColorPickPanel.CMMouseLeave(var Msg: TMessage);
begin
  inherited;
  FMouseIn := False;
  Repaint;
  Invalidate;
end;

procedure TColorPickPanel.Paint;
var R: TRect;
begin
 Canvas.Brush.Color := Color;
 Canvas.Brush.Style := bsSolid;
 R := Rect( 0, 0, Width, Height );
 if Enabled
  then
   begin
    if FMouseIn
     then
      begin
       Frame3D(Canvas, R, clBtnShadow, clBtnHighlight, 1);
       Frame3D(Canvas, R, cl3DDkShadow, clBtnFace, 1);
       Canvas.Brush.Color := Color;
       Canvas.Brush.Style := bsSolid;
       Canvas.FillRect(R);
      end
     else
      begin
       Frame3D(Canvas, R, clBtnShadow, clBtnHighlight, 1);
       Canvas.Brush.Color := Color;
       Canvas.Brush.Style := bsSolid;
       Canvas.FillRect(R);
      end;
   end
  else
   begin
    Frame3D(Canvas, R, clBtnShadow, clBtnHighlight, 1);
    Canvas.Brush.Color := clBtnFace;
    Canvas.Brush.Style := bsSolid;
    Canvas.FillRect(R);
   end;
end;


procedure Register;
begin
  RegisterComponents('Samples', [TColorPickPanel]);
end;

end.
