unit Unit1;

interface

uses
  Windows, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Inifiles, ExtCtrls, Tomcard2, Menus;

type
  TPiletype = ( ptStock, ptWaste, ptTableau, ptFoundation, ptSingle, ptOther, ptHidden );
  TOrientation = ( poVert, poHoriz, poNeither, poRHoriz );

  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Game1: TMenuItem;
    About1: TMenuItem;
    About2: TMenuItem;
    Undo1: TMenuItem;
    Newgame1: TMenuItem;
    Replay1: TMenuItem;
    Exit1: TMenuItem;
    Selectdifferentgame1: TMenuItem;
    N1: TMenuItem;
    Numbers: TImage;
    Suits: TImage;
    Cursorcard: TImage;
    Autoplay1: TMenuItem;
    HowtoPlay1: TMenuItem;
    N2: TMenuItem;
    About3: TMenuItem;
    ScoreMenu: TMenuItem;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure DispatchClick(Sender: TObject);
    procedure Newgame1Click(Sender: TObject);
    procedure Autoplay1Click(Sender: TObject);
    procedure Selectdifferentgame1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure HowtoPlay1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Undo1Click(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button1Click(Sender: TObject);
    procedure About3Click(Sender: TObject);
  private
    { Private declarations }
  public
    gnames: TStringlist;
    helptext: string;                   {what it says}
    { Public declarations }
  end;

  TPile = class( TScrollBox )
  public
    Piletype: TPiletype;
    Pickrule: Longint;
    Droprule: Longint;
    EDroprule: Longint;
    Showrule: Longint;
    Dealpattern: String;
    Orientation: TOrientation;
    PPileRule: Longint;
    Res2: Longint;
    Res3: Longint;
  end;


var
  Form1: TForm1;

implementation

uses Unit2, Unit3, Unit4, Unit6;

{$R *.DFM}

procedure shuffleanddeal( replay: boolean ); forward;
procedure showpile( APile: TPile ); forward;
procedure pickcard(Whichcard: TCards); forward;
procedure dropcard( ToPile, FromPile: TPile; FPC: integer ); forward;
procedure selectcard( FromPile: TPile; i, j: integer ); forward;
function candrop( ToPile, FromPile: TPile; FPC: integer ): Boolean; forward;
procedure DrawCustomCursor( MyCard: TCards ); forward;
procedure pickpile( APile: TPile ); forward;
procedure autoplay; forward;
function autoplay2( FromPile: TPile ): Boolean; forward;
procedure updatescore; forward;
procedure freepiles; forward;
procedure SetUndo( Pfrom, Pto: TPile; Num: integer; Ffrom, Fto, FReverse, FOK: boolean ); forward;
procedure Postdrop( ToPile, FromPile: TPile ); forward;
procedure Postpick( Whichcard: TCards; FromPile: TPile ); forward;
procedure Prepick( Whichcard: TCards; FromPile: TPile ); forward;
function PyramidTest( ToPile: TPile ): boolean; forward;

type
  Tundo = record
    UFrom, UTo: TPile;
    UNum: integer;        // number of cards that moved
    UHidefrom: boolean;      // if true, set top FromPile card to ctBack before returning cards
    UHideto: boolean;     // if true, set returning cards to ctBack
    UReverse: boolean;      // if true, re-lay cards in REVERSE order (returning to stock)
  end;

const
  gcheight: integer = 96;           {height of images in CARDS.DLL}
  gcwidth: integer = 71;            {card width}

var
  card: array[1..104] of TCards;      {two decks of cards}
  cardpix: array[1..53] of TCards;    {spare set of card images & back, used only to correct resource-usage flaw in TCards}
  gMark: array[ 0..ord( high( TPiletype ) ), 0..1 ] of integer;   {index to find 1st & last of a particular piletype}
  cardchosen: Boolean;                {true when a card has been clicked on & is moving}
  Temppile, Pickedpile: TPile;        {temppile is used to move cards, pickedpile is set to pile moving card came from}
  gdecks,                             {number of decks used in particular game}
  gscoring,                           {Rule for how to count player's score}
  gPrepick,                           {rule for special activity before Pickcard is called}
  gPostdrop,                          {rule for special activity after Dropcard is called}
  gPostpick,                          {rule for special activity after Pickcard is called}
  gfwidth,                            {Form width}
  gfheight,                           {Form height}
  gOTF,                               {One Time Flag for some special rules}
  gredeals,                           {maximum number of redeals in a game}
  gdealsleft: integer;                {number of remaining redeals}
  TheBox: TWinControl;                {place to store unused cards}
  BitMasque: TBitmap;                 {transparency bitmap for custom cursor}
  Undomove: TUndo;                    {feeble attempt to permit undo}
  shuf: array[1..104] of integer;     {shuffling array, kept global so game can be restarted}
  npreplay: integer;                  {number of cards to reserve from shuffle (range 0-16)}
  preplaylist: array[ 1..16 ] of integer;   {list of up to 16 cards reserved from shuffle}
  seehbar, seevbar: boolean;          {to hide/restore scrollbars when RMB is clicked}
  seepile: TPile;                     {pile RMB was clicked over}

procedure TForm1.FormCreate(Sender: TObject);
var i: integer;
begin
  randomize;
  cardchosen := false;

  SeePile := nil;

  TheBox := TWinControl.create( self );

  Temppile := TPile.create( self );
  temppile.visible := false;
  temppile.dealpattern := '';
  temppile.parent := self;
  temppile.name := 'Fritz';
  temppile.showrule := 400;
  temppile.piletype := ptHidden;

  gnames := TStringlist.create;

  Pickedpile := nil;

  for i := 1 to 104 do begin
    card[ i ] := TCards.create( self );
    card[ i ].cardbackstyle := 4;
    card[ i ].onclick := dispatchclick;
    card[ i ].onmousedown := formmousedown;
    card[ i ].onmouseup := formmouseup;
    card[ i ].parent := TheBox;
    // each card gets a sorted deckvalue from 1 to 52
    card[ i ].deckvalue := ((i-1) mod 52) + 1;
    card[ i ].tag := ord( ctFront );
  end;

  // cardpix exists only because there is a resource leak with the current version
  // of TCards whenever a new image is loaded into a card.  The leak doesn't occur
  // when an image is copied from another card, so to flip a card from front to back
  // or vice-versa we copy from the cardpix image
  for i := 1 to 52 do begin
    cardpix[ i ] := TCards.create( self );
    cardpix[ i ].parent := TheBox;
    cardpix[ i ].deckvalue := i;
  end;
  cardpix[ 53 ] := TCards.create( self );
  cardpix[ 53 ].cardbackstyle := 6;
  cardpix[53].state := ctBack;
  cardpix[53].parent := TheBox;

  // create transparency bitmap for cursorcard
  BitMasque := TBitmap.create;
  with BitMasque, canvas do begin
    width := 32;
    height := 32;
    draw( 0, 0, Cursorcard.picture.bitmap );
    {$IFDEF VER90}
    brush.color := Cursorcard.picture.bitmap.transparentcolor;
    BitMasque.monochrome := true;
    {$ENDIF}
    {$IFDEF VER100}
		BitMasque.mask( clBlack );		//add 05/06 for D3
    {$ENDIF}
  end;

  helptext := 'Click on the "Game | Select a new game" menu item to get started.';

  SetUndo( nil, nil, 0, false, false, false, false );

  // Welcome display...turn off event handlers for these cards or it'll crash!
  card[ 52 ].onclick := nil;
  card[ 52 ].onmousedown := nil;
  card[ 52 ].onmouseup := nil;
  card[ 38 ].onclick := nil;
  card[ 38 ].onmousedown := nil;
  card[ 38 ].onmouseup := nil;
  card[ 11 ].onclick := nil;
  card[ 11 ].onmousedown := nil;
  card[ 11 ].onmouseup := nil;

  card[ 52 ].parent := form1;
  card[ 52 ].setbounds( 3, 2, 71, 96 );
  card[ 38 ].parent := form1;
  card[ 38 ].setbounds( 74, 2, 71, 96 );
  card[ 11 ].parent := form1;
  card[ 11 ].setbounds( 145, 2, 71, 96 );

end;


procedure shuffleanddeal( replay: boolean );
var i, x, y, z, rcard, temp, pp: integer;
begin
  if not replay then begin
    // arrange deck(s) in fresh-out-of-the-box order
    for x := 1 to 104 do begin
      shuf[ x ] := x;
    end;

    // place cards which will be preplayed at front of deck, swapping with the replaced card
    for x := 1 to npreplay do begin
      for y := 1 to 104 do
        if shuf[ y ] = preplaylist[ x ] then
          break;
      temp := shuf[ x ];
      shuf[ x ] := preplaylist[ x ];
      shuf[ y ] := temp;
    end;

    // shuffle by moving each card to random location within deck
    for x := npreplay + 1 to ( 52 * gdecks ) do begin
      rcard := random( ( 52 * gdecks ) - npreplay ) + 1 + npreplay;
      temp := shuf[ rcard ];
      shuf[ rcard ] := shuf[ x ];
      shuf[ x ] := temp;
    end;
  end;

  // place according to dealpattern...z marks our place in shuffled portion of deck,
  // pp our place in the preplay portion
  z := npreplay + 1;
  pp := 1;
  for x := 0 to form1.controlcount - 1 do
    if ( form1.controls[ x ] is TPile ) then
      if TPile(form1.controls[ x ]).dealpattern <> '' then begin
        for y := 1 to length( TPile(form1.controls[ x ]).dealpattern ) do
          case TPile(form1.controls[ x ]).dealpattern[ y ] of
            'u', 'U':
              begin
                card[ shuf[ z ] ].parent := TPile(form1.controls[ x ]);
                if card[ shuf [ z ]].tag <> ord( ctFront) then begin
                  card[ shuf [ z ] ].picture.bitmap := cardpix[ (shuf[ z ]-1) mod 52 + 1 ].picture.bitmap;
                  card[ shuf [ z ] ].tag := ord( ctFront );
                end;
                card[ shuf[ z ] ].visible := true;
                z := z + 1;
              end;
            'd', 'D':
              begin
                card[ shuf[ z ] ].parent := TPile(form1.controls[ x ]);
                if card[ shuf[ z ]].tag <> ord( ctBack ) then begin
                  card[ shuf[ z ] ].picture.bitmap := cardpix[53].picture.bitmap;
                  card[ shuf[ z ] ].tag := ord( ctBack );
                end;
                card[ shuf[ z ] ].visible := true;
                z := z + 1;
              end;
            's', 'S':
              begin
                card[ preplaylist[ pp ] ].parent := TPile(form1.controls[ x ]);
                if card[ preplaylist[ pp ] ].tag <> ord( ctFront) then begin
                  card[ preplaylist[ pp ] ].picture.bitmap := cardpix[ ( preplaylist[ pp ]-1 ) mod 52 + 1 ].picture.bitmap;
                  card[ preplaylist [ pp ] ].tag := ord( ctFront );
                end;
                card[ preplaylist[ pp ] ].visible := true;
                inc( pp );
              end;
          end;
        showpile( TPile(form1.controls[ x ]) );
      end;

  gdealsleft := gredeals;
  updatescore;

end;


procedure showpile( APile: TPile );
var x, dneeded: integer;
begin
with APile do
  case showrule of
    400:  ;  // never show it

    401:  // show tableau stack fanned out
        begin
          if horzscrollbar.visible then
            horzscrollbar.position := 0;
          if vertscrollbar.visible then
            vertscrollbar.position := 0;
          case orientation of
            poVert:
              for x := 0 to controlcount - 1 do begin
                controls[ x ].setbounds( 0, ( ( gcheight div 6 ) + 1 ) * x, gcwidth, gcheight );
                controls[ x ].visible := true;
              end;
            poHoriz:
              for x := 0 to controlcount - 1 do begin
                controls[ x ].setbounds( ( ( gcwidth div 5 ) + 1 ) * x, 0, gcwidth, gcheight );
                controls[ x ].visible := true;
              end;
            poRHoriz:
              begin
                dneeded := gcwidth + ( gcwidth div 5 + 1 ) * ( controlcount - 1 ) - width;
                if dneeded < 0 then dneeded := 0;
                for x := 0 to controlcount - 1 do begin
                  controls[ x ].setbounds( width + dneeded - gcwidth - ( ( gcwidth div 5 ) + 1 ) * x, 0, gcwidth, gcheight );
                  controls[ x ].visible := true;
                end;
              end;
            poNeither:
              for x := 0 to controlcount - 1 do begin
                controls[ x ].setbounds( 0, 0, gcwidth, gcheight );
                controls[ x ].visible := true;
              end;
          end;
        end;

    402:  // show top card only
        begin
          for x := 0 to controlcount - 1 do begin
            controls[ x ].setbounds( 0, 0, gcwidth, gcheight );
            controls[ x ].visible := false;
          end;
          if controlcount > 0 then
            controls[ controlcount - 1 ].visible := true
          else
            refresh;
        end;

    403:  // show top three cards...NB handles poVert and poHoriz only, not poRHoriz!
        begin
          if orientation = poVert then begin
            if controlcount < 3 then begin
              for x := 0 to controlcount - 1 do begin
                controls[ x ].setbounds( 0, ( ( gcheight div 6 ) + 1 ) * x, gcwidth, gcheight );
                controls[ x ].visible := true;
              end
            end else begin
              for x := 0 to controlcount - 4 do begin
                controls[ x ].setbounds( 0, 0, gcwidth, gcheight );
                controls[ x ].visible := false;
              end;
              for x := 0 to 2 do begin
                controls[ controlcount - 3 + x ].setbounds( 0, ( ( gcheight div 6 ) + 1 ) * x, gcwidth, gcheight );
                controls[ controlcount - 3 + x ].visible := true;
              end;
            end
          end else begin
            if controlcount < 3 then begin
              for x := 0 to controlcount - 1 do begin
                controls[ x ].setbounds( ( ( gcwidth div 5 ) + 1 ) * x, 0, gcwidth, gcheight );
                controls[ x ].visible := true;
              end
            end else begin
              for x := 0 to controlcount - 4 do begin
                controls[ x ].setbounds( 0, 0, gcwidth, gcheight );
                controls[ x ].visible := false;
              end;
              for x := 0 to 2 do begin
                controls[ controlcount - 3 + x ].setbounds( ( ( gcwidth div 5 ) + 1 ) * x, 0, gcwidth, gcheight );
                controls[ controlcount - 3 + x ].visible := true;
              end;
            end
          end;
        end;

    404:  // show top card only, turn pile facedown when it holds 13
        begin
          for x := 0 to controlcount - 1 do begin
            controls[ x ].setbounds( 0, 0, gcwidth, gcheight );
            controls[ x ].visible := false;
          end;
          if controlcount = 0 then
            refresh
          else
            if controlcount < 13 then
              controls[ controlcount - 1 ].visible := true
            else begin
              TCards(controls[ 12 ]).tag := ord(ctBack);
              TCards(controls[ 12 ]).picture.bitmap := cardpix[53].picture.bitmap;
              controls[ controlcount - 1 ].visible := true;
            end;
        end;

  end;
end;


procedure TForm1.DispatchClick(Sender: TObject);
begin
  if not cardchosen then begin

    if ( Sender is TCards ) then
      pickcard( Sender as TCards )
    else
      // check for player clicking on empty stock to refill it?
      if ( Sender is TPile ) then
        pickpile( Sender as TPile );

  end else  // i.e. a chosen card is pending

    if ( Sender is TCards ) then begin
      if candrop( (Sender as TCards).Parent as TPile, TempPile, 0 ) then
        dropcard( (Sender as TCards).Parent as Tpile, TempPile, 0 );
    end else begin
      if ( Sender is TPile ) then
        if candrop( (Sender as TPile), TempPile, 0 ) then
          dropcard( Sender as TPile, TempPile, 0 );
    end;

end;


procedure pickcard(Whichcard: TCards);
var Frompile: TPile;
    FPC, Pilenum, x, temprank: integer;
    tempsuitcolor: TSuitColor;
    tempsuit: TCardSuit;
begin
  Frompile := ( Whichcard.parent as TPile );

  // before the pick, check for special cases
  if gPrepick > 0 then Prepick( Whichcard, Frompile );

  // ?? mustn't frompile have 1 card since the player clicked on it!?
  if Frompile.controlcount > 0 then
    case Frompile.pickrule of
      0:  begin
          // no cards may be taken from this pile
          end;

      1:  begin
            // topmost card may be chosen
            DrawCustomCursor( (Frompile.controls[ Frompile.controlcount - 1 ] as TCards) );
            selectcard( Frompile, Frompile.controlcount - 1, Frompile.controlcount - 1 );
            Pickedpile := Frompile;
            Cardchosen := true;
          end;

      2:  begin
            // any sequence may be chosen (1st card must be face-up)
            if whichcard.tag = ord( ctFront ) then begin
              FPC := -1;
              repeat
                inc( FPC )
              until ( Frompile.controls[ FPC ] = Whichcard ) or ( FPC = Frompile.controlcount );
              if FPC < Frompile.controlcount then begin
                DrawCustomCursor( TCards(Frompile.controls[ FPC ]) );
                selectcard( Frompile, FPC, Frompile.controlcount - 1 );
                Pickedpile := Frompile;
                Cardchosen := true;
              end;
            end;
          end;

      3:  begin
            // set must form descending alternating-color sequence
            if whichcard.tag = ord( ctFront ) then begin
              FPC := -1;
              repeat
                inc( FPC )
              until ( Frompile.controls[ FPC ] = Whichcard ) or ( FPC = Frompile.controlcount );
              if FPC < Frompile.controlcount then begin
                tempsuitcolor := TCards(FromPile.controls[ FPC ]).suitcolor;
                temprank := TCards(FromPile.controls[ FPC ]).value;
                x := FPC + 1;
                while x < Frompile.controlcount do
                  if ( TCards(Frompile.controls[ x ]).suitcolor <> tempsuitcolor ) and
                       ( TCards(Frompile.controls[ x ]).value = temprank - 1 ) then begin
                     dec( temprank );
                     tempsuitcolor := TCards(FromPile.controls[ x ]).suitcolor;
                     inc( x );
                    end
                  else
                    break;
                if ( x = Frompile.controlcount ) then begin
                  DrawCustomCursor( TCards(Frompile.controls[ FPC ]) );
                  selectcard( Frompile, FPC, Frompile.controlcount - 1 );
                  Pickedpile := Frompile;
                  Cardchosen := true;
                end;
              end;
            end;
          end;

      4:  begin
            // set must form descending suit sequence
            if whichcard.tag = ord( ctFront ) then begin
              FPC := -1;
              repeat
                inc( FPC )
              until ( Frompile.controls[ FPC ] = Whichcard ) or ( FPC = Frompile.controlcount );
              if FPC < Frompile.controlcount then begin
                tempsuit := TCards(FromPile.controls[ FPC ]).suit;
                temprank := TCards(FromPile.controls[ FPC ]).value;
                x := FPC + 1;
                while x < Frompile.controlcount do
                  if ( TCards(Frompile.controls[ x ]).suit = tempsuit ) and
                       ( TCards(Frompile.controls[ x ]).value = temprank - 1 ) then begin
                     dec( temprank );
                     inc( x );
                    end
                  else
                    break;
                if ( x = Frompile.controlcount ) then begin
                  DrawCustomCursor( TCards(Frompile.controls[ FPC ]) );
                  selectcard( Frompile, FPC, Frompile.controlcount - 1 );
                  Pickedpile := Frompile;
                  Cardchosen := true;
                end;
              end;
            end;
          end;

      5:  begin
            // set must form descending sequence regardless of suit
            if whichcard.tag = ord( ctFront ) then begin
              FPC := -1;
              repeat
                inc( FPC )
              until ( Frompile.controls[ FPC ] = Whichcard ) or ( FPC = Frompile.controlcount );
              if FPC < Frompile.controlcount then begin
                temprank := TCards(FromPile.controls[ FPC ]).value;
                x := FPC + 1;
                while x < Frompile.controlcount do
                  if ( TCards(Frompile.controls[ x ]).value = temprank - 1 ) then begin
                     dec( temprank );
                     inc( x );
                    end
                  else
                    break;
                if ( x = Frompile.controlcount ) then begin
                  DrawCustomCursor( TCards(Frompile.controls[ FPC ]) );
                  selectcard( Frompile, FPC, Frompile.controlcount - 1 );
                  Pickedpile := Frompile;
                  Cardchosen := true;
                end;
              end;
            end;
          end;

      6:  begin
            // set must form descending suit sequence, wrapping from A to K
            if whichcard.tag = ord( ctFront ) then begin
              FPC := -1;
              repeat
                inc( FPC )
              until ( Frompile.controls[ FPC ] = Whichcard ) or ( FPC = Frompile.controlcount );
              if FPC < Frompile.controlcount then begin
                tempsuit := TCards(FromPile.controls[ FPC ]).suit;
                temprank := TCards(FromPile.controls[ FPC ]).value;
                x := FPC + 1;
                while x < Frompile.controlcount do
                  if ( TCards(Frompile.controls[ x ]).suit = tempsuit ) and
                       ( ( TCards(Frompile.controls[ x ]).value = temprank - 1 ) or
                       ( TCards(Frompile.controls[ x ]).value = temprank + 12 ) ) then begin
                     dec( temprank );
                     inc( x );
                    end
                  else
                    break;
                if ( x = Frompile.controlcount ) then begin
                  DrawCustomCursor( TCards(Frompile.controls[ FPC ]) );
                  selectcard( Frompile, FPC, Frompile.controlcount - 1 );
                  Pickedpile := Frompile;
                  Cardchosen := true;
                end;
              end;
            end;
          end;

      7:  begin
            // any face-up card may be chosen even if buried in the pile
            if whichcard.tag = ord( ctFront ) then begin
              FPC := -1;
              repeat
                inc( FPC )
              until ( Frompile.controls[ FPC ] = Whichcard ) or ( FPC = Frompile.controlcount );
              if FPC < Frompile.controlcount then begin
                DrawCustomCursor( (Frompile.controls[ FPC ] as TCards) );
                selectcard( Frompile, FPC, FPC );
                Pickedpile := Frompile;
                Cardchosen := true;
              end;
            end;
          end;

      8:  begin
            // card in pyramid must be fully exposed
            if pyramidtest( FromPile ) then begin
              DrawCustomCursor( (Frompile.controls[ 0 ] as TCards) );
              selectcard( Frompile, 0, 0 );
              Pickedpile := Frompile;
              Cardchosen := true;
            end;
          end;

      90: begin
            // pile is Stock-type: deal one card to next pile
            Pilenum := -1;
            repeat
              inc( Pilenum )
            until ( Form1.controls[ Pilenum ] = FromPile ) or ( Pilenum = Form1.controlcount );
            if Pilenum < form1.controlcount then
              if form1.controls[ Pilenum + 1 ] is TPile then begin
                Whichcard.parent := TPile(form1.controls[ Pilenum + 1 ]);
                Whichcard.tag := ord(ctFront);
                Whichcard.picture.bitmap := Cardpix[ whichcard.deckvalue ].picture.bitmap;
                showpile( FromPile );
                showpile( TPile(form1.controls[ Pilenum + 1 ]) );

                SetUndo( FromPile, TPile(form1.controls[ Pilenum + 1 ]), 1, true, true, false, true );
                // exception--if stock is empty, don't try to hide top card on undo!
                if FromPile.controlcount = 0 then
                  Undomove.UHidefrom := false;
                updatescore;
              end;
          end;
      91: begin
            // pile is stock-type: deal three cards to next pile
            Pilenum := -1;
            repeat
              inc( Pilenum )
            until ( Form1.controls[ Pilenum ] = FromPile ) or ( Pilenum = Form1.controlcount );
            if Pilenum < form1.controlcount then
              if form1.controls[ Pilenum + 1 ] is TPile then begin
                x := 3;
                repeat
                  with TCards(FromPile.controls[ FromPile.controlcount - 1 ]) do begin
                    tag := ord(ctFront);
                    picture.bitmap := cardpix[ deckvalue ].picture.bitmap;
                    parent := TPile(form1.controls[ Pilenum + 1 ]);
                  end;
                  dec( x );
                until ( x = 0 ) or ( FromPile.controlcount = 0 );
                showpile( FromPile );
                showpile( TPile(form1.controls[ Pilenum + 1 ]) );
              end;
              SetUndo( FromPile, TPile(form1.controls[ Pilenum + 1 ]), 3, true, true, true, true );
              // exception--if stock is empty, don't try to hide top card on undo!
              if FromPile.controlcount = 0 then
                Undomove.UHidefrom := false;
              updatescore;
          end;
      92: begin
            // pile is stock-type: deal 1 card to every ptTableau
            x := 0;
            repeat
              if ( form1.controls[ x ] is TPile ) and ( TPile(form1.controls[ x ]).piletype = ptTableau ) then begin
                with TCards(FromPile.controls[ FromPile.controlcount - 1 ]) do begin
                  tag := ord(ctFront);
                  picture.bitmap := cardpix[ deckvalue ].picture.bitmap;
                  parent := TPile(form1.controls[ x ]);
                end;
                showpile( FromPile );
                showpile( TPile(form1.controls[ x ]) );
              end;
              inc( x );
            until ( Frompile.controlcount = 0 ) or ( x = form1.controlcount );
            SetUndo( nil, nil, 0, false, false, false, false );
            updatescore;
          end;
    end;

    // after the pick, check for special cases
    if cardchosen then
      if gPostpick > 0 then Postpick( Whichcard, Frompile );

end;


procedure Prepick( Whichcard: TCards; FromPile: TPile );
begin
  case gPrepick of
    1:  begin
          // La Belle Lucie: player may 1 time only pluck any card & move to front
          if ( gOTF = 0 )  and ( FromPile.piletype = ptTableau ) then begin
            Whichcard.parent := Temppile;
            TCards(Temppile.controls[ Temppile.controlcount - 1 ]).parent := FromPile;
            dec( gOTF );
          end;
        end;
  end;
end;


procedure Postpick( Whichcard: TCards; FromPile: TPile );
// remember that Whichcard may not be in Frompile any longer--it may be in Temppile
begin
  case gPostpick of
    13: begin
          // Pyramid: check last drop to see if top 2 cards = 13--if yes, move to Foundation
          // if there is no foundation, big trouble!
          if Whichcard.value = 13 then begin
            SetUndo( Nil, nil, 0, false, false, false, false );
            Whichcard.parent := TPile(form1.controls[ gMark[ ord( ptFoundation ), 0 ] ]);
            Showpile( TPile(form1.controls[ gMark[ ord( ptFoundation ), 0 ] ]) );

            if PickedPile <> nil then
              if ( pickedpile.controlcount > 0 ) and ( (pickedpile.controls[ pickedpile.controlcount - 1 ] as TCards).tag = ord( ctBack ) ) then
                with TCards(pickedpile.controls[ pickedpile.controlcount - 1 ]) do begin
                  picture.bitmap := cardpix[ deckvalue ].picture.bitmap;
                  tag := ord( ctFront );
                  Undomove.uhidefrom := true;
                end;

            if ( PickedPile.piletype = ptSingle ) and ( PickedPile.controlcount = 0 ) then
              PickedPile.hide;

            cardchosen := false;
            Screen.Cursor := crDefault;
            PickedPile := nil;
            updatescore;
          end;
        end;
  end;
end;


procedure pickpile( APile: TPile );
// player hasn't chosen a card, but has clicked on a pile...
// if it's empty stock, try to refill from waste
var Pilenum, x, y: integer;
    NextPile: TPile;
begin
  case APile.PPilerule of
    301:  begin
          // Klondike type--stock gathers from very next pile
            if ( gdealsleft > 0 ) and ( Apile.controlcount = 0 ) then begin
              Pilenum := -1;
              repeat
                inc( Pilenum )
              until ( Form1.controls[ Pilenum ] = APile ) or ( Pilenum = Form1.controlcount - 1 );
              if form1.controls[ Pilenum + 1 ] is TPile then begin
                NextPile := TPile(form1.controls[ Pilenum + 1 ]);
                for x := NextPile.controlcount - 1 downto 0 do begin
                  TCards(NextPile.controls[ x ]).tag := ord(ctBack);
                  TCards(NextPile.controls[ x ]).picture.bitmap := cardpix[53].picture.bitmap;
                  NextPile.controls[ x ].parent := APile;
                end;
                showpile( NextPile );
                showpile( APile );
                dec( gdealsleft );
              end;
              SetUndo( nil, nil, 0, false, false, false, false );
            end;
          end;

    302:  begin
          // La Belle Lucie type
            // pile is stock-type: pick up tableau, shuffle, redeal in 3's, dec( gdealsleft )
            if ( Temppile.controlcount = 0 ) and ( gdealsleft > 0 ) and ( Apile.controlcount = 0 ) then begin
              // gather tableau cards into Temppile
              for x := gMark[ ord( ptTableau ), 0 ] to gMark[ ord( ptTableau ), 1 ] do
                if TPile(form1.controls[ x ]).piletype = ptTableau then
                  with TPile(form1.controls[ x ]) do begin
                    for y := controlcount - 1 downto 0 do
                      controls[ y ].parent := Temppile;
                  end;
              // shuffle into stock by random drawing
              while Temppile.controlcount > 0 do
                TCards(Temppile.controls[ random( Temppile.controlcount ) ]).parent := APile;
              //deal out in trios to each tableau
              x := gMark[ ord( ptTableau ), 0 ];
              while APile.controlcount > 0 do begin
                for y := 1 to 3 do
                  if APile.controlcount > 0 then
                    TCards(APile.controls[ APile.controlcount - 1 ]).parent := TPile(form1.controls[ x ]);
                showpile( TPile(form1.controls[ x ]) );
                repeat
                  inc( x )
                until ( x > gMark[ ord( ptTableau ), 1 ] ) or ( TPile(form1.controls[ x ]).piletype = ptTableau );
              end;
              dec( gdealsleft );
              SetUndo( nil, nil, 0, false, false, false, false );
            end else
              if ( gdealsleft = 0 ) then ShowMessage( 'No more redeals' );
          end;
  end;
end;


procedure selectcard( FromPile: TPile; i, j: integer );
var x: integer;
begin
  for x := i to j do begin
    FromPile.controls[ i ].parent := TempPile;
  end;
  showpile( FromPile );
end;


procedure DrawCustomCursor( MyCard: TCards );
// instead of keeping a cursor for every card in the deck, we'll create on-the-fly cursors
// by combining sections of the 3 image components.  Delphi destroys the old cursor each time
// a new one is created
var MyCursor: TIconInfo;
begin
  // prepare custom cursor bitmap
  // copyrect( dest rect, source canvas, source rect )...rect( left, top, right, bottom )
  // numbers are arranged in 11 wide x 14 high grid
  // suits are arranged in 15 wide x 15 high grid

  {$IFDEF VER100}
	form1.cursorcard.Picture.bitmap.PixelFormat := pf8bit;  // needed for D3
  {$ENDIF}

  form1.Cursorcard.canvas.copyrect( Rect( 6, 2, 17, 16 ), form1.numbers.canvas, Rect( ( MyCard.value - 1 ) * 11,
      ord( MyCard.suitcolor ) * 14, ( MyCard.value - 1 ) * 11 + 11, ord( MyCard.suitcolor) * 14 + 14 ) );
  form1.Cursorcard.canvas.copyrect( Rect( 11, 15, 26, 30 ), form1.suits.canvas, Rect( ord( MyCard.suit ) * 15,
      0, ord( MyCard.suit ) * 15 + 15, 15 ) );

  // fill in an ICONINFO structure
  MyCursor.fIcon := false;      {true=icon, false=cursor}
  MyCursor.xHotspot := 15;
  MyCursor.yHotspot := 0;
  MyCursor.hbmMask := BitMasque.handle;    {transparency mask}
  MyCursor.hbmColor := form1.Cursorcard.Picture.bitmap.handle;    {image bitmap}

  // call API function to create cursor, add it to Delphi-maintained custom cursors
  Screen.Cursors[ 1 ] := CreateIconIndirect( MyCursor );

  // turn it on
  Screen.Cursor := 1;
end;


function candrop( ToPile, FromPile: TPile; FPC: integer ): Boolean;
// FPC is the FromPile.Controls[] number of the card to test--usually but not always 0
var i, j, k, x, temprank: integer;
    tempsuit: tcardsuit;
    tempsuitcolor: tsuitcolor;
    FromPilecard, ToPilecard: TCards;
begin
  result := false;

  // player can always replace cards on pile they came from
  if ToPile = PickedPile then begin
    result := true;
    exit;
  end;

  FromPilecard := TCards(FromPile.controls[ FPC ] );
  // rules to apply if ToPile is NOT empty
  if ToPile.controlcount > 0 then
    begin
      ToPilecard := TCards(ToPile.controls[ ToPile.controlcount - 1 ]);
      case ToPile.droprule of
        100:  begin
                // no drop permitted
              end;
        101:  begin
                // any single card 1 higher regardless of suit, 13 cards allowed
                if (ToPile.controlcount < 13 ) and
                    ( ( ToPilecard.value = FromPilecard.value - 1) or ( ToPilecard.value = FromPilecard.value + 12 ) ) and
                    ( FromPile.controlcount - FPC = 1 ) then
                  result := true;
              end;
        102:  begin
              // any 1 card in descending suit sequence from last card of ToPile
                if ( Frompile.controlcount - FPC = 1 ) and ( FromPilecard.value = ToPilecard.value - 1 )
                    and ( FromPilecard.suit = ToPilecard.suit ) then
                  result := true;
              end;
        103:  begin
                // any 1 card in descending alternating color sequence
                if (FromPile.controlcount - FPC = 1 ) and
                    ( ToPilecard.suitcolor <> FromPilecard.suitcolor) and
                    ( ToPilecard.value = FromPilecard.value + 1) then
                  result := true;
              end;
        104:  begin
                // any single card 2 higher regardless of suit, 13 cards allowed
                if ( ToPile.controlcount < 13 ) and
                    ( ( ToPilecard.value = FromPilecard.value - 2 ) or
                    ( ToPilecard.value = FromPilecard.value + 11 ) ) and
                    ( FromPile.controlcount - FPC = 1 ) then
                  result := true;
              end;
        105:  begin
                // any single card 3 higher regardless of suit, wrap J or Q but not K
                if ( ToPilecard.value <> 13 ) and
                    ( ( ToPilecard.value = FromPilecard.value - 3 ) or
                    ( ToPilecard.value = FromPilecard.value + 10 ) ) and
                    ( FromPile.controlcount - FPC = 1 ) then
                  result := true;
              end;
        106:  begin
                // any 1 card in ascending suit sequence
                if ( ToPilecard.suit = FromPilecard.suit) and
                    ( ToPilecard.value = FromPilecard.value - 1) and
                    ( FromPile.controlcount - FPC = 1 ) then
                  result := true;
              end;
        107:  begin
                // any sequence, 1st card is in descending suit sequence to last card of ToPile
                if ( FromPilecard.value = ToPilecard.value - 1 )
                    and ( FromPilecard.suit = ToPilecard.suit ) then
                  result := true;
                end;
        108:  begin
                // any single card 4 higher regardless of suit, 13 cards allowed
                if (ToPile.controlcount < 13 ) and
                    ( ( ToPilecard.value = FromPilecard.value - 4 ) or
                    ( ToPilecard.value = FromPilecard.value + 9 ) ) and
                    ( FromPile.controlcount - FPC = 1 ) then
                  result := true;
              end;
        109:  begin
                // any sequence, 1st card in descending alternating-color sequence to last card of ToPile
                if ( ToPilecard.suitcolor <> FromPilecard.suitcolor) and
                    ( ToPilecard.value = FromPilecard.value + 1) then
                  result := true;
              end;
        110:  begin
                // single card up in suit, but ptStock pile must be empty (see Strategy)
                if ( ToPilecard.suit = FromPilecard.suit) and
                    ( ToPilecard.value = FromPilecard.value - 1) and
                    ( FromPile.controlcount - FPC = 1 ) and
                    ( gMark[ ord( ptStock ), 0 ] >= 0 ) and
                    ( TPile(form1.controls[ gMark[ ord( ptStock ), 0 ] ]).controlcount = 0 ) then
                  result := true;
              end;
        111:  begin
                // complete suit from K to A
                if ( Frompile.controlcount - FPC = 13 ) and
                    ( FromPilecard.value = 13 ) then begin
                  tempsuit := FromPilecard.suit;
                  temprank := 12;
                  i := FPC + 1;
                  while i < Frompile.controlcount do
                    if ( TCards(Frompile.controls[ i ]).suit = tempsuit ) and
                       ( TCards(Frompile.controls[ i ]).value = temprank ) then begin
                       dec( temprank );
                       inc( i );
                      end
                    else
                      break;
                  if i = Frompile.controlcount then
                    result := true;
                end;
              end;
        112:  begin
                // may drop 1 card of +1 or -1 value, unless ToPile shows a King (rule for Golf)
                if ( FromPile.controlcount - FPC = 1 ) and
                    ( ToPilecard.value <> 13 ) and
                    ( abs( ToPilecard.value - FromPilecard.value ) = 1 ) then
                  result := true;
              end;
        113:  begin
                // 1 card from previous stock pile (e.g. waste receives only from previous stock)
                if ( Frompile.controlcount - FPC = 1 ) then begin
                  x := gMark[ ord( ToPile.piletype ), 0 ];
                  while ( TPile(form1.controls[ x ]) <> ToPile ) do
                    inc( x );
                  repeat
                    dec( x )
                  until ( TPile(form1.controls[ x ]).piletype = ptStock ) or ( x = gMark[ ord( ptStock ), 0 ] );
                  if ( x >= 0 ) and ( TPile(form1.controls[ x ]) = PickedPile ) then
                    result := true;
                end;
              end;
        114:  begin
                // any set, 1st card is 1 less than top of ToPile regardless of suit
                if ( ToPilecard.value - FromPilecard.value = 1 ) then
                  result := true;
              end;
        115:  begin
                // 1 card with value +1 to ToPile's card, regardless of suit--wrap from K to A
                // also, ToPile can hold 13 cards only!  (German Patience)
                if ( FromPile.controlcount - FPC =1 ) and ( ToPile.controlcount < 13 ) and
                   ( ( ToPilecard.value - FromPilecard.value = -1 ) or
                   ( ToPilecard.value - FromPilecard.value = 12 ) ) then
                  result := true;
              end;
        116:  begin
                // special rule for Pyramid allows player to click in either order--
                // combined values must be 13,
                // if ToPile is ptSingle, ToPile must not be blocked by other piles...
                // or, card may move from stock to waste
                if ( Pickedpile.piletype = ptStock ) and ( ToPile.piletype = ptWaste ) then
                  result := true
                else if ( FromPilecard.value + ToPilecard.value = 13 ) then
                  if ToPile.piletype <> ptSingle then
                    result := true
                  else
                    result := Pyramidtest( ToPile );
              end;
        199:  begin
                //
              end;

      end;   // of case ToPile.droprule
    end
  else
    begin // rules for dropping on empty piles
      case ToPile.edroprule of
        200:  begin
              // no drops permitted
            end;
        201:  begin
              // can drop any 1 card
              if ( Frompile.controlcount - FPC = 1 ) then
                result := true;
            end;
        202:  begin
              // can drop any 1 king
              if ( Frompile.controlcount - FPC = 1 ) and ( FromPilecard.value = 13 ) then
                result := true;
              end;
        203:  begin
              // can drop any 1 ace
              if ( Frompile.controlcount - FPC = 1 ) and ( FromPilecard.value = 1 ) then
                result := true;
              end;
        204:  begin
              // 1 card must be same as initial value in previous foundation
                if ( Frompile.controlcount - FPC = 1 ) then begin
                  x := -1;
                  repeat
                    inc( x );
                  until ( TPile(form1.controls[ x ]) = ToPile );
                  repeat
                    dec( x );
                  until ( x < 0 ) or ( ( TPile(form1.controls[ x ]).piletype = ptFoundation ) and
                      ( TPile(form1.controls[ x ]).controlcount > 0 ) );
                  if ( x >= 0 ) and ( TCards(TPile(form1.controls[ x ]).controls[ 0 ]).value =
                      FromPilecard.value ) then
                    result := true;
                end;
              end;
        205:  begin
              // can drop any set in descending suit sequence
              if FromPile.controlcount - FPC = 1 then
                result := true
              else begin
                tempsuit := FromPilecard.suit;
                temprank := FromPilecard.value;
                i := FPC + 1;
                while i < Frompile.controlcount do
                  if ( TCards(Frompile.controls[ i ]).suit = tempsuit ) and
                       ( TCards(Frompile.controls[ i ]).value = temprank - 1 ) then begin
                     dec( temprank );
                     inc( i );
                    end
                  else
                    break;
                if ( i = Frompile.controlcount ) then
                  result := true;
              end;
            end;
        206:  begin
              // can drop any set in descending suit sequence headed by king
              tempsuit := FromPilecard.suit;
              temprank := 13;
              i := FPC;
              while i < Frompile.controlcount do
                if ( TCards(Frompile.controls[ i ]).suit = tempsuit ) and
                   ( TCards(Frompile.controls[ i ]).value = temprank ) then begin
                   dec( temprank );
                   inc( i );
                  end
                else
                  break;
              if i = Frompile.controlcount then
                result := true;
            end;
        207:  begin
              // can drop any set in descending alternating-color sequence
              if FromPile.controlcount - FPC = 1 then
                result := true
              else begin
                tempsuitcolor := FromPilecard.suitcolor;
                temprank := FromPilecard.value;
                i := FPC + 1;
                while i < Frompile.controlcount do
                  if ( TCards(Frompile.controls[ i ]).suitcolor <> tempsuitcolor ) and
                       ( TCards(Frompile.controls[ i ]).value = temprank - 1 ) then begin
                     dec( temprank );
                     tempsuitcolor := TCards(FromPile.controls[ i ]).suitcolor;
                     inc( i );
                    end
                  else
                    break;
                if ( i = Frompile.controlcount ) then
                  result := true;
              end;
            end;
        208:  begin
              // can drop any descending alternating-color sequence headed by king
              if FromPilecard.suitcolor = scRed then
                tempsuitcolor := scBlack
              else
                tempsuitcolor := scRed;
              temprank := 13;
              i := FPC;
              while i < Frompile.controlcount do
                if ( TCards(Frompile.controls[ i ]).suitcolor <> tempsuitcolor ) and
                   ( TCards(Frompile.controls[ i ]).value = temprank ) then begin
                   dec( temprank );
                   tempsuitcolor := TCards(FromPile.controls[ i ]).suitcolor;
                   inc( i );
                  end
                else
                  break;
              if i = Frompile.controlcount then
                result := true;
            end;
        209:  begin
              // any sequence headed by a king
              if FromPilecard.value = 13 then
                result := true;
            end;
        210: begin
              // any sequence
              result := true;
            end;
        211:  begin
                // complete suit from K to A
                if ( Frompile.controlcount - FPC = 13 ) and
                    ( FromPilecard.value = 13 ) then begin
                  tempsuit := FromPilecard.suit;
                  temprank := 12;
                  i := FPC + 1;
                  while i < Frompile.controlcount do
                    if ( TCards(Frompile.controls[ i ]).suit = tempsuit ) and
                       ( TCards(Frompile.controls[ i ]).value = temprank ) then begin
                      dec( temprank );
                      inc( i );
                    end
                    else
                      break;
                  if i = Frompile.controlcount then
                    result := true;
                end;
              end;
        213:  begin
                // 1 card from previous stock pile (e.g. waste receives only from previous stock)
                if ( Frompile.controlcount - FPC = 1 ) then begin
                  x := gMark[ ord( ToPile.piletype ), 0 ];
                  while ( TPile(form1.controls[ x ]) <> ToPile ) do
                    inc( x );
                  repeat
                    dec( x )
                  until ( TPile(form1.controls[ x ]).piletype = ptStock ) or ( x = gMark[ ord( ptStock ), 0 ] );
                  if ( x >= 0 ) and ( TPile(form1.controls[ x ]) = Pickedpile ) then
                    result := true;
                end;
                // 1 card from previous stock pile
                if ( Frompile.controlcount - FPC = 1 ) then begin
                  x := -1;
                  repeat
                    inc( x );
                  until ( TPile(form1.controls[ x ]) = PickedPile ) or ( x = form1.controlcount );
                  if ( x < form1.controlcount - 1 ) and ( TPile(form1.controls[ x + 1 ]) = ToPile ) then
                    result := true;
                end;
              end;
      end;  // of Case ToPile.edroprule
    end;

end;


procedure dropcard( ToPile, FromPile: TPile; FPC: integer );
var x, y: integer;
begin
  // need to record Undomove.UNum before cards are moved!
  SetUndo( PickedPile, ToPile, Frompile.controlcount - FPC, false, false, false, true );
  for x := FPC to ( Frompile.controlcount - 1 ) do begin
    Frompile.controls[ FPC ].parent := ToPile;
  end;
  Showpile( ToPile );

  if gPostdrop > 0 then
    Postdrop( ToPile, FromPile );

  // if PickedPile is headed by facedown card, turn it up
  if PickedPile <> nil then
    if ( pickedpile.controlcount > 0 ) and ( (pickedpile.controls[ pickedpile.controlcount - 1 ] as TCards).tag = ord( ctBack ) ) then
      with TCards(pickedpile.controls[ pickedpile.controlcount - 1 ]) do begin
        picture.bitmap := cardpix[ deckvalue ].picture.bitmap;
        tag := ord( ctFront );
        Undomove.uhidefrom := true;
      end;

  cardchosen := false;
  Screen.Cursor := crDefault;
  PickedPile := nil;
  updatescore;
end;


procedure Postdrop( ToPile, FromPile: TPile );
var x: integer;
begin
  case gPostdrop of
    13: begin
          // mark this movement not undoable
          SetUndo( Nil, nil, 0, false, false, false, false );

          // check last drop to see if top 2 cards = 13--if yes, move to Foundation
          if ToPile <> PickedPile then begin
            if ( ToPile.controlcount > 1 ) and ( TCards(ToPile.controls[ ToPile.controlcount - 1 ]).value +
                TCards(ToPile.controls[ ToPile.controlcount - 2 ]).value = 13 ) then begin
              TCards(ToPile.controls[ ToPile.controlcount - 1 ]).parent := TPile(form1.controls[ gMark[ ord( ptFoundation ), 0 ] ]);
              TCards(ToPile.controls[ ToPile.controlcount - 1 ]).parent := TPile(form1.controls[ gMark[ ord( ptFoundation ), 0 ] ]);
            end;
            Showpile( ToPile );
            Showpile( TPile(form1.controls[ gMark[ ord( ptFoundation ), 0 ] ]) );

            // hide PickedPile, ToPile if they're in the pyramid and empty
            if ( ToPile.piletype = ptSingle ) and ( ToPile.controlcount = 0 ) then
              ToPile.hide;
            if ( PickedPile.piletype = ptSingle ) and ( PickedPile.controlcount = 0 ) then
              PickedPile.hide;

            // in Pyramid we allow player to drop a match onto the stock--
            // so review stocks to make sure their topcard is up
            if gMark[ ord( ptStock ), 0 ] >= 0 then
              for x := gMark[ ord( ptStock ), 0 ] to gMark[ ord( ptStock ), 1 ] do
                if ( TPile(form1.controls[ x ]).piletype = ptStock ) then
                  with form1.controls[ x ] as TPile do
                    if ( controlcount > 0 ) and ( (controls[ controlcount - 1 ] as TCards).tag = ord( ctBack ) ) then
                      with TCards(controls[ controlcount - 1 ]) do begin
                        picture.bitmap := cardpix[ deckvalue ].picture.bitmap;
                        tag := ord( ctFront );
                      end;


          end;
        end;
    20: begin
        // in Blockade, if FromPile is empty tableau and stock is not empty, move top stock
        // card to FromPile
          if ( PickedPile.piletype = ptTableau ) and ( PickedPile.controlcount = 0 ) then begin
            x := gMark[ ord( ptStock ), 0 ];  // note, we simply assume there is a stock pile!
            if TPile(form1.controls[ x ]).controlcount > 0 then begin
              TCards(TPile(form1.controls[ x ]).controls[ TPile(form1.controls[ x ]).controlcount - 1 ]).parent := PickedPile;
              Showpile( PickedPile );
              Showpile( TPile(form1.controls[ x ]) );
            end;
          end;

        end;
  end;

end;


procedure autoplay;
var i, moved: integer;
begin
  moved := 0;
  i := 0;
  repeat
    if ( form1.controls[ i ] is TPile ) and
        ( TPile(form1.controls[ i ]).Piletype in [ ptTableau, ptSingle, ptWaste ] ) and
        ( TPile(form1.controls[ i ]).controlcount > 0 ) then
      if autoplay2( TPile(form1.controls[ i ]) ) then begin
        i := 0;
        inc( moved );
        continue;
      end;
    inc( i );
  until i = form1.controlcount;
  updatescore;
  if moved > 0 then begin
    SetUndo( nil, nil, 0, false, false, false, false );
  end;
end;


function autoplay2( FromPile: TPile ): Boolean;
var j: integer;
begin
  result := false;
  j := 0;
  repeat
    if ( form1.controls[ j ] is TPile ) and ( TPile(form1.controls[ j ]).piletype = ptFoundation ) then
      if candrop( TPile(form1.controls[ j ]), FromPile, Frompile.controlcount - 1 ) then begin
        PickedPile := FromPile;
        dropcard( TPile(form1.controls[ j ]), FromPile, FromPile.controlcount - 1 );
        showpile( FromPile );  // dropcard only updates the ToPile!
        result := true;
      end;
    inc( j );
  until ( j = form1.controlcount ) or ( result = true );
end;

procedure updatescore;
var i, j, k: integer;
begin
  i := 0;
  case gscoring of
    0:  begin   // count all cards on Foundations
          for j := 0 to form1.controlcount - 1 do begin
            if ( form1.controls[ j ] is TPile ) and ( TPile(form1.controls[ j ]).piletype = ptFoundation ) then
              i := i + TPile(form1.controls[ j ]).controlcount;
          end;
        end;
    1:  begin   // count all face-up cards in descending suit sequence on tableau (Wasp)
          for j := 0 to form1.controlcount - 1 do
            if ( form1.controls[ j ] is TPile ) and ( TPile(form1.controls[ j ]).piletype = ptTableau ) then
              with TPile(form1.controls[ j ]) do begin
                if ( controlcount > 0 ) and ( TCards(controls[ 0 ]).value = 13 ) and
                    ( TCards(controls[ 0 ]).tag = ord(ctFront) ) then
                  inc( i );
                for k := 1 to controlcount - 1 do
                  if ( TCards(controls[ k ]).tag = ord(ctFront) ) and
                      ( TCards(controls[ k - 1 ]).tag = ord(ctFront) ) and
                      ( TCards(controls[ k ]).suit = TCards(controls[ k - 1 ]).suit ) and
                      ( TCards(controls[ k ]).value = TCards(controls[ k - 1 ]).value - 1 ) then
                    inc( i );
              end;
        end;
    2:  begin   // count all cards on tableau (German Patience)
          for j := 0 to form1.controlcount - 1 do begin
            if ( form1.controls[ j ] is TPile ) and ( TPile(form1.controls[ j ]).piletype = ptTableau ) then
              i := i + TPile(form1.controls[ j ]).controlcount;
          end;
        end;
  end;
  form1.scoremenu.caption := '             Your score = ' + inttostr( i );
  if i = gdecks * 52 then
    with TForm3.Create( Application ) do
      try
        showmodal;
      finally
        free;
      end;
end;


procedure TForm1.Newgame1Click(Sender: TObject);
var x: integer;
begin
  // erase cards
  for x := 1 to 104 do begin
    card[ x ].parent := TheBox;
  end;
  for x := 0 to form1.controlcount - 1 do
    if ( form1.controls[ x ] is TPile ) and not ( TPile(form1.controls[ x ]).piletype = ptHidden ) then begin
      if TPile(form1.controls[ x ]).visible = false then
        TPile(form1.controls[ x ]).show;
      showpile( TPile(form1.controls[ x ]) );
    end;
  gOTF := 1;
  cardchosen := false;
  SetUndo( nil, nil, 0, false, false, false, false );
  Scoremenu.caption := '';

  if sender = form1.newgame1 then
    shuffleanddeal( false )
  else if sender = form1.replay1 then
    shuffleanddeal( true );
end;

procedure TForm1.Autoplay1Click(Sender: TObject);
begin
  autoplay;
end;


// To select different game:
// Show Form2--if mrCancel, do nothing
// if mrOK, put all cards away (necessary?)
// free all piles and specials except hidden piles
// parse description--create new piles
// ? showmodal rule box ?

// To start a game:
// put all cards away
// do initial deal
// set special variables, scores, etc.

procedure TForm1.Selectdifferentgame1Click(Sender: TObject);
var gameini: tinifile;
    gstrings, parseme: tstringlist;
    namestr, valstr: string;
    x, y, pm: integer;
    mypile: tpile;
    mybutton: TButton;
begin
  if form2.showmodal = mrOK then begin

    if form4.visible = true then
      form4.hide;

    // clear welcome screen & reassign event handlers
    label1.hide;
    card[ 52 ].parent := TheBox;
    card[ 38 ].parent := TheBox;
    card[ 11 ].parent := TheBox;
    card[ 52 ].onclick := dispatchclick;
    card[ 52 ].onmousedown := formmousedown;
    card[ 52 ].onmouseup := formmouseup;
    card[ 38 ].onclick := dispatchclick;
    card[ 38 ].onmousedown := formmousedown;
    card[ 38 ].onmouseup := formmouseup;
    card[ 11 ].onclick := dispatchclick;
    card[ 11 ].onmousedown := formmousedown;
    card[ 11 ].onmouseup := formmouseup;

    helptext := '';
    freepiles;
    gstrings := tstringlist.create;
    parseme := tstringlist.create;
    gameini := tinifile.create( '.\' + gnames.values[ form2.gamelist.items[ form2.gamelist.itemindex ] ] );
    try
      gameini.readsectionvalues( form2.gamelist.items[ form2.gamelist.itemindex ], gstrings );
    finally
      gameini.free;
    end;

    form1.caption := gstrings.values[ 'Name' ];

    valstr := gstrings.values[ 'Decks' ];
    if valstr = '' then
      gdecks := 1
    else
      gdecks := strtoint( valstr );

    valstr := gstrings.values[ 'Scoring' ];
    if valstr = '' then
      gscoring := 0
    else
      gscoring := strtoint( valstr );

    valstr := gstrings.values[ 'Redeals' ];
    if valstr = '' then
      gredeals := 0
    else
      gredeals := strtoint( valstr );

    if gstrings.values[ 'Postdrop' ] = '' then
      gPostdrop := 0
    else
      gPostdrop := strtoint( gstrings.values[ 'Postdrop' ] );

    if gstrings.values[ 'Postpick' ] = '' then
      gPostpick := 0
    else
      gPostpick := strtoint( gstrings.values[ 'Postpick' ] );

    if gstrings.values[ 'Prepick' ] = '' then
      gPrepick := 0
    else
      gPrepick := strtoint( gstrings.values[ 'Prepick' ] );

    if gstrings.values[ 'Formwidth' ] = '' then
      gfwidth := 640
    else
      gfwidth := strtoint( gstrings.values[ 'Formwidth' ] );

    if gstrings.values[ 'Formheight' ] = '' then
      gfheight := 440
    else
      gfheight := strtoint( gstrings.values[ 'Formheight' ] );

    if gstrings.values[ 'Preplay' ] = '' then
      npreplay := 0
    else begin
      parseme.commatext := gstrings.values[ 'Preplay' ];
      npreplay := parseme.count;
      for x := 1 to npreplay do
        preplaylist[ x ] := strtoint( parseme.strings[ x - 1 ] );
    end;

    form1.setbounds( ( screen.width - gfwidth ) div 2, ( screen.height - gfheight ) div 2, gfwidth, gfheight );

    for x := 0 to gstrings.count - 1 do
      if ( uppercase( copy( gstrings[ x ], 1, 4 ) ) = 'PILE' ) then begin
        namestr := copy( gstrings[ x ], 1, pos( '=', gstrings[ x ] ) - 1 );
        valstr := copy( gstrings[ x ], pos( '=', gstrings[ x ] ) + 1, length( gstrings[ x ] ) );
        mypile := tpile.create( self );
        for pm := parseme.count - 1 downto 0 do
          parseme.delete( pm );
        parseme.commatext := valstr;

        if uppercase( parseme.strings[ 2 ] ) = 'SAME' then begin
          mypile.left            := strtoint( parseme.strings[ 0 ] );
          mypile.top             := strtoint( parseme.strings[ 1 ] );
          with Form1.controls[ form1.controlcount - 1 ] as TPile do begin
            mypile.width           := width;
            mypile.height          := height;
            mypile.orientation     := orientation;
            mypile.piletype        := Piletype;
            mypile.pickrule        := pickrule;
            mypile.droprule        := droprule;
            mypile.edroprule       := edroprule;
            mypile.showrule        := showrule;
            mypile.ppilerule       := ppilerule;
            mypile.res2            := res2;
            mypile.res3            := res3;
            mypile.dealpattern     := dealpattern;
          end
        end else
          with mypile do begin
            left            := strtoint( parseme.strings[ 0 ] );
            top             := strtoint( parseme.strings[ 1 ] );
            width           := strtoint( parseme.strings[ 2 ] );
            height          := strtoint( parseme.strings[ 3 ] );
            orientation     := TOrientation( strtoint( parseme.strings[ 4 ] ) );
            piletype        := TPiletype( strtoint( parseme.strings[ 5 ] ) );
            pickrule        := strtoint( parseme.strings[ 6 ] );
            droprule        := strtoint( parseme.strings[ 7 ] );
            edroprule       := strtoint( parseme.strings[ 8 ] );
            showrule        := strtoint( parseme.strings[ 9 ] );
            { parseme.strings[ 10-12 ] is reserved for future use!}
            ppilerule       := strtoint( parseme.strings[ 10 ] );
            res2            := strtoint( parseme.strings[ 11 ] );
            res3            := strtoint( parseme.strings[ 12 ] );
            dealpattern     := parseme.strings[ 13 ];
          end;

        with mypile do begin
          case piletype of
            ptstock:
              begin
                color := clblue;
              end;
            ptwaste:      color := claqua;
            pttableau:    color := clgreen;
            ptfoundation: color := clred;
            ptsingle:     color := clteal;
            ptother:      color := clyellow;
          end;
          name := namestr;
          borderstyle := bsnone;
          parent := self;
          case orientation of
            poVert:
              horzscrollbar.visible := false;
            poHoriz {, poRHoriz}:
              vertscrollbar.visible := false;
            poNeither:
              begin
                horzscrollbar.visible := false;
                vertscrollbar.visible := false;
              end;
          end;
          visible := true;
          onclick := dispatchclick;
          onmouseup := formmouseup;
        end;

      end else
        if ( uppercase( copy( gstrings[ x ], 1, 4 ) ) = 'HELP' ) then begin
          valstr :=copy( gstrings[ x ], pos( '=', gstrings[ x ] ) + 1, length( gstrings[ x ] ) );
          if valstr = 'N' then
            helptext := helptext + #13#10#13#10
          else
            helptext := helptext + valstr + ' ';
        end else
          if ( uppercase( copy( gstrings[ x ], 1, 6 ) ) = 'BUTTON' ) then begin
            namestr := copy( gstrings[ x ], 1, pos( '=', gstrings[ x ] ) - 1 );
            valstr := copy( gstrings[ x ], pos( '=', gstrings[ x ] ) + 1, length( gstrings[ x ] ) );
            mybutton := TButton.create( self );
            for pm := parseme.count - 1 downto 0 do
              parseme.delete( pm );
            parseme.commatext := valstr;
            with mybutton do begin
              left            := strtoint( parseme.strings[ 0 ] );
              top             := strtoint( parseme.strings[ 1 ] );
              width           := strtoint( parseme.strings[ 2 ] );
              height          := strtoint( parseme.strings[ 3 ] );
              tag             := strtoint( parseme.strings[ 4 ] );
              caption         := parseme.strings[ 5 ];
              name := namestr;
              parent := self;
              visible := true;
              onclick := Button1click;
              font.size := 8;
              font.name := 'MS Sans Serif';
              font.style := [ fsBold ];
            end;
            // TBitBtns caused crashes when changing games
            {TB := TBitmap.Create;
            with TB do
              try
                width := 32;
                height := 32;
                Canvas.Draw( 0, 0, Application.Icon );
                with mybutton.glyph do begin
                  width := 48;
                  height := 48;
                  Canvas.StretchDraw( Rect( 0, 0, Width, Height ), TB );
                end;
              finally
                Free;
              end;}
          end; {if = BUTTON}

    if helptext = '' then
      helptext := 'Sorry, no information available.';

    // do I need to individually free gstrings.items ???
    gstrings.free;
    parseme.free;

    for x := 1 to 104 do begin
      card[ x ].width := gcwidth;
      card[ x ].height := gcheight;
    end;

    for x := 0 to ord( high( TPiletype ) ) do
      for y := 0 to 1 do
        gMark[ x, y ] := -1;
    for x := 0 to form1.controlcount - 1 do
      if form1.controls[ x ] is TPile then begin
        if gMark[ ord( TPile(form1.controls[ x ]).piletype), 0 ] = -1 then
          gMark[ ord( TPile(form1.controls[ x ]).piletype), 0 ] := x;
        gMark[ ord( TPile(form1.controls[ x ]).piletype), 1 ] := x;
      end;

    gOTF := 1;
    shuffleanddeal( false );

    form4.memo1.settextbuf( PChar( helptext ) );

    form1.newgame1.enabled := true;
    form1.autoplay1.enabled := true;
    form1.replay1.enabled := true;

  end;  {if form2.showmodal=OK...}
end;


procedure freepiles;
var x: integer;
begin
  for x := 1 to 104 do begin
      card[ x ].visible := false;
      card[ x ].parent := TheBox;
  end;
  for x := form1.controlcount - 1 downto 0 do
    if ( ( form1.controls[ x ] is TPile ) and ( TPile(form1.controls[ x ]).piletype <> ptHidden ) ) then
      TPile(form1.controls[ x ]).free
    else if ( form1.controls[ x ] is TButton ) then
      TButton(form1.controls[ x ]).free;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  application.terminate;
end;

procedure TForm1.HowtoPlay1Click(Sender: TObject);
begin
{  with TForm4.Create( Application ) do
  try
    memo1.settextbuf( PChar( helptext ) );
    showmodal;
  finally
    free;
  end;}
  if form4.visible = false then
    form4.show;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  gnames.free;
  BitMasque.free;
end;

procedure TForm1.Undo1Click(Sender: TObject);
var x: integer;
begin
  with undomove do begin
    if ( UFrom <> nil ) and ( UTo <> nil ) and ( UNum > 0 ) then begin
      if UHidefrom = true then begin
        // turn over top card of UFrom before moving it
        TCards(UFrom.controls[ UFrom.controlcount - 1 ]).picture.bitmap := Cardpix[ 53 ].picture.bitmap;
        TCards(UFrom.controls[ UFrom.controlcount - 1 ]).tag := ord( ctBack );
      end;
      if UReverse then
        for x := UNum downto 1 do begin
          if UHideto = true then begin
            TCards(UTo.controls[ UTo.controlcount - 1 ]).picture.bitmap := Cardpix[ 53 ].picture.bitmap;
            TCards(UTo.controls[ UTo.controlcount - 1 ]).tag := ord( ctBack );
          end;
          UTo.controls[ UTo.controlcount - 1 ].parent := UFrom;
        end
      else
        for x := UNum downto 1 do begin
          if UHideto = true then begin
            TCards(UTo.controls[ UTo.controlcount - 1 ]).picture.bitmap := Cardpix[ 53 ].picture.bitmap;
            TCards(UTo.controls[ UTo.controlcount - 1 ]).tag := ord( ctBack );
          end;
          UTo.controls[ UTo.controlcount - x ].parent := UFrom;
        end;
      showpile( UFrom );
      showpile( UTo );
      UFrom := nil;
      UTo := nil;
      UNum := 0;
      uhideto := false;
      uhidefrom := false;
      ureverse := false;
      Undo1.enabled := false;
      updatescore;
    end
  end
end;

procedure SetUndo( Pfrom, Pto: TPile; Num: integer; Ffrom, Fto, FReverse, FOK: boolean );
begin
  with Undomove do begin
    UFrom := Pfrom;
    UTo := Pto;
    UNum := Num;
    UHidefrom := Ffrom;
    UHideto := Fto;
    UReverse := FReverse;
  end;
  Form1.Undo1.Enabled := Fok;
end;


procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if ( Sender is TCards ) and ( Button = mbRight ) and ( SeePile = nil ) then begin
    with ( TCards( Sender ).Parent as TPile) do begin
      seehbar := horzscrollbar.visible;
      seevbar := vertscrollbar.visible;
      horzscrollbar.visible := false;
      vertscrollbar.visible := false;
      SeePile := TPile( TCards( Sender ).Parent );
    end;
  end;
end;

procedure TForm1.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if ( Button = mbRight ) and ( SeePile <> nil ) then begin
    SeePile.horzscrollbar.visible := seehbar;
    SeePile.vertscrollbar.visible := seevbar;
    SeePile := nil;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var x: integer;
begin
  // soon to be a general-purpose button handler
  case (Sender as TButton).tag of
    1:  begin
        // Strategy: hide an unused tableau column
        for x := gMark[ ord( ptTableau ), 1 ] downto gMark[ ord( ptTableau ), 0 ] do
          if (x >= 0 ) and ( TPile(form1.controls[ x ]).piletype = ptTableau ) and
              ( TPile(form1.controls[ x ]).visible = true ) and
              ( TPile(form1.controls[ x ]).controlcount = 0 ) then begin
            TPile(form1.controls[ x ]).hide;
            break;
          end;
        end;
    2:  begin
        // La Belle Lucie: next card clicked jumps to front of its pile
          if gdealsleft <> 0 then
            ShowMessage( 'Can''t be used until no redeals are left' )
          else
            if ( not cardchosen ) and ( gOTF = 1 ) then
              dec( gOTF );
          if ( gOTF < 0 ) then
            ShowMessage( 'You can do this only once per game' );
        end;
  end;
end;


// Pyramidtest returns true if clicked-on card in pyramid is exposed and can be selected
function pyramidtest( ToPile: TPile ): boolean;
var
  i, j, k, x: integer;
begin
  x := gMark[ ord( ptSingle ), 0 ];
  // clicked card is the i-th member of the pyramid, and we need to
  // know what row it's on to figure out the member numbers of the
  // cards beneath it.
  i := 0;
  while not ( TPile(form1.controls[ x + i ]) = ToPile ) do
    inc( i );
  j := 1;
  k := 1;
  while i + 2 > j + k do begin
    j := j + k;
    inc( k );
  end;
  if x + i + k + 1 < form1.controlcount then
    if form1.controls[ x + i + k + 1 ] is TPile then
      if TPile(form1.controls[ x + i + k + 1 ]).piletype = ptSingle then
        if ( form1.controls[ x + i + k + 1 ].visible = false ) and ( form1.controls[ x + i + k ].visible = false ) then
          result := true    {there were 2 cards beneath but both have been moved}
        else
          result := false   {one or two of the cards is still there}
      else
        result := true      {pile below isn't type Single, so we must be on last row of pyramid}
    else
      result := true        {there is no pile below, so we must be on last row of pyramid}
  else
    result := true;         {there is no control below, so we must be on last row of pyramid}
end;


procedure TForm1.About3Click(Sender: TObject);
begin
  AboutForm.showmodal;
end;

end.
