unit Tomcard2;
// 32 Bit CARDS.DLL Freeware VCL Component
// Ver 1.00
// By Tom Lee , Taiwan
// E-Mail Address : tom@libra.aaa.hinet.net
// Web : http://www.aaa.hinet.net/delphi

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

const
  Err1 = 'Unable to load %s ';
  Err2 = 'Resource #%d not found (%s)';
  Err3 = 'Bitmap #%d hasn''t been stored properly';

type
  TCardSuit = (csClubs,csDiamonds,csHearts,csSpades);
  TCardState = (ctFront,ctBack);
  TSuitColor = (scBlack,scRed);
  TCards = class(TImage)
  private
    { Private declarations }
    FState:TCardState;
    FCardBackStyle:integer;
		FValue:integer;
    FSuit:TCardSuit;
    FSuitColor:TSuitColor;
    FDValue:Integer;
    procedure LoadDLLBmp(FileName:string; BmpId:Integer; Dest:TBitmap);
    procedure SetState(value:TCardState);
    procedure SetCardBackStyle(value:integer);
    procedure SetValue(value:integer);
    procedure SetSuit(value:TCardSuit);
    procedure DisplayCard;
    procedure SetDeckValue(value:integer);
  protected
    { Protected declarations }
	public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    property SuitColor:TSuitColor read FSuitColor;
  published
    { Published declarations }
    property State:TCardState read Fstate write SetState default ctFront ;
    property CardBackStyle:integer read FCardBackStyle write SetCardBackStyle default 1;
    property Value:integer read FValue write SetValue default 1;
    property Suit:TCardSuit read FSuit write SetSuit default csClubs;
    property Deckvalue:Integer read FDValue write SetDeckValue default 1;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TCards]);
end;

procedure TCards.LoadDLLBmp(FileName:String ; BmpId:Integer; Dest:TBitmap);
{ Based on palette-preserving code in Lloyd's LDELPHI.HLP }
var
  Lib,rInfo,hMemory: THandle;
	rSize: Longint;
  pData: PByte;
  BmpHdr: TBitmapFileHeader;
  stream: TMemoryStream;
begin
  Lib := LoadLibrary('CARDS.DLL');
  if Lib < HINSTANCE_ERROR then raise Exception.CreateFmt(Err1,['Cards.DLL']);
  { locate bitmap within library }
  rInfo := FindResource(Lib, MakeIntResource(BmpId), rt_Bitmap);
  if rInfo = 0 then raise Exception.CreateFmt(Err2,[BmpId,'FindResource']);
  { load bitmap into global memory }
  hMemory := LoadResource(Lib,rInfo);
  try
		if hMemory = 0 then raise Exception.CreateFmt(Err2,[BmpId,'LoadResource']);
    { pin down the global memory to a specific address }
    pData := LockResource(hMemory);
    try
      { find upperbound of bitmap library usage }
      rSize := SizeofResource(Lib,rInfo);
      if rSize = 0 then raise Exception.CreateFmt(Err3,[BmpId]);
      { write to a stream so we can use TBitmap.LoadFromStream }
      stream := TMemoryStream.Create;
      try
        { fake a BM header to keep LoadFromStream happy }
        BmpHdr.bfType := $4D42;
        stream.SetSize(sizeof(BmpHdr)+rSize);
				stream.Write(BmpHdr,sizeof(BmpHdr));
        stream.Write(pData^,rSize);
        stream.Seek(0,0);
        Dest.LoadFromStream(stream);
      finally
        stream.Free;
      end;
    finally
      UnlockResource(hMemory);
    end;
  finally
    FreeResource(hMemory);
  end;
end;

constructor TCards.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     FState:=ctFront ;
     FCardBackStyle:=1;
     FValue:=1;
     FSuit:=csClubs;
     FDValue:=1;
     FSuitColor:=scBlack;
     AutoSize:=False;
		 Stretch:=True;
		 Width := 71;
		 Height := 96;
		 DisplayCard;
end;

procedure TCards.SetState(value:TCardState);
var
	 ID:integer;
begin
		 if value<>FState then
		 begin
					FState:=value;
					DisplayCard;
		 end;
end;

procedure TCards.SetCardBackStyle(value:integer);
begin
		 if (value>13) or (value<1) then exit;
		 if value<>FCardBackStyle then
		 begin
					FCardBackStyle:=value;
					if FState = ctBack then
						DisplayCard;
		 end;
end;

procedure TCards.SetValue(value:integer);
begin
		 if (value>13) or (value<1) then exit;
		 if value<>FValue then
		 begin
					FValue:=value;
					FDValue := value + ( 13 * ord( FSuit ) );
					if FState = ctFront then
						DisplayCard;
		 end;
end;

procedure TCards.SetDeckValue(value:integer);
begin
		 if (value>52) or (value<1) then exit;
		 if value<>FDValue then
		 begin
					FDValue:=value;
					FValue := ( ( value - 1 ) mod 13 ) + 1;
					FSuit := TCardSuit( ( value - 1 ) div 13 );
					if ( ( FSuit = csClubs ) or ( FSuit = csSpades ) ) then
						FSuitColor := scBlack
					else
						FSuitColor := scRed;
					if FState = ctFront then
						DisplayCard;
		 end;
end;

procedure TCards.SetSuit(value:TCardSuit);
begin
		 if value<>FSuit then
		 begin
					FSuit:=value;
					FDValue := FValue + ( 13 * ord( value ) );
					if ( ( FSuit = csClubs ) or ( FSuit = csSpades ) ) then
						FSuitColor := scBlack
					else
						FSuitColor := scRed;
					if FState = ctFront then
						DisplayCard;
		 end;
end;

Procedure TCards.DisplayCard;
var
	 Id:integer;
begin
		 if FState=ctFront then
				ID:=FValue+Ord(FSuit)*13
		 else
				ID:=52+FCardBackStyle;

		 LoadDLLBmp('Cards.DLL',ID,Picture.Bitmap);
end;

end.
