 unit CMB_W2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, Menus, Spin, CMButton;

type
  TForm2 = class(TForm)
    Panel1: TPanel;
    BitBtnSwitch: TBitBtn;
    PopupMenu1: TPopupMenu;
    first1: TMenuItem;
    second1: TMenuItem;
    third1: TMenuItem;
    RadioGroupPopupButton: TRadioGroup;
    RadioGroupColor: TRadioGroup;
    SpinEditBevel: TSpinEdit;
    Label1: TLabel;
    CheckBoxWordWrap: TCheckBox;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure BitBtnSwitchClick(Sender: TObject);
    procedure first1Click(Sender: TObject);
    procedure second1Click(Sender: TObject);
    procedure third1Click(Sender: TObject);
    procedure RadioGroupPopupButtonClick(Sender: TObject);
    procedure RadioGroupColorClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpinEditBevelChange(Sender: TObject);
    procedure CheckBoxWordWrapClick(Sender: TObject);
  private
    { Private-Deklarationen }
    CMBtn1, CMBtn2, CMBtn3, CMBtn4: TCMBtn;
    procedure CMBtn1Click (Sender: TObject);
    procedure CMBtn2_3Click(Sender: TObject);
  public
    { Public-Deklarationen }
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}

{**********************************************************************}
{                                                                      }
{**********************************************************************}

procedure TForm2.CMBtn1Click (Sender: TObject);
begin
  close;
end;

{**********************************************************************}
{                                                                      }
{**********************************************************************}

procedure TForm2.CMBtn2_3Click(Sender: TObject);
begin
  ShowMessage ('You''ve clicked on a button');
end;

{**********************************************************************}
{                                                                      }
{**********************************************************************}

procedure TForm2.FormCreate(Sender: TObject);
var Bitmap: TBitmap;

begin

  Bitmap := TBitmap.Create;

  Bitmap.LoadFromFile ('Exit.bmp');

  CMBtn1 := TCMBtn.Create (Self);

  with CMBtn1 do begin
    Left := 10;
    Top := 10;
    Width := 60;
    Height := 60;
    Parent := self;
    Visible := true;
    ShowHint := true;
    Name := 'CMBtn1';
    Caption := 'Click to e&xit';
    Glyph := Bitmap;
    HelpContext := 1;
    OnClick := CMBtn1Click;
  end;

  Bitmap.LoadFromFile ('Blitz.bmp');

  CMBtn2 := TCMBtn.Create (Self);

  with CMBtn2 do begin
    Left := 80;
    Top := 10;
    Width := 60;
    Height := 60;
    Parent := self;
    Visible := true;
    ShowHint := true;
    Name := 'CMBtn2';
    Caption := '&Click this button!';
    Glyph := Bitmap;
    HelpContext := 2;
    OnClick := CMBtn2_3Click;
  end;

  Bitmap.LoadFromFile ('Three.bmp');

  CMBtn3 := TCMBtn.Create (Self);

  with CMBtn3 do begin
    Left := 150;
    Top := 10;
    Width := 60;
    Height := 60;
    Parent := self;
    Visible := true;
    ShowHint := true;
    Name := 'CMBtn3';
    Caption := '&three glyphs';
    Glyph := Bitmap;
    HelpContext := 3;
    OnClick := CMBtn2_3Click;
  end;

  Bitmap.LoadFromFile ('Bulb.bmp');

  CMBtn4 := TCMBtn.Create (Self);

  with CMBtn4 do begin
    Left := 220;
    Top := 10;
    Width := 60;
    Height := 60;
    Parent := self;
    Visible := true;
    ShowHint := true;
    Name := 'CMBtn4';
    Caption := 'with &popup';
    Glyph := Bitmap;
    HelpContext := 4;
    PopUpMenu := PopUpMenu1;
  end;

  Bitmap.Free;

end;

{**********************************************************************}
{                                                                      }
{**********************************************************************}

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  CMBtn1.Free;
  CMBtn2.Free;
  CMBtn3.Free;
  CMBtn4.Free;
end;

{**********************************************************************}
{                                                                      }
{**********************************************************************}

procedure TForm2.BitBtnSwitchClick(Sender: TObject);
begin

  CMBtn1.Enabled := not CMBtn1.Enabled;
  CMBtn2.Enabled := not CMBtn2.Enabled;
  CMBtn3.Enabled := not CMBtn3.Enabled;
  CMBtn4.Enabled := not CMBtn4.Enabled;

  if CMBtn1.Enabled then
    BitBtnSwitch.Caption := 'Disable'
  else
    BitBtnSwitch.Caption := 'Enable';

end;

{**********************************************************************}
{                                                                      }
{**********************************************************************}

procedure TForm2.first1Click(Sender: TObject);
begin
  ShowMessage ('You''ve clicked in popup menu "first"');
end;

{**********************************************************************}
{                                                                      }
{**********************************************************************}

procedure TForm2.second1Click(Sender: TObject);
begin
  ShowMessage ('You''ve clicked in popup menu "second"');
end;

{**********************************************************************}
{                                                                      }
{**********************************************************************}

procedure TForm2.third1Click(Sender: TObject);
begin
  ShowMessage ('You''ve clicked in popup menu "third"');
end;

{**********************************************************************}
{                                                                      }
{**********************************************************************}

procedure TForm2.RadioGroupPopupButtonClick(Sender: TObject);
begin
  case RadioGroupPopupButton.ItemIndex of
    0: CMBtn4.PopupButton := mbLeft;
    1: CMBtn4.PopupButton := mbRight;
  end;
end;

{**********************************************************************}
{                                                                      }
{**********************************************************************}

procedure TForm2.RadioGroupColorClick(Sender: TObject);
var Color: TColor;
begin
  case RadioGroupColor.ItemIndex of
    0: Color := clWindowText;
    1: Color := clRed;
    2: Color := clNavy;
  end;
  CMBtn1.Font.Color := Color;
  CMBtn2.Font.Color := Color;
  CMBtn3.Font.Color := Color;
  CMBtn4.Font.Color := Color;
end;

{**********************************************************************}
{                                                                      }
{**********************************************************************}

procedure TForm2.SpinEditBevelChange(Sender: TObject);
begin
  CMBtn1.BevelWidth := SpinEditBevel.Value;
  CMBtn2.BevelWidth := SpinEditBevel.Value;
  CMBtn3.BevelWidth := SpinEditBevel.Value;
  CMBtn4.BevelWidth := SpinEditBevel.Value;
end;

{**********************************************************************}
{                                                                      }
{**********************************************************************}

procedure TForm2.CheckBoxWordWrapClick(Sender: TObject);
begin
  CMBtn1.WordWrap := CheckBoxWordWrap.Checked;
  CMBtn2.WordWrap := CheckBoxWordWrap.Checked;
  CMBtn3.WordWrap := CheckBoxWordWrap.Checked;
  CMBtn4.WordWrap := CheckBoxWordWrap.Checked;
end;

end.
