unit Demo1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ColorButton, StdCtrls, ComCtrls, ExtCtrls;

type
  TfrmMain = class(TForm)
  	pnlDisplay: TPanel;
    btnColorButton: TColorButton;
    gbxProperties: TGroupBox;
    lblAlignment: TLabel;
    cbxAlignment: TComboBox;
    lblBevelSize: TLabel;
    txtBevelSize: TEdit;
    spnBevelSize: TUpDown;
    lblBevelStyle: TLabel;
    cbxBevelStyle: TComboBox;
    lblCaption: TLabel;
    txtCaption: TEdit;
    lblColor: TLabel;
    txtColor: TEdit;
    btnColor: TButton;
    lblFont: TLabel;
    txtFont: TEdit;
    btnFont: TButton;
    chkEnabled: TCheckBox;
    chkAutoSize: TCheckBox;
    chkCenter: TCheckBox;
    chkStretch: TCheckBox;
    chkShowFocus: TCheckBox;
    lblPicture: TLabel;
    txtPicture: TEdit;
    btnPicture: TButton;
    lblSpacing: TLabel;
    txtSpacing: TEdit;
    spnSpacing: TUpDown;
    dlgColor: TColorDialog;
    dlgFont: TFontDialog;
    dlgOpen: TOpenDialog;
    procedure OnInitialize(Sender: TObject);
    procedure OnChangeAlignment(Sender: TObject);
    procedure OnChangeCaption(Sender: TObject);
    procedure OnChangeBevelSize(Sender: TObject);
    procedure OnChangeBevelStyle(Sender: TObject);
    procedure OnBrowseColor(Sender: TObject);
    procedure OnBrowseFont(Sender: TObject);
    procedure OnBrowsePicture(Sender: TObject);
    procedure OnChangeSpacing(Sender: TObject);
    procedure OnChangeEnabled(Sender: TObject);
    procedure OnChangeStyle(Sender: TObject);
    procedure OnMoveToCenter(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.OnInitialize(Sender: TObject);
begin
	// Initialize the app
  cbxAlignment.ItemIndex := 4;
  cbxBevelStyle.ItemIndex := 2;

  OnMoveToCenter(Self);
end;

procedure TfrmMain.OnChangeAlignment(Sender: TObject);
begin
	case cbxAlignment.ItemIndex of
  	0: btnColorButton.Alignment := alTopLeft;
    1: btnColorButton.Alignment := alTopCenter;
    2: btnColorButton.Alignment := alTopRight;
    3: btnColorButton.Alignment := alMiddleLeft;
    4: btnColorButton.Alignment := alMiddleCenter;
    5: btnColorButton.Alignment := alMiddleRight;
    6: btnColorButton.Alignment := alBottomLeft;
    7: btnColorButton.Alignment := alBottomCenter;
    8: btnColorButton.Alignment := alBottomRight;
  end;
end;

procedure TfrmMain.OnChangeCaption(Sender: TObject);
begin
	btnColorButton.Caption := txtCaption.text;
end;

procedure TfrmMain.OnChangeBevelSize(Sender: TObject);
begin
	btnColorButton.BevelSize := spnBevelSize.Position;

  OnMoveToCenter(Self);
end;

procedure TfrmMain.OnChangeBevelStyle(Sender: TObject);
begin
	case cbxBevelStyle.ItemIndex of
  	0: btnColorButton.BevelStyle := bbNone;
    1: btnColorButton.BevelStyle := bbLowered;
    2: btnColorButton.BevelStyle := bbRaised;
  end;
end;

procedure TfrmMain.OnBrowseColor(Sender: TObject);
begin
	dlgColor.Color := btnColorButton.Color;
	if dlgColor.Execute then
  begin
  	btnColorButton.Color := dlgColor.Color;
    txtColor.Text := ColorToString(dlgColor.Color);
  end;
end;

procedure TfrmMain.OnBrowseFont(Sender: TObject);
begin
	dlgFont.Font := btnColorButton.Font;
  if dlgFont.Execute then
  begin
  	btnColorButton.Font := dlgFont.Font;
    txtFont.Text := dlgFont.Font.Name;
  end;
end;

procedure TfrmMain.OnBrowsePicture(Sender: TObject);
begin
	if dlgOpen.Execute then
  begin
  	btnColorButton.Picture.LoadFromFile(dlgOpen.FileName); btnColorButton.Repaint;
    if LowerCase(ExtractFileExt(dlgOpen.Filename)) = '.bmp' then txtPicture.Text := '(Bitmap)';
    if LowerCase(ExtractFileExt(dlgOpen.Filename)) = '.ico' then txtPicture.Text := '(Icon)';
    if LowerCase(ExtractFileExt(dlgOpen.Filename)) = '.wmf' then txtPicture.Text := '(Metafile)';
    if LowerCase(ExtractFileExt(dlgOpen.Filename)) = '.emf' then txtPicture.Text := '(Enhanced Metafile)';

  	OnMoveToCenter(Self);
  end;
end;

procedure TfrmMain.OnChangeSpacing(Sender: TObject);
begin
	btnColorButton.Spacing := spnSpacing.Position;

  OnMoveToCenter(Self);
end;

procedure TfrmMain.OnChangeEnabled(Sender: TObject);
begin
	btnColorButton.Enabled := chkEnabled.Checked;
end;

procedure TfrmMain.OnChangeStyle(Sender: TObject);
begin
	btnColorButton.Style := [];
  if chkAutoSize.Checked then btnColorButton.Style := btnColorButton.Style + [bsAutoSize];
  if chkCenter.Checked then btnColorButton.Style := btnColorButton.Style + [bsCenter];
  if chkStretch.Checked then btnColorButton.Style := btnColorButton.Style + [bsStretch];
  if chkShowFocus.Checked then btnColorButton.Style := btnColorButton.Style + [bsShowFocus];

  OnMoveToCenter(Self);
end;

procedure TfrmMain.OnMoveToCenter(Sender: TObject);
begin
	btnColorButton.Left := (pnlDisplay.Width - btnColorButton.Width) div 2;
  btnColorButton.Top := (pnlDisplay.Height - btnColorButton.Height) div 2;
end;

end.
