{ -------------------------------------------------------------------------------------}
{ A "break apart strings" component for Delphi32.                                      }
{ Copyright 1996, Patrick Brisacier and Jean-Fabien Connault.  All Rights Reserved.    }
{ This component can be freely used and distributed in commercial and private          }
{ environments, provided this notice is not modified in any way.                       }
{ -------------------------------------------------------------------------------------}
{ Feel free to contact us if you have any questions, comments or suggestions at        }
{   PBrisacier@mail.dotcom.fr (Patrick Brisacier)                                      }
{   JFConnault@mail.dotcom.fr (Jean-Fabien Connault)                                   }
{ You can always find the latest version of this component at:                         }
{   http://www.worldnet.net/~cycocrew/delphi/                                          }
{ -------------------------------------------------------------------------------------}
{ Date last modified:  06/12/96                                                        }
{ -------------------------------------------------------------------------------------}

{ -------------------------------------------------------------------------------------}
{ TBrkApart v1.00                                                                      }
{ -------------------------------------------------------------------------------------}
{ Description:                                                                         }
{   A component that allows you to break apart strings.                                }
{ Properties:                                                                          }
{   property BreakString: String;                                                      }
{   property BaseString: String;                                                       }
{   property AllowEmptyString: Boolean;                                                }
{   property StringList: TStringList;                                                  }
{ Procedures and functions:                                                            }
{   procedure BreakApart;                                                              }
{   procedure ReverseBreakApart;                                                       }
{                                                                                      }
{ See example contained in example.zip file for more details.                          }
{ -------------------------------------------------------------------------------------}
{ Revision History:                                                                    }
{ 1.00:  + Initial release                                                             }
{ -------------------------------------------------------------------------------------}

unit Brkapart;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TBrkApart = class(TComponent)
  private
    { Private-dclarations }
    FBaseString: String;
    FBreakString: String;
    FAllowEmptyString: Boolean;
    FStringList: TStringList;
    procedure SetStringList(AStringList: TStringList);
  protected
    { Protected-dclarations }
  public
    { Public-dclarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure BreakApart;
    procedure ReverseBreakApart;
  published
    { Published-dclarations }
    property BreakString: String read FBreakString write FBreakString;
    property BaseString: String read FBaseString write FBaseString;
    property AllowEmptyString: Boolean read FAllowEmptyString write FAllowEmptyString;
    property StringList: TStringList read FStringList write SetStringList;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Systme', [TBrkApart]);
end;

constructor TBrkApart.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FStringList := TStringList.Create;
end;

destructor TBrkApart.Destroy;
begin
  FStringList.Free;
  inherited Destroy;
end;

procedure TBrkApart.SetStringList(AStringList: TStringList);
begin
  FStringList.Assign(AStringList);
end;

procedure TBrkApart.BreakApart;
var
  EndOfCurrentString: Integer;
  TempStr, TempBaseString: string;
begin
  FStringList.Clear;
  TempBaseString := FBaseString;
  repeat
    EndOfCurrentString := Pos(FBreakString, TempBaseString);
    if EndOfCurrentString = 0 then
      TempStr := TempBaseString
    else
      TempStr := Copy(TempBaseString, 1, EndOfCurrentString - 1);

    if ((TempStr = '') and FAllowEmptyString) or (TempStr <> '') then
      FStringList.add(TempStr);

    TempBaseString := Copy(TempBaseString, EndOfCurrentString + length(FBreakString),
                        length(TempBaseString) - EndOfCurrentString);
  until EndOfCurrentString = 0;
end;

procedure TBrkApart.ReverseBreakApart;
var
  i: Integer;
begin
  if FStringList.Count > 0 then
  begin
    FBaseString := FStringList[0];
    for i := 1 to FStringList.Count - 1 do
      if ((FStringList[i] = '') and FAllowEmptyString) or (FStringList[i] <> '') then
        FBaseString := FBaseString + FBreakString + FStringList[i];
  end
  else
    FBaseString := '';
end;

end.
