{******************************************************************************}
{*                              Delphi Cleanup                                *}
{******************************************************************************}
{*Erstellt/Gendert am:   01.08.97 um 19:32:53                                *}
{*                                                                            *}
{*Projekt:                Extracted from TinyTools 1.2                        *}
{*                                                                            *}
{*Erstellt von:           R.Dold                                              *}
{*                                                                            *}
{*History/Bemerkungen:    Headers by TinyTools Comment-Expert!                *}
{*                        Source Formating by TinyTools Formater              *}
{*                                                                            *}
{******************************************************************************}

UNIT cleaner;

INTERFACE

USES
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileFind,ComCtrls,Buttons, ExtCtrls,Registry;

TYPE
  TCleanForm = CLASS(TForm)
    ListBox1: TListBox;
    SButn: TButton;
    LABEL1: TLabel;
    GroupBox1: TGroupBox;
    StatusBar: TStatusBar;
    LABEL2: TLabel;
    DelBtn: TButton;
    CBtn: TButton;
    Panel1: TPanel;
    GetDirBtn: TSpeedButton;
    DirEdit: TEdit;
    SubDirs: TCheckBox;
    Dcus: TCheckBox;
    Exes: TCheckBox;
    dsk: TCheckBox;
    FileFind1: TFileFind;
    PROCEDURE SButnClick(Sender: TObject);
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE DirEditChange(Sender: TObject);
    PROCEDURE FileFind1Terminated(Sender: TObject);
    PROCEDURE ListBox1DblClick(Sender: TObject);
    PROCEDURE ListBox1Click(Sender: TObject);
    PROCEDURE CBtnClick(Sender: TObject);
    PROCEDURE DelBtnClick(Sender: TObject);
    PROCEDURE FormDestroy(Sender: TObject);
    PROCEDURE GetDirBtnClick(Sender: TObject);
  PRIVATE
    { Private-Deklarationen }
  PUBLIC
    StrHolder: TStrings;
        MyReg: TRegIniFile;
    PROCEDURE Clean_It;
  END;

    FUNCTION FILESIZE(CONST FileName: STRING): LONGINT;
    PROCEDURE FileShredder(CONST Filename: STRING);

VAR
  CleanForm: TCleanForm;
  Sizes    : LONGINT;
 
IMPLEMENTATION

USES dirs;

{$R *.DFM}

{******************************************************************************}
{*                   Ermitteln der Filegrsse von FileName                    *}
{******************************************************************************}
//Gets the FILESIZE OF FileName
FUNCTION FILESIZE(CONST FileName: STRING): LONGINT;
VAR
  SEARCHREC       : TSearchRec;
BEGIN
  IF FindFirst(FileName,faAnyFile,SEARCHREC)=0
    THEN Result:=SEARCHREC.Size
    ELSE Result:=0;
END;

{******************************************************************************}
{*                             Lschen des Files                              *}
{******************************************************************************}
//My Personal Thrashcan ;)
PROCEDURE FileShredder(CONST Filename: STRING);
VAR
  aFile : INTEGER;
  aSize : INTEGER;
  P     : Pointer;
BEGIN
  aSize:=FILESIZE(Filename);
  aFile:=FileOpen(FileName,fmOpenReadWrite);
  TRY
    GETMEM(P,aSize);
    FILLCHAR(P^,aSize,'X');
    FileWrite(aFile,P^,aSize);
    FREEMEM(P,aSize);
  FINALLY
    FileClose(aFile);
    DeleteFile(Filename);
  END;
END;


{******************************************************************************}
{*                     Weiterverarbeitung der Fileliste                       *}
{******************************************************************************}
//Processes the Filelist
PROCEDURE TCleanForm.Clean_It;
VAR
I       : INTEGER;
PasFile : STRING;
BEGIN
 FOR I :=0 TO FileFind1.FilesFound.Count -1 DO
 BEGIN //Clean_It
  IF Dcus.Checked AND (Uppercase(ExtractFileExt(FileFind1.FilesFound[I]))='.DCU')
   THEN
    BEGIN //Pas-FILE suchen
     PasFile:=COPY(FileFind1.FilesFound[i],1,LENGTH(FileFind1.FilesFound[i])-4)+
                    '.pas';
     IF FileExists(PasFile)THEN StrHolder.Add(FileFind1.FilesFound[I]);
    END //Pas FILE suchen
 //----------------------------------------------------------------------------
 ELSE
 IF EXES.Checked AND (Uppercase(ExtractFileExt(FileFind1.FilesFound[I]))='.EXE')
  THEN
   BEGIN //dpr-FILE suchen
    PasFile:=COPY(FileFind1.FilesFound[i],1,LENGTH(FileFind1.FilesFound[i])-4)+
                    '.dpr';
    IF FileExists(PasFile)THEN StrHolder.Add(FileFind1.FilesFound[I]);
   END //dpr FILE suchen
 //----------------------------------------------------------------------------
 ELSE
 IF dsk.Checked AND (Uppercase(ExtractFileExt(FileFind1.FilesFound[I]))='.DSK')
  THEN StrHolder.Add(FileFind1.FilesFound[I])
 //----------------------------------------------------------------------------
 ELSE
 StrHolder.Add(FileFind1.FilesFound[I]);
 //----------------------------------------------------------------------------
END;
  FileFind1.FilesFound.ASSIGN(StrHolder);
END;//Clean_It


{******************************************************************************}
{*                              Formerstellung                                *}
{******************************************************************************}
//Create OF the MainForm
PROCEDURE TCleanForm.FormCreate(Sender: TObject);
BEGIN
 StrHolder:= TStringList.Create;
    MyReg := TRegIniFile.Create('Software\CleanUp');
 DirEdit.TEXT:=GetCurrentDir;
 FileFind1.StartDir:=DirEdit.TEXT;
 WITH MyReg DO
  BEGIN
   Subdirs.Checked:= ReadBool('Defaults','SubDirs',SubDirs.Checked);
   DCus.Checked   := ReadBool('Defaults','Dcu',DCus.Checked);
   Exes.Checked   := ReadBool('Defaults','Exe',Exes.Checked);
   Dsk.Checked    := ReadBool('Defaults','Dsk',Dsk.Checked);
  END;
 END;


{******************************************************************************}
{*                            Suchen der Dateien                              *}
{******************************************************************************}
//Search Files...
PROCEDURE TCleanForm.SButnClick(Sender: TObject);
BEGIN
 StrHolder.Clear;
 FileFind1.FilePattern:='*.~*';
  IF DCUs.Checked THEN FileFind1.FilePattern:=FileFind1.FilePattern+';*.DCU';
  IF EXEs.Checked THEN FileFind1.FilePattern:=FileFind1.FilePattern+';*.EXE';
  IF DSK.Checked  THEN FileFind1.FilePattern:=FileFind1.FilePattern+';*.DSK';
 FileFind1.Recursive:=SubDirs.Checked;
 StatusBar.Panels.Items[0].TEXT := 'Searching Files...';
 CleanForm.Cursor:=CRHourGlass;
 FileFind1.ThreadExecute;  //Use the Filesearch AS Thread!
END;

{******************************************************************************}
{*                      Wechseln des Suchverzeichnisses                       *}
{******************************************************************************}
//Change Working Dir
PROCEDURE TCleanForm.DirEditChange(Sender: TObject);
BEGIN
FileFind1.StartDir:=DirEdit.TEXT;
END;

{******************************************************************************}
{*               Dateisuche abgeschlossen,Ergebniss auswerten                 *}
{******************************************************************************}
//FILE search done...
PROCEDURE TCleanForm.FileFind1Terminated(Sender: TObject);
VAR
   I     :LONGINT;
BEGIN
Clean_It;
Listbox1.Items.ASSIGN(FileFind1.FilesFound);
StatusBar.Panels.Items[0].TEXT := 'Done';
CleanForm.Cursor:=CRDefault;
Sizes:=0;
FOR I:=0 TO Listbox1.items.count-1 DO
BEGIN
sizes:=Sizes+FILESIZE(Listbox1.Items[I]);
END;
StatusBar.Panels.Items[1].TEXT:=IntToStr(Listbox1.Items.Count)+' Files with '+
                                IntToStr(Sizes DIV 1024)+' Kb found';
END;


{******************************************************************************}
{*               Doppelklick in die Listbox,Eintrag entfernen                 *}
{******************************************************************************}
//Remove Entry after Double-Click
PROCEDURE TCleanForm.ListBox1DblClick(Sender: TObject);
VAR
   I :INTEGER;
BEGIN
ListBox1.Items.DELETE(Listbox1.Itemindex);
Sizes:=0;
FOR I:=0 TO Listbox1.items.count-1 DO
BEGIN
sizes:=Sizes+FILESIZE(Listbox1.Items[I]);
END;
StatusBar.Panels.Items[1].TEXT:=IntToStr(Listbox1.Items.Count)+' Files with '+
                                IntToStr(Sizes DIV 1024)+' Kb found';
END;

{******************************************************************************}
{*                     Auswerten der Dateiatt nach klick                      *}
{******************************************************************************}
//ListBox Entry Clicked...
PROCEDURE TCleanForm.ListBox1Click(Sender: TObject);
BEGIN
StatusBar.Panels.Items[2].TEXT:='Filename:'+
ExtractFilename(ListBox1.Items[Listbox1.ItemIndex])+'  Size:'+
IntTostr(FILESIZE(ListBox1.Items[Listbox1.ItemIndex])DIV 1024)+'kb';
END;

{******************************************************************************}
{*                                App beenden                                 *}
{******************************************************************************}
//CancelBtn Clicked
PROCEDURE TCleanForm.CBtnClick(Sender: TObject);
BEGIN
CLOSE;
END;

{******************************************************************************}
{*                              Dateien lschen                               *}
{******************************************************************************}
//DELETE Files IN List
PROCEDURE TCleanForm.DelBtnClick(Sender: TObject);
VAR i:INTEGER;
BEGIN
FOR I:=0 TO Listbox1.items.count-1 DO
BEGIN
Fileshredder(Listbox1.Items.Strings[I]);
END;
StatusBar.Panels.Items[1].TEXT:=IntToStr(Listbox1.Items.Count)+' Files with '+
                                IntToStr(Sizes DIV 1024)+' Kb deleted';
ListBox1.Items.Clear;
END;

{******************************************************************************}
{*                       Form schlieen,Reg schreiben                         *}
{******************************************************************************}
//WRITE reg Entrys,CLOSE Form
PROCEDURE TCleanForm.FormDestroy(Sender: TObject);
BEGIN
 WITH MyReg DO
  BEGIN
   WriteBool('Defaults','SubDirs',SubDirs.Checked);
   WriteBool('Defaults','Dcu',DCus.Checked);
   WriteBool('Defaults','Exe',Exes.Checked);
   WriteBool('Defaults','Dsk',Dsk.Checked);
  END;
StrHolder.Free;
MyReg.Free;
END;

{******************************************************************************}
{*                            Verzeichniss whlen                             *}
{******************************************************************************}
//Get Working-Dir
PROCEDURE TCleanForm.GetDirBtnClick(Sender: TObject);
BEGIN
Application.CreateForm(TDirForm,DirForm);
DirForm.Showmodal;
DirForm.Free;
END;

END.
