unit GraphStyle;

interface

uses
  Windows, Graphics, Classes, Forms,
  ExtCtrls, StdCtrls, Buttons, GraphView, Controls;

type
  TGraphStyleDialog = class(TForm)
    LineBtn: TSpeedButton;
    BarBtn: TSpeedButton;
    AreaBtn: TSpeedButton;
    PointBtn: TSpeedButton;
    B1: TBevel;
    OkBtn: TButton;
    CancelBtn: TButton;
    procedure LineBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure LineBtnDblClick(Sender: TObject);
  private
    procedure ResetAll;
  public
    CurrentBtn: TGraphStyle;
  end;

var
  GraphStyleDialog: TGraphStyleDialog;

implementation

{$R *.DFM}

procedure TGraphStyleDialog.ResetAll;
begin
  LineBtn.Font.Style := [];
  BarBtn.Font.Style := [];
  AreaBtn.Font.Style := [];
  PointBtn.Font.Style := [];
end;

procedure TGraphStyleDialog.LineBtnClick(Sender: TObject);
begin
  ResetAll;
  (Sender as TSpeedButton).Font.Style := [fsBold];
  CurrentBtn := TGraphStyle((Sender as TSpeedButton).Tag);
end;

procedure TGraphStyleDialog.FormShow(Sender: TObject);
begin
  ResetAll;
  case CurrentBtn of
    gsLine: begin
             LineBtn.Down := True;
             LineBtn.Font.Style := [fsBold];
            end;
    gsBar: begin
            BarBtn.Down := True;
            BarBtn.Font.Style := [fsBold];
           end;
    gsArea: begin
             AreaBtn.Down := True;
             AreaBtn.Font.Style := [fsBold];
            end;
    gsPoint: begin
              PointBtn.Down := True;
              PointBtn.Font.Style := [fsBold];
             end;
   end;
end;

procedure TGraphStyleDialog.LineBtnDblClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

end.
