unit tdemo1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ticker;

type
  TTickerform = class(TForm)
    B_Initiate: TButton;
    B_Scroll: TButton;
    ComboBox1: TComboBox;
    Label1: TLabel;
    CF_Ticker1: TCF_Ticker;
    Label2: TLabel;
    Edit1: TEdit;
    Label3: TLabel;
    Edit2: TEdit;
    procedure B_InitiateClick(Sender: TObject);
    procedure B_ScrollClick(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Tickerform: TTickerform;
  WorkBitMap: TBitMap;    // Use a global bitmap to save memory

implementation

{$R *.DFM}

procedure TTickerform.B_InitiateClick(Sender: TObject);
begin
  CF_Ticker1.Initialize;            // ALWAYS call this procedure the first thing you do with the ticker
end;

procedure TTickerform.B_ScrollClick(Sender: TObject);
begin
  CF_Ticker1.Step := StrToInt(Edit1.Text);
  CF_Ticker1.Speed := StrToInt(Edit2.Text);
  // The ShowTickerData - procedure will scroll the selected bitmap immidiately
  CF_Ticker1.ShowTickerData(WorkBitmap);
end;

procedure TTickerform.ComboBox1Change(Sender: TObject);
begin
  Case ComboBox1.ItemIndex of
    0:CF_Ticker1.ScrollType := stLeftToRight;
    1:CF_Ticker1.ScrollType := stRightToLeft;
    2:CF_Ticker1.ScrollType := stBottomToTop;
    3:CF_Ticker1.ScrollType := stTopToBottom;
  End;
end;

procedure TTickerform.FormDestroy(Sender: TObject);
begin
  WorkBitmap.Free;   // Don't forget this
end;

procedure TTickerform.FormCreate(Sender: TObject);
begin
  // Building a sample bitmap, this can bitmap can have any look. The important thing to have in mind is
  // that the bitmap have to be less or equal to the tickers width and height
  WorkBitmap := TBitMap.Create;
  WorkBitmap.Width := 569;
  WorkBitmap.Height := 40;
  WorkBitmap.Canvas.Brush.Color := clBlack;
  WorkBitmap.Canvas.FillRect(Rect(0,0,569,40));
  With WorkBitmap.Canvas.Font do begin
    Name := 'Arial';
    Size := 18;
    Style := [fsBold,fsItalic];
    Color := clTeal;
  End;
  WorkBitmap.Canvas.TextOut(5,5,'Welcome to the TCF_Ticker - component demo !');
  WorkBitmap.Canvas.Font.Color := clAqua;
  WorkBitmap.Canvas.TextOut(7,7,'Welcome to the TCF_Ticker - component demo !');
end;

end.
