
{*******************************************************}
{                                                       }
{       Delphi Runtime Library                          }
{                                                       }
{       Partial translation of DBT.H                    }
{                                                       }
{       version : 4.00                                  }
{       Date : 24 May 1993                              }
{       Copyright (c) 1993-1996 Microsoft Corporation   }
{                                                       }
{       Equates for WM_DEVICECHANGE                     }
{                                                       }
{       Copyright (p) 1998 ZifNab (T. Deprez)           }
{                                                       }
{*******************************************************}

{*******************************************************}
{ [History :]                                           }
{   18-01-1998 : first release                          }
{   21-02-1998 : added OEM, NET and PORT structures     }                                                       
{ [FUTURE :]                                            }
{   - further translation of DBT.H                      }
{                                                       }
{*******************************************************}

unit DBTMsg;

interface
uses windows;

const
 (* Events of WM_DEVICECHANGE (wParam) *)

  DBT_DEVICEARRIVAL = $8000;            (* system detected a new device *)
  DBT_DEVICEQUERYREMOVE = $8001;        (* wants to remove, may fail *)
  DBT_DEVICEQUERYREMOVEFAILED = $8002;  (* removal aborted *)
  DBT_DEVICEREMOVEPENDING = $8003;      (* about to remove, still avail *)
  DBT_DEVICEREMOVECOMPLETE = $8004;     (* device is gone *)
  DBT_DEVICETYPESPECIFIC = $8005;       (* type specific event *)
  DBT_CONFIGCHANGED = $0018;

 (* type of device in DEV_BROADCAST_HDR *)
  DBT_DEVTYP_OEM = $00000000;           (* OEM- or IHV-defined *)
  DBT_DEVTYP_DEVNODE = $00000001;       (* Devnode number *)
  DBT_DEVTYP_VOLUME = $00000002;        (* Logical volume *)
  DBT_DEVTYP_PORT = $00000003;          (* Port (serial or parallel *)
  DBT_DEVTYP_NET = $00000004;           (* Network resource *)

  (* media types in DBT_DEVTYP_VOLUME *)
  DBTF_MEDIA = $0001;
  DBTF_NET = $0002;                     (* logical volume is network volume *)

type

 (* window structures *)

 PDEV_BROADCAST_HDR = ^TDEV_BROADCAST_HDR;
 TDEV_BROADCAST_HDR = packed record
   dbch_size : DWORD;
   dbch_devicetype : DWORD;
   dbch_reserved : DWORD;
  end;

  PDEV_BROADCAST_VOLUME = ^TDEV_BROADCAST_VOLUME;
  TDEV_BROADCAST_VOLUME = packed record
   dbcv_size : DWORD;
   dbcv_devicetype : DWORD;
   dbcv_reserved : DWORD;
   dbcv_unitmask : DWORD;
   dbcv_flags : WORD;
  end;

  PDEV_BROADCAST_NET = ^TDEV_BROADCAST_NET;
  TDEV_BROADCAST_NET = packed record
   dbcn_size : DWORD;
   dbcn_devicetype : DWORD;
   dbcn_reserved : DWORD;
   dbcn_resource : DWORD;
   dbcn_flags : DWORD;
  end;

  PDEV_BROADCAST_PORT = ^TDEV_BROADCAST_PORT;
  TDEV_BROADCAST_PORT = packed record
   dbcp_size : DWORD;
   dbcp_devicetype : DWORD;
   dbcp_reserved : DWORD;
   dbcp_name : PCHAR;
  end;

  PDEV_BROADCAST_OEM = ^TDEV_BROADCAST_OEM;
  TDEV_BROADCAST_OEM = packed record
   dbco_size : DWORD;
   dbco_devicetype : DWORD;
   dbco_reserved : DWORD;
   dbco_identifier : DWORD;
   dbco_suppfunc : DWORD;
  end;

  TWMDeviceChange = record
   Msg : Cardinal;
   Event : UINT;
   dwData : Pointer;
   Result : LongInt;
  end;


implementation

end.
