{*****************************************************************************}
{ [TAudioCDEVENTS]                                                            }
{   Special Units = DBTMsg                                                    }
{   Version = 1.0                                                             }
{ [SOURCE]                                                                    }
{   Copyright  1998 by Tom Deprez                                            }
{   (Just to prevent to get multiple components, which all have great         }
{    things but would be a GREAT component with a lot (all) of GREAT things   }
{    That way everybody can benefit of such a GREAT component)                }
{ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ }
{ [COMPONENT]                                                                 }
{   Derived from TCDEVENTS                                                    }
{   Some properties and events, special to audio CD's                         }
{ [properties]                                                                }
{   AudioAutoRun : Disable/Enable audio autorun feature                       }
{   AutoRun      : See TCDEvents                                              }
{ [events]                                                                    }
{   See TCDEvents                                                             }
{                                                                             }
{ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ }
{ [AUTHOR]                                                                    }
{   Author name   = ZifNab (Tom Deprez)                                       }
{   Author e-mail = tom.deprez@uz.kuleuven.ac.be                              }
{ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ }
{ [HISTORY]                                                                   }
{   21/02/1998 : first release                                                }
{   24/02/1998 : added ability to change application that starts with CD      }
{                                                                             }
{*****************************************************************************}

{*****************************************************************************}
{  [COMMENTS]                                                                 }
{   I very often visit the Delphi page of the www.Experts-Exchange.com site   }
{   It's a place where you can ask or answer questions. One day somebody      }
{   needed to know when a CD is inserted in or ejected out of the CD-Rom      }
{   drive. I found it an interesting question, especially because I could     }
{   not find some 'delphi' source for this problem.                           }
{   I started to search for a solution.                                       }
{   Well, that was the beginning of this component. Where it ends?            }
{   That I don't know, it really depends on the reaction of you! If I get     }
{   some reaction, I'll futher improve it, otherwise it sticks with this.     }
{   Too bad, because I think it can become a great tool.                      }
{                                                                             }
{  [IMPORTANT]                                                                }
{    Made some improvements? : please let me know of, so I can update it      }
{    Need some improvements? : please, just ask and I'll try to make it       }
{    Have you got some ideas? : please, send them to me                       }
{    You use this component? : please, send me an e-mail, why you use this    }
{                              component. An E-mail isn't asked too much.     }
{                              Isn't it? At least let me know of the fact     }
{                              you're using it. It makes me very HAPPY!       }
{  [THANKS]                                                                   }
{    Matvey who brought the first idea to this component                      }
{    Perhaps YOU?                                                             }
{                                                                             }
{ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ }
{  [COPYRIGHT]                                                                }
{    This file is distributed as freeware and without warranties of any       }
{    kind. You can use it in your own applications at your own risk.          }
{                                                                             }
{  [NOTE]                                                                     }
{    It's freeware, but don't hesitate to send me some money if you've        }
{    become rich with the help of this component ;-)                          }
{    It's freeware, but don't hesitate to send me the program or the          }
{    component, where you use this component in. I would be ever gratefull    }
{    to you, thanks.                                                          }
{*****************************************************************************}

unit AudioCDEvents;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CDEvents, Registry;

type
  TAudioCdResetOption = (rAutorun, rPlayer);
  TAudioCDResetOptions = set of TAudioCDResetOption;

  TAudioCDOptions = class(TPersistent)
  private
    fAutoReset : Boolean;
    fOldAudioAutoRun : Boolean;
    fOldAudioPlayer : String;
    fResetOptions : TAudioCDResetOptions;
  protected
    procedure SetAudioCDAutoRun(vAudioAutoRun : Boolean);
    function GetAudioCDAutoRun : Boolean;
    procedure SetAudioCDPlayer(vAudioPlayer: String);
    function GetAudioCDPlayer : String;
  public
    constructor Create;
    destructor Destroy; override;
    procedure ResetAudioCDOptions;
  published
    property AutoReset : Boolean read fAutoReset write fAutoReset default true;
    property AutoRun: Boolean read GetAudioCDAutoRun write SetAudioCDAutoRun;
    property Player: String read GetAudioCDPlayer write SetAudioCDPlayer;
    property Reset: TAudioCDResetOptions read fResetOptions write fResetOptions;
  end;

  TAudioCDEvents = class(TCDEvents)
  private
    { Private declarations }
    fExtraOptions : TAudioCDOptions;
  protected
    { Protected declarations }
     procedure SetExtraOptions(value : TAudioCDOptions);
  public
    { Public declarations }
     constructor Create(AOwner: TComponent); override;
     destructor Destroy; override;
  published
    { Published declarations }
    property OptionsExtra : TAudioCDOptions read fExtraOptions
                                              write SetExtraOptions;
  end;

implementation

{************************** tAudioCDOptions component *************************}

constructor TAudioCDOptions.Create;
begin
 fResetOptions := [rAutoRun, rPlayer];
 fAutoReset := true;
 fOldAudioAutoRun := GetAudioCDAutoRun;
 fOldAudioPlayer := GetAudioCDPlayer;
end;

destructor TAudioCDOptions.Destroy;
begin
 if fAutoReset then ResetAudioCDOptions;
 inherited Destroy;
end;

function TAudioCDOptions.GetAudioCDAutoRun : Boolean;
 (* this code comes from Delphi Developer Support *)
var reg : TRegistry;
    Classes : String;
    ClassesRoot : String;
    i : integer;
begin
 reg := TRegistry.Create;
 with reg do begin
  Rootkey := HKEY_LOCAL_MACHINE;
  OpenKey('Software\Classes\AudioCD\Shell', false);
  Classes := ReadString('');
  CloseKey;
  RootKey := HKEY_CLASSES_ROOT;
  OpenKey('AudioCD\Shell', false);
  ClassesRoot := ReadString('');
  CloseKey;
  Free;
 end;
 for i:= 1 to length(Classes) do
  Classes[i] := UpCase(Classes[i]);
 for i:= 1 to length(ClassesRoot) do
  ClassesRoot[i] := UpCase(ClassesRoot[i]);
 result := ((Classes = 'PLAY') and
            (ClassesRoot = 'PLAY'));
end;

procedure TAudioCDOptions.SetAudioCDAutoRun(vAudioAutoRun:Boolean);
 (* this code comes from Delphi Developer Support *)
var reg : TRegistry;
    Classes : String;
    ClassesRoot : String;
begin
 reg := TRegistry.Create;
 with reg do begin
  RootKey := HKEY_LOCAL_MACHINE;
  OpenKey('SOFTWARE\Classes\AudioCD\Shell', false);
  if vAudioAutoRun then WriteString('', 'play')
   else WriteString('', '');
  CloseKey;
  RootKey := HKEY_CLASSES_ROOT;
  OpenKey('AudioCD\Shell', false);
  if vAudioAutoRun then WriteString('', 'play')
   else WriteString('', '');
  CloseKey;
  Free;
 end;
end;

function TAudioCDOptions.GetAudioCDPlayer:String;
var reg : TRegistry;
begin
 reg := TRegistry.Create;
 with reg do begin
  Rootkey := HKEY_LOCAL_MACHINE;
  OpenKey('SOFTWARE\Classes\AudioCD\Shell\play\command', false);
  Result := ReadString('');
  CloseKey;
  Free;
 end;
end;

procedure TAudioCDOptions.SetAudioCDPlayer(vAudioPlayer : String);
var reg : TRegistry;
    Classes : String;
    ClassesRoot : String;
begin
 reg := TRegistry.Create;
 with reg do begin
  RootKey := HKEY_LOCAL_MACHINE;
  OpenKey('SOFTWARE\Classes\AudioCD\Shell\play\command',false);
  WriteString('', vAudioPlayer);
  CloseKey;
  RootKey := HKEY_CLASSES_ROOT;
  OpenKey('AudioCD\Shell\play\command', false);
  WriteString('',vAudioPlayer);
  CloseKey;
  Free;
 end;
end;

procedure TAudioCDOptions.ResetAudioCDOptions;
begin
 if rAutoRun in fResetOptions then SetAudioCDAutoRun(fOldAudioAutoRun);
 if rPlayer in fResetOptions then SetAudioCDPlayer(fOldAudioPlayer);
end;

{************************* tAudioCDEvents component ***************************}

constructor TAudioCDEvents.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  fExtraOptions := TAudioCDOptions.Create;
end;

destructor TAudioCDEvents.Destroy;
begin
  fExtraOptions.Free;
  inherited Destroy;
end;

procedure TAudioCDEvents.SetExtraOptions(value : TAudioCDOptions);
begin
 fExtraOptions.Assign(value);
end;

end.
