//send any comments to aa, aa@bitsmart.com

unit main;

interface

uses
  Windows, Messages, Forms, SysUtils, Dialogs, Graphics, StdCtrls, Controls, ComCtrls, Buttons,
  Classes, ExtCtrls, CheckLst, MMSystem;

type
  Tfrm = class(TForm)
    Bevel1: TBevel;
    Status1: TLabel;
    Status2: TLabel;
    Status3: TLabel;
    ini: TLabel;
    S17: TLabel;
    ChkSrc: TLabel;
    ChkDst: TLabel;
    TheLabel1: TLabel;
    TheLabel2: TLabel;
    TheLabel3: TLabel;
    meter: TProgressBar;
    AutoEject: TCheckBox;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    iNew: TSpeedButton;
    iOpen: TSpeedButton;
    iSave: TSpeedButton;
    iCheck: TSpeedButton;
    Reset: TSpeedButton;
    Clear: TSpeedButton;
    Load: TSpeedButton;
    Eject: TSpeedButton;
    HelpText: TSpeedButton;
    STOP: TSpeedButton;
    QUIT: TSpeedButton;
    CheckList: TCheckListBox;
    procedure FormPaint(Sender: TObject);
    procedure iNewClick(Sender: TObject);
    procedure iSaveClick(Sender: TObject);
    procedure iOpenClick(Sender: TObject);
    procedure iCheckClick(Sender: TObject);
    procedure QuitClick(Sender: TObject);
    procedure CheckListTheClickCheck(Sender: TObject);
    procedure StopClick(Sender: TObject);
    procedure clearClick(Sender: TObject);
    procedure CheckListTheClick(Sender: TObject);
    procedure ejectClick(Sender: TObject);
    procedure loadClick(Sender: TObject);
    procedure resetClick(Sender: TObject);
    procedure HelpTextClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    ffn:String;
    EverSucceed:Boolean;
    ChkValS:TStringList;
    Broken:Boolean;
    procedure LoadNotify(var msg:TMessage);message MM_MCINotify;
    procedure PaintInBlue;
    procedure ButtonsEnabled(State:Boolean);
    procedure enumeratelist;
    procedure SetCfgName(fname:string);
    function GetCfgName:String;
  public
    property CfgName:String
      read GetCfgName write SetCfgName;
    procedure SaveCfg;
    procedure LoadCfg;
  end;

var
  frm: Tfrm;

implementation
  uses CkSummer, FileUti2;

{$R *.DFM}

procedure tfrm.SetCfgName(fname:string); begin
  if pos('\', fname)=0 then
    fname:=GetWindowsDir+'\'+fname;
  if ffn<>fname then begin
    ffn:= fname;
  end;
  ini.Caption:=ffn;
end;

function tfrm.GetCfgName:String; begin
  Result:= ffn;
end;

const
  OFFSET_HDR=0;
  OFFSET_INI=1;
  OFFSET_SRC=2;
  OFFSETNLST=3;
//  OFFSETNVAL=4;
  OFFSET_DAT=4;
  CFG_HEADER='[CheckCD]';

procedure tfrm.SaveCfg;
var L:TStringList;
begin
  L:=TStringList.Create;
  L.Add(CFG_HEADER);
  L.Add(ini.Caption);
  L.Add(ChkSrc.Caption);
  L.Add(inttostr(CheckList.Items.Count));
//  L.Add(inttostr(ChkVals.Count));
  L.AddStrings(CheckList.Items);
  L.AddStrings(ChkVals);
  L.SaveToFile(ffn);
  L.Free;
end;

procedure tfrm.LoadCfg;
var L:TStringList; i,j:integer;
begin
  L:=TStringList.Create;
  L.LoadFromFile(ffn);
  if L[OFFSET_HDR]<>CFG_HEADER then begin
    L.Free;
    raise exception.Create('Invalid Config File');
  end;
  //ini.Caption:=L[OFFSET_INI];
  ini.Caption:=ffn;
  ChkSrc.Caption:=L[OFFSET_SRC];
  CheckList.Items.Clear;
  j:=StrToInt(L[OFFSETNLST]);
  for i:=0 to j-1 do
    CheckList.Items.Add(L[i+OFFSET_DAT]);
  ChkVals.Clear;
  for i:= OFFSET_DAT+j to L.Count-1 do
    ChkVals.Add(L[i]);
  L.Free;
end;

procedure tfrm.LoadNotify(var msg:TMessage);
begin
  if msg.WParam=MCI_NOTIFY_SUCCESSFUL then
    if EverSucceed and AutoEject.Checked then begin
      iCheck.Click;
    end
    else
     AutoEject.Checked:=FALSE
end;

procedure tfrm.PaintInBlue;
var
  i:integer;
  rect:TRect;
begin
  //exit;
  rect.Left:=0;rect.Right:=width;
  for i:=0 to $FF do begin
    Canvas.Brush.Color:=tColor(RGB($20, $00, i-i mod $20));
    rect.Top:=i*height div $100;
    rect.Bottom:=(i+1)*Height div $100;
    Canvas.FillRect(rect);
  end;
end;

procedure tfrm.ButtonsEnabled(State:Boolean);
begin
  iNew.Enabled:=State;
  iOpen.Enabled:=State;
  iSave.Enabled:=State;
  iCheck.Enabled:=State;
  reset.Enabled:=State;
  clear.Enabled:=State;
end;

procedure Tfrm.FormPaint(Sender: TObject);
begin
  PaintInBlue;
end;

procedure tfrm.enumeratelist;
var i:integer;
begin
  with CheckList do
  for i:=0 to CheckList.items.count-1 do begin
    if Checked[i]<>(ChkVals[i][17]='1')then
      Checked[i]:=ChkVals[i][17]='1';
   end;
end;


procedure Tfrm.iNewClick(Sender: TObject);
const drv:string='';
var i:integer; crc,chx:integer; fn:string;
begin
  drv:=ChkSrc.Caption;
  Try
  if not BrowseDirectory(drv,'Please pick a drive or directory to scan',0) then exit;
  CheckList.Clear;
  Broken:=FALSE;ButtonsEnabled(FALSE);
  while drv[length(drv)]='\' do delete(drv,length(drv),1);
  DirSlashS(drv, CheckList.Items);
  Broken:=FALSE;ButtonsEnabled(FALSE);
  ChkVals.Clear;
  ChkSrc.Caption:=drv+'\';
  for i:=0 to CheckList.Items.Count-1 do begin
    Application.ProcessMessages;
    if Broken then break;
    fn:=drv+'\'+CheckList.Items[i];
    S17.Caption:='CRC32:';
    Status1.Caption:='CRC32:'#9+inttohex(crc,8)+'H';
    Application.ProcessMessages;
    if Broken then break;
    crc:=GetCRC32(fn);
    S17.Caption:='CHX19:';
    Application.ProcessMessages;
    if Broken then break;
    chx:=GetCheck19(fn);
    Status2.Caption:='CHX19:'#9+inttohex(chx,8)+'H';
    Status3.Caption:=inttostr(i+1)+'/'+inttostr(CheckList.items.count);
    Application.ProcessMessages;
    if Broken then break;
    ChkVals.Add(inttohex(crc,8)+inttohex(chx,8)+'1');
    CheckList.Checked[i]:=TRUE;
  end;
  if Broken then showmessage('Stopped.'#13+inttostr(ChkVals.Count)+
    ' file(s) checked from total: '+inttostr(CheckList.Items.count));
  ButtonsEnabled(TRUE);
  if (CheckList.Items.count=ChkVals.Count) then exit;
  if CheckList.Items.count>ChkVals.Count then
    for i:=CheckList.Items.count downto ChkVals.Count+1 do
      CheckList.Items.Delete(i-1) else
  if CheckList.Items.count<ChkVals.Count then
    for i:=ChkVals.Count downto CheckList.Items.count+1 do
      ChkVals.Delete(i-1);
  showmessage('Unfinished item(s) cleared');
  except
    ButtonsEnabled(TRUE);
    raise
  end;
end;

procedure Tfrm.iCheckClick(Sender: TObject);
const errs=' ->ERROR!'; drv:string='';
const conclussion:array[0..2] of String=('COULD','MIGHT','MUST NOT');
var i,n,errn:integer; ncrc,nchx:integer; crc,chx,fn:string;
begin
  n:=0;errn:=0;
  if CheckList.Items.Count<1 then
    raise Exception.Create('No file listed');
  if (length(drv)>0) and (drv[length(drv)]=':') then drv:=drv+'\';
    if not BrowseDirectory(drv,'Please pick a drive or directory to scan',0) then exit;
  if not GetDriveType(pChar(drv))=DRIVE_CDROM then
    with AutoEject do if Checked then Checked:=FALSE;
  while drv[length(drv)]='\' do delete(drv,length(drv),1);
  EverSucceed:=FALSE; Broken:=FALSE; ButtonsEnabled(FALSE);
  for i:=0 to CheckList.Items.Count-1 do begin
    CheckList.State[i]:=cbUnchecked;
    if ChkVals.Strings[i][17]='0' then
      CheckList.State[i]:= cbGrayed
  end;
  try
  ChkDst.Caption:=drv+'\';
  for i:=0 to CheckList.Items.Count-1 do begin
    Application.ProcessMessages;
    if Broken then break;

    if ChkVals.Strings[i][17]='0' then begin
      CheckList.State[i]:= cbGrayed;
      continue;
    end;

    if CheckList.State[i] <> cbGrayed then begin
      inc(n);
      fn:=drv+'\'+CheckList.Items[i];
      crc:=copy(chkvals.Strings[i],1,8);
      chx:=copy(chkvals.Strings[i],9,8);
      Status1.Caption:='CRC-32bit :'#9+crc+'H';
      Status2.Caption:='ChekSum19 :'#9+chx+'H';
      Status3.Caption:=inttostr(i+1)+'/'+inttostr(CheckList.Items.Count);
      //
      S17.Caption:='CRC32:'+ChkVals.Strings[i][17];
      Application.ProcessMessages;
      if Broken then break;
      try ncrc:=GetCRC32(fn);
      except
        if Application.MessageBox(pChar('File: '+fn+#13#10'Do you want to continue?'),
        'Error while Getting CRC-32', mb_systemmodal+mb_yesno+mb_defbutton1)=mrNO then
          break;
      end;
      S17.Caption:='CHX19:'+ChkVals.Strings[i][17];
      Application.ProcessMessages;
      if Broken then break;
      try nchx:=GetCheck19(fn);
      except end;
      //
      with Status1 do
        if inttohex(ncrc,8)=crc then
          Caption:=Caption+' -OK'
        else
          Caption:=Caption+errs;
      with Status2 do
        if inttohex(nchx,8)=chx then
          Caption:=Caption+' -OK'
        else
          Caption:=Caption+errs;
      if pos(errs,Status1.Caption)+pos(errs,Status2.Caption)=0 then begin
        CheckList.State[i]:=cbChecked //State[i]:=Grayed;
      end
      else begin
        CheckList.State[i]:=cbGrayed; //State[i]:=Grayed;
        inc(errn);
        if Application.MessageBox(pChar('CheckSum not matched!'+#13#10+#13#10+
        'Cyclic Redundancy Check (CRC)-32bit test'#13+
        'File name '#9+': '+extractfilename(CheckList.Items[i])+#13+
        StringOfChar('-',40)+#13+
        'Stored value'#9': '+crc+' H'#13+
        'Checked value'#9+': '+inttohex(ncrc,8)+' H'#13#10+#13#10+
        //'CHX19:'#9+chx+#9'-> '+inttohex(nchx,8)+#13#10+#13#10+
        'Do you want to continue to check the rest of files?'), 'CheckSum Error',
        mb_systemmodal+mb_yesno+mb_defbutton1)=mrNO then break;
      end;
    end;
    EverSucceed:=TRUE;
  end;
  showmessage(
  'Error(s) found'#9': '+inttostr(errn)+#13+
  'Cheksum valid'#9': '+inttostr(n-errn)+#13+
  StringOfChar('-',25)+#13+
  'Checked '#9': '+inttostr(n)+#13+
  'Skipped '#9': '+inttostr(CheckList.Items.Count-n)+#13+
  StringOfChar('-',25)+#13+
  'Total file(s)'#9': '+inttostr(CheckList.Items.Count)
  );
  ButtonsEnabled(TRUE);
  if AutoEject.Checked and EverSucceed then Eject.Click;
  except
    //EverSucceed:=FALSE;
    enumeratelist;
    ButtonsEnabled(TRUE);
    raise
  end;
end;

procedure Tfrm.iOpenClick(Sender: TObject);
begin
  OpenDialog1.FileName:=CfgName;
  if not OpenDialog1.Execute then exit;
  CfgName:=OpenDialog1.FileName;
  LoadCfg;   //3 Restore
  ini.Caption:=CfgName;
  enumeratelist;
end;

procedure Tfrm.iSaveClick(Sender: TObject);
begin
  if CheckList.Items.Count<1 then
    raise exception.Create('nothing to store');
  SaveDialog1.FileName:=CfgName;
  if not SaveDialog1.Execute then exit;
  CfgName:=SaveDialog1.FileName;
  SaveCfg;
end;

procedure Tfrm.QuitClick(Sender: TObject);
begin
  Broken:=TRUE;
  Close
end;

procedure Tfrm.CheckListTheClickCheck(Sender: TObject);
begin
  with ChkVals, CheckList do
    if State[ItemIndex]=cbUnChecked then begin
      if Strings[ItemIndex][17]<>'0' then
        Strings[ItemIndex]:=copy(Strings[ItemIndex],1,16)+'0';
    end
    else begin //could be 1 or 2
      if Strings[ItemIndex][17]<>'1' then
        Strings[ItemIndex]:=copy(Strings[ItemIndex],1,16)+'1';
    end;
  S17.Caption:=ChkVals.Strings[CheckList.ItemIndex][17]
end;


procedure Tfrm.StopClick(Sender: TObject);
begin
  Broken:=TRUE;
end;

procedure Tfrm.clearClick(Sender: TObject);
begin
  CheckList.Items.Clear;
  ChkVals.Clear;
  ChkSrc.Caption:='';ChkDst.Caption:='';
end;

procedure Tfrm.CheckListTheClick(Sender: TObject);
var i,n:integer;
begin
  i:=CheckList.ItemIndex;
  n:=CheckList.Items.Count;
  Status1.Caption:='CRC-32bit :'#9+copy(chkvals.Strings[i],1,8)+'H';
  Status2.Caption:='ChekSum19 :'#9+copy(chkvals.Strings[i],9,8)+'H';
  Status3.Caption:=InttoStr(i+1)+'/'+InttoStr(n);
  S17.Caption:=ChkVals.Strings[i][17];
end;

procedure Tfrm.ejectClick(Sender: TObject);
var errmsg:array[0..127] of char;const errno:dword=0;
begin
  Broken:=TRUE;
  errno:=mciSendString('Set cdaudio door open wait', errmsg, sizeof(errmsg), handle);
  if errno<>0 then begin
    mciGetErrorString(errno, errmsg, sizeof(errmsg));
    showmessage('Error no: '+InttoHex(errno,8)+#13+errmsg)
  end;
  errno:=0;
end;

procedure Tfrm.loadClick(Sender: TObject);
var errmsg:array[0..127] of char;const errno:dword=0;
begin
  Broken:=TRUE;
  errno:=mciSendString('Set cdaudio door closed wait', errmsg, sizeof(errmsg), handle);
  if errno<>0 then begin
    mciGetErrorString(errno, errmsg, sizeof(errmsg));
    showmessage('Error no: '+InttoHex(errno,8)+#13+errmsg);
  end
  else if EverSucceed and AutoEject.Checked then begin
  end;
  errno:=0;
end;

procedure Tfrm.resetClick(Sender: TObject);
var i:integer;
begin
  if CheckList.Items.Count <> ChkVals.Count then
    raise exception.create('ListFile invalid.'#13#13+
    'ChkList item count'#9' :'+inttoStr(CheckList.Items.Count)+#13+
    'Values item count'#9' :'+inttostr(ChkVals.Count)+#13#13+
    'Create new list first, please');
  with CheckList, ChkVals do
  for i:=0 to CheckList.items.count-1 do begin
    if Checked[i]<>(Strings[i][17]='1') then
      Checked[i]:=Strings[i][17]='1';
    if State[i]=cbGrayed then State[i]:=cbUnChecked;
    end;
end;

procedure Tfrm.HelpTextClick(Sender: TObject);
begin
  WinExec('notepad CDCheck.HLP',SW_SHOWNORMAL);
end;

procedure Tfrm.FormCreate(Sender: TObject);
begin
  ChkValS:=TStringList.Create;
  ffn:= GetWindowsDir+'\CDCHECK.CFG';
end;

procedure Tfrm.FormDestroy(Sender: TObject);
begin
  ChkValS.Free;
end;












procedure Tfrm.FormResize(Sender: TObject);
begin
  CheckList.Width:=Width-100;
  with CheckList do if Width<200 then
    width:=200;
  meter.Width:=CheckList.Width;
end;

end.
