{******************************************************************************}
{*                                                                            *}
{*               Adirondack Software & Graphics ShowCfg Unit                  *}
{*            (C) Copyright Adirondack Software & Graphics 1997               *}
{*                                                                            *}
{******************************************************************************}

unit Showcfg;  {Unit to Show/Edit Reg or Ini Files}

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, Dialogs, Spin, BrowseDr, INIFiles;

type
  TViewModifyDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    NameField: TEdit;
    Label2: TLabel;
    DirField: TEdit;
    Label3: TLabel;
    SerialNumberField: TEdit;
    Label4: TLabel;
    PasswordField: TEdit;
    Label5: TLabel;
    FileDirField: TEdit;
    Label7: TLabel;
    GroupBox1: TGroupBox;
    Label8: TLabel;
    Label9: TLabel;
    SpinButton1: TSpinButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label6: TLabel;
    CompanyField: TEdit;
    BrowseDirectoryDlg1: TBrowseDirectoryDlg;
    BrowseDirectoryDlg2: TBrowseDirectoryDlg;
    CheckBox1: TCheckBox;
    DelayTimeField: TEdit;
    procedure SpinButton1DownClick(Sender: TObject);
    procedure SpinButton1UpClick(Sender: TObject);
    procedure DelayTimeFieldChange(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BrowseDirectoryDlg1SelChanged(Sender: TObject;
      const NewSel: string);
    procedure BrowseDirectoryDlg2SelChanged(Sender: TObject;
      const NewSel: string);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function Execute : boolean;
  end;

var
  ViewModifyDlg: TViewModifyDlg;

implementation
uses Main, SysUtils, GlobalUt;

{$R *.DFM}

{==============================================================================}
function TViewModifyDlg.Execute : boolean;
{==============================================================================}
var
  ApprehendIni: TIniFile;
begin
  ApprehendIni := TIniFile.Create(ExtractFilePath(Application.EXEName) + 'Apprehend.Ini');
  with ApprehendIni do
  begin
      MainForm.UserName := ReadString('User Info', 'User', 'Unregistered User');
      MainForm.CompanyName  := ReadString('User Info', 'Company', 'Unregistered Company');
      MainForm.Password := ReadString('User Info', 'Password', 'Unregistered Password');
      MainForm.SerialNumber := ReadString('User Info', 'Serial Number', 'Unregistered Password');
      MainForm.InstallPath := ReadString('Program Options','Program Directory', 'c:\capture');
      MainForm.FilePath := ReadString('Program Options','File Directory', 'c:\capture\images');
      MainForm.AutoSave := ReadBool('Program Options','Auto Save', true);
      MainForm.DelayTime := ReadInteger('Program Options','Delay Time', 800);
    end;
  ApprehendIni.Free;
  NameField.Text := MainForm.UserName;
  CompanyField.Text := MainForm.CompanyName;
  PasswordField.Text := MainForm.Password;
  SerialNumberField.Text := MainForm.SerialNumber;
  DirField.text := MainForm.InstallPath;
  FileDirField.Text := MainForm.FilePath;
  DelayTimeField.Text := IntToStr(MainForm.DelayTime);
  CheckBox1.Checked := MainForm.AutoSave;
  If ShowModal=mrOK then begin
    MainForm.UserName := NameField.Text;
    MainForm.CompanyName := CompanyField.Text;
    MainForm.InstallPath := DirField.Text;
    MainForm.FilePath := FileDirField.Text;
    MainForm.Password := PasswordField.Text;
    MainForm.SerialNumber := SerialNumberField.Text;
    MainForm.DelayTime := StrToInt(DelayTimeField.Text);
    MainForm.AutoSave := Checkbox1.Checked;
    {Write changes to INI file}
    ApprehendIni := TIniFile.Create(ExtractFilePath(Application.EXEName) + 'Apprehend.Ini');
    with ApprehendIni do
    begin
       WriteString('User Info','User', MainForm.UserName);
       WriteString('User Info', 'Company', MainForm.CompanyName);
       WriteString('User Info','Password', MainForm.Password);
       WriteString('User Info','Serial Number', MainForm.SerialNumber);
       WriteString('Program Options','Program Directory', MainForm.InstallPath);
       WriteString('Program Options','File Directory', MainForm.FilePath);
       WriteInteger('Program Options','Delay Time', MainForm.DelayTime);
       WriteBool('Program Options','Auto Save', MainForm.AutoSave);
    end;
    ApprehendIni.Free;
    DefaultDirectory := MainForm.FilePath;
    MainForm.StatusBar.Panels[1].Text := DefaultDirectory;
    if Checkbox1.Checked then begin
       MainForm.XToolBar1.AutoSavePosition := True;
       MainForm.XToolBar2.AutoSavePosition := True;
    end
    else begin
       MainForm.XToolBar1.AutoSavePosition := False;
       MainForm.XToolBar2.AutoSavePosition := False;
    end;
    Result := True;
    end
  else Result := False;
end;

{==============================================================================}
procedure TViewModifyDlg.SpinButton1DownClick(Sender: TObject);
{==============================================================================}
begin
   MainForm.DelayTime := StrToInt(DelayTimeField.Text);
   Dec(MainForm.DelayTime);
   DelayTimeField.Text := IntToStr(MainForm.DelayTime);
end;

{==============================================================================}
procedure TViewModifyDlg.SpinButton1UpClick(Sender: TObject);
{==============================================================================}
begin
   MainForm.DelayTime := StrToInt(DelayTimeField.Text);
   Inc(MainForm.DelayTime);
   DelayTimeField.Text := IntToStr(MainForm.DelayTime);
end;

{==============================================================================}
procedure TViewModifyDlg.DelayTimeFieldChange(Sender: TObject);
{==============================================================================}
begin
   { if edit is not blank then set delay }
   if DelayTimeField.Text <> '' then begin
   if MainForm.DelayTime > 10000 then MainForm.DelayTime := 10000 else
      if MainForm.DelayTime < 0 then MainForm.DelayTime := 0;
         DelayTimeField.Text := IntToStr(MainForm.DelayTime);
   end;
end;

{==============================================================================}
procedure TViewModifyDlg.BitBtn1Click(Sender: TObject);
{==============================================================================}
begin
   if BrowseDirectoryDlg1.Execute then
   DirField.Text := BrowseDirectoryDlg1.Selection;
end;

{==============================================================================}
procedure TViewModifyDlg.BitBtn2Click(Sender: TObject);
{==============================================================================}
begin
   if BrowseDirectoryDlg2.Execute then
   DirField.Text := BrowseDirectoryDlg2.Selection;
end;

{==============================================================================}
procedure TViewModifyDlg.FormCreate(Sender: TObject);
{==============================================================================}
begin
   BrowseDirectoryDlg1.Selection := ExtractFilePath(Application.EXEName);
   BrowseDirectoryDlg2.Selection := ExtractFilePath(Application.EXEName)+'Images';
end;

{==============================================================================}
procedure TViewModifyDlg.BrowseDirectoryDlg1SelChanged(Sender: TObject;
  const NewSel: string);
{==============================================================================}
begin
   BrowseDirectoryDlg1.StatusText := NewSel;
end;

{==============================================================================}
procedure TViewModifyDlg.BrowseDirectoryDlg2SelChanged(Sender: TObject;
{==============================================================================}
  const NewSel: string);
begin
   BrowseDirectoryDlg2.StatusText := NewSel;
end;

{==============================================================================}
procedure TViewModifyDlg.CheckBox1Click(Sender: TObject);
{==============================================================================}
begin
if Checkbox1.Checked then begin
   MainForm.XToolBar1.AutoSavePosition := True;
   MainForm.XToolBar2.AutoSavePosition := True;
   MainForm.XToolBar3.AutoSavePosition := True;
   MainForm.XToolBar4.AutoSavePosition := True;
   MainForm.XToolBar5.AutoSavePosition := True;
   MainForm.AutoSave := True;
end
else begin
   MainForm.XToolBar1.AutoSavePosition := False;
   MainForm.XToolBar2.AutoSavePosition := False;
   MainForm.XToolBar3.AutoSavePosition := False;
   MainForm.XToolBar4.AutoSavePosition := False;
   MainForm.XToolBar5.AutoSavePosition := False;
   MainForm.AutoSave := False;
end;
end;

end.
