{******************************************************************************}
{*                                                                            *}
{*                 Adirondack Software & Graphics Main Unit                   *}
{*            (C) Copyright Adirondack Software & Graphics 1997               *}
{*                                                                            *}
{******************************************************************************}

unit Main;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus, StdCtrls,
     Dialogs, IdlgUt, Buttons, Messages, ExtCtrls, ComCtrls, ScrnCap, Capture2,
     Capture3, GlobalUt, WinRoll, About, Iinfo16, Iinfo256, ClipBrd, xProcs,
     SysHot, CompDlg, XToolBar, WComp, ChildWin, IniFiles, Printers;

Const
  smAlwaysOnTop      = 1000;
	smCaptureDesktop   = 1001;
  smCaptureRectangle = 1002;
  smCaptureWindow    = 1003;
  smCaptureIcon      = 1004;
	AlwaysOnTop        : Boolean = False;

type
  Str16 = string[16];
  
type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileCloseItem: TMenuItem;
    Window1: TMenuItem;
    Help1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    TileHorzontallyItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    EditMnu1: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    WindowMinimizeItem: TMenuItem;
    StatusBar: TStatusBar;
    Image1: TMenuItem;
    Desktop1: TMenuItem;
    Area1: TMenuItem;
    Print1: TMenuItem;
    PrintSetup1: TMenuItem;
    N3: TMenuItem;
    SaveDialog1: TSaveDialog;
    PrintDialog1: TPrintDialog;
    PrinterSetupDialog1: TPrinterSetupDialog;
    N4: TMenuItem;
    WinRoller1: TWinRoller;
    CloseAll1: TMenuItem;
    N6: TMenuItem;
    WindowNextItem: TMenuItem;
    WindowPreviousItem: TMenuItem;
    TileVerticallyItem: TMenuItem;
    Preferences1: TMenuItem;
    ForceClose1: TMenuItem;
    OpenDialog1: TOpenDialog;
    ShowConfig1: TMenuItem;
    SysHotKey1: TSysHotKey;
    CaptureWindoworControl1: TMenuItem;
    Components1: TMenuItem;
    Register1: TMenuItem;
    Docks1: TDocks;
    Docks2: TDocks;
    Docks3: TDocks;
    Docks4: TDocks;
    Information1: TMenuItem;
    CaptureIcon1: TMenuItem;
    XToolBar4: TXToolBar;
    SpeedButton15: TSpeedButton;
    SpeedButton16: TSpeedButton;
    SpeedButton17: TSpeedButton;
    SpeedButton18: TSpeedButton;
    SpeedButton23: TSpeedButton;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    XToolBar1: TXToolBar;
    OpenBtn: TSpeedButton;
    SaveBtn: TSpeedButton;
    SpeedButton22: TSpeedButton;
    XToolBar2: TXToolBar;
    CopyBtn: TSpeedButton;
    PasteBtn: TSpeedButton;
    XToolBar3: TXToolBar;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton33: TSpeedButton;
    XToolBar5: TXToolBar;
    SpeedButton12: TSpeedButton;
    ToolBars1: TMenuItem;
    SpeedButton28: TSpeedButton;
    Rulers1: TMenuItem;
    SpeedButton32: TSpeedButton;
    ExitBtn: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Contents1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FileNewItemClick(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure UpdateMenuItems(Sender: TObject);
    procedure TileHorzontallyItemClick(Sender: TObject);
    procedure WindowArrangeItemClick(Sender: TObject);
    procedure FileCloseItemClick(Sender: TObject);
    procedure FileOpenItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure FileSaveItemClick(Sender: TObject);
    procedure FileSaveAsItemClick(Sender: TObject);
    procedure CopyItemClick(Sender: TObject);
    procedure PasteItemClick(Sender: TObject);
    procedure WindowMinimizeItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Desktop1Click(Sender: TObject);
    procedure Area1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure PrintSetup1Click(Sender: TObject);
    procedure HelpAboutItemClick(Sender: TObject);
    procedure SpeedButton11Click(Sender: TObject);
    procedure CloseAll1Click(Sender: TObject);
    procedure WindowNextItemClick(Sender: TObject);
    procedure WindowPreviousItemClick(Sender: TObject);
    procedure TileVerticallyItemClick(Sender: TObject);
    procedure WinRoller1Roller(Sender: TObject; mode: TRollerMode);
    procedure ForceClose1Click(Sender: TObject);
    procedure CaptureWindowClick(Sender: TObject);
    procedure ShowConfig1Click(Sender: TObject);
    procedure SysHotKey1HotKey(Sender: TObject; Index: Integer);
    procedure Components1Click(Sender: TObject);
    procedure Register1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Exit2Click(Sender: TObject);
    procedure Information1Click(Sender: TObject);
    procedure CaptureIcon1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure XToolBar4DockChanged(Sender: TObject);
    procedure XToolBar1DockChanged(Sender: TObject);
    procedure XToolBar2DockChanged(Sender: TObject);
    procedure XToolBar3DockChanged(Sender: TObject);
    procedure XToolBar5DockChanged(Sender: TObject);
    procedure ToolBars1Click(Sender: TObject);
    procedure Rulers1Click(Sender: TObject);
    procedure wmHandleMessages(var Msg : TMsg; var Handled : Boolean);
    procedure SpeedButton4Click(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
  private
    { Private declarations }
    FSetDefault: Boolean;
    procedure Delay(msecs:integer);
    function  ReadConfigInfo: boolean;
    procedure CreateConfigEntry;
    procedure CreateMDIChild(const Name: string);
    procedure ShowHint(Sender: TObject);
    procedure CaptureArea;
    procedure CaptureWindow;
    procedure CaptureIcon;
  public
    { Public declarations }
    ABitmap        : TBitmap;
    DelayTime      : Integer;
    UserName       : String;
    CompanyName    : String;
    Password       : String;
    CreateTime     : TDateTime;
    ProgOptEnabled : Boolean;
    InstallPath    : String;
    FilePath       : String;
    SerialNumber   : Str16;
    AutoSave       : Boolean;
    Child          : TMDIChild;
  end;

var
  MainForm         : TMainForm;
  SharedPalette    : Boolean;

implementation

{$R *.DFM}

uses  ShowCFG, Capture4, Splash;


{==============================================================================}
procedure TMainForm.Delay(msecs:integer);
{==============================================================================}
var
   FirstTickCount:Longint;
begin
     FirstTickCount:=GetTickCount;
     repeat
        begin
           Application.ProcessMessages; {allowing access to other 
                                         controls, etc.}
        end;
     until ((GetTickCount-FirstTickCount) >= Longint(msecs));
end;

{==============================================================================}
function TMainForm.ReadConfigInfo: Boolean;
{==============================================================================}
var
  ApprehendIni: TIniFile;
begin
  ApprehendIni := TIniFile.Create(ExtractFilePath(Application.EXEName) + 'Apprehend.Ini');
  with ApprehendIni do
  begin
      UserName := ReadString('User Info', 'User', 'Unregistered User');
      CompanyName  := ReadString('User Info', 'Company', 'Unregistered Company');
      Password := ReadString('User Info', 'Password', 'Unregistered Password');
      SerialNumber := ReadString('User Info', 'Serial Number', 'Unregistered Password');

      InstallPath := ReadString('Program Options', 'Program Directory', 'Unregistered Program Directory');
      FilePath := ReadString('Program Options', 'File Directory', 'Unregistered File Directory');
      DefaultDirectory := FilePath;
      DelayTime := ReadInteger('Program Options', 'Delay Time', 800);
      AutoSave := ReadBool('Program Options', 'Auto Save', True);
    end;
  ApprehendIni.Free;
end;

{==============================================================================}
procedure TMainForm.CreateConfigEntry;
{==============================================================================}
var
  ApprehendIni: TIniFile;
begin
  ApprehendIni := TIniFile.Create(ExtractFilePath(Application.EXEName) + 'Apprehend.Ini');
  with ApprehendIni do
  begin
      WriteString('User Info', 'User', UserName);
      WriteString('User Info', 'Company', CompanyName);
      WriteString('User Info', 'Password', Password);
      WriteString('User Info', 'Serial Number', SerialNumber);

      WriteString('Program Options', 'Program Directory', InstallPath);
      WriteString('Program Options', 'File Directory', FilePath);
      WriteInteger('Program Options', 'Delay Time', DelayTime);
      WriteBool('Program Options', 'Auto Save', AutoSave);
    end;
  ApprehendIni.Free;
end;

{==============================================================================}
Procedure TMainForm.wmHandleMessages(var Msg : TMsg; var Handled : Boolean);
{==============================================================================}
var	CheckedFlag : Word;
 	SystemMenu : Hmenu;
begin
	if Msg.message = WM_SYSCOMMAND then begin
		if Msg.wParam = smAlwaysOnTop then begin
             { Code to keep the form on top or not }
			if AlwaysOnTop then begin
  				AlwaysOnTop := False;
				CheckedFlag := mf_unchecked; {Clear the Always on top checkmark }
                       SetWindowPos(Handle, HWND_NOTOPMOST, 0, 0, 0, 0,
                                   SWP_NOMOVE or SWP_NOSIZE or SWP_NOACTIVATE);
			end else begin
 				AlwaysOnTop := True;
				CheckedFlag := mf_checked; {Set the checkmark}
                       SetWindowPos(Handle, HWND_TOPMOST, 0, 0, 0, 0,
                                   SWP_NOMOVE or SWP_NOSIZE or SWP_NOACTIVATE);
			end;

   			SystemMenu := GetSystemMenu( Application.Handle, False );
   			CheckMenuItem(SystemMenu,smAlwaysOnTop,mf_ByCommand+CheckedFlag);

   			SystemMenu := GetSystemMenu( Handle, False );
   			CheckMenuItem(SystemMenu,smAlwaysOnTop,mf_ByCommand+CheckedFlag);

		end else
		if Msg.wParam = smCaptureDesktop then
        Desktop1Click(Self);
     if Msg.wParam = smCaptureRectangle then
        Area1Click(Self);
     if Msg.wParam = smCaptureWindow then
        CaptureWindowClick(Self);
      if Msg.wParam = smCaptureIcon then
        CaptureIcon1Click(Self);
	end;
end;

{==============================================================================}
procedure TMainForm.FormCreate(Sender: TObject);
{==============================================================================}
Var
   PaletteInfoDlg16  : TPaletteInfoDlg16;
   PaletteInfoDlg256 : TPaletteInfoDlg256;
   NumColors         : Longint;
   SystemMenu        : HMenu;
begin

    Delay(2000);

    {Setup Hotkeys - captures keypresses even when minimized}
    with SysHotKey1 do
    begin
       AddHotKey(vkF7, []);
       AddHotKey(vkF8, []);
       AddHotKey(vkF9, []);
       AddHotKey(vkF10, []);
     end;

    { Build a New System Menu for app when it's minimized }
    SystemMenu := GetSystemMenu( Application.Handle, False );
    { And now add in another separator bar }
    InsertMenu(SystemMenu, 5, MF_ByPosition + MF_SEPARATOR , 901, '');
    { Add in New Menu Items after the separator bar }
    InsertMenu(SystemMenu, 6, MF_ByPosition+MF_String, smAlwaysOnTop, '&Always On Top' );
    { And now add in another separator bar }
    InsertMenu(SystemMenu, 7, MF_ByPosition + MF_SEPARATOR , 901, '');
    InsertMenu(SystemMenu, 8, MF_ByPosition+MF_String, smCaptureDesktop, 'Capture &Desktop' );
    InsertMenu(SystemMenu, 9, MF_ByPosition+MF_String, smCaptureRectangle, 'Capture &Rectangle' );
    InsertMenu(SystemMenu, 10, MF_ByPosition+MF_String, smCaptureWindow, 'Capture &Object' );
    InsertMenu(SystemMenu, 11, MF_ByPosition+MF_String, smCaptureIcon, 'Capture &Icon' );

    { And then build another for when it's NOT minimized }
    SystemMenu := GetSystemMenu( Handle, False );

    { Add in New Menu Items after the existing separator bar }
    InsertMenu(SystemMenu, 6, MF_ByPosition+MF_String, smAlwaysOnTop, '&Always On Top' );
    { And now add in another separator bar }
    InsertMenu( SystemMenu, 7, MF_ByPosition + MF_SEPARATOR , 901, '');
    InsertMenu(SystemMenu, 8, MF_ByPosition+MF_String, smCaptureDesktop, 'Capture &Desktop' );
    InsertMenu(SystemMenu, 9, MF_ByPosition+MF_String, smCaptureRectangle, 'Capture &Rectangle' );
    InsertMenu(SystemMenu, 10, MF_ByPosition+MF_String, smCaptureWindow, 'Capture &Object' );
    InsertMenu(SystemMenu, 11, MF_ByPosition+MF_String, smCaptureIcon, 'Capture &Icon' );

    { And now add in another separator bar }
    InsertMenu( SystemMenu, 12, MF_ByPosition + MF_SEPARATOR , 901, '');

    { The next step is very important : set up the OnMessage Handler so that
	  every time our application gets a windows message, it passes through
	  this routine.  We'll talk about this routine next. }

    Application.OnMessage := wmHandleMessages;

    Height := Screen.Height - (Screen.Height div 3);
    Width  := 720;

    { Get number of screen colors }
    NumColors := 1 shl GetDeviceCaps( Canvas.Handle, BITSPIXEL );

    SharedPalette := FALSE ;
    { If colors = 16 then display 16 color dialog else 256 color dialog }
    if ( NumColors = 16 ) then
    begin
        SharedPalette := TRUE ;
        PaletteInfoDlg16 := TPaletteInfoDlg16.Create( Application );
        try
            PaletteInfoDlg16.ShowModal;
        finally
            PaletteInfoDlg16.Free;
        end;
    end
    else if ( NumColors = 256 ) then
    begin
        SharedPalette := TRUE ;
        PaletteInfoDlg256 := TPaletteInfoDlg256.Create( Application );
        try
            PaletteInfoDlg256.ShowModal;
        finally
            PaletteInfoDlg256.Free;
        end;
    end;

    Application.OnHint := ShowHint;
    {Set initial defaults}
    Screen.OnActiveFormChange := UpdateMenuItems;
    
    CaptureNum := 0;
    StatusBar.Panels[1].Text := LowerCase(ExtractFilePath(Application.EXEName)+'Images');
    StatusBar.Panels[2].Text := 'No Image';
    FSetDefault := True;

    OpenDialog1.Filename := '';
    OpenDialog1.FilterIndex := 1;
    OpenDialog1.InitialDir := DefaultDirectory;

end;

{==============================================================================}
procedure TMainForm.ShowHint(Sender: TObject);
{==============================================================================}
begin
  StatusBar.Panels[0].Text := Application.Hint;
end;

{==============================================================================}
procedure TMainForm.CreateMDIChild(const Name: string);
{==============================================================================}
begin
  { Create a new MDI child window }
  Child         := TMDIChild.Create(Application);
  Child.Caption := Name;
  StatusBar.Panels[2].Text := ExtractFilename(Name);
end;

{==============================================================================}
procedure TMainForm.FileNewItemClick(Sender: TObject);
{==============================================================================}
begin
   Inc(CaptureNum,1);

   { Set file information }
   Filename := 'Unnamed '+IntToStr(CaptureNum);
   Filename := DefaultDirectory+'\'+Filename;

   { Create MDi Child Window }
   CreateMDIChild(FileName);
end;

{==============================================================================}
procedure TMainForm.FileOpenItemClick(Sender: TObject);
{==============================================================================}
begin
    OpenDialog1.Filename := '';
    if OpenDialog1.Execute then
    begin
        Child := TMDIChild.Create(Self);
        Filename := OpenDialog1.Filename;
        Child.Image1.Picture.LoadFromFile(Filename);
        if Rulers1.Checked then
          begin
             Child.ClientWidth := Child.Image1.Picture.Width+Child.Panel2.Width;
             Child.ClientHeight := Child.Image1.Picture.Height+Child.Panel1.Height;
             Child.HorzScrollBar.Range := Child.Image1.Picture.Width+Child.Panel2.Width;
             Child.VertScrollBar.Range := Child.Image1.Picture.Height+Child.Panel1.Height;
          end
          else
          begin
             Child.ClientWidth := Child.Image1.Picture.Width;
             Child.ClientHeight := Child.Image1.Picture.Height;
             Child.HorzScrollBar.Range := Child.Image1.Picture.Width;
             Child.VertScrollBar.Range := Child.Image1.Picture.Height;
          end;
        {This next line is not needed if the TImage is aligned to the client area.}
        SetBounds((Screen.Width - Width) div 2, (Screen.Height - Height) div 2, Width, Height);
        Child.Caption := Filename;
        Child.Image1.Hint := 'Height: ' + IntToStr(Child.Image1.Picture.Height) + ' pixels'+
                             '  Width: ' + IntToStr(Child.Image1.Picture.Width) + ' pixels';

        StatusBar.Panels[2].Text := ExtractFilename(Filename);
    end;
end;

{==============================================================================}
procedure TMainForm.FileCloseItemClick(Sender: TObject);
{==============================================================================}
begin
  if ActiveMDIChild <> nil then
     ActiveMDIChild.Close;
  if MDIChildCount = 1 then begin
     CaptureNum := 0;
     StatusBar.Panels[2].Text := 'No Image';
  end;
end;

{==============================================================================}
procedure TMainForm.FileSaveItemClick(Sender: TObject);
{==============================================================================}
begin
  { save current file (ActiveMDIChild points to the window) }
  with ActiveMDIChild as TMDIChild do begin  { save image to disk }
    Filename := Extractname(Caption);
    FileExtension := '.bmp';
    Filename := DefaultDirectory+'\'+Filename+FileExtension;
       { If file exists then delete it }
       if FileExists(Filename) then begin
          { Prompt user to delete file }
          if MessageDlg(Filename+' exists, Delete?', mtInformation, [mbYes, mbNo], 0) = mrYes then
             DeleteFile(Filename);
       end;
    Image1.Picture.SaveToFile(Filename);
    Caption := Filename;
    StatusBar.Panels[1].Text := ExtractFilepath(Caption);
    StatusBar.Panels[2].Text := ExtractFilename(Caption);
    end;
end;

{==============================================================================}
procedure TMainForm.FileSaveAsItemClick(Sender: TObject);
{==============================================================================}
begin
 { Save current file (ActiveMDIChild points to the window) }
 if MDIChildCount <> 0 then
  with ActiveMDIChild as TMDIChild do begin { Save current file under new name }
     SaveDialog1.InitialDir := DefaultDirectory;
     if SaveDialog1.Execute then begin
        Image1.Picture.SaveToFile(SaveDialog1.Filename);
        Filename := SaveDialog1.Filename;
        Caption := SaveDialog1.Filename;
        StatusBar.Panels[1].Text := ExtractFilepath(Caption);
        StatusBar.Panels[2].Text := ExtractFilename(Caption);
     end;
  end;
end;

{==============================================================================}
procedure TMainForm.FileExitItemClick(Sender: TObject);
{==============================================================================}
begin
  Close;
end;

{==============================================================================}
procedure TMainForm.CopyItemClick(Sender: TObject);
{==============================================================================}
begin
  {copy selection to clipboard}
  if MDIChildCount <> 0 then
  with ActiveMDIChild as TMDIChild do
     Clipboard.Assign(Image1.Picture);
  end;

{==============================================================================}
procedure TMainForm.PasteItemClick(Sender: TObject);
{==============================================================================}
begin
  {paste from clipboard}
  { Create MDi Child Window }
  CreateMDIChild('Unnamed');
  StatusBar.Panels[2].Text := 'Unnamed';
  with ActiveMDIChild as TMDIChild do begin
        if not Clipboard.HasFormat(CF_PICTURE) then
        MessageDlg('There is no image on the Clipboard', mtInformation,[mbOK],0);
  Image1.AutoSize := False;
  Image1.Stretch := False;
  Image1.Picture.Assign(Clipboard);
  Image1.AutoSize := True;
  Image1.Stretch := True;
  end;
end;

{==============================================================================}
procedure TMainForm.WindowCascadeItemClick(Sender: TObject);
{==============================================================================}
begin
  Cascade;
end;

{==============================================================================}
procedure TMainForm.TileHorzontallyItemClick(Sender: TObject);
{==============================================================================}
begin
  TileMode := tbHorizontal;
  Tile;
end;

{==============================================================================}
procedure TMainForm.WindowArrangeItemClick(Sender: TObject);
{==============================================================================}
begin
  ArrangeIcons;
end;

{==============================================================================}
procedure TMainForm.WindowMinimizeItemClick(Sender: TObject);
{==============================================================================}
var
  I: Integer;
begin
  { Must be done backwards through the MDIChildren array }
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

{==============================================================================}
procedure TMainForm.UpdateMenuItems(Sender: TObject);
{==============================================================================}
begin
  { Force memu items and buttons to be disabled if no child window }
  FileCloseItem.Enabled       := MDIChildCount > 0;
  FileSaveItem.Enabled        := MDIChildCount > 0;
  FileSaveAsItem.Enabled      := MDIChildCount > 0;
  CopyItem.Enabled            := MDIChildCount > 0;
  PasteItem.Enabled           := MDIChildCount > 0;
  PasteBtn.Enabled            := MDIChildCount > 0;
  SaveBtn.Enabled             := MDIChildCount > 0;
  CopyBtn.Enabled             := MDIChildCount > 0;
  FileCloseItem.Enabled       := MDIChildCount > 0;
  CloseAll1.Enabled           := MDIChildCount > 0;
  ForceClose1.Enabled         := MDIChildCount > 0;
  FileSaveItem.Enabled        := MDIChildCount > 0;
  FileSaveAsItem.Enabled      := MDIChildCount > 0;
  Information1.Enabled        := MDIChildCount > 0;
  Print1.Enabled              := MDIChildCount > 0;
  Rulers1.Enabled             := MDIChildCount > 0;
  WindowCascadeItem.Enabled   := MDIChildCount > 0;
  TileHorzontallyItem.Enabled := MDIChildCount > 0;
  WindowArrangeItem.Enabled   := MDIChildCount > 0;
  WindowMinimizeItem.Enabled  := MDIChildCount > 0;
  WindowCascadeItem.Enabled   := MDIChildCount > 0;
  TileVerticallyItem.Enabled  := MDIChildCount > 0;
  WindowArrangeItem.Enabled   := MDIChildCount > 0;
  WindowMinimizeItem.Enabled  := MDIChildCount > 0;
  WindowNextItem.Enabled      := MDIChildCount > 0;
  WindowPreviousItem.Enabled  := MDIChildCount > 0;
  SpeedButton8.Enabled        := MDIChildCount > 0;
  SpeedButton9.Enabled        := MDIChildCount > 0;
  SpeedButton12.Enabled       := MDIChildCount > 0;
  SpeedButton15.Enabled       := MDIChildCount > 0;
  SpeedButton16.Enabled       := MDIChildCount > 0;
  SpeedButton17.Enabled       := MDIChildCount > 0;
  SpeedButton18.Enabled       := MDIChildCount > 0;
  SpeedButton22.Enabled       := MDIChildCount > 0;
  SpeedButton23.Enabled       := MDIChildCount > 0;
  SpeedButton28.Enabled       := MDIChildCount > 0;
end;

{==============================================================================}
procedure TMainForm.FormDestroy(Sender: TObject);
{==============================================================================}
begin
  Screen.OnActiveFormChange := nil;
  CreateConfigEntry;
end;

{==============================================================================}
procedure TMainForm.CaptureArea;
{==============================================================================}
begin
   with TForm2.Create(Application) do
     try
        if ShowModal = mrOK then
           with fRect do
              begin  { Exit if improper rectangle drawn }
                 if (Right > Left) and (Bottom > Top) then begin
                    { Give system time to refresh }
                    Delay(DelayTime div 2); 
                    { Capture desktop }
                    ABitmap := TBitmap.Create;
                    ABitmap.Assign(CaptureScreenRect(fRect));
                    { Copy the image to the Light Lib Images component }
                    Child.Image1.Picture.Bitmap := ABitmap;
                    Child.HorzScrollBar.Range := Child.Image1.Picture.Width;
                    Child.VertScrollBar.Range := Child.Image1.Picture.Height;
                    { Free the bitmap }
                    ABitmap.Free;
                 end
                 else
                 begin
                    MessageDlg('Error selecting rectangle, try again!', mtInformation, [mbOk], 0);
                    Child.Close;
                    Form2.Free;
                    Exit;
                 end; {If}
              end; {fRect}
     finally  {ShowModal}
        Free;
   end;
end;

{==============================================================================}
procedure TMainform.CaptureWindow;
{==============================================================================}
begin
end;

{==============================================================================}
procedure TMainForm.CaptureIcon;
{==============================================================================}
begin
   with TForm4.Create(Application) do
     try
        if ShowModal = mrOK then
           with fRect do
              begin  { Exit if improper rectangle drawn }
                 if (Right > Left) and (Bottom > Top) then begin
                    { Give system time to refresh }
                    Delay(DelayTime div 2);
                    { Capture icon }
                    ABitmap := TBitmap.Create;
                    ABitmap.Assign(CaptureScreenRect(fRect));
                    { Copy the image to the Light Lib Images component }
                    Child.Image1.Picture.Bitmap := ABitmap;
                    { Free the bitmap }
                    ABitmap.Free;
                 end
                 else
                 begin
                    MessageDlg('Error selecting rectangle, try again!', mtInformation, [mbOk], 0);
                    Child.Close;
                    Form4.Free;
                    Exit;
                 end; {If}
              end; {fRect}
     finally  {ShowModal}
        Free;
   end;
end;

{==============================================================================}
procedure TMainForm.Desktop1Click(Sender: TObject);
{==============================================================================}
begin

   Inc(CaptureNum,1);

   { Get Apprehend out of the way ... }
   if WinRoller1.Roller <> true then
   Application.Minimize;

   { Give screen time to refresh by delay }
   if WinRoller1.Roller <> true then
   Delay(DelayTime div 2);

   { Set file information }
   Filename := 'Capture '+IntToStr(CaptureNum);
   Filename := DefaultDirectory+'\'+Filename;

   { Create MDi Child Window }
   CreateMDIChild(FileName);
   StatusBar.Panels[2].Text := ExtractFilename(Filename);

   with ActiveMDIChild as TMDIChild do begin
      Image1.Picture.Bitmap := CaptureScreen;
      if Rulers1.Checked then begin
         HorzScrollBar.Range := Image1.Picture.Width+Child.Panel2.Width;
         VertScrollBar.Range := Image1.Picture.Height+Child.Panel1.Height;
      end
      else
      begin
         HorzScrollBar.Range := Image1.Picture.Width;
         VertScrollBar.Range := Image1.Picture.Height;
      end;
   end;

   InfoDlg.edHeight.Text := IntToStr(Child.Image1.Height);
   InfoDlg.edWidth.Text := IntToStr(Child.Image1.Width);

   Child.Image1.Hint := 'Height: ' + IntToStr(Child.Image1.Picture.Height) + ' pixels'+
   '  Width: ' + IntToStr(Child.Image1.Picture.Width) + ' pixels';

   { Restore Apprehend32 to original state }
   Application.Restore;
end;

{==============================================================================}
procedure TMainForm.Area1Click(Sender: TObject);
{==============================================================================}
begin
   { Get Apprehend out of the way ... if not rolled}
   if WinRoller1.Roller <> true then
      Application.Minimize;

   { Give screen time to refresh by delay }
   if WinRoller1.Roller <> true then
   Delay(DelayTime div 2);

   Inc(CaptureNum,1);

   { Set file information }
   Filename := 'Capture '+IntToStr(CaptureNum);
   Filename := DefaultDirectory+'\'+Filename;

   { Create MDi Child Window }
   CreateMDIChild(FileName);
   StatusBar.Panels[2].Text := ExtractFilename(Filename);

   { Capture area of screen }
   CaptureArea;

   {This next line is not needed if the TImage is aligned to the client area.}
   SetBounds((Screen.Width - Width) div 2, (Screen.Height - Height) div 2, Width, Height);
   {This code came from Lloyd's help file!}

   if Rulers1.Checked then
          begin
             Child.ClientWidth := Child.Image1.Picture.Width+Child.Panel2.Width;
             Child.ClientHeight := Child.Image1.Picture.Height+Child.Panel1.Height;
             Child.HorzScrollBar.Range := Child.Image1.Picture.Width+Child.Panel2.Width;
             Child.VertScrollBar.Range := Child.Image1.Picture.Height+Child.Panel1.Height;
          end
          else
          begin
             Child.ClientWidth := Child.Image1.Picture.Width;
             Child.ClientHeight := Child.Image1.Picture.Height;
             Child.HorzScrollBar.Range := Child.Image1.Picture.Width;
             Child.VertScrollBar.Range := Child.Image1.Picture.Height;
          end;
   
   InfoDlg.edHeight.Text := IntToStr(Child.Image1.Height);
   InfoDlg.edWidth.Text := IntToStr(Child.Image1.Width);

   Child.Image1.Hint := 'Height: ' + IntToStr(Child.Image1.Picture.Height) + ' pixels'+
   '  Width: ' + IntToStr(Child.Image1.Picture.Width) + ' pixels';

   { Restore Apprehend to original state ... if not rolled}
   if WinRoller1.Roller <> true then
      Application.Restore;
end;

{==============================================================================}
procedure TMainForm.Print1Click(Sender: TObject);
{==============================================================================}
begin
     Screen.Cursor := crHourglass;
     if MDIChildCount <> 0 then
     with ActiveMDIChild as TMDIChild do begin
       with Printer do
         begin
           BeginDoc;	{ start printing }
           Canvas.Draw(0, 0, Image1.Picture.Graphic);	{ draw Image at top left corner of printed page }
           EndDoc;	{ finish printing }
         end;
     end;
     Screen.Cursor := crDefault;
end;

{==============================================================================}
procedure TMainForm.PrintSetup1Click(Sender: TObject);
{==============================================================================}
begin
     Screen.Cursor := crHourglass;
     PrinterSetupDialog1.Execute;
     Screen.Cursor := crDefault;
end;

{==============================================================================}
procedure TMainForm.HelpAboutItemClick(Sender: TObject);
{==============================================================================}
begin
   AboutBox1.ShowModal;
end;

{==============================================================================}
procedure TMainForm.SpeedButton11Click(Sender: TObject);
{==============================================================================}
begin
   PrintSetup1Click(Sender);
end;

{==============================================================================}
procedure TMainForm.CloseAll1Click(Sender: TObject);
{==============================================================================}
var
  I: Integer;
begin
  for I := MDIChildCount - 1 downto 0 do begin
    MDIChildren[I].Close;
    if I = 0 then
       CaptureNum := 0;
  end;
end;

{==============================================================================}
procedure TMainForm.WindowNextItemClick(Sender: TObject);
{==============================================================================}
begin
   Next;
   with ActiveMDIChild as TMDIChild do begin
   if WindowState = wsMaximized then
      StatusBar.Panels[2].Text := ExtractFilename(Caption)
   else
      StatusBar.Panels[2].Text := ExtractFilename(Caption);
   end;
end;

{==============================================================================}
procedure TMainForm.WindowPreviousItemClick(Sender: TObject);
{==============================================================================}
begin
  Previous;
  with ActiveMDIChild as TMDIChild do begin
  if WindowState = wsMaximized then
     StatusBar.Panels[2].Text := ExtractFilename(Caption)
  else
     StatusBar.Panels[2].Text := ExtractFilename(Caption);
  end;
end;

{==============================================================================}
procedure TMainForm.TileVerticallyItemClick(Sender: TObject);
{==============================================================================}
begin
   TileMode := tbVertical;
   Tile;
end;

{==============================================================================}
procedure TMainForm.WinRoller1Roller(Sender: TObject; mode: TRollerMode);
{==============================================================================}
begin
   case Mode of
      mdRollUp: Caption := 'Capture Desktop: F7  Area: F8  Window: F9  Icon: F10';
      mdRollDown : Caption := 'Apprehend32 Lite';
   end {case}
end;

{==============================================================================}
procedure TMainForm.ForceClose1Click(Sender: TObject);
{==============================================================================}
begin
  ForceClose1.Checked := not ForceClose1.Checked;
end;

{==============================================================================}
procedure TMainForm.CaptureWindowClick(Sender: TObject);
{==============================================================================}
var
   ABitmap    : TBitmap;
   P          : TPoint;
   Handles    : HWnd;
begin
   { Get Apprehend out of the way ... }
   if WinRoller1.Roller <> true then
   Application.Minimize;

   { Give screen time to refresh by delay }
   if WinRoller1.Roller <> true then
   Delay(DelayTime);

   Inc(CaptureNum,1);

   { Set file information }
   Filename := 'Capture '+IntToStr(CaptureNum);
   Filename := DefaultDirectory+'\'+Filename;

   with TForm3.Create(Application) do
     try
        if ShowModal = mrOK then
        begin
           { Create MDi Child Window }
           CreateMDIChild(FileName);
           StatusBar.Panels[2].Text := ExtractFilename(Filename);

          { Give system time to refresh }
          Delay(DelayTime);

          { Create a bitmap }
          ABitmap := TBitmap.Create;

          {Get cursor position}
          GetCursorPos(P);

          { If the function succeeds, the return value is the handle of the window }
          { that contains the point. If no window exists at the given point, the }
          { return value is NULL. }
          Handles := WindowFromPoint(P);

          { Add code to capture control as bitmap & copy to bitmap }
          ABitmap := CaptureWindowImage(Handles);

          { Copy the image to the Images component }
          Child.Image1.Picture.Bitmap := ABitmap;

          if Rulers1.Checked then
          begin
             Child.ClientWidth := Child.Image1.Picture.Width+Child.Panel2.Width;
             Child.ClientHeight := Child.Image1.Picture.Height+Child.Panel1.Height;
             Child.HorzScrollBar.Range := Child.Image1.Picture.Width+Child.Panel2.Width;
             Child.VertScrollBar.Range := Child.Image1.Picture.Height+Child.Panel1.Height;
          end
          else
          begin
             Child.ClientWidth := Child.Image1.Picture.Width;
             Child.ClientHeight := Child.Image1.Picture.Height;
             Child.HorzScrollBar.Range := Child.Image1.Picture.Width;
             Child.VertScrollBar.Range := Child.Image1.Picture.Height;
          end;
          
          Child.Image1.Hint := 'Height: ' + IntToStr(Child.Image1.Picture.Height) + ' pixels'+
             '  Width: ' + IntToStr(Child.Image1.Picture.Width) + ' pixels';

          { Free the bitmap }
          ABitmap.Free;
          end; {If}
     finally  {ShowModal}
        Free;
        
   InfoDlg.edHeight.Text := IntToStr(Child.Image1.Height);
   InfoDlg.edWidth.Text := IntToStr(Child.Image1.Width);
   
   { Restore Apprehend32 to original state }
   if WinRoller1.Roller <> true then
      Application.Restore;
end;
end;

{==============================================================================}
procedure TMainForm.ShowConfig1Click(Sender: TObject);
{==============================================================================}
begin
    if AutoSave then ViewModifyDlg.Checkbox1.Checked := True else
       ViewModifyDlg.Checkbox1.Checked := False;
    ViewModifyDlg.Execute;
end;

{==============================================================================}
procedure TMainForm.SysHotKey1HotKey(Sender: TObject; Index: Integer);
{==============================================================================}
begin
case Index of
    0     : begin  //First hotkey F7
               Desktop1Click(Self);
            end;
    1     : begin  //Second hotkey F8
               Area1Click(Self);
            end;
    2     : begin  //Third hotkey F9
               CaptureWindowClick(Self);
            end;
    3     : begin  //Fourth hotkey F10
               CaptureIcon1Click(Self);
            end;
  end; {case}
end;

{==============================================================================}
procedure TMainForm.Components1Click(Sender: TObject);
{==============================================================================}
begin
   Comp.ShowModal;
end;

{==============================================================================}
procedure TMainForm.Register1Click(Sender: TObject);
{==============================================================================}
begin
   ShowConfig1Click(Self);
end;

{==============================================================================}
procedure TMainForm.FormActivate(Sender: TObject);
{==============================================================================}
begin
{ if no ini file info then display message }
if NOT ReadConfigInfo then begin
   ShowMessage('Config Information Not Found'+#10#13+
               'Please register this program by'+#10#13+
               'selecting Help-Register from the menu!');
end;
end;

{==============================================================================}
procedure TMainForm.Exit2Click(Sender: TObject);
{==============================================================================}
begin
   Close;
end;

{==============================================================================}
procedure TMainForm.Information1Click(Sender: TObject);
{==============================================================================}
begin
if MDIChildCount <> 0 then
    with ActiveMDIChild as TMDIChild do begin
       with InfoDlg do begin
          edName.Text    := ExtractFilename(Filename);
          edColors.Text  := IntToStr(1 shl GetDeviceCaps( Canvas.Handle, BITSPIXEL ));
          edHeight.Text := IntToStr(Image1.Picture.Height);
          edWidth.Text := IntToStr(Image1.Picture.Width);
       end;
    end;
InfoDlg.ShowModal;
end;

{==============================================================================}
procedure TMainForm.CaptureIcon1Click(Sender: TObject);
{==============================================================================}
begin
   { Get Apprehend out of the way ... if not rolled}
   if WinRoller1.Roller <> true then
      Application.Minimize;

   { Give screen time to refresh by delay }
   if WinRoller1.Roller <> true then
   Delay(DelayTime div 2);

   Inc(CaptureNum,1);

   { Set file information }
   Filename := 'Capture '+IntToStr(CaptureNum);
   Filename := DefaultDirectory+'\'+Filename;

   { Create MDi Child Window }
   CreateMDIChild(FileName);
   StatusBar.Panels[2].Text := ExtractFilename(Filename);

   { Capture icon size (32x32) area of screen }
   CaptureIcon;

   {This next line is not needed if the TImage is aligned to the client area.}
   SetBounds((Screen.Width - Width) div 2, (Screen.Height - Height) div 2, Width, Height);
   {This code came from Lloyd's help file!}

   if Rulers1.Checked then
   begin
      Child.ClientWidth := Child.Image1.Picture.Width+Child.Panel2.Width;
      Child.ClientHeight := Child.Image1.Picture.Height+Child.Panel1.Height;
      Child.HorzScrollBar.Range := Child.Image1.Picture.Width+Child.Panel2.Width;
      Child.VertScrollBar.Range := Child.Image1.Picture.Height+Child.Panel1.Height;
   end
   else
   begin
      Child.ClientWidth := Child.Image1.Picture.Width;
      Child.ClientHeight := Child.Image1.Picture.Height;
      Child.HorzScrollBar.Range := Child.Image1.Picture.Width;
      Child.VertScrollBar.Range := Child.Image1.Picture.Height;
   end;

   InfoDlg.edHeight.Text := '32';
   InfoDlg.edWidth.Text := '32';

   Child.Image1.Hint := 'Height: ' + IntToStr(Child.Image1.Picture.Height) + ' pixels'+
   '  Width: ' + IntToStr(Child.Image1.Picture.Width) + ' pixels';

   { Restore Apprehend to original state ... if not rolled}
   if WinRoller1.Roller <> true then
      Application.Restore;
end;

{==============================================================================}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
{==============================================================================}
begin
   CreateConfigEntry;
end;

{==============================================================================}
procedure TMainForm.XToolBar1DockChanged(Sender: TObject);
{==============================================================================}
begin
if XToolbar1.DockedTo = nil then
   XToolbar1.Hint := ''
else
  XToolbar1.Hint := 'Double click or drag to undock';
XToolbar1.NoticeVisibleChanged;
end;

{==============================================================================}
procedure TMainForm.XToolBar2DockChanged(Sender: TObject);
{==============================================================================}
begin
if XToolbar2.DockedTo = nil then
   XToolbar2.Hint := ''
else
   XToolbar2.Hint := 'Double click or drag to undock';
XToolbar2.NoticeVisibleChanged;
end;

{==============================================================================}
procedure TMainForm.XToolBar3DockChanged(Sender: TObject);
{==============================================================================}
begin
if XToolbar3.DockedTo = nil then
   XToolbar3.Hint := ''
else
   XToolbar3.Hint := 'Double click or drag to undock';
XToolbar3.NoticeVisibleChanged;
end;

{==============================================================================}
procedure TMainForm.XToolBar4DockChanged(Sender: TObject);
{==============================================================================}
begin
if XToolbar4.DockedTo = nil then
   XToolbar4.Hint := ''
else
   XToolbar4.Hint := 'Double click or drag to undock';
XToolbar4.NoticeVisibleChanged;
end;

{==============================================================================}
procedure TMainForm.XToolBar5DockChanged(Sender: TObject);
{==============================================================================}
begin
if XToolbar5.DockedTo = nil then
   XToolbar5.Hint := ''
else
   XToolbar5.Hint := 'Double click or drag to undock';
XToolbar5.NoticeVisibleChanged;
end;

{==============================================================================}
procedure TMainForm.ToolBars1Click(Sender: TObject);
{==============================================================================}
begin
ToolBars1.Checked  := Not ToolBars1.Checked;
if ToolBars1.Checked then
begin
   Docks1.Visible := True;
   Docks2.Visible := True;
   Docks3.Visible := True;
   Docks4.Visible := True;
end
else
begin
   Docks1.Visible := False;
   Docks2.Visible := False;
   Docks3.Visible := False;
   Docks4.Visible := False;
end;
XToolbar1.NoticeVisibleChanged;
XToolbar2.NoticeVisibleChanged;
XToolbar3.NoticeVisibleChanged;
XToolbar4.NoticeVisibleChanged;
XToolbar5.NoticeVisibleChanged;
end;

{==============================================================================}
procedure TMainForm.Rulers1Click(Sender: TObject);
{==============================================================================}
begin
Rulers1.Checked  := Not Rulers1.Checked;
if Rulers1.Checked then
begin
   Child.Panel1.Visible := True;
   Child.Panel2.Visible := True;
   Child.ClientWidth := Child.Image1.Picture.Width+Child.Panel2.Width;
   Child.ClientHeight := Child.Image1.Picture.Height+Child.Panel1.Height;
   Child.HorzScrollBar.Range := Child.Image1.Picture.Width+Child.Panel2.Width;
   Child.VertScrollBar.Range := Child.Image1.Picture.Height+Child.Panel1.Height;
end
else
begin
   Child.Panel1.Visible := False;
   Child.Panel2.Visible := False;
   Child.ClientWidth := Child.Image1.Picture.Width;
   Child.ClientHeight := Child.Image1.Picture.Height;
   Child.HorzScrollBar.Range := Child.Image1.Picture.Width;
   Child.VertScrollBar.Range := Child.Image1.Picture.Height;
end;
Child.FormResize(Self);
end;
procedure TMainForm.SpeedButton4Click(Sender: TObject);
begin
    Application.HelpFile := ExtractFilePath(Application.EXEName) + '\APPREHEND.HLP';
    Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TMainForm.Contents1Click(Sender: TObject);
begin
   Application.HelpFile := ExtractFilePath(Application.EXEName) + '\APPREHEND.HLP';
   Application.HelpCommand(HELP_CONTENTS, 0);
end;

end.

