{******************************************************************************}
{*                                                                            *}
{*               Adirondack Software & Graphics ChildWin Unit                 *}
{*            (C) Copyright Adirondack Software & Graphics 1997               *}
{*                                                                            *}
{******************************************************************************}

unit Childwin;

interface

uses SysUtils, Windows, Classes, Graphics, Forms, Controls, Dialogs, GlobalUT,
StdCtrls, ExtCtrls, Menus, ComCtrls, RulerU, Buttons;

type
  TMDIChild = class(TForm)
    Image1: TImage;
    Panel1: TPanel;
    HRuler1: THRuler;
    Panel2: TPanel;
    VRuler1: TVRuler;
    Button1: TSpeedButton;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormActivate(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure Exit2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ImageWindow1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormResize(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

uses Main, IDlgUt;

{$R *.DFM}

{==============================================================================}
procedure TMDIChild.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
{==============================================================================}
const
CloseMsg = '''%s'' has been modified, save?';
var
MsgVal: Integer;
begin
     { Get image name from child window }
     Filename := Caption;
     if not MainForm.ForceClose1.Checked then begin
        { See if image has been saved }
        MsgVal := MessageDlg(Format(CloseMsg, [Filename]), mtConfirmation, [mbYes, mbNo, mbCancel], 0);
        case MsgVal of
           mrYes    : MainForm.FileSaveItemClick(Self);
           mrCancel : CanClose := false;
        end; { case }
     end;
end;

{==============================================================================}
procedure TMDIChild.FormActivate(Sender: TObject);
{==============================================================================}
begin
   if WindowState = wsMaximized then begin
      MainForm.StatusBar.Panels[2].Text := ExtractFilename(Caption);
   end
   else begin
      MainForm.StatusBar.Panels[2].Text := ExtractFilename(Caption);
   end;
   
   HRuler1.Width := Panel1.Width;
   VRuler1.Height := Panel2.Height;

end;

{==============================================================================}
procedure TMDIChild.Close1Click(Sender: TObject);
{==============================================================================}
begin
   Close;
end;

{==============================================================================}
procedure TMDIChild.Exit2Click(Sender: TObject);
{==============================================================================}
begin
   MainForm.Close;
end;

{==============================================================================}
procedure TMDIChild.FormClose(Sender: TObject; var Action: TCloseAction);
{==============================================================================}
begin
   Action := caFree;
end;

{==============================================================================}
procedure TMDIChild.ImageWindow1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
{==============================================================================}
begin
Image1.Hint := 'Image Size: ' + IntToStr( Image1.Height )+
                      ' pixels high x '+ IntToStr( Image1.Width )+
                      ' pixels wide';
end;

procedure TMDIChild.FormResize(Sender: TObject);
begin
   HRuler1.Width := Panel1.Width;
   VRuler1.Height := Panel2.Height;
end;

procedure TMDIChild.Button1Click(Sender: TObject);
begin
   case HRuler1.Units of
        ruInches: begin
           Button1.Caption := 'DI';
           HRuler1.Units := ruDecInches;
           VRuler1.Units := ruDecInches;
           HRuler1.Hint := 'Decimal Inches';
           vRuler1.Hint := 'Decimal Inches';
        end;
        ruDecInches: begin
           Button1.Caption := 'Cm';
           HRuler1.Units := ruCentims;
           VRuler1.Units := ruCentims;
           HRuler1.Hint := 'Centimeters';
           VRuler1.Hint := 'Centimeters';
        end;
        ruCentims: begin
           Button1.Caption := 'Pix';
           HRuler1.Units := ruPixels;
           VRuler1.Units := ruPixels;
           HRuler1.Hint := 'Pixels';
           vRuler1.Hint := 'Pixels';
        end;
        ruPixels: begin
           Button1.Caption := 'In';
           HRuler1.Units := ruInches;
           VRuler1.Units := ruInches;
           HRuler1.Hint := 'Inches';
           vRuler1.Hint := 'Inches';
        end;
     end;
end;

procedure TMDIChild.FormCreate(Sender: TObject);
begin
 if MainForm.Rulers1.Checked then
 begin
 Panel1.Visible := true;
 Panel2.Visible := true;
 end
 else
 begin
 Panel1.Visible := false;
 Panel2.Visible := false;;
 end;
end;

procedure TMDIChild.FormShow(Sender: TObject);
begin
if MainForm.Rulers1.Checked then
 begin
 Panel1.Visible := true;
 Panel2.Visible := true;
 end
 else
 begin
 Panel1.Visible := false;
 Panel2.Visible := false;;
 end;
end;

end.
