unit child3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TClientCapture = class(TForm)
    Image1: TImage;
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ClientCapture: TClientCapture;

implementation

{$R *.DFM}

procedure TClientCapture.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  hwindow: HWND;
  pt: TPoint;
  r : TRect;
  aDC: HDC;
  Bmp: TBitmap;
begin
   MouseCapture := False;
   pt := Point(x,y);
   pt := ClientToScreen( pt );
   hwindow := WindowFromPoint( pt );
   If handle <> 0 Then Begin
     Windows.GetWindowRect( hwindow, r );
     Windows.GetClientRect( hwindow, r );
     pt := Point(0,0);
     Windows.ClientToScreen( hwindow, pt );
     Sleep( 500 );
     aDC := GetDC( hWindow );
     If aDC <> 0 Then Begin
       Bmp:= TBitmap.Create;
       Bmp.Width := r.right - r.left;
       Bmp.Height := r.bottom - r.top;
       BitBlt( Bmp.Canvas.Handle, r.left, r.top, r.right, r.bottom, aDC,
               0, 0, SRCCOPY );
       ReleaseDC( hwindow, aDC );
       Image1.Picture.Bitmap := Bmp;
       Bmp.Free;
    End;
  End;
  SetForegroundWindow( handle );
end;

end.
