{******************************************************************************}
{*                                                                            *}
{*             Adirondack Software & Graphics Capture Form Unit               *}
{*            (C) Copyright Adirondack Software & Graphics 1997               *}
{*                                                                            *}
{******************************************************************************}

unit capture3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TForm3 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormPaint(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    procedure WMEraseBkGnd( Var Msg: TWMEraseBkGnd ); message WM_ERASEBKGND;
  public
    { Public declarations }
    fRect: TRect;
    fBmp: TBitmap;
  end;

var
  Form3: TForm3;

implementation

Uses Main;

{$R *.DFM}
{$R Capture3.Res}

procedure TForm3.FormCreate(Sender: TObject);
var
  aDC: HDC;
const
  crHand = -18;
begin
  Screen.Cursors[crHand] := LoadCursor(hInstance, pChar('CURSOR_1'));
  Cursor := crHand;
  fBMP        := TBitmap.Create;
  fBMP.Width  := Screen.Width;
  fBMP.Height := Screen.Height;
  aDC         := GetDC( 0 );
  BitBlt( fBMP.Canvas.handle, 0, 0, Screen.Width, Screen.Height,
          aDC, 0, 0, srcCopy );
  ReleaseDC( 0, aDC );
  SetBounds( 0, 0, Screen.Width, Screen.Height );
end;

procedure TForm3.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  ModalResult := mrOK;
end;

procedure TForm3.FormPaint(Sender: TObject);
begin
  Canvas.Draw( 0, 0, fBMP );
end;

procedure TForm3.FormDestroy(Sender: TObject);
begin
  fBMP.Free;
  Screen.Cursor := crDefault;
end;

Procedure TForm3.WMEraseBkGnd( var Msg: TWMEraseBkGnd );
begin
  Msg.Result := 1;
end;

procedure TForm3.FormActivate(Sender: TObject);
const
  crHand = -18;
begin
   Screen.Cursors[crHand] := LoadCursor(hInstance, pChar('CURSOR_1'));
   Cursor := crHand;
end;

end.





