unit capture1;

{Here is a simple Unit for a "capture" form. It launches a form with no border
that covers the screen and copies the screen content to an internal bitmap,
which it displays. You can hold down the left mouse button and drag a
selection rectangle on screen. When the mouse button goes up again the form
closes and control returns to the first form. There you could recover the
coordinates of the drag rectangle and copy the appropriate section out of the
fBMP bitmap of the capture form.}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ScrnCap, ExtCtrls, Clipbrd, Dtmisc, Balloon, VisApp, ComCtrls,
  Menus, Buttons, explbtn, Printers, Seldir, GlobalUt, Tabs;

type
  TForm1 = class(TForm)
    BalloonHint1: TBalloonHint;
    VisualApp1: TVisualApp;
    StatusBar1: TStatusBar;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    N1: TMenuItem;
    PrintSetup1: TMenuItem;
    Print1: TMenuItem;
    SaveAs1: TMenuItem;
    Save1: TMenuItem;
    Open1: TMenuItem;
    Edit1: TMenuItem;
    Copy1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Contents1: TMenuItem;
    Capture1: TMenuItem;
    Desktop1: TMenuItem;
    Rectangle1: TMenuItem;
    N3: TMenuItem;
    Panel2: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    PrintDialog1: TPrintDialog;
    PrinterSetupDialog1: TPrinterSetupDialog;
    SpeedButton7: TSpeedButton;
    PopupMenu1: TPopupMenu;
    Capturedesktop1: TMenuItem;
    Capturerectangle1: TMenuItem;
    N4: TMenuItem;
    Close2: TMenuItem;
    SpeedButton8: TSpeedButton;
    Options1: TMenuItem;
    Hotkeys1: TMenuItem;
    DesktopComboBox1: TComboBox;
    RectangleComboBox2: TComboBox;
    Directories1: TMenuItem;
    TabSet1: TTabSet;
    Notebook1: TNotebook;
    ScrollBox1: TScrollBox;
    Image1: TImage;
    ProgressBar1: TProgressBar;
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Rectangle1Click(Sender: TObject);
    procedure Desktop1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure PrintSetup1Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure Close2Click(Sender: TObject);
    procedure Capturedesktop1Click(Sender: TObject);
    procedure Capturerectangle1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure DesktopHotKeyComboBoxClick(Sender: TObject);
    procedure HotKey1Exit(Sender: TObject);
    procedure DesktopComboBox1Click(Sender: TObject);
    procedure DesktopComboBox1Change(Sender: TObject);
    procedure RectangleComboBox2Change(Sender: TObject);
    procedure Directories1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure TabSet1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure TabSet1Click(Sender: TObject);
  private
    { Private declarations }
    DesktopShortCut: TShortCut;
    RectangleShortCut: TShortCut;
  public
    { Public declarations }
    CaptureWindow: Boolean;
    CaptureNum: Integer;
    ScanNum: Integer;
    Filename: String;
    Tab: Integer;
    Stream1 : TMemoryStream;
    Procedure WMHandleMessages(var Msg : TMsg; var Handled : Boolean);
    procedure DisplayHint(Sender: TObject);
  end;

var
  Form1: TForm1;
  
implementation

uses Capture2, CapForm, about, Actdlg;
{$R *.DFM}

const
{Menu item id's}
smDesktop = 1000;
smRectangle = 1001;

procedure TForm1.wmHandleMessages(var Msg : TMsg; var Handled : Boolean);
var
SystemMenu : Hmenu;
Sender: TObject;
begin
   if Msg.message = WM_SYSCOMMAND then begin
      if Msg.wParam = smDesktop then begin
         { Code to capture the desktop }
         Desktop1Click(Sender);
      end;

      if Msg.wParam = smRectangle then begin
         { Code to capture a rectangular area of the screen }
         Rectangle1Click(Sender);
      end;

      SystemMenu := GetSystemMenu( Application.Handle, False );
      SystemMenu := GetSystemMenu( Form1.Handle, False );
   end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   MouseCapture := True;
   CaptureWindow := True;
end;

procedure TForm1.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  hwindow: HWND;
  pt: TPoint;
  r : TRect;
  aDC: HDC;
  Bmp: TBitmap;
begin
  if CaptureWindow then begin
     MouseCapture := False;
     pt := Point(x,y);
     pt := ClientToScreen( pt );
     hwindow := WindowFromPoint( pt );
     if handle <> 0 then begin
       Windows.GetWindowRect( hwindow, r );
       pt := Point(r.left,r.top);
       Windows.ClientToScreen( hwindow, pt );
       Sleep( 500 );
       aDC := GetDC( hWindow );
       if aDC <> 0 then begin
         Bmp:= TBitmap.Create;
         Bmp.Width := r.right - r.left;
         Bmp.Height := r.bottom - r.top;
         Image1.Width := Bmp.Width;
         Image1.Height := Bmp.Height;
         BitBlt( Bmp.Canvas.Handle, 0, 0, width, height, aDC,  0, 0, SRCCOPY );
         ReleaseDC( hwindow, aDC );
         Image1.Picture.Bitmap := Bmp;
         Bmp.Free;
       end;
  end;
  SetForegroundWindow( handle );
  end {capturewindow true}
  else
  begin
     MouseCapture := False;
     pt := Point(x,y);
     pt := ClientToScreen( pt );
     hwindow := WindowFromPoint( pt );
     if handle <> 0 then begin
        Windows.GetWindowRect( hwindow, r );
        Windows.GetClientRect( hwindow, r );
        pt := Point(0,0);
        Windows.ClientToScreen( hwindow, pt );
        Sleep( 500 );
        aDC := GetDC( hWindow );
        if aDC <> 0 then begin
           Bmp:= TBitmap.Create;
           Bmp.Width := r.right - r.left;
           Bmp.Height := r.bottom - r.top;
           BitBlt( Bmp.Canvas.Handle, r.left, r.top, r.right, r.bottom, aDC,  0, 0, SRCCOPY );
           ReleaseDC( hwindow, aDC );
           Image1.Picture.Bitmap := Bmp;
           Bmp.Free;
        end;
     end;
  SetForegroundWindow( handle );
  end; {capturewindow false}
end;

procedure TForm1.FormCreate(Sender: TObject);
var
SystemMenu: HMenu;
begin
   CaptureWindow := True;
   CaptureNum := 0;
   ScanNum := 0;
   { Create a memorystream to store images }
   Stream1 := TMemoryStream.Create;
   DefaultDirectory := 'C:\Program Files\Apprehend32\Images';
   OpenDialog1.InitialDir := DefaultDirectory;
   SaveDialog1.InitialDir := DefaultDirectory;
  { System Menu Handling Code based on example By:
  Pete Ness, CIS# 102347,710.  Internet: Scream@Primenet.com
  "How to change and process the System Menu in Delphi" }

  { Build a New System Menu for the Application when it's minimized }
  { --------------------------------------------------------------- }
  SystemMenu := GetSystemMenu( Application.Handle, False );
  { And now add in a separator bar }
  InsertMenu(SystemMenu, 2, MF_ByPosition + MF_SEPARATOR , 901, '');
  { Add in New Menu Items after the separator bar }
  InsertMenu(SystemMenu, 3, MF_ByPosition+MF_String, smDesktop, 'Capture &Desktop' );
  InsertMenu(SystemMenu, 4, MF_ByPosition+MF_String, smRectangle, 'Capture &Rectangle' );

  { And then build another for the Form when it's NOT minimized }
  { ----------------------------------------------------------- }
  SystemMenu := GetSystemMenu( Handle, False );
  { And now add in a separator bar }
  InsertMenu(SystemMenu, 5, MF_ByPosition + MF_SEPARATOR , 901, '');
  { Add in New Menu Items after the separator bar }
  InsertMenu(SystemMenu, 6, MF_ByPosition+MF_String, smDesktop, 'Capture &Desktop' );
  InsertMenu(SystemMenu, 7, MF_ByPosition+MF_String, smRectangle, 'Capture &Rectangle' );

   { The next step is very important : set up the OnMessage Handler so that 
     every time our application gets a windows message, it passes through
     this routine. }

   Application.OnMessage := wmHandleMessages;
   
   {display extended hint in statusbar}
   Application.OnHint := DisplayHint;
end;

procedure TForm1.DisplayHint(Sender: TObject);
begin
   StatusBar1.Panels.Items[0].Text := Application.Hint;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
   Clipboard.Assign(Image1.Picture);
   WinExec('Clipbrd.exe', sw_Show);
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
   Close;
end;

procedure TForm1.About1Click(Sender: TObject);
begin
   AboutBox.Show;
end;

procedure TForm1.Rectangle1Click(Sender: TObject);
begin
 Inc(CaptureNum,1);
 {Get Apprehend32 out of the way of the capture}
 Application.Minimize;
  with TForm2.Create(Application) do
  try
    if ShowModal = mrOK then
      with fRect do
      begin  {exit if improper rectangle drawn}
        if (Left > Right) or (Top > Bottom) then begin
           Exit;
        end
        else
           Image1.Picture.Bitmap := CaptureScreenRect( fRect );
        end;
  finally
    Free;
  end;
     ScrollBox1.HorzScrollBar.Range := Image1.Picture.Width;
     ScrollBox1.VertScrollBar.Range := Image1.Picture.Height;
     {Restore Apprehend32 to original state}
     Application.Restore;
end;

procedure TForm1.Desktop1Click(Sender: TObject);
begin
   Inc(CaptureNum,1);
   FileName := 'Capture ' + IntToStr(CaptureNum);
   TabSet1.Tabs.Add (Filename);
   
   {Get Apprehend32 out of the way of the capture}
   Application.Minimize;
   Image1.Picture.Assign(CaptureScreen);

   { save image to memory stream }
    try
      Image1.Picture.Graphic.SaveToStream(Stream1);
    finally
      Stream1.Free;
    end;

   with ScrollBox1.HorzScrollBar do
     begin
        Range := Image1.Picture.Width;
        Increment := 10;
     end;
   with ScrollBox1.VertScrollBar do
     begin
        Range := Image1.Picture.Height;
        Increment := 10;
     end;
   {Restore Apprehend32 to original state}
   Application.Restore;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
   Close;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
   Desktop1Click(Sender);
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
   Rectangle1Click(Sender);
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
   SaveDialog1.Filename := 'Capture'+IntToStr(CaptureNum);
   if SaveDialog1.Execute then begin
      Image1.Picture.SaveToFile(SaveDialog1.Filename);
   end;
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
   if OpenDialog1.Execute then begin
      Image1.Picture.LoadFromFile(OpenDialog1.Filename);
      HorzScrollBar.Range := Image1.Picture.Width;
      VertScrollBar.Range := Image1.Picture.Height;
   end;
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
   Save1Click(Sender);
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
   Open1Click(Sender);
end;

procedure TForm1.Print1Click(Sender: TObject);
begin
   PrintDialog1.Execute;
   with Printer do
   begin
       Title := 'Apprehend32 Screen Capture';
       BeginDoc; { start printing }
       Canvas.Draw(0, 0, Image1.Picture.Bitmap); { draw Image at top left corner of printed page }
       EndDoc;	{ finish printing }
   end;
end;

procedure TForm1.PrintSetup1Click(Sender: TObject);
begin
   PrinterSetupDialog1.Execute;
end;

procedure TForm1.SpeedButton6Click(Sender: TObject);
begin
   Print1Click(Sender);
end;

procedure TForm1.SpeedButton7Click(Sender: TObject);
begin
   PrintSetup1Click(Sender);
end;

procedure TForm1.Close2Click(Sender: TObject);
begin
   Close;
end;

procedure TForm1.Capturedesktop1Click(Sender: TObject);
begin
   Desktop1Click(Sender);   
end;

procedure TForm1.Capturerectangle1Click(Sender: TObject);
begin
   Rectangle1Click(Sender);
end;

procedure TForm1.Copy1Click(Sender: TObject);
begin
   Clipboard.Assign(Image1.Picture);
end;

procedure TForm1.SpeedButton8Click(Sender: TObject);
begin
   Clipboard.Assign(Image1.Picture);
end;

procedure TForm1.DesktopHotKeyComboBoxClick(Sender: TObject);
begin
  ActivationDlg.ShowModal;
  DesktopShortCut := TextToShortCut(DesktopHotkey);
  Desktop1.ShortCut := DesktopShortCut;
  RectangleShortCut := TextToShortCut(RectangleHotkey);
  Rectangle1.ShortCut := RectangleShortCut;
end;

procedure TForm1.HotKey1Exit(Sender: TObject);
begin
   DesktopShortCut := TextToShortCut(DesktopHotkey);
   Desktop1.ShortCut := DesktopShortCut;
end;

procedure TForm1.DesktopComboBox1Click(Sender: TObject);
begin

  DesktopShortCut := TextToShortCut(DesktopHotkey);
  Desktop1.ShortCut := DesktopShortCut;
end;

procedure TForm1.DesktopComboBox1Change(Sender: TObject);
begin
  DesktopHotkey := DesktopComboBox1.Text;
  DesktopShortCut := TextToShortCut(DesktopHotkey);
  Desktop1.ShortCut := DesktopShortCut;
end;

procedure TForm1.RectangleComboBox2Change(Sender: TObject);
begin
   RectangleHotkey := RectangleComboBox2.Text;
   RectangleShortCut := TextToShortCut(RectangleHotkey);
   Rectangle1.ShortCut := RectangleShortCut;
end;

procedure TForm1.Directories1Click(Sender: TObject);
begin
   SelectDir.ShowModal;
   StatusBar1.Panels.Items[1].Text := DefaultDirectory;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
   TabSet1.Tabs.Clear;
  { FileName := 'Default'; }
   StatusBar1.Panels.Items[1].Text := DefaultDirectory;
   OpenDialog1.InitialDir := DefaultDirectory;
   SaveDialog1.InitialDir := DefaultDirectory;
   {TabSet1.Tabs.Add (Filename);}
end;

procedure TForm1.TabSet1Change(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
   { Get filename from Tabs }
   Filename := TabSet1.Tabs[NewTab];
   Tab := NewTab;
   { Load image from memory stream }
   Image1.Picture.Graphic.LoadFromStream(Stream1);
end;

procedure TForm1.TabSet1Click(Sender: TObject);
begin
   { Save image to memory stream }
   Image1.Picture.Graphic.SaveToStream(Stream1);
end;

end.
