{******************************************************************************}
{*                                                                            *}
{*                 Adirondack Software & Graphics About Unit                  *}
{*            (C) Copyright Adirondack Software & Graphics 1997               *}
{*                                                                            *}
{******************************************************************************}

unit About;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls;

type
  TAboutBox1 = class(TForm)
    ProgramLabel: TLabel;
    Version: TLabel;
    Copyright: TLabel;
    Bevel1: TBevel;
    Label3: TLabel;
    PhysMem: TLabel;
    Label4: TLabel;
    FreeRes: TLabel;
    OKButton: TButton;
    Comments: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    WinVersion: TLabel;
    Processor: TLabel;
    Label5: TLabel;
    PhysicalMemory: TLabel;
    Label6: TLabel;
    Image2: TImage;
    Label7: TLabel;
    UserName: TLabel;
    Label8: TLabel;
    CompanyName: TLabel;
    SerialNoLbl: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutBox1: TAboutBox1;

implementation

uses MAIN;

{$R *.DFM}

{==============================================================================}
procedure TAboutBox1.FormCreate(Sender: TObject);
{==============================================================================}
const
PlatNames: array[0..2] of string = ('Win32s', 'Windows 95', 'Windows NT');
var
  OVI: TOsVersionInfo;
  SI: TSystemInfo;
begin
  { Replace programicon with application's icon }
  { Programicon.Picture.Graphic := Application.Icon; }
  { Get windows version }
  OVI.dwOSVersionInfoSize := Sizeof(OVI);
  GetVersionEx(OVI);
  WinVersion.Caption := Format('%s, version %u.%.2u',[Platnames[OVI.dwPlatformID],OVI.dwMajorVersion,OVI.dwMinorVersion]);
  { Get system information }
  GetSystemInfo(SI);
  case SI.dwProcessorType of
       386: Processor.Caption := '80386';
       486: Processor.Caption := '80486';
       586: Processor.Caption := 'Pentium';
       686: Processor.Caption := 'Cyrx 686';
       else  Processor.Caption := 'Unknown processor' + InttoStr(SI.dwProcessorType);
  end; {case}
  ProgramLabel.Caption := 'Apprehend32';
  Version.Caption :=  'Version 2.1 (Beta) for Windows 95';
  UserName.Caption := MainForm.UserName;
  CompanyName.Caption := MainForm.CompanyName;
  SerialNoLbl.Caption := MainForm.SerialNumber;
  Copyright.Caption :=  ' 1997 Adirondack Software && Graphics';
  Comments.Caption := '';
end;

{==============================================================================}
procedure TAboutBox1.OKButtonClick(Sender: TObject);
{==============================================================================}
begin
   Close;
end;

{==============================================================================}
procedure TAboutBox1.FormActivate(Sender: TObject);
{==============================================================================}
var
TMS: TMemoryStatus;
begin
     { Get memory status info }
     TMS.dwLength := Sizeof(TMS);
     GlobalMemoryStatus(TMS);
     PhysicalMemory.Caption := FormatFloat('#," MB"', (TMS.dwTotalPhys) / 1048576);
     PhysMem.Caption := FormatFloat('#," KB Free"', (TMS.dwTotalPhys + TMS.dwAvailPageFile) / 1024);
     FreeRes.Caption := Format('%d %%', [TMS.dwMemoryLoad]);
end;

end.

