{******************************************************************************}
{*                                                                            *}
{*          Adirondack Software & Graphics Screen Capture Functions           *}
{*            (C) Copyright Adirondack Software & Graphics 1997               *}
{*                                                                            *}
{******************************************************************************}

unit ScrnCap;

interface
uses WinTypes, WinProcs, Forms, Controls, Classes, Graphics;

function CaptureScreenRect( ARect: TRect ): TBitmap;
function CaptureScreen: TBitmap;
function CaptureClientImage( Control: TControl ): TBitmap;
function CaptureControlImage( Control: TControl ): TBitmap;
function CaptureWindowImage( Wnd: HWND ): TBitmap;

implementation

{ Use this to capture a rectangle on the screen... }
function CaptureScreenRect( ARect: TRect ): TBitmap;
var
  ScreenDC: HDC;
begin
  Result := TBitmap.Create;
  with Result, ARect do
  begin
    Width := Right - Left;
    Height := Bottom - Top;
    ScreenDC := GetDC( 0 );
    try
      BitBlt( Canvas.Handle, 0, 0, Width, Height, ScreenDC,
        Left, Top, SRCCOPY );
    finally
      ReleaseDC( 0, ScreenDC );
    end;
  end;
end;

{ Use this to capture the entire screen... }
function CaptureScreen: TBitmap;
begin
  with Screen do
    Result := CaptureScreenRect( Rect( 0, 0, Width, Height ));
end;

{ Use this to capture just the client area of a form
  or control... }
function CaptureClientImage( Control: TControl ): TBitmap;
begin
  with Control, Control.ClientOrigin do
    Result := CaptureScreenRect( Bounds( X, Y, ClientWidth,
                ClientHeight ));
end;

{ Use this to capture an entire form or control... }
function CaptureControlImage( Control: TControl ): TBitmap;
begin
  with Control do
   if Parent = nil then
      Result := CaptureScreenRect( Bounds( Left, Top, Width,
                  Height ))
    else
      with Parent.ClientToScreen( Point( Left, Top )) do
        Result := CaptureScreenRect( Bounds( X, Y, Width,
                    Height )); 
end;

{ Use this to capture an entire form or control paased as an API hWnd... }
function CaptureWindowImage( Wnd: HWND ): TBitmap;
var
  R: TRect;
begin
  GetWindowRect(Wnd, R);
  Result := CaptureScreenRect(R);
end;


end.

