{******************************************************************************}
{*                                                                            *}
{*                 Adirondack Software & Graphics DelayUt Unit                *}
{*            (C) Copyright Adirondack Software & Graphics 1997               *}
{*                                                                            *}
{******************************************************************************}

unit DelayUt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Spin;

type
  TDelayForm = class(TForm)
    GroupBox1: TGroupBox;
    Edit1: TEdit;
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    Label2: TLabel;
    Label3: TLabel;
    SpinButton1: TSpinButton;
    Label4: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpinButton1DownClick(Sender: TObject);
    procedure SpinButton1UpClick(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DelayForm: TDelayForm;

implementation

uses Main;

{$R *.DFM}
{================================================}
procedure TDelayForm.FormCreate(Sender: TObject);
{================================================}
begin
   { Set capture time to edit and main form caption }
   Edit1.Text := IntToStr(MainForm.DelayTime);
   MainForm.Caption := 'Capture';
end;

{========================================================================}
procedure TDelayForm.FormClose(Sender: TObject; var Action: TCloseAction);
{========================================================================}
begin
   { if edit is not blank then get delay from edit, x 10 }
   if Edit1.Text <> '' then
      MainForm.DelayTime := (StrToInt(Edit1.Text)) * 10 else begin
         MainForm.DelayTime := 0;
         Edit1.Text := '0';
         MainForm.Caption := 'Capture';
      end;
end;

{=========================================================}
procedure TDelayForm.SpinButton1DownClick(Sender: TObject);
{=========================================================}
begin
   { if edit is not blank then get delay from edit, x 10 }
   if Edit1.Text <> '' then begin
      MainForm.DelayTime := StrToInt(Edit1.Text);
      Dec(MainForm.DelayTime);
      Edit1.Text := IntToStr(MainForm.DelayTime);
   end;
end;

{=======================================================}
procedure TDelayForm.SpinButton1UpClick(Sender: TObject);
{=======================================================}
begin
   { if edit is not blank then get delay from edit, x 10 }
   if Edit1.Text <> '' then begin
      MainForm.DelayTime := StrToInt(Edit1.Text);
      Inc(MainForm.DelayTime);
      Edit1.Text := IntToStr(MainForm.DelayTime);
   end;
end;

{================================================}
procedure TDelayForm.Edit1Change(Sender: TObject);
{================================================}
begin
   { if edit is not blank then set delay to 0-5, set edit, set delay x 10 }
   if Edit1.Text <> '' then begin
   if MainForm.DelayTime > 5 then MainForm.DelayTime := 5 else
      if MainForm.DelayTime < 0 then MainForm.DelayTime := 0;
         Edit1.Text := IntToStr(MainForm.DelayTime);
         MainForm.Caption := 'Capture Delay Time: ' +
            IntToStr(MainForm.DelayTime) + ' seconds';
   end;
end;

{================================================}
procedure TDelayForm.Button1Click(Sender: TObject);
{================================================}
begin
   { If ok clicked then reset MainForm.Caption }
   MainForm.Caption := 'Capture';
end;

{================================================}
procedure TDelayForm.Button2Click(Sender: TObject);
{================================================}
begin
   { If ok clicked then reset MainForm.Caption }
   MainForm.Caption := 'Capture';
end;

end.
