unit Unit1;

interface

uses Windows,
     BSplines,
     Messages,
     SysUtils,
     Classes,
     Graphics,
     Controls,
     Forms,
     Dialogs,
     StdCtrls;

type TMainForm = class(TForm)
                 Button1: TButton;
    Splines1: TSplines;
    Button2: TButton;
                 procedure Button1Click(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Button2Click(Sender: TObject);
                 private  { Private declarations }
                    procedure Draw;
                 public   { Public declarations }
              end;

var MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.Draw;
var BSpline : TBSpline;
    I : Integer;
begin
   {Wipe previous drawn splines from form}
   Canvas.Pen.Color:=clWhite;
   Canvas.Brush.Color:=clWhite;
   Canvas.Brush.Style:=bsSolid;
   Canvas.Rectangle(0,0,clientWidth,ClientHeight);

   {Then draw them all again.}
   for I:=1 to Splines1.Count do
   begin
      BSpline:=Splines1.Items[I-1];
      if BSpline<>nil then BSpline.Draw(Canvas);
   end;
end;{TMainForm.Draw}

procedure TMainForm.Button1Click(Sender: TObject);
var BSpline : TBSpline;
    Vertex  : TVertex;
    I       : integer;
begin
   BSpline:=TBSpline.Create;
   randomize;
   BSpline.Color:=Random(832873285425);
   for I:=1 to 2+Random(8) do
   begin
     Vertex.X:=Random(ClientWidth);
     Vertex.Y:=Random(ClientHeight);
     BSpline.AddPoint(Vertex);// Use the AddPoint method to add a point to the spline

     // For a point to be a knuckle-point remove comment lines

     if Random(3)>1 then BSpline.Knuckle[BSpline.NumberOfPoints]:=True;

   end;
   BSpline.Interpolated:=True; // Interpolate property can be true or false
   BSpline.Showvertices:=True; // Showvertices property enables the user to view the defined controlpoints
   BSpline.Fragments:=20+Random(100); // Set the number of straight line-segments for drawing the line
   Splines1.Addspline(BSpline);
   Draw;
end;

procedure TMainForm.FormPaint(Sender: TObject);
begin
   Draw;
end;

procedure TMainForm.FormResize(Sender: TObject);
begin
   Draw;
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
   Splines1.Clear;
   Draw;
end;

end.
 