unit Main;
(***********************************************)
(* The Game of Four Wins in a Box,             *)
(* including an intelligent Computer Player    *)
(************************************************)
(* Date:   22.05.2001                           *)
(* Author: Brian Schrder                       *)
(* eMail:  delphi@brian-schroeder.de            *)
(* www:    http://www.brian-schroeder.de        *)
(************************************************)
(* Description                                  *)
(* Use the Example Programm to understand the   *)
(* usage of the FourWins Component, or just play*)
(* and have fun (but i think the Computer is to *)
(* hard to play against)                        *)
(************************************************)
(* Legal Stuff                                  *)
(* The Code is provided as is, WITHOUT ANY      *)
(* WARRANTY OF ANY KIND.                        *)
(* Don't blame me in any case where the usage of*)
(* this code has done you harm.                 *)
(************************************************)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FourWinsControl, Menus, ComCtrls;

type
  TForm1 = class(TForm)
    FourWins: TFourWinsControl;
    MainMenu1: TMainMenu;
    Startz1: TMenuItem;
    StatusBar1: TStatusBar;
    procedure Startz1Click(Sender: TObject);
    procedure FourWinsGameEnds(Sender: TObject);
    procedure FourWinsProgress(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private-Deklarationen }
    Playing : Integer;
    procedure Idle(Sender: TObject; var Done: Boolean);
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Startz1Click(Sender: TObject);
begin
  FourWins.Reset;
  Playing := 1;
end;

procedure TForm1.FourWinsGameEnds(Sender: TObject);
begin
  ShowMessage('Spieler '+FourWins.Winner +' hat gewonnen');
end;

procedure TForm1.FourWinsProgress(Sender: TObject);
begin
  StatusBar1.Panels[2].Text := IntToStr(round(100*FourWins.PercentDone))+'% fertig';
  StatusBar1.Refresh;
end;

procedure TForm1.Idle(Sender: TObject; var Done: Boolean);
var t, t1 : TDateTime;

begin
  if Playing = 0 then begin
    if FourWins.Winner <> '' then FourWins.Reset;
    FourWins.ComputerMakeMove;
  end;
  Done := False;
  t1 := EncodeTime(0,0,2,0);
  t := now;
  while now-t<t1 do Application.ProcessMessages;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Playing := 0;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  Application.OnIdle := Idle;
end;

end.
