unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  BrowseDr, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    BrowseDirectoryDlg: TBrowseDirectoryDlg;
    Button2: TButton;
    Button1: TButton;
    Label1: TLabel;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure BrowseDirectoryDlgSelChanged(Sender: TObject; const NewSel: string);
    procedure BrowseDirectoryDlgCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  BrowseDirectoryDlg.Selection := ExtractFilePath(Application.EXEName);
  if BrowseDirectoryDlg.Execute then
    MessageDlg('You selected ' + BrowseDirectoryDlg.Selection, mtInformation, [mbOk], 0);
end;

procedure TForm1.BrowseDirectoryDlgSelChanged(Sender: TObject; const NewSel: string);
begin
  BrowseDirectoryDlg.StatusText := NewSel;
  // Disallow selection of paths less than 10 characters.
  BrowseDirectoryDlg.EnableOKButton := Length(NewSel) >= 10;
end;

procedure TForm1.BrowseDirectoryDlgCreate(Sender: TObject);
begin
  MessageDlg('BrowseDirectoryDlg has been created.', mtInformation, [mbOk], 0);
end;

end.
