unit Tiff;

interface

uses Windows, Graphics, extctrls;

type
	PDirEntry = ^TDirEntry;
	TDirEntry = record
  	_Tag    : Word;
    _Type   : Word;
    _Count  : LongInt;
    _Value  : LongInt;
	end;

  procedure WriteTiff( Filename : string; Bitmap : TBitmap );

var
    // TIFF File Header:
	TifHeader : array[0..7] of Byte = (
            $49, $49,                 // Intel byte order
            $2a, $00,                 // TIFF version (42)
            $08, $00, $00, $00 );     // Pointer to the first directory

  NoOfDirs : array[0..1] of Byte = ( $0F, $00 );	// Number of tags within the directory

	DirectoryCOL : array[0..14] of TDirEntry = (
    ( _Tag: $00FE; _Type: $0004; _Count: $00000001; _Value: $00000000 ),	// NewSubFile: Image with full solution (0)
    ( _Tag: $0100; _Type: $0003; _Count: $00000001; _Value: $00000000 ),  // ImageWidth:      Value will be set later
    ( _Tag: $0101; _Type: $0003; _Count: $00000001; _Value: $00000000 ),  // ImageLength:     Value will be set later
    ( _Tag: $0102; _Type: $0003; _Count: $00000001; _Value: $00000008 ),  // BitsPerSample:   8
    ( _Tag: $0103; _Type: $0003; _Count: $00000001; _Value: $00000001 ), 	// Compression:     No compression
    ( _Tag: $0106; _Type: $0003; _Count: $00000001; _Value: $00000003 ), 	// PhotometricInterpretation:
    ( _Tag: $0111; _Type: $0004; _Count: $00000001; _Value: $00000000 ),  // StripOffsets: Pointer to the adress of the image data
    ( _Tag: $0115; _Type: $0003; _Count: $00000001; _Value: $00000001 ),  // SamplesPerPixels: 1
    ( _Tag: $0116; _Type: $0004; _Count: $00000001; _Value: $00000000 ),  // RowsPerStrip: Value will be set later
    ( _Tag: $0117; _Type: $0004; _Count: $00000001; _Value: $00000000 ),  // StripByteCounts: xs*ys bytes pro strip
    ( _Tag: $011A; _Type: $0005; _Count: $00000001; _Value: $00000000 ),  // X-Resolution: Adresse
    ( _Tag: $011B; _Type: $0005; _Count: $00000001; _Value: $00000000 ),  // Y-Resolution: (Adresse)
    ( _Tag: $0128; _Type: $0003; _Count: $00000001; _Value: $00000002 ),  // Resolution Unit: (2)= Unit ZOLL
    ( _Tag: $0131; _Type: $0002; _Count: $0000000A; _Value: $00000000 ), 	// Software: Kruwo Soft
    ( _Tag: $0140; _Type: $0003; _Count: $00000300; _Value: $00000008 ) );// ColorMap: Color table startadress

	DirectoryRGB : array[0..14] of TDirEntry = (
    ( _Tag: $00FE; _Type: $0004; _Count: $00000001; _Value: $00000000 ), 	// NewSubFile:      Image with full solution (0)
    ( _Tag: $0100; _Type: $0003; _Count: $00000001; _Value: $00000000 ), 	// ImageWidth:      Value will be set later
    ( _Tag: $0101; _Type: $0003; _Count: $00000001; _Value: $00000000 ), 	// ImageLength:     Value will be set later
    ( _Tag: $0102; _Type: $0003; _Count: $00000003; _Value: $00000008 ), 	// BitsPerSample:   8
    ( _Tag: $0103; _Type: $0003; _Count: $00000001; _Value: $00000001 ), 	// Compression:     No compression
    ( _Tag: $0106; _Type: $0003; _Count: $00000001; _Value: $00000002 ), 	// PhotometricInterpretation:   0=black, 2 power BitsPerSample -1 =white
    ( _Tag: $0111; _Type: $0004; _Count: $00000001; _Value: $00000000 ), 	// StripOffsets: Pointer to the adress of the image data
    ( _Tag: $0115; _Type: $0003; _Count: $00000001; _Value: $00000003 ), 	// SamplesPerPixels: 3
    ( _Tag: $0116; _Type: $0004; _Count: $00000001; _Value: $00000000 ), 	// RowsPerStrip: Value will be set later
    ( _Tag: $0117; _Type: $0004; _Count: $00000001; _Value: $00000000 ),	// StripByteCounts: xs*ys bytes pro strip
    ( _Tag: $011A; _Type: $0005; _Count: $00000001; _Value: $00000000 ),	// X-Resolution: Adresse
    ( _Tag: $011B; _Type: $0005; _Count: $00000001; _Value: $00000000 ),	// Y-Resolution: (Adresse)
    ( _Tag: $011C; _Type: $0003; _Count: $00000001; _Value: $00000001 ),	// PlanarConfiguration: Pixel data will be stored continous
    ( _Tag: $0128; _Type: $0003; _Count: $00000001; _Value: $00000002 ),	// Resolution Unit: (2)= Unit ZOLL
    ( _Tag: $0131; _Type: $0002; _Count: $0000000A; _Value: $00000000 ));	// Software: Kruwo Soft

  NullString    : array[0..3] of Byte = ( $00, $00, $00, $00 );
  X_Res_Value   : array[0..7] of Byte = ( $6D,$03,$00,$00,  $0A,$00,$00,$00 );  // Value for X-Resolution: 87,7 Pixel/Zoll (SONY SCREEN)
  Y_Res_Value   : array[0..7] of Byte = ( $6D,$03,$00,$00,  $0A,$00,$00,$00 );  // Value for Y-Resolution: 87,7 Pixel/Zoll
  Software      : array[0..9] of Char = ( 'K', 'r', 'u', 'w', 'o', ' ', 's', 'o', 'f', 't');
  BitsPerSample : array[0..2] of Word = ( $0008, $0008, $0008 );


implementation

procedure WriteTiff( Filename : string; Bitmap : TBitmap );
var
	TIFfile      : FILE;
  BM           : HBitmap;
  Header, Bits : PChar;
  BitsPtr      : PChar;
  HeaderSize   : DWORD;
  BitsSize     : DWORD;
  Width, Height: Integer;
  DataWidth    : Integer;
  BitCount     : Integer;
  ColorMapRed  : array[0..255,0..1] of Byte;
  ColorMapGreen: array[0..255,0..1] of Byte;
  ColorMapBlue : array[0..255,0..1] of Byte;
  ColTabSize   : Integer;
  I            : Integer;
  Red, Blue    : Char;
  BmpWidth     : Integer;
  OffsetXRes     : LongInt;
  OffsetYRes     : LongInt;
  OffsetSoftware : LongInt;
  OffsetStrip    : LongInt;
  OffsetDir      : LongInt;
  OffsetBitsPerSample : LongInt;
Begin

	BM := Bitmap.Handle;
  if BM = 0 then exit;

  GetDIBSizes(BM, HeaderSize, BitsSize);
  GetMem(Header, HeaderSize + BitsSize);
  try
  	Bits := Header + HeaderSize;
    if GetDIB(BM, Bitmap.Palette, Header^, Bits^) then
    begin

				//
				// Read Image description
  	  	//
    	Width    := PBITMAPINFO(Header)^.bmiHeader.biWidth;
    	Height   := PBITMAPINFO(Header)^.bmiHeader.biHeight;
    	BitCount := PBITMAPINFO(Header)^.bmiHeader.biBitCount;
			DataWidth := Width;

      if BitCount = 1 then
      begin
		  	FreeMem(Header);
        exit;
			end;

			ColTabSize := (1 shl BitCount);
//			ColTabSize := 1;
//   		for I:=1 to BitCount do ColTabSize := ColTabSize * 2;

			BmpWidth := Trunc(BitsSize / Height);

				//
    		// Image with Color Table
        //================================
        //
      if BitCount in [2, 4, 8] then
      begin
       	DataWidth := Width;
	     	if BitCount in [2, 4] then
        begin
        		// If we have only 2 or 4 bit per pixel, we have to
            // truncate the size of the image to a byte boundary
          Width := (Width div BitCount) * BitCount;
          if BitCount = 2 then DataWidth := Width div 4;
          if BitCount = 4 then DataWidth := Width div 2;
				end;

	     	DirectoryCOL[1]._Value := LongInt(Width);  				// Image Width
  			DirectoryCOL[2]._Value := LongInt(abs(Height)); 	// Image Height
  			DirectoryCOL[3]._Value := LongInt(BitCount); 			// BitsPerSample
			  DirectoryCOL[8]._Value := LongInt(Height); 				// Image Height
			  DirectoryCOL[9]._Value := LongInt(BitsSize); 			// Strip Byte Counts

    		for I:=0 to ColTabSize-1 do
        begin
	        ColorMapRed  [I][1] := PBITMAPINFO(Header)^.bmiColors[I].rgbRed;
	        ColorMapRed  [I][0] := 0;
  	      ColorMapGreen[I][1] := PBITMAPINFO(Header)^.bmiColors[I].rgbGreen;
  	      ColorMapGreen[I][0] := 0;
    	    ColorMapBlue [I][1] := PBITMAPINFO(Header)^.bmiColors[I].rgbBlue;
    	    ColorMapBlue [I][0] := 0;
				end;

			  DirectoryCOL[14]._Count := LongInt(ColTabSize*3*2);
      end
      else
				//
    		// Image with RGB-Values
        //======================
        //
      begin
	     	DirectoryRGB[1]._Value := LongInt(Width);  			// Image Width
  			DirectoryRGB[2]._Value := LongInt(Height); 			// Image Height
			  DirectoryRGB[8]._Value := LongInt(Height); 			// Image Height
			  DirectoryRGB[9]._Value := LongInt(BitsSize); 		// Strip Byte Counts
      end;


		//
		// Write TIFF - File
		//

			AssignFile(TIFfile, FileName);
		  Rewrite(TIFfile, 1);

				//
    		// Write Image with Color Table
        //================================
        //
      if BitCount in [1, 2, 4, 8] then
      begin
				BlockWrite(TIFfile, TifHeader, 		 sizeof(TifHeader));
				BlockWrite(TIFfile, ColorMapRed, 	 ColTabSize*2);
				BlockWrite(TIFfile, ColorMapGreen, ColTabSize*2);
	    	BlockWrite(TIFfile, ColorMapBlue,  ColTabSize*2);

				OffsetXRes := FilePos(TIFfile);
				BlockWrite(TIFfile, X_Res_Value, 		sizeof(X_Res_Value));

				OffsetYRes := FilePos(TIFfile);
				BlockWrite(TIFfile, Y_Res_Value, 		sizeof(Y_Res_Value));

				OffsetSoftware := FilePos(TIFfile);
				BlockWrite(TIFfile, Software, 			sizeof(Software));

				OffsetStrip := FilePos(TIFfile);
        if Height < 0 then
        begin
	    		for I:=0 to Height-1 do
  	      begin
	          BitsPtr := Bits + I*BmpWidth;
  					BlockWrite(TIFfile, BitsPtr^, DataWidth);
          end;
				end
        else
        begin
	        	// Flip Image
	    		for I:=1 to Height do
  	      begin
	          BitsPtr := Bits + (Height-I)*BmpWidth;
  					BlockWrite(TIFfile, BitsPtr^, DataWidth);
          end;
        end;

					// Set Adresses into Directory
			  DirectoryCOL[ 6]._Value := OffsetStrip; 			// StripOffset
			  DirectoryCOL[10]._Value := OffsetXRes; 				// X-Resolution
			  DirectoryCOL[11]._Value := OffsetYRes; 				// Y-Resolution
			  DirectoryCOL[13]._Value := OffsetSoftware; 		// Software

					// Write Directory
				OffsetDir := FilePos(TIFfile);
				BlockWrite(TIFfile, NoOfDirs, 	    sizeof(NoOfDirs));
				BlockWrite(TIFfile, DirectoryCOL, 	sizeof(DirectoryCOL));
				BlockWrite(TIFfile, NullString, 		sizeof(NullString));

					// Update Start of Directory
        seek(TIFfile, 4);
				BlockWrite(TIFfile, OffsetDir, 		  sizeof(OffsetDir));
			end
			else
      begin
				//
    		// Write Image with RGB-Values
        //======================
        //
		    // Write Header
				BlockWrite(TIFfile, TifHeader, 		 sizeof(TifHeader));

				OffsetXRes := FilePos(TIFfile);
				BlockWrite(TIFfile, X_Res_Value, 		sizeof(X_Res_Value));

				OffsetYRes := FilePos(TIFfile);
				BlockWrite(TIFfile, Y_Res_Value, 		sizeof(Y_Res_Value));

				OffsetBitsPerSample := FilePos(TIFfile);
				BlockWrite(TIFfile, BitsPerSample,  sizeof(BitsPerSample));

				OffsetSoftware := FilePos(TIFfile);
				BlockWrite(TIFfile, Software, 			sizeof(Software));

				OffsetStrip := FilePos(TIFfile);

       		// Exchange Red and Blue Color-Bits
				BitsPtr := Bits;
    		for I:=0 to (Height*Width)-1 do
 	      begin
          Blue := (BitsPtr)^ ;
          Red  := (BitsPtr+2)^;
          (BitsPtr)^   := Red;
          (BitsPtr+2)^ := Blue;
          BitsPtr := BitsPtr + 3;
				end;

        if Height < 0 then
        begin
					BmpWidth := Trunc((BitsSize/3) / Height);
	    		for I:=0 to Height-1 do
  	      begin
	          BitsPtr := Bits + I*BmpWidth*3;
  					BlockWrite(TIFfile, BitsPtr^, Width*3);
          end;
				end
        else
        begin
	        	// Flip Image
					BmpWidth := Trunc((BitsSize/3) / Height);
	    		for I:=1 to Height do
  	      begin
	          BitsPtr := Bits + (Height-I)*BmpWidth*3;
  					BlockWrite(TIFfile, BitsPtr^, Width*3);
          end;
        end;

					// Set Adresses into Directory
			  DirectoryRGB[ 3]._Value := OffsetBitsPerSample;		// BitsPerSample
			  DirectoryRGB[ 6]._Value := OffsetStrip; 					// StripOffset
			  DirectoryRGB[10]._Value := OffsetXRes; 						// X-Resolution
			  DirectoryRGB[11]._Value := OffsetYRes; 						// Y-Resolution
			  DirectoryRGB[14]._Value := OffsetSoftware; 				// Software

					// Write Directory
				OffsetDir := FilePos(TIFfile);
				BlockWrite(TIFfile, NoOfDirs, 	  sizeof(NoOfDirs));
				BlockWrite(TIFfile, DirectoryRGB, sizeof(DirectoryRGB));
				BlockWrite(TIFfile, NullString, 	sizeof(NullString));

					// Update Start of Directory
        seek(TIFfile, 4);
				BlockWrite(TIFfile, OffsetDir, sizeof(OffsetDir));
      end;
  		CloseFile(TIFfile);
    end;
	finally
  	FreeMem(Header);
	end;
end;


end.
