
unit    LiteChk;

{   litechk.pas    TLiteCheckBox is an improved descendant of TCheckBox.

    Additional features:
    *   It automagically sizes itself to just fit the text.
    *   It protects and sets to appropriate defaults these properties:
        Alignment       taRightJustify
        Color           clBtnFace
        Ctl3D           TRUE
        Cursor          crDefault
        DragCursor      crDrag
        Height          Calculated from actual text height
        ParentColor     TRUE
        ParentCtl3D     TRUE
        ShowAccelChar   TRUE
        Width           Calculated from actual text width

    REVISION HISTORY

     2 Dec 1996 rdk Original version written

     END OF HISTORY
}

interface

uses    Forms, Menus, Controls, SysUtils, Classes, Graphics, StdCtrls;

type

    TLiteCheckBox = Class( TCustomCheckBox )
    private
    procedure           ResizeMe;

    protected

    public
    {   overridden public methods }
    procedure           Invalidate; override;
    procedure           Update; override;
    procedure           Repaint; override;

    constructor         Create( owner: TComponent ); override;
    destructor          Destroy; override;

    published

    { properties we will allow the user to use }
    property            AllowGrayed;
    property            Caption;
    property            Checked;
    property            Enabled;
    property            Font;
    property            HelpContext;
    property            Hint;
    property            Left;
    property            Name;
    property            ParentShowHint;
    property            PopupMenu;
    property            ShowHint;
    property            State;
    property            TabOrder;
    property            TabStop;
    property            Tag;
    property            Top;
    property            Visible;

    { we publish all events -- who are we to say ... }
    property            OnClick;
    property            OnDragDrop;
    property            OnDragOver;
    property            OnEndDrag;
    property            OnEnter;
    property            OnExit;
    property            OnKeyDown;
    property            OnKeyPress;
    property            OnKeyUp;
    property            OnMouseDown;
    property            OnMouseMove;
    property            OnMouseUp;
    end;


procedure Register;

implementation

uses    Dialogs, WinProcs, WinTypes, ExtCtrls;

var
    myCanvas:       TCanvas;

procedure Register;

{   VCL Registration function.
}

begin
    RegisterComponents( 'Midnight', [ TLiteCheckBox ] )
end;

destructor TLiteCheckBox.Destroy;
begin
    inherited Destroy
end;


procedure TLiteCheckBox.ResizeMe;
begin

    { compute height and width from Caption's actuals }

    if ( myCanvas = NIL ) then
    begin
        myCanvas := TCanvas.Create;
        myCanvas.Handle := GetDC( TWinControl( owner ).Handle )
    end;

    myCanvas.Font.Assign( Font );

    { allow sixteen pixels for the checkbox itself }
    Width := 16 + myCanvas.TextWidth( Caption );

    Height := myCanvas.TextHeight( Caption );
    if ( Height < 16 ) then     { allow space for the height of the checkbox }
        Height := 16
end;


procedure TLiteCheckBox.Invalidate;
begin
    ResizeMe;
{    MessageDlg( Format( '%s: Invalidate()', [ Name ] ), mtinformation,[mbok],0); }
     
    inherited Invalidate
end;


procedure TLiteCheckBox.Update;
begin
    ResizeMe;

    inherited Update
end;


procedure TLiteCheckBox.Repaint;
begin
    ResizeMe;

    inherited Repaint
end;


constructor TLiteCheckBox.Create( owner: TComponent );

{   Default VCL constructor
}

begin
    inherited Create( owner );

    { establish our default properties }

    Alignment := taRightJustify;
    Color := clBtnFace;
    Ctl3D := TRUE;
    Cursor := crDefault;
    DragCursor := crDrag;
    ParentColor := TRUE;
    ParentCtl3D := TRUE;
    ParentFont := TRUE;

    ResizeMe
end;

end.











