(****************************************************************************
   TBinView, Version 1.01 du 3 septembre 1999

   Composant destin  l'affichage (et dition) d'un entier (Byte, Word, etc)
   sous forme d'une suite de boutons.

   Auteur   : Pascal Peyremorte
   Contacts : p.peyremorte@free.fr
              http://p.peyremorte.free.fr
              http://www.vienneinfo.org/delphi/delphinautes.htm

   Merci de transmettre toute modification, bug ou amlioration

   Composant public et gratuit. Merci d'y laisser cet entte.
*****************************************************************************)
{ Utilisation, remarques :

  - BitWidth  est le nombre de bits affichs (8 par dfaut)
  - Bit0Place permet de placer le bit 0  gauche ou  droite ( droite par dfaut)
  - Bit0Car   est le caractre apparaissant sur le bouton 0. Les autres sont
              obtenus par incrementation ('0' par dfaut)
  - BlocDir   permet de placer la barre verticalement (horizontale par dfaut)

  - BorderV   est la bordure laisse  gauche et  droite (1 par dfaut)
  - BorderH   est la bordure laisse en haut et en bas    (1 par dfaut)
  - BtnSpace  est l'espace laiss entre deux boutons      (1 par dfaut)
  - Color     est la couleur de la bordure (celle du parent par dfaut)

  - Value     est la valeur binaire affiche. Aucun contrle de limites n'est fait.
              Par exemple, avec 8 bits affichs la valeur peut tre plus grande
              que 255, mais seuls les 8 bits de poids faible seront affichs.
}

{Historique :
  1.00  27/05/99  Premire version
  1.01  03/09/99  Correction bug chargement en position verticale}

unit BinView;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TBlocDir = (bdHorizontal, bdVertical);
  TBitPos  = (bpRight, bpLeft);
  TProcObj = procedure of object;

  TBinView = class(TCustomControl{GraphicControl})
  private { Dclarations prives }
    fValeur       : Integer;
    fBitMax       : Byte;

    fBordV        : Word;              {bordure verticale en pixels}
    fBordH        : Word;              {bordure horizontale en pixels}
    fIntervale    : Word;              {Espace entre poutons}
    fBlocDir      : TBlocDir;          {Direction du bloc}
    fBit0Pos      : TBitPos;           {Emplacement du Bit 0}
    fBit0Car      : Char;              {Caractre du bit 0}

    {Accs aux proprits}
    Function GetBitWidth:Byte;
    Procedure SetBitWidth(L:Byte);
    procedure SetBit0Car(Car:Char);
    procedure SetBit0Pos(Pos:TBitPos);
    procedure SetBlocDir(Dir:TBlocDir);
    procedure SetBordV(Taille:Word);
    procedure SetBordH(Taille:Word);
    procedure SetIntervale(Taille:Word);
    Procedure SetValeur(N:Integer);

    {Dessin du composant}
    Procedure Paint; Override; // Reaffichage de tout l'cran
    Procedure Loaded; Override;
  protected { Dclarations protges }
    Procedure MouseDown(Button:TMouseButton; Shift:TShiftState; X,Y:Integer); Override;
  public { Dclarations publiques }
    Constructor Create(AOwner:TComponent); Override;
  published { Dclarations publies }
    property Align;
    Property BitWidth: Byte read GetBitWidth write SetBitWidth default 8;
    property Bit0Car : Char read fBit0Car write SetBit0Car default '0';
    Property Bit0Place:TBitPos read fBit0Pos write SetBit0Pos default bpRight;
    property BlocDir :TBlocDir read fBlocDir write SetBlocDir default bdHorizontal;
    property BorderV : Word read fBordV write SetBordV default 1;
    property BorderH : Word read fBordH write SetBordH default 1;
    property BtnSpace: Word read fIntervale write SetIntervale default 1;
    Property Color;
    property DragMode;
    property DragCursor;
    property Enabled;
    property Font;
    property ParentColor;
    property ParentFont;
    property Visible;
    Property Value:Integer read fValeur write SetValeur default 0;

    property OnClick;
    property OnDblClick;
    property OnMouseMove;
    property OnMouseDown;
    property OnMouseUp;

    property OnStartDrag;
    property OnDragOver;
    property OnEndDrag;
    property OnDragDrop;
  end;

procedure Register;

(****************************************************************************)

implementation

Const
  EDGE:Array[Boolean] of Integer=(EDGE_RAISED,EDGE_SUNKEN);
  BORD=BF_RECT or BF_SOFT or BF_MIDDLE;

//--------------------------------------------------------------------------
// Routines utilitaires hors composant
//--------------------------------------------------------------------------

procedure Register;
begin
  RegisterComponents('Perso', [TBinView]);
end;


//----------------------------------------------------------------
//  Cration et destruction
//----------------------------------------------------------------

Constructor TBinView.Create(AOwner:TComponent);
Begin
  Inherited Create(AOwner);
  fValeur   := 0;
  fBitMax   := 7;
  fBordV    := 1;  // Petite bordure
  fBordH    := 1;
  fIntervale:= 1;  // Les boutons se touchent presque
  fBlocDir  := bdHorizontal;
  fBit0Pos  := bpRight;
  fBit0Car  :='0';
  SetBounds(Left,Top,120,21);
End;


//----------------------------------------------------------------
//  Dessin
//----------------------------------------------------------------

Procedure TBinView.Paint;
var
  W,H     : Integer;   {Largeur, Hauteur des boutons}
  PasH, PasV : Integer;{Pas entre les boutons}
  Residu  : Integer;   {Nombre de pixel  rpartir entre les boutons}
  I       : Integer;
  R       : TRect;
  Masque  : Integer;
  DC      : THandle;   {Pour viter appels multiples de getDC}
  BitName : Char;
  Etat    : Boolean;
Begin
  If fBlocDir = bdHorizontal then
  begin {Alignement horizontal}
    I := Width-fBordV*2-fBitMax*fIntervale;
    W := I div (fBitMax+1);
    H := Height-fBordH*2;
    PasH := W + fIntervale;
    PasV := 0;
  end
  else
  begin {Alignement vertical}
    W := Width-FBordV*2;
    I := Height-fBordH*2-fBitMax*fIntervale;
    H := I Div (fBitMax+1);
    PasH := 0;
    PasV := H + fIntervale;
  end;
  Residu := fBitMax+1 - (I mod (fBitMax+1));
  R.Top:=fBordH;
  R.Left:=fBordV;
  R.Bottom:=R.Top+H;
  R.Right:=R.Left+W;

  BitName:=fBit0Car;
  If fBit0Pos=bpRight then
  Begin
    Masque:=1 shl fBitmax;
    Inc(BitName, fBitMax);
  End
  else
    Masque:=1;

  Canvas.Brush.Color:=clBtnFace;
  Canvas.Brush.Style:=bsSolid;
  DC := Canvas.Handle; {Evite appels multiples}

  for I:=0 to fBitMax do
  Begin
    If I=Residu then
      If fBlocDir = bdHorizontal
        then Begin Inc(PasH); Inc(R.Right); End
        else Begin Inc(PasV); Inc(R.Bottom); End;
    Etat:=(Masque and fValeur)<>0;
    DrawEdge(DC, R, EDGE[Etat], BORD);
    If Etat then OffsetRect(R,1,1);
    DrawText(DC, @BitName, 1, R, DT_SINGLELINE or DT_CENTER or DT_VCENTER or DT_NOPREFIX);
    If Etat then OffsetRect(R,-1,-1);

    Inc(R.Top,PasV);
    Inc(R.Bottom,PasV);
    Inc(R.Left,PasH);
    Inc(R.Right,PasH);

    If fBit0Pos=bpRight then
    Begin
      asm shr  Masque,1 End;
      Dec(BitName);
    End
    else
    Begin
      asm shl  Masque,1 End;
      Inc(BitName);
    End;
  End;
End;

Procedure TBinView.Loaded;
Begin
  {Delphi a enregistr 'bounds' dans l'tat final}
  If fBlocDir=bdVertical then
    Setbounds(Left,Top,Height,Width);
End;

//----------------------------------------------------------------
//  Accs aux proprits
//----------------------------------------------------------------

Function TBinView.GetBitWidth:Byte;
Begin
  Result:=fBitMax+1;
End;

Procedure TBinView.SetBitWidth(L:Byte);
Begin
  If fBitMax=L-1 then Exit;
  fBitMax:=L-1;
  Invalidate;
End;

procedure TBinView.SetBit0Car(Car:Char);
Begin
  If fBit0Car=Car then Exit;
  fBit0Car:=Car;
  Invalidate;
End;

procedure TBinView.SetBit0Pos(Pos:TBitPos);
Begin
  If fBit0Pos=Pos then Exit;
  fBit0Pos:=Pos;
  Invalidate;
End;

procedure TBinView.SetBlocDir(Dir:TBlocDir);
Begin
  If fBlocDir=Dir then Exit;
  fBlocDir:=Dir;
  Setbounds(Left,Top,Height,Width);
  Invalidate;
End;
procedure TBinView.SetBordH(Taille:Word);
Begin
  If fBordH=Taille then Exit;
  fBordH:=Taille;
  Invalidate;
End;

procedure TBinView.SetBordV(Taille:Word);
Begin
  If fBordV=Taille then Exit;
  fBordV:=Taille;
  Invalidate;
End;

procedure TBinView.SetIntervale(Taille:Word);
Begin
  If fIntervale=Taille then Exit;
  fIntervale:=Taille;
  Invalidate;
End;

Procedure TBinView.SetValeur(N:Integer);
Begin
  if fValeur=N then Exit;
  fValeur:=N;
  Invalidate;
End;


//----------------------------------------------------------------
//  Traitement du click
//----------------------------------------------------------------

{Mthode sale en attendant que j'aie le courage de dterminer par calcul direct
 le numro du bouton enfonc.}

Procedure TBinView.MouseDown(Button:TMouseButton; Shift:TShiftState; X,Y:Integer);
Var
  W,H     : Integer;   {Largeur, Hauteur des boutons}
  PasH, PasV : Integer;{Pas entre les boutons}
  Residu  : Integer;   {Nombre de pixel  rpartir entre les boutons}
  I       : Integer;
  R       : TRect;
  Masque  : Integer;
  DC      : THandle;
  BitName : char;
  Etat    : Boolean;
Begin
  If (Button=mbLeft) then
  Begin
    If fBlocDir = bdHorizontal then
    begin {Alignement horizontal}
      I := Width-fBordV*2-fBitMax*fIntervale;
      W := I div (fBitMax+1);
      H := Height-fBordH*2;
      PasH := W + fIntervale;
      PasV := 0;
    end
    else
    begin {Alignement vertical}
      W := Width-FBordV*2;
      I := Height-fBordH*2-fBitMax*fIntervale;
      H := I Div (fBitMax+1);
      PasH := 0;
      PasV := H + fIntervale;
    end;
    Residu := fBitMax+1 - (I mod (fBitMax+1));
    R.Top:=fBordH;
    R.Left:=fBordV;
    R.Bottom:=R.Top+H;
    R.Right:=R.Left+W;

  BitName:=fBit0Car;
  If fBit0Pos=bpRight then
  Begin
    Masque:=1 shl fBitmax;
    Inc(BitName, fBitMax);
  End
  else
    Masque:=1;

    for I:=0 to fBitMax do
    Begin
      If I=Residu then
        If fBlocDir = bdHorizontal
          then Begin Inc(PasH); Inc(R.Right); End
          else Begin Inc(PasV); Inc(R.Bottom); End;

      If (X>=R.Left) and (X<=R.Right) and
         (Y>=R.Top) and (Y<=R.Bottom) then
      Begin
        fValeur:=fValeur xor Masque;
        Etat:= (Masque and fValeur)<>0;
        Canvas.Brush.Color:=clBtnFace;
        Canvas.Brush.Style:=bsSolid;
        DC:=Canvas.Handle;                       
        DrawEdge(DC, R, EDGE[Etat], BORD);
        If Etat Then
          OffSetRect(R,1,1);
        DrawText(DC, @BitName, 1, R, DT_SINGLELINE or DT_CENTER or DT_VCENTER or DT_NOPREFIX);
        Break;
      End;

      Inc(R.Top,PasV);
      Inc(R.Bottom,PasV);
      Inc(R.Left,PasH);
      Inc(R.Right,PasH);

      If fBit0Pos=bpRight then
      Begin
        asm shr  Masque,1 End;
        Dec(BitName);
      End
      else
      Begin
        asm shl  Masque,1 End;
        Inc(BitName);
      End;
    End;
  End; {btn Left}
  Inherited;
End;

end.
