(***********************************************************************
 Komponente fr den Verzeichnisdialog von Win95   (Freeware)

 Autor    : Matthias Zartmann
            Urbanstrae 4
            74172 Neckarsulm
            Deutschland

 Version  : 1.0  02.08.97
 Revision : 1.0  02.08.97

 nderungen:
 Datum      Name      Beschreibung


***********************************************************************)


unit BFFolder;

interface
uses Classes,OLE2,ShellApi,shlobj,sysutils,Windows,Dialogs;

type
  bff_Options = (bff_BrowseForComputer,bff_BrowseForPrinter,bff_DontGoBelowDomain,bff_ReturnFSAncestors,bff_ReturnOnlyFSDirs,bff_Statustext);
  bff_OptionsSet = set of bff_options;
  bff_RootClsid  = (Use_RootDir,bff_DESKTOP,bff_DESKTOPDIRECTORY,bff_DRIVES,bff_NETWORK,bff_PRINTERS,bff_PROGRAMS,bff_STARTMENU);
  bff_DNameType  = (bff_FORPARSING,bff_INFOLDER,bff_NORMAL);


  TBrowseFolder = Class(TComponent)
        private
          FRootClsid        :bff_RootClsid;
          FRootDir          :string;
          FTitle            :string;
          FBFF_Options      :BFF_OptionsSet;
          FOnINITIALIZED    :TNotifyEvent;
          FOnSelectItem     :TNotifyEvent;

          Desktop           : IShellFolder;                     //Desktop - Interface
          RootDirPid        : PItemIDList;                      //Pid from the RootDir
          bi                : TBrowseInfo ;
          folder            : array [0..MAX_PATH] of char;      //Selected Foulder
          SMalloc           : IMalloc;                          //SMalloc Interface
          cwstr_RootDir     : array[0..MAX_PATH] of TOLEChar;   //WideString from the Rootdir
        public
          BFF_Wnd       : HWND;                                 //CallBack Parameter mirro
          BFF_Msg       : UINT;
          BFF_lParam    : LPARAM;
          BFF_lpData    : LPARAM;
          SelectedPid   : PItemIDList;
          SelectedDir   : String;

          function  Execute:Boolean;

          procedure SetStatusText(text:String);
          procedure EnabledOK(status:Boolean);
          procedure SetSelection(Displayname:string);
          procedure SetSelectionPID(Pid:PItemIDList);

          function  GetDisplayName(Pid:PItemIDList;dnametype:bff_DNameType):string;

        Published
          property RootClsid    :bff_RootClsid  read FRootClsid     write FRootClsid;
          Property RootDir      :string         Read FRootDir       Write FRootDir;
          Property Title        :string         Read FTitle         Write FTitle;
          Property BFF_Options  :bff_OptionsSet Read FBFF_Options   Write FBFF_Options;
          Property OnInitialized:TNotifyEvent   Read FOnINITIALIZED Write fOnINITIALIZED;
          Property OnSelectItem :TNotifyEvent   Read FOnSelectItem  Write FOnSelectItem;
  end;

procedure Register;

function BFF_Callback(Wnd: HWND; uMsg: UINT; lParam,lpData: LPARAM): Integer stdcall;


implementation

procedure Register;
begin
  RegisterComponents('Win95', [TBrowseFolder]);
end;


(*------------------------------------------------------------------------
  Beschreibung:
               CallBack vom Dialog
  Parameter:
               Siehe SDK
------------------------------------------------------------------------*)
function BFF_Callback(Wnd: HWND; uMsg: UINT; lParam,lpData: LPARAM): Integer;
var
 BFF:TBrowseFolder;
begin
  if (uMsg=BFFM_INITIALIZED) or (uMsg=BFFM_SELCHANGED) then
  begin
    BFF := TBrowseFolder(lpData);             //Class Pointer from the Caller

    if bff = nil then exit;

    BFF.BFF_Wnd    := Wnd;                    //Transfer Parameter to the Class
    BFF.BFF_Msg    := uMsg;
    BFF.BFF_lParam := LPARAM;
    BFF.BFF_lpData := LPARAM;
  end;

  if uMsg=BFFM_INITIALIZED then              //Dialog Init
  begin
    if Assigned(BFF.OnINITIALIZED) then
       BFF.OnINITIALIZED(TObject(BFF));
  end;

  if uMsg=BFFM_SELCHANGED then               //Selection Change
  begin
    if Assigned(BFF.OnSelectItem) then
       BFF.OnSelectItem(TObject(BFF));
  end;


  Result :=0;
end;
(*------------------------------------------------------------------------
  Beschreibung:
               Zeigt den SystemDialog an um ein Verzeichnis zu whlen
  Parameter:

  Rckgabe:
           TRUE  = Verzeichnis wurde ausgewhlt
           False = Cancel wurde gedrckt
------------------------------------------------------------------------*)

function  TBrowseFolder.Execute:Boolean;
var
  Attribute    : Longint;
  dummy        : Longint;
  uoptions     : Longint;              //Options for the Dialog
  specialfolder:integer;
begin
  SHGetMalloc(SMalloc);               //Get the Malloc-Interface
  SHGetDesktopFolder(Desktop);        //Get the Desktop-Interface

  RootDirPid := nil;


  case FRootClsid of
       bff_DESKTOP           : specialfolder:=CSIDL_DESKTOP;
       bff_DESKTOPDIRECTORY  : specialfolder:=CSIDL_DESKTOPDIRECTORY;
       bff_DRIVES            : specialfolder:=CSIDL_DRIVES;
       bff_NETWORK           : specialfolder:=CSIDL_NETWORK;
       bff_PRINTERS          : specialfolder:=CSIDL_PRINTERS;
       bff_PROGRAMS          : specialfolder:=CSIDL_PROGRAMS;
       bff_STARTMENU         : specialfolder:=CSIDL_STARTMENU;
  end;

 //Start at a User Directory
 if (RootDir <> '') and (FRootClsid=Use_RootDir)  then
 begin
   //Make a Wide String
   MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED,PChar(Rootdir), -1,cwstr_RootDir, MAX_PATH);

   RootDirPid :=nil;
   //Get the Pid from the Dir
   if not SUCCEEDED( Desktop.ParseDisplayName(0,nil,cwstr_RootDir,dummy,RootDirPid,Attribute)) then
   begin
     showmessage('BFF:RootDir <'+Rootdir+'> not Found');
     Desktop.Release;
     SMalloc.Release;
     exit;
   end;
 end
 else
 begin
   if Not (FRootClsid=Use_RootDir) then
   begin
     if not SUCCEEDED(SHGetSpecialFolderLocation(0,specialfolder,RootDirPid)) then
     begin
       showmessage('BFF:SpecialFolder not Found');
       exit;
     end;
   end;

 end;

 uoptions :=0;


 //set Options for the Dialog
 if bff_BrowseForComputer in BFF_Options then uoptions := uoptions or BIF_BROWSEFORCOMPUTER;
 if bff_BrowseForPrinter  in BFF_Options then uoptions := uoptions or BIF_BROWSEFORPRINTER;
 if bff_DontGoBelowDomain in BFF_Options then uoptions := uoptions or BIF_DONTGOBELOWDOMAIN;
 if bff_ReturnFSAncestors in BFF_Options then uoptions := uoptions or BIF_RETURNFSANCESTORS;
 if bff_ReturnOnlyFSDirs  in BFF_Options then uoptions := uoptions or BIF_RETURNONLYFSDIRS;
 if bff_Statustext        in BFF_Options then uoptions := uoptions or BIF_STATUSTEXT;

 try
   //Fill the Struct
   bi.hwndOwner := 0;
   bi.pidlRoot  := RootDirPid;
   bi.pszDisplayName := folder;
   bi.lpszTitle := PChar(Title);
   bi.ulFlags   := uoptions;
   bi.lpfn      := @BFF_Callback;
   bi.lParam    := LongInt(self);
   // Browse for a folder and return its PIDL.
   SelectedPid := SHBrowseForFolder(bi);

   if nil = SelectedPid then
     result:=False     //Cancel Pressed
   else
   begin
     result      :=True;
     SelectedDir :=GetDisplayName(SelectedPid,bff_FORPARSING);
   end;

 finally
   //Free the Resource
   if (RootDir <> '') and (FRootClsid=Use_RootDir)then
   begin
     SMalloc.Free(RootDirPid);
   end;

   Desktop.Release;
   SMalloc.Release;

 end;
end;

(*------------------------------------------------------------------------
  Beschreibung:
               Setzt den Statustext im Dialog
  Parameter:
               Text = Statustext
------------------------------------------------------------------------*)
procedure TBrowseFolder.SetStatusText(text:String);
begin
  SendMessage(BFF_Wnd,BFFM_SETSTATUSTEXT,0,LongInt(Pchar(text)));
end;

(*------------------------------------------------------------------------
  Beschreibung:
               OK Button ein/ausschalten
  Parameter:
               Status = TRUE  OK Button eingeschaltet
               Status = FALSE OK Button ausgeschaltet
------------------------------------------------------------------------*)
procedure TBrowseFolder.EnabledOK(status:Boolean);
begin
  SendMessage(BFF_Wnd,BFFM_ENABLEOK,0,Longint(status));
end;

(*------------------------------------------------------------------------
  Beschreibung:
               Selektiert einen Eintrag in dem Baum nach einen Pfad
  Parameter:
               Displayname= Pfad zu einem Verzeichnis das zu selektieren ist
------------------------------------------------------------------------*)
procedure TBrowseFolder.SetSelection(Displayname:string);
var
 Pid       : PItemIDList;
 cwstr_Dir : array[0..MAX_PATH] of TOLEChar;
 Attribute    : Longint;
 dummy        : Longint;

begin
  //Get the Pid for the Displayname
  MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED,PChar(Displayname), -1,cwstr_Dir, MAX_PATH);

  if not SUCCEEDED( Desktop.ParseDisplayName(0,nil,cwstr_Dir,dummy,Pid,Attribute)) then
  begin
    showmessage('Dir <'+Displayname+'> not Found');
    Desktop.Release;
    SMalloc.Release;
    exit;
  end
  else
    SetSelectionPID(Pid);
end;

(*------------------------------------------------------------------------
  Beschreibung:
               Selektiert einen Eintrag in dem Baum
  Parameter:
               Pid = Pid von dem Eintrag der zu selektieren ist
------------------------------------------------------------------------*)
procedure TBrowseFolder.SetSelectionPID(Pid:PItemIDList);
begin
  SendMessage(BFF_Wnd,BFFM_SETSELECTION,0,Longint(Pid));
end;
(*------------------------------------------------------------------------
  Beschreibung:
               Ermittelt den Anzeigetext von einem Pid
  Parameter:
               Pid = Pid
  Rckgabe :   Azeigetext zu dem Pid
------------------------------------------------------------------------*)
function  TBrowseFolder.GetDisplayName(Pid:PItemIDList;dnametype:bff_DNameType):string;
var
  dname  : TStrRet;
  dnamet : Integer;
begin
  case dnametype of
      bff_FORPARSING: dnamet := SHGDN_FORPARSING;
      bff_INFOLDER:   dnamet := SHGDN_INFOLDER;
      bff_NORMAL:     dnamet := SHGDN_NORMAL;
  else            dnamet := SHGDN_NORMAL;

  end;

  if SUCCEEDED( Desktop.GetDisplayNameOf(Pid,dnamet,dName)) then
  begin
    case dname.uType of
      STRRET_WSTR:
        begin
          // Make sure enough mem is available initially.
          SetLength(Result, MAX_PATH+1);
          // This resets the length and copies the string into Name
          SetLength(Result, WideCharToMultiByte(CP_ACP, 0, dName.pOleStr, -1,pChar(result), MAX_PATH, NIL, NIL));
        end;
      STRRET_OFFSET: result := StrPas(PChar(Longint(Pid) + dName.uOffset));
      STRRET_CSTR:   result := StrPas(dName.cStr);
    end;
  end
  else
    result := '';
end;
end.
