unit BFFExam;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,DB,BFFolder,shlobj;

type
  TBrowseForFolder = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure BrowseFolderSelectItem(Sender: TObject);
    procedure BrowseFolderInitialized(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  BrowseForFolder: TBrowseForFolder;

implementation

{$R *.DFM}

procedure TBrowseForFolder.Button1Click(Sender: TObject);
var
  BrowseFolder: TBrowseFolder;
begin
  BrowseFolder:= TBrowseFolder.Create(self);
  try
    BrowseFolder.BFF_Options := [bff_ReturnOnlyFSDirs,bff_Statustext];
    BrowseFolder.RootCLSID   := bff_DESKTOP;
    BrowseFolder.Title       := 'Test Dialog for BrowseForFolder';
    BrowseFolder.OnInitialized := BrowseFolderInitialized;
    BrowseFolder.OnSelectItem:=BrowseFolderSelectItem;

    //Show the Dialog
    if BrowseFolder.Execute then
    begin
      //Show the selected Dir
      edit1.text := BrowseFolder.SelectedDir
    end
    else
      edit1.text := 'You press Cancel';
  finally
    BrowseFolder.Free;
  end;
end;

procedure TBrowseForFolder.BrowseFolderSelectItem(Sender: TObject);
var
 name:string;
begin
  //Callback from the Dialog when you select a Item

  //Get the Name of the Item
  name := TBrowseFolder(sender).GetDisplayName(PItemIDList(TBrowseFolder(sender).BFF_lParam),bff_FORPARSING);
  //Set the Statusline
  TBrowseFolder(sender).SetStatusText('You select <'+name+'>');
  if name = '' then
    TBrowseFolder(sender).EnabledOK(FALSE)        //Disable the Button
  else
    TBrowseFolder(sender).EnabledOK(TRUE);        //Enabled the Button
end;

procedure TBrowseForFolder.BrowseFolderInitialized(Sender: TObject);
begin
    //Callback from the Dialog on Initialzed Time
    TBrowseFolder(sender).SetSelection('C:\temp');   //Select at Popup the Directory 'C:\temp'
end;

end.
