unit Uprinc;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ComCtrls, ToolWin, StdCtrls, IniFiles;

type
  TOnglet = Class (TStringList)
    constructor Create (N : String);
    constructor Lis (S : TStringList);
    procedure renomme (N : String);
    procedure peuple (M : TCustomMemo);
    procedure AJour (M : TCustomMemo);
  public
    Nom : String;
  end;

  TTexte = Class (TStringList)
    constructor Create;
    constructor Lis (F : String);
    destructor Destroy; override;
    procedure ecris (F : String);
    procedure RenommeOnglet (index : integer ; N : String);
  private
    Onglets : TStringList;
    function GetOnglet(index: integer): TOnglet;
    procedure SetOnglet(index: integer; const Value: TOnglet);
  public
    modifie : boolean;
    property Onglet [index : integer] : TOnglet read GetOnglet write SetOnglet;
  end;


  TForm1 = class(TForm)
    TabControl: TTabControl;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    MainMenu1: TMainMenu;
    Fichier1: TMenuItem;
    Nouveau2: TMenuItem;
    Ouvrir1: TMenuItem;
    enregistrerSous2: TMenuItem;
    N2: TMenuItem;
    Quitter2: TMenuItem;
    Sauver1: TMenuItem;
    Onglets1: TMenuItem;
    Ajouter2: TMenuItem;
    Supprimer2: TMenuItem;
    Renommer1: TMenuItem;
    dplacergauche1: TMenuItem;
    dplacerdroite1: TMenuItem;
    Aide1: TMenuItem;
    Index2: TMenuItem;
    Auteur2: TMenuItem;
    Memo: TMemo;
    prcdent1: TMenuItem;
    suivant1: TMenuItem;
    N1: TMenuItem;
    procedure Quitter1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TabControlChange(Sender: TObject);
    procedure Nouveau1Click(Sender: TObject);
    procedure Titre1Click(Sender: TObject);
    procedure Enregistrer1Click(Sender: TObject);
    procedure EnregistrerSous1Click(Sender: TObject);
    procedure Supprimer1Click(Sender: TObject);
    procedure Ajouter1Click(Sender: TObject);
    procedure gauche1Click(Sender: TObject);
    procedure droite1Click(Sender: TObject);
    procedure Index1Click(Sender: TObject);
    procedure Auteur1Click(Sender: TObject);
    procedure TabControlChanging(Sender: TObject;
      var AllowChange: Boolean);
    procedure prcdent1Click(Sender: TObject);
    procedure suivant1Click(Sender: TObject);
    procedure Ouvrir1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure MemoChange(Sender: TObject);
  private
    { Dclarations prives }
    Fichier : String;
    Texte : TTexte;
    IniFile : TIniFile;
    ModifieTemp : Boolean;
    function GetOnglet: TOnglet;
    function GetTabIndex: integer;
    procedure SetTabIndex(const Value: integer);
    procedure AfficheCaption;
    procedure OuvreIni;
    procedure FermeIni;
    procedure EcritIni;
    procedure OuvreFichier;
    procedure AssigneOnglets;
    function Precaution : word;
  public
    { Dclarations publiques }
    property OngletActif : TOnglet read GetOnglet;
    property TabIndex : integer read GetTabIndex write SetTabIndex;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

const
  NomParDefaut = 'SineNomine.txt';
  Balise = '<Onglet>';

procedure TForm1.Quitter1Click(Sender: TObject);
begin
  Close;
end;

{ TOnglet }

procedure TOnglet.AJour(M: TCustomMemo);
begin
  Text := M.Text;
end;

constructor TOnglet.Create(N : String);
begin
  inherited Create;
  Nom := N;
end;

constructor TOnglet.Lis(S: TStringList);
begin
  inherited Create;
  if (S.count > 0) and (pos (balise, S[0]) > 0) then
      begin
        Nom := copy( S[0], length (balise) + 1, length(S[0]));
        S.Delete (0);
      end
      else Nom := '';
    while (S.Count > 0) and (pos(balise, S[0]) < 1) do
      begin
        Add(S[0]);
        S.Delete (0);
      end;
end;

procedure TOnglet.peuple(M: TCustomMemo);
begin
  M.Lines := Self;
end;

procedure TOnglet.renomme(N: String);
begin
  Nom := N;
end;

{ TTexte }

constructor TTexte.Create;
begin
  inherited Create;
  Onglets := TStringList.Create;
  Onglets.AddObject('1', TOnglet.Create('1.'));
  Modifie := false;
end;

destructor TTexte.Destroy;
begin
  Onglets.Free;
  inherited Destroy;
end;

procedure TTexte.ecris(F: String);
  var T : TStringList;
      i : integer;
begin
  T := TStringList.Create;
  for i := 0 to Onglets.Count - 1 do
    begin
      if Onglet[i].Nom > ''
        then T.Add (balise + Onglet[i].nom);
      T.AddStrings(Onglet[i]);
    end;
  T.SaveToFile(F);
  T.Free;
end;

function TTexte.GetOnglet(index: integer): TOnglet;
begin
  if index < Onglets.Count
    then Result := TOnglet (Onglets.Objects[index])
    else Result := nil;
end;

constructor TTexte.Lis(F: String);
  var T : TStringList;
      O : TOnglet;
begin
  inherited Create;
  T := TStringList.Create;
  T.LoadFromFile (F);
  Onglets := TStringList.Create;
  while T.Count > 0 do
    begin
      O := TOnglet.Lis (T);
      Onglets.AddObject (O.Nom, O);
    end;
  T.Free;
  Modifie := False;
end;

procedure TTexte.RenommeOnglet(index: integer ; N : string);
begin
  Onglet[index].Renomme(N);
  Onglets[index] := N;
end;

procedure TTexte.SetOnglet(index: integer; const Value: TOnglet);
begin
  if index < Onglets.count then
    Begin
      Onglets[index] := Value.Nom;
      Onglets.Objects[index] := Value;
    end;
end;

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
  Memo.Clear;
  Memo.Align := alClient;
  TabControl.Align := alClient;

  Texte := TTexte.Create;
  if FileExists (ChangeFileExt(Paramstr(0), '.ini')) then
    begin
      OuvreIni;
      OpenDialog.InitialDir :=
        IniFile.ReadString('Rpertoire', 'nom',
          ExtractFilePath (Paramstr(0)));
      Fichier :=
        IniFile.ReadString('Fichiers', '0', NomParDefaut);
      FermeIni;
      if (Fichier <> NomParDefaut) and FileExists(Fichier)
        then OuvreFichier
        else Nouveau1Click(nil);
    end
    else Index1Click (nil);
  Texte.Modifie := false;
end;

procedure TForm1.TabControlChange(Sender: TObject);
begin
  OngletActif.peuple (Memo);
  Memo.SetFocus;
  Texte.Modifie := ModifieTemp;
end;

procedure TForm1.Nouveau1Click(Sender: TObject);
begin
  // prcaution
  if Precaution = mrCancel then exit;
  
  TabControl.Tabs.Clear;
  Memo.Clear;
  Texte.Free;
  Texte := TTexte.Create;
  Fichier := NomParDefaut;
  AfficheCaption;
  AssigneOnglets;
end;

procedure TForm1.Titre1Click(Sender: TObject);
  var T : string;
begin
  T := InputBox( 'Titre de l''onglet', 'titre', OngletActif.Nom);
  if Trim(T) > '' then
    begin
      Texte.RenommeOnglet(TabIndex, T);
      AssigneOnglets;
    end;
end;

procedure TForm1.Enregistrer1Click(Sender: TObject);
begin
  Texte.Onglet[TabIndex].Ajour(Memo);
  if (Fichier = NomParDefaut)
    then EnregistrerSous1Click(nil)
    else
      try
        Texte.Ecris (Fichier);
        except
        Memo.Lines.SaveToFile(Fichier);
        end;
  Texte.Modifie := False;
end;

procedure TForm1.EnregistrerSous1Click(Sender: TObject);
begin
  with SaveDialog do
      begin
        InitialDir := ExtractFilePath (Paramstr(0));
        if Execute Then
          begin
            Fichier := FileName;
            Try
              Texte.Ecris (Fichier);
              except
                Memo.Lines.SaveToFile(Fichier);
              end;
            InitialDir := ExtractFilePath(FileName);
            OpenDialog.InitialDir := InitialDir;
            EcritIni;
          end;
        AfficheCaption;
        Texte.Modifie := False;
      end;
end;

procedure TForm1.Supprimer1Click(Sender: TObject);
begin
  // supprimer onglet
  if (TabIndex >= 0) and
     ( MessageDlg('Supprimer l''onglet '+ OngletActif.Nom,
     mtConfirmation, [mbYes, mbNo], 0) = mrYes ) then
    begin
      Texte.Onglets.Delete (TabIndex);
      TabControl.Tabs := Texte.Onglets;
      Texte.Modifie := true;
    end;
end;

procedure TForm1.Ajouter1Click(Sender: TObject);
  var N : string;
begin
  // ajouter onglet
  N := IntToStr(succ(TabControl.Tabs.count));
  If InputQuery ('Nouvel onglet', 'titre', N) then
    begin
      OngletActif.AJour(Memo);
      if TabIndex < TabControl.Tabs.Count - 1
        then Texte.Onglets.InsertObject(
          succ(TabIndex), N, TOnglet.Create(N))
        else Texte.Onglets.AddObject(N, TOnglet.Create(N));
      AssigneOnglets;
      TabIndex := TabControl.Tabs.IndexOf(N);
      TabControlChange(nil);
      Texte.Modifie := true;
    end;
end;

procedure TForm1.gauche1Click(Sender: TObject);
begin
  // dplacer l'onglet  gauche
  if TabIndex > 0 then
    begin
      Texte.Onglets.Move(TabIndex, pred(TabIndex));
      TabControl.Tabs.Move(TabIndex, pred(TabIndex));
    end;
end;

procedure TForm1.droite1Click(Sender: TObject);
begin
  // dplacer l'onglet  droite
   if TabIndex < TabControl.Tabs.Count - 1 then
    begin
      Texte.Onglets.Move(TabIndex, succ(TabIndex));
      TabControl.Tabs.Move(TabIndex, succ(TabIndex));
    end;
end;

procedure TForm1.Index1Click(Sender: TObject);
  var F : String;
begin
 if Precaution = mrCancel then exit;
  // charger le fichier d'aide
  F := ChangeFileExt(Paramstr(0), '.txt');
  if FileExists(F) then
    begin
      Fichier := F;
      OuvreFichier;
    end
    else ShowMessage ('le Fichier ' + F + 'manque.');
 Texte.Modifie := false;
end;

procedure TForm1.Auteur1Click(Sender: TObject);
begin
  ShowMessage ('Yves Ouvrard'#13#10'avril MM'#13#10'y.ouvrard@collatinus.com');
end;

function TForm1.GetOnglet: TOnglet;
begin
  // renvoie l'onglet actif
  result := Texte.Onglet[TabIndex];
end;

procedure TForm1.TabControlChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
  ModifieTemp := Texte.Modifie;
  OngletActif.AJour(Memo);
end;

function TForm1.GetTabIndex: integer;
begin
  Result := TabControl.TabIndex;
end;

procedure TForm1.SetTabIndex(const Value: integer);
begin
  TabControl.TabIndex := Value;
end;

procedure TForm1.prcdent1Click(Sender: TObject);
begin
  OngletActif.AJour(Memo);
  if TabIndex > 0
    then TabIndex := Pred(TabIndex);
  TabControlChange (nil);
end;

procedure TForm1.suivant1Click(Sender: TObject);
begin
  OngletActif.AJour(Memo);
  if TabIndex < TabControl.Tabs.count - 1
    then TabIndex := succ (TabIndex);
  TabControlChange (nil);
end;

procedure TForm1.Ouvrir1Click(Sender: TObject);
begin
 // ouvre un fichier;
 if Precaution = mrCancel then exit;
  with OpenDialog  do
    if Execute then
      begin
        // dialogue de prcaution
        Fichier := FileName;
        OuvreFichier;
        EcritIni;
      end;
  Texte.modifie := false;
end;

procedure TForm1.AfficheCaption;
begin
  Caption := Application.Title + ' - ' + Fichier;
end;

procedure TForm1.FermeIni;
begin
  IniFile.Free;
end;

procedure TForm1.OuvreIni;
begin
  IniFile := TIniFile.Create (
    ChangeFileExt (Paramstr(0), '.ini'));
end;

procedure TForm1.OuvreFichier;
begin
  Texte.Free;
  Texte := TTexte.Lis (Fichier);
  if Texte.Onglets.Count > 0 then
    begin
      AssigneOnglets;
      Memo.Lines := Texte.Onglet[0];
    end
    else Memo.Lines.LoadFromFile(Fichier);
  AfficheCaption;
end;

procedure TForm1.EcritIni;
begin
OuvreIni;
IniFile.WriteString (
  'Rpertoire', 'nom', ExtractFilePath(Fichier));
IniFile.WriteString ('Fichiers', '0', Fichier);
FermeIni;
end;

procedure TForm1.AssigneOnglets;
begin
  TabControl.Tabs.Assign(Texte.Onglets);
end;

function TForm1.Precaution: word;
begin
  if not (Texte.Modifie) then
    Result := mrNo
    else
    begin
      Result := MessageDlg('Le fichier ' + Fichier +
        'a t modifi. Enregistrer ?',
        mtWarning, [mbYes, mbNo, mbCancel], 0);
      if Result = mrYes
        then Enregistrer1Click(nil);
    end;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := not Texte.Modifie
    or (Texte.Modifie and (Precaution <> mrCancel));
end;

procedure TForm1.MemoChange(Sender: TObject);
begin
  Texte.Modifie := True;
end;

end.
