unit WinInfo;
{ WinInfo 1.0 (Freeware)

  (c) Copyright 1999 by Blent BiNiCi
  E-Mail : bulent@ada.net.tr
}

{$F+}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls, Forms,
  Dialogs,Registry,DsgnIntf;

const
  DBRoot = HKEY_LOCAL_MACHINE;
  NBNAMESIZE    = 16;
  MAXLANAS      = 254;
  NCB_ASYNC     = $80;
  NCB_CALL      = $10;
  NCB_LISTEN    = $11;
  NCB_HANGUP    = $12;
  NCB_SEND      = $14;
  NCB_RECV      = $15;
  NCB_RECVANY   = $16;
  NCB_CHAINSEND = $17;
  NCB_DGSEND    = $20;
  NCB_DGRECV    = $21;
  NCB_DGSENDBC  = $22;
  NCB_DGREVCBC  = $23;
  NCB_ADDNAME   = $30;
  NCB_DELNAME   = $31;
  NCB_RESET     = $32;
  NCB_ADPSTAT   = $33;
  NCB_SSTAT     = $34;
  NCB_CANCEL    = $35;
  NCB_ADDGRPNAME= $36;
  NCB_ENUM      = $37;
  NCB_UNLINK    = $70;
  NCB_SENDNA    = $71;
  NCB_CHAINSENDNA=$72;
  NCB_LANSTALERT= $73;
  NCB_ACTION    = $77;
  NCB_FINDNAME  = $78;
  NCB_TRACE     = $79;
  NRC_GOODRET     = $00;
  NRC_BUFLEN      = $01;
  NRC_ILLCMD      = $03;
  NRC_CMDTMO      = $05;
  NRC_INCOMP      = $06;
  NRC_BADDR       = $07;
  NRC_SNUMOUT     = $08;
  NRC_NORES       = $09;
  NRC_SCLOSED     = $0a;
  NRC_CMDCAN      = $0b;
  NRC_DUPNAME     = $0d;
  NRC_NAMTFUL     = $0e;
  NRC_ACTSES      = $0f;
  NRC_LOCTFUL     = $11;
  NRC_REMTFUL     = $12;
  NRC_ILLNN       = $13;
  NRC_NOCALL      = $14;
  NRC_NOWILD      = $15;
  NRC_INUSE       = $16;
  NRC_NAMERR      = $17;
  NRC_SABORT      = $18;
  NRC_NAMCONF     = $19;
  NRC_IFBUSY      = $21;
  NRC_TOOMANY     = $22;
  NRC_BRIDGE      = $23;
  NRC_CANOCCR     = $24;
  NRC_CANCEL      = $26;
  NRC_DUPENV      = $30;
  NRC_ENVNOTDEF   = $34;
  NRC_OSRESNOTAV  = $35;
  NRC_MAXAPPS     = $36;
  NRC_NOSAPS      = $37;
  NRC_NORESOURCES = $38;
  NRC_INVADDRESS  = $39;
  NRC_INVDDID     = $3B;
  NRC_LOCKFAIL    = $3C;
  NRC_OPENERR     = $3f;
  NRC_SYSTEM      = $40;
  NRC_PENDING     = $ff;
  ALL_TRANSPORTS = 'M'#$00#$00#$00;
  MS_NBF         = 'MNBF';
  NAME_FLAGS_MASK = $87;
  GROUP_NAME      = $80;
  UNIQUE_NAME     = $00;

  REGISTERING     = $00;
  REGISTERED      = $04;
  DEREGISTERED    = $05;
  DUPLICATE       = $06;
  DUPLICATE_DEREG = $07;

  LISTEN_OUTSTANDING      = $01;
  CALL_PENDING            = $02;
  SESSION_ESTABLISHED     = $03;
  HANGUP_PENDING          = $04;
  HANGUP_COMPLETE         = $05;
  SESSION_ABORTED         = $06;

type
  TNBName = array[0..(NBNAMESIZE - 1)] of byte;
  TMacAddress = array[0..5] of byte;
  PNCB = ^TNCB;

 {$IFDEF WIN32}
  TNCBPostProc = procedure(P: PNCB);
 {$ENDIF}

  TNCB = packed record
    Command:  byte;
    RetCode:  byte;
    LSN:      byte;
    Num:      byte;
    Buf:      ^byte;
    Length:   word;
    CallName: TNBName;
    Name:     TNBName;
    RTO:      byte;
    STO:      byte;
  {$IFNDEF WIN32}
    Post_Offs:word;
    Post_Seg: word;
  {$ELSE}
    PostPrc:  TNCBPostProc;
  {$ENDIF}
    Lana_Num: byte;
    Cmd_Cplt: byte;
  {$IFDEF WIN32}
    Reserved: array[0..9] of byte;
    Event:    THandle;

  {$ELSE}
    Reserved: array[0..13] of byte;
  {$ENDIF}
  end;

  PNameInfo = ^TNameInfo;
  TNameInfo = packed record
    Name:   TNBName;
    NameNum:byte;
    NameSt: byte;
  end;

  PAdpStat = ^TAdpStat;
  TAdpStat = packed record
    ID:       TMacAddress;
    VMajor:   byte;
    Resvd0:   byte;
    AdpType:  byte;
    VMinor:   byte;
    RptTime:  word;
    RcvCRC:   word;
    RcvOth:   word;
    TxmCol:   word;
    TxmOth:   word;
    TxmOK:    LongInt;
    RcvOK:    LongInt;
    TxmRetr:  word;
    NoRcvBuf: word;
    T1_tmo:   word;
    Ti_tmo:   word;
    Resvd1:   LongInt;
    Free_Ncbs:word;
    Cfg_Ncbs: word;
    max_Ncbs: word;
    NoTxmBuf: word;
    MaxDGSize:word;
    Pend_Ses: word;
    Cfg_Ses:  word;
    Max_Ses:  word;
    Max_SPSz: word;
    nNames:   word;
    Names:    array[0..15] of TnameInfo;
  end;

  PSession_Header = ^TSession_Header;
  TSession_Header = packed record
    sess_name:            byte;
    num_sess:             byte;
    rcv_dg_outstanding:   byte;
    rcv_any_outstanding:  byte;
  end;

  PSession_Buffer = ^TSession_Buffer;
  TSession_Buffer = packed record
    lsn:                  byte;
    state:                byte;
    local_name:           TNBName;
    remote_name:          TNBName;
    rcvs_outstanding:     byte;
    sends_outstanding:    byte;
  end;

  PLana_Enum = ^TLana_Enum;
  TLANA_ENUM = packed record
    length:   byte;
    lana:     array[0..(MAXLANAS - 1)] of byte;
  end;

  PFind_Name_Header = ^TFind_Name_Header;
  TFind_Name_Header = packed record
    node_count:    word;
    reserved:      byte;
    unique_group:  byte;
  end;

  PFind_Name_Buffer = ^TFind_Name_Buffer;
  TFind_Name_Buffer = packed record
    length:          byte;
    access_control:  byte;
    frame_control:   byte;
    destination_addr:TMacAddress;
    source_addr:     TMacAddress;
    routing_info:    array[0..17] of byte;
  end;

  PAction_Header = ^TAction_Header;
  TAction_Header = packed record
    transport_id: LongInt;
    action_code:  Word;
    reserved:     Word;
  end;
  TAbout = class(TPropertyEditor)
  public
        procedure Edit; override;
        function GetAttributes: TPropertyAttributes; override;
        function GetValue: string; override;
  end;
  TWinInfo = class(TComponent)

  private
    FAbout: TAbout;
    FMacAdress,FBiosName,FBiosVer,FBiosDate : string;
    FWorkgroup,FComputerName,FComment,FProductId,FProductKey : string;
    FRegisteredOwner,FRegisteredOrganization,FSystemRoot : string;
    FProgramFilesDir,FBootCount,FCommonFilesDir,FConfigPath : string;
    FDevicePath,FMediaPath,FOtherDevicePath,FPF_AccessoriesName : string;
    FProductName,FProductType,FProgramFilesPath,FSM_AccessoriesName : string;
    FVersion,FVersionNumber,FWallPaperDir : string;

  public
    constructor Create(AOwner: TComponent); override;

  published
    property About: TAbout read FAbout write FAbout;
    property MacAdress: string read FMacAdress write FMacAdress;
    property BiosDate: string read FBiosDate write FBiosDate;
    property BiosName: string read FBiosName write FBiosName;
    property BiosVer: string read FBiosVer write FBiosVer;
    property Workgroup: string read FWorkgroup write FWorkgroup;
    property ComputerName: string read FComputerName write FComputerName;
    property Comment: string read FComment write FComment;
    property ProductId: string read FProductId write FProductId;
    property ProductKey: string read FProductKey write FProductKey;
    property WallPaperDir: string read FWallPaperDir write FWallPaperDir;
    property VersionNumber: string read FVersionNumber write FVersionNumber;
    property Version: string read FVersion write FVersion;
    property SM_AccessoriesName: string read FSM_AccessoriesName write FSM_AccessoriesName;
    property ProgramFilesPath: string read FProgramFilesPath write FProgramFilesPath;
    property ProductType: string read FProductType write FProductType;
    property ProductName: string read FProductName write FProductName;
    property PF_AccessoriesName: string read FPF_AccessoriesName write FPF_AccessoriesName;
    property OtherDevicePath: string read FOtherDevicePath write FOtherDevicePath;
    property MediaPath: string read FMediaPath write FMediaPath;
    property DevicePath: string read FDevicePath write FDevicePath;
    property ConfigPath: string read FConfigPath write FConfigPath;
    property CommonFilesDir: string read FCommonFilesDir write FCommonFilesDir;
    property BootCount: string read FBootCount write FBootCount;
    property ProgramFilesDir: string read FProgramFilesDir write FProgramFilesDir;
    property SystemRoot: string read FSystemRoot write FSystemRoot;
    property RegisteredOrganization: string read FRegisteredOrganization write FRegisteredOrganization;
    property RegisteredOwner: string read FRegisteredOwner write FRegisteredOwner;
  end;


{$IFDEF WIN32}
  function Netbios(P: PNCB): Char; stdcall;
{$ENDIF}

function NetbiosCmd(var NCB: TNCB): Word;

var
  BRegistry: TRegistry;

procedure Register;

implementation


{$IFDEF WIN32}
function Netbios; external 'netapi32.dll' name 'Netbios';
{$ENDIF}

function NetbiosCmd(var NCB: TNCB): Word;
begin
{$IFNDEF WIN32}
  asm
    push bp
    push ss
    push ds
    les  bx, NCB
    call NetBiosCall;
    xor  ah,ah
    mov  @Result, ax
    pop  ds
    pop  ss
    pop  bp
  end;
{$ELSE}
  Result := Word(Netbios(PNCB(@NCB)));
{$ENDIF}
end;

function NbLanaEnum: TLana_Enum;
var
  NCB: TNCB;
  L_Enum: TLana_Enum;
  RetCode: Word;
begin
{$IFDEF WIN32}
  FillChar(NCB, SizeOf(NCB), 0);
  FillChar(L_Enum, SizeOf(TLana_Enum), 0);
  NCB.Command := NCB_ENUM;
  NCB.Buf := @L_Enum;
  NCB.Length := Sizeof(L_Enum);
  RetCode := NetBiosCmd(NCB);
  if RetCode <> NRC_GOODRET then begin
    L_Enum.Length := 0;
    L_Enum.Lana[0] := Byte(RetCode);
  end;
{$ELSE}
  L_Enum.Length := 1;
  L_Enum.Lana[0] := 0;
{$ENDIF}
  Result := L_Enum;
end;

function NbReset(l: Byte): Word;
var
  NCB: TNCB;
begin
{$IFNDEF WIN32}
  Result := NRC_GOODRET;
{$ELSE}
  FillChar(NCB, SizeOf(NCB), 0);
  NCB.Command := NCB_RESET;
  NCB.Lana_Num := l;
  Result := NetBiosCmd(NCB);
{$ENDIF}
end;

function NbGetMacAddr(LanaNum: Integer): String;
var
  NCB: TNCB;
  AdpStat: TAdpStat;
  RetCode: Word;
begin
  FillChar(NCB, SizeOf(NCB), 0);
  FillChar(AdpStat, SizeOf(AdpStat), 0);
  NCB.Command := NCB_ADPSTAT;
  NCB.Buf := @AdpStat;
  NCB.Length := Sizeof(AdpStat);
  FillChar(NCB.CallName, Sizeof(TNBName), $20);
  NCB.CallName[0] := Byte('*');
  NCB.Lana_Num := LanaNum;
  RetCode := NetBiosCmd(NCB);
  if RetCode = NRC_GOODRET then begin
    Result := Format('%2.2x:%2.2x:%2.2x:%2.2x:%2.2x:%2.2x',
                   [AdpStat.ID[0],
                   AdpStat.ID[1],
                   AdpStat.ID[2],
                   AdpStat.ID[3],
                   AdpStat.ID[4],
                   AdpStat.ID[5]
                   ]);
  end else begin
    Result := '??:??:??:??:??:??';
  end;
end;

constructor TWinInfo.Create;
var
  L_Enum : TLana_Enum;
  RetCode: Word;
  i: Integer;
begin
  inherited;
  BRegistry := TRegistry.Create;
  BRegistry.RootKey := DBRoot;
  BRegistry.LazyWrite := false;
  BRegistry.OpenKey('Enum\Root\*PNP0C01\0000', False);
  BiosDate := BRegistry.ReadString('BIOSDate');
  BiosName := BRegistry.ReadString('BIOSName');
  BiosVer := BRegistry.ReadString('BIOSVersion');

  BRegistry.CloseKey;

  BRegistry.OpenKey('System\CurrentControlSet\Services\VxD\VNETSUP', False);
  Workgroup := BRegistry.ReadString('Workgroup');
  ComputerName := BRegistry.ReadString('ComputerName');
  Comment := BRegistry.ReadString('Comment');
  BRegistry.CloseKey;


  BRegistry.OpenKey('SOFTWARE\Microsoft\Windows\CurrentVersion', False);
  ProductId := BRegistry.ReadString('ProductId');
  ProductKey := BRegistry.ReadString('ProductKey');

  RegisteredOwner        := BRegistry.ReadString('RegisteredOwner');
  RegisteredOrganization := BRegistry.ReadString('RegisteredOrganization');
  SystemRoot             := BRegistry.ReadString('SystemRoot');
  ProgramFilesDir        := BRegistry.ReadString('ProgramFilesDir');
  BootCount              := BRegistry.ReadString('BootCount');
  CommonFilesDir         := BRegistry.ReadString('CommonFilesDir');
  ConfigPath             := BRegistry.ReadString('ConfigPath');
  DevicePath             := BRegistry.ReadString('DevicePath');
  MediaPath              := BRegistry.ReadString('MediaPath');
  OtherDevicePath        := BRegistry.ReadString('OtherDevicePath');
  PF_AccessoriesName     := BRegistry.ReadString('PF_AccessoriesName');
  ProductName            := BRegistry.ReadString('ProductName');
  ProductType            := BRegistry.ReadString('ProductType');
  ProgramFilesPath       := BRegistry.ReadString('ProgramFilesPath');
  SM_AccessoriesName     := BRegistry.ReadString('SM_AccessoriesName');
  Version                := BRegistry.ReadString('Version');
  VersionNumber          := BRegistry.ReadString('VersionNumber');
  WallPaperDir           := BRegistry.ReadString('WallPaperDir');

  BRegistry.CloseKey;

  BRegistry.Free;
{ -----------------o------------------}

  L_Enum := NbLanaEnum;
  if L_Enum.Length = 0 then begin
    MacAdress := '';
    exit;
  end;

  for i := 0 to (L_Enum.Length - 1)do begin

    RetCode := NbReset(L_Enum.Lana[i]);
    if RetCode <> NRC_GOODRET then begin
       MacAdress := '';
       exit;
    end;

    MacAdress := NbGetMacAddr(i);

  end;

end;

procedure TAbout.Edit;
begin
    Application.MessageBox
      ('WinInfo'+#13+#10+'(c) Copyright 1999 by Blent Binici'+#13+#10+'E-Mail : bulent@ada.net.tr',
       'About', MB_OK or MB_ICONINFORMATION);
end;

function TAbout.GetAttributes: TPropertyAttributes;
begin
    Result := [paMultiSelect, paDialog, paReadOnly];
end;

function TAbout.GetValue: string;
begin
    Result := '(about)';
end;

procedure Register;
begin
  RegisterComponents('Samples', [TWinInfo]);
  RegisterPropertyEditor(TypeInfo(TAbout), TWININFO, 'ABOUT', TAbout);
end;

end.
