{
OBJECT      : Component Design: Persistance, Property Editors
              TMyRecObjEditor : Simple Property Editor for TMyRecObj

LAST CHANGES: 16.12.1996

AUTHOR      : Kurt Spitzley, (101.10490@germanynet.de or Kurt.Spitzley@rz-online.de)

COPYRIGHT   : (c) 1996 by Kurt Spitzley, All rights reserved.
              This software should not be SOLD by anyone. It is distributed as
              freeware and therefore may be used free of charge.

DISCLAIMER  : I have provided this software to the public free of charge. You
              accept this software AS IS without any representation or warranty
              of any kind, including but not limited to the warranty of
              merchantability or fitness for a particular purpose.
}
unit PropEd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DsgnIntf, StdCtrls;

type
  TMyRecObjfrm = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    btnOK: TButton;
    btnCancel: TButton;
  end;

TMyRecObjEditor=class(TPropertyEditor)
  function GetAttributes: TPropertyAttributes;override;
  function GetValue:string;override;
  procedure Edit;override;
end;

var
  MyRecObjfrm: TMyRecObjfrm;

procedure Register;

implementation

uses Comp;

{$R *.DFM}

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(TMyRecObj),nil,'',TMyRecObjEditor);
end;

function TMyRecObjEditor.GetAttributes: TPropertyAttributes;
begin
  result:=inherited GetAttributes+[paDialog,paReadOnly]-[paSubProperties];
end;

function TMyRecObjEditor.GetValue:string;
begin
  result:='TMyRecObj';
end;

procedure TMyRecObjEditor.Edit;
var
  RefToMyRecObj: TMyRecObj; // reference to actual edited object
  TmpMyRec: TMyRec;
begin
  with TMyRecObjFrm.Create(nil) do
    begin
      BtnOK.ModalResult:=mrOK; // modal Dialog terminated with mrOK
      BtnCancel.ModalResult:=mrCancel;// modal Dialog terminated with mrCancel
      RefToMyRecObj:=TMyRecObj(GetOrdValue); // get actual edited object
      TmpMyRec:=RefToMyRecObj.GetMyRec; // get data
      Edit1.Text:=TmpMyRec.s; // setup dialog controls with data
      Edit2.Text:=IntToStr(TmpMyRec.l);
      if ShowModal=mrOK then // user has clicked OK-Button
        begin
          TmpMyRec.s:=Edit1.Text;
          TmpMyRec.l:=StrToInt(Edit2.Text);
          RefToMyRecObj.SetMyRec(TmpMyRec); // write back new data
          SetOrdValue(longint(RefToMyRecObj)); // ensures registration of change
        end;
      Free; // free dialog
    end;
end;

end.
