
{*******************************************************}
{                                                       }
{       Delphi 2.01 Client/Server                       }
{       Unit AutoGrid                                   }
{                                                       }
{       Copyright (c) 1996,97 Stephan Schneider         }
{       email: sstephan@donau.de                        }
{                                                       }
{*******************************************************}

unit AutoGrid;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids;

type

{ TAutoStringGrid class }

  TAutoStringGrid = class(TStringGrid)
  protected
    procedure EmptyAll;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
  end;

{ Register procedure }

procedure Register;

implementation

{ TAutoStringGrid }

procedure TAutoStringGrid.EmptyAll;
var
  I, J: Integer;
begin
  for I := 1 to RowCount-1 do
    for J := 0 to ColCount-1 do
      Cells[J,I] := EmptyStr;
end;

procedure TAutoStringGrid.KeyDown(var Key: Word; Shift: TShiftState);
var
  StringList: TStringList;
  MaxRows: Integer;
  MaxCols: Integer;
  I, J: Integer;
  Index: Integer;
begin
  case Key of
   { at the end of the Grid extend it automatically }
    VK_TAB:
      begin
        if (not (ssShift in Shift)) then
          if ((Row = RowCount-1) and (Col = ColCount-1)) then
            RowCount := RowCount + 1;
      end;
   { insert a row }
    VK_INSERT:
      begin
        MaxRows := RowCount - FixedRows;
        MaxCols := ColCount - FixedCols;
        StringList := TStringList.Create;
        try
          for I := 1 to MaxRows do
            for J := 0 to MaxCols-1 do
              StringList.Add(Cells[J,I]);
          for Index := (Row * ColCount - ColCount) to (Row * ColCount - 1) do
            StringList.Insert(Index, EmptyStr);
          RowCount := RowCount + 1;
          MaxRows := RowCount - FixedRows;
          EmptyAll;
          Index := 0;
          for I := 1 to MaxRows do
            for J := 0 to MaxCols-1 do
            begin
              Cells[J,I] := StringList.Strings[Index];
              Inc(Index);
            end;
        finally
          StringList.Free;
        end;
      end;
   { delete a row }
    VK_DELETE:
      begin
        if ((RowCount > 2) and (not EditorMode)) then
        begin
          MaxRows := RowCount - FixedRows;
          MaxCols := ColCount - FixedCols;
          StringList := TStringList.Create;
          try
            for I := 1 to MaxRows do
              for J := 0 to MaxCols-1 do
                if (I <> Row) then
                  StringList.Add(Cells[J,I]);
            EmptyAll;
            MaxRows := Pred(RowCount) - FixedRows;
            Index := 0;
            for I := 1 to MaxRows do
              for J := 0 to MaxCols-1 do
              begin
                Cells[J,I] := StringList.Strings[Index];
                Inc(Index);
              end;
            RowCount := RowCount - 1;
          finally
            StringList.Free;
          end;
        end;
      end;
  end;
  inherited;
end;

{ Registration }

procedure Register;
begin
  RegisterComponents('Additional', [TAutoStringGrid]);
end;

end.
