unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  async32, StdCtrls, ExtCtrls;

type
  TMainForm = class(TForm)
    Comm: TComm32;
    CheckBoxDTR: TCheckBox;
    CheckBoxRTS: TCheckBox;
    CheckBoxBREAK: TCheckBox;
    CheckBoxCR: TCheckBox;
    ErrorLabel: TLabel;
    ErrorText: TLabel;
    CommStateLabel: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Memo1: TMemo;
    Memo2: TMemo;
    ErrCode: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure CheckBoxDTRClick(Sender: TObject);
    procedure CheckBoxRTSClick(Sender: TObject);
    procedure CheckBoxBREAKClick(Sender: TObject);
    procedure CommErrorSignal(Sender: TObject; Errors: Integer);
    procedure CommRxCharSignal(Sender: TObject; Count: Integer);
    procedure CommTxEmptySignal(Sender: TObject);
    procedure CommRxFlagSignal(Sender: TObject);
    procedure CommBreakSignal(Sender: TObject);
    procedure CommCTSSignal(Sender: TObject; State: Boolean);
    procedure CommDSRSignal(Sender: TObject; State: Boolean);
    procedure CommRingSignal(Sender: TObject);
    procedure CommRLSDSignal(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure CommOpen(Sender: TObject; Error: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Comm.Open;
  if Comm.Enabled then CommStateLabel.Caption := 'Openend'
                  else CommStateLabel.Caption := 'Closed';
end;

procedure TMainForm.CheckBoxDTRClick(Sender: TObject);
begin
  Comm.DTR(CheckBoxDTR.Checked);
end;

procedure TMainForm.CheckBoxRTSClick(Sender: TObject);
begin
  Comm.RTS(CheckBoxRTS.Checked);
end;

procedure TMainForm.CheckBoxBREAKClick(Sender: TObject);
begin
  Comm.BREAK(CheckBoxBreak.Checked);
end;

procedure TMainForm.CommErrorSignal(Sender: TObject; Errors: Integer);
begin
  ErrorText.Caption := IntToStr(Errors);
end;

procedure TMainForm.CommRxCharSignal(Sender: TObject; Count: Integer);
var
  Buffer: array[0..999] of char;
  R: Integer;
  S: PChar;
begin
  Memo1.Lines.add('RxChar signal: '+ IntToStr(Count) + ' bytes');
  Fillchar(Buffer, Sizeof(Buffer), 0);
  R := Comm.Read(Buffer, Count);
  Memo1.Lines.Add('Reading: ' + IntToStr(R) + ' bytes');
  Memo2.Lines.Add(String(Buffer));
end;

procedure TMainForm.CommTxEmptySignal(Sender: TObject);
begin
  Memo1.Lines.add('TxEmpty signal received........');
end;

procedure TMainForm.CommRxFlagSignal(Sender: TObject);
begin
  Memo1.Lines.add('RxFlag signal received.........');
end;

procedure TMainForm.CommBreakSignal(Sender: TObject);
begin
  Memo1.Lines.add('Break signal received.......');
end;

procedure TMainForm.CommCTSSignal(Sender: TObject; State: Boolean);
begin
  Memo1.Lines.add('CTS signal received.....');
end;

procedure TMainForm.CommDSRSignal(Sender: TObject; State: Boolean);
begin
  Memo1.Lines.add('DSR signal received..........');
end;

procedure TMainForm.CommRingSignal(Sender: TObject);
begin
  Memo1.Lines.add('Ring signal received.......');
end;

procedure TMainForm.CommRLSDSignal(Sender: TObject);
begin
  Memo1.Lines.add('RLSD signal received......');
end;

procedure TMainForm.Button1Click(Sender: TObject);
var
  S: String;
  Bytes: Integer;
  I: Integer;
begin
  S := Edit1.Text;
  if CheckBoxCR.Checked then S := S + #13;
  Bytes := Comm.Write(S[1], Length(S));
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
  Comm.PurgeIn;
end;

procedure TMainForm.Button3Click(Sender: TObject);
begin
  Comm.PurgeOut;
end;

procedure TMainForm.Button4Click(Sender: TObject);
begin
  Memo1.Lines.Clear;
  Memo2.Lines.Clear;
  ErrorText.Caption := '0';
end;

procedure TMainForm.Button5Click(Sender: TObject);
begin
  Comm.Open;
  if Comm.Enabled then CommStateLabel.Caption := 'Openend'
                  else CommStateLabel.Caption := 'Closed';
end;

procedure TMainForm.Button6Click(Sender: TObject);
begin
  Comm.Close;
  if Comm.Enabled then CommStateLabel.Caption := 'Openend'
                  else CommStateLabel.Caption := 'Closed';
end;

procedure TMainForm.CommOpen(Sender: TObject; Error: Integer);
begin
  ErrCode.Caption := IntToStr(Error);
end;

end.
