unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,ARDBCalendarN,
  StdCtrls, ExtCtrls, ARSaveForm, Buttons, ComCtrls, DBCtrls, Db, DBTables,
  Mask, ExtDlgs;

type
  TfrmMain = class(TForm)
    BTN_InitCalendar: TButton;
    TBL_DBCALENDAR: TTable;
    DTS_DBCALENDAR: TDataSource;
    Label1: TLabel;
    EDT_MonthYear: TDBEdit;
    DBNavigator1: TDBNavigator;
    Label2: TLabel;
    EDT_Date: TDBEdit;
    Label3: TLabel;
    EDT_DayValues: TDBEdit;
    GPB_CalendarStatus: TGroupBox;
    RBT_Enabled: TRadioButton;
    RBT_Disabled: TRadioButton;
    ARDB_Calendar: TARDBCalendar;
    STA_Status: TStatusBar;
    GPB_DisabledImage: TGroupBox;
    BTN_Demo: TSpeedButton;
    Label4: TLabel;
    BTN_Load: TSpeedButton;
    DLG_Picture: TOpenPictureDialog;
    BTN_Clear: TSpeedButton;
    Label5: TLabel;
    Label6: TLabel;
    LTV_CalendarScheme: TListView;
    Label7: TLabel;
    BTN_GetCalendarScheme: TSpeedButton;
    IMG_LTV_CalendarScheme: TImageList;
    procedure ARDB_CalendarCreatingScheme(Sender: TObject;
      var CreateDate: TDateTime; var CreateDateFormat: String;
      var CreateScheme: array of TDayStatus);
    procedure RBT_EnabledClick(Sender: TObject);
    procedure RBT_DisabledClick(Sender: TObject);
    procedure BTN_InitCalendarClick(Sender: TObject);
    procedure ARDB_CalendarStatusChange(Sender: TObject; Selected,
      UnSelected, Disabled: Integer);
    procedure FormShow(Sender: TObject);
    procedure BTN_LoadClick(Sender: TObject);
    procedure BTN_ClearClick(Sender: TObject);
    procedure ARDB_CalendarDatePanelCaptionChange(Sender: TObject;
      var Text: String; Date: TDateTime);
    procedure BTN_GetCalendarSchemeClick(Sender: TObject);
    procedure ARDB_CalendarDayClick(Sender: TObject; Day, Month, Year,
      Week: Integer; DayStatus: TDayStatus; var AllowChange: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.ARDB_CalendarCreatingScheme(Sender: TObject;var CreateDate: TDateTime; var CreateDateFormat: String;var CreateScheme: array of TDayStatus);
var
	NumeroItem				: integer;
begin
	CreateDate := StrToDateTime('01/01/2000');
	CreateDateFormat := 'dd/mm/yyyy';
	for NumeroITem := 1 to 31 do
		begin
			CreateScheme[NumeroITem] := day_Selected;
		end;


end;

procedure TfrmMain.RBT_EnabledClick(Sender: TObject);
begin
	ARDB_Calendar.Enabled := True;
end;

procedure TfrmMain.RBT_DisabledClick(Sender: TObject);
begin
	ARDB_Calendar.Enabled := False;
end;

procedure TfrmMain.BTN_InitCalendarClick(Sender: TObject);
var
	CreateDate				: TDateTime;
	CreateDateFormat		: string;	
	CreateScheme			: array[0..40] of TDayStatus; {array it bigger... for safelly calls object will not allow less than 0..40}
	NumeroItem				: integer;
	RandomNumber			: integer;
begin
	CreateDate := StrToDateTime('01/01/1998');
	CreateDateFormat := 'dd/mm/yyyy';

	for NumeroItem := 1 to 31 do
		begin
			RandomNumber := Random(3);
			CreateScheme[NumeroItem] := TDayStatus(RandomNumber);
		end;
	if not ARDB_Calendar.InitCalendar(CreateDate,CreateDateFormat,CreateScheme) then
		begin
			ShowMessage('Some Error Happened at InitCalendar }:-(');
		end;
end;

procedure TfrmMain.ARDB_CalendarStatusChange(Sender: TObject; Selected,UnSelected, Disabled: Integer);
begin
	STA_Status.Panels[0].Text := Format('Selected: %.2d',[Selected]);
	STA_Status.Panels[1].Text := Format('UnSelected: %.2d',[UnSelected]);
	STA_Status.Panels[2].Text := Format('Disabled: %.2d',[Disabled]);
end;

procedure TfrmMain.FormShow(Sender: TObject);
begin
	case ARDB_Calendar.Enabled of
		True:
			begin
				RBT_Enabled.Checked := True;
			end;
		False:
			begin
				RBT_Disabled.Checked := True;
			end;
	end;

	if not ARDB_Calendar.DisabledBitmap.Empty then
		begin
			BTN_Demo.Caption := '';
			BTN_Demo.Glyph.Assign(ARDB_Calendar.DisabledBitMap)
		end
	else
		begin
			BTN_Demo.Glyph.Assign(nil);
			BTN_Demo.Caption := 'X';
		end;
end;

procedure TfrmMain.BTN_LoadClick(Sender: TObject);
begin
	if DLG_Picture.Execute then
		begin
			ARDB_Calendar.DisabledBitmap.LoadFromFile(DLG_Picture.FileName);
			BTN_Demo.Glyph.Assign(ARDB_Calendar.DisabledBitMap);
			BTN_Demo.Caption := '';
		end;
end;

procedure TfrmMain.BTN_ClearClick(Sender: TObject);
begin
	ARDB_Calendar.DisabledBitmap.Assign(nil);
	BTN_Demo.Glyph.Assign(nil);
	BTN_Demo.Caption := 'X';


end;

procedure TfrmMain.ARDB_CalendarDatePanelCaptionChange(Sender: TObject;var Text: String; Date: TDateTime);
begin
	Text := Format('Albert Research 98 [%s]',[FormatDateTime('mmmm yyyy',Date)]);
end;

procedure TfrmMain.BTN_GetCalendarSchemeClick(Sender: TObject);
var
	a_Date					: TDateTIme;
	a_MonthYear				: string;
	a_CalendarScheme		: array[0..40] of TDayStatus; {array it bigger... for safelly calls object will not allow less than 0..40}
	NumeroItem				: integer;
	VItem					: TListItem;
const
	StatusText				: array[0..2] of string = ('Selected','Unselected','Disabled');
begin

	if ARDB_Calendar.GetCalendarScheme(A_Date,a_MonthYear,A_CalendarScheme) then
		begin
			LTV_CalendarScheme.Items.Clear;
			for NumeroItem := 1 to 31 do
				begin
					VItem := LTV_CalendarScheme.Items.Add;
					VItem.Caption := IntToStr(NumeroItem);
					VItem.SubItems.Add(StatusText[ord(TDayStatus(A_CalendarScheme[NumeroItem]))]);
					VItem.ImageIndex :=ord(TDayStatus(A_CalendarScheme[NumeroItem]));
				end;
		end
	else
		begin
			ShowMessage('Some Error Happened at GetCalendarScheme }:-(');		
		end;

end;

procedure TfrmMain.ARDB_CalendarDayClick(Sender: TObject; Day, Month, Year,Week: Integer; DayStatus: TDayStatus; var AllowChange: Boolean);
const
	StatusText				: array[0..2] of string = ('Selected','Unselected','Disabled');

begin
	ShowMessage(Format('You Pressed the Day: %d%sIn Week: %d%sIn Month: %d%sAt Year: %d%sWith Status: %s',[Day,#10,Week,#10,Month,#10,Year,#10,StatusText[ord(DayStatus)]]));
//	AllowChange := False;
end;

end.
