{ }
(*
	ARDBCalendar V2.0 by Albert Research 98

	Legal Notice:

	Distribution

	This component is freeware. As such, Albert Research gives no warranty to its accuracy, fitness for any particular use, effects of use, or reliability.
	This component may not be distributed as a part of another component package without Albert Research written consent. It may be freely distributed,
	although it must be distributed with all original files in their original format intact. If you use this component in your software, please include an acknow-
	ledgment that portions are copyrighted by Albert Research. Please contact the author, Albert, at one of the below address with questions, comments, bug-reports
	 or any updates you make to the component.

	 Albert Research:

	 e-mail: albertrs@redestb.es
	 Web: http://personal.redest.es/albertrs



								 ``     ```''MM'``
										``A##NNN````
								   `` ``''#UUMMMNN```
								 ``  'MMAAHRRMMMHHNN```
								   ``R@@##@##MMHHHMMN````
								 ``HHR@@@@@##MMMHHNNNNN``
							  ```AAHH#@@@@@@@MMNNNMMMHHNN`           `
				  ``       `````H##@@H####@##MMMMMHHMHHHHH```` ````
						 `` ''###@@##HHHHHR##MMNNNMMNHHHHNNN`````  ``
				  ```      `UU###@@HH@##RR#RRMMMHHNNNNNMMHHHNN`````  `
						 ``#####@##@@@@@##@##MMMMMNNNHHNNNNNNNN````
					   ````RHH##H#####@@@@@##NNNNNMMMNNNNNNNHHHNN  ``
					   `````''~~~::UU@##RR#RRMMMMMNNMMMMM'''```````
					`##HHHH@HH@@HHHHHHHHNNH@@NNHHH@@HHHHH@##HH#@@##HH`
      `````        ````'####@@###@@H@@HHH@@HHHHHHH@HH@@@@@@@@@@NNMNNHHHHH``
		``     ```##@@@@@##@@@##@@@@@@####@##MMMMMMMNMMMMNMMHHMHHNNNNHNN```
		  `  ```''RR#HH@@@@HRR##@@@@@@@@@@@##MMMNNMMNNNNNNHHMMNNNMMHHNNNHH```  `
		  `    `HHAA@####@@@@@@@H@@@@@@@#####MMNNNMMNNNNNMNNHHNMMNNMMHNNNN'       ``
	  ``   ``  ```''~MM####@HH##@@@@@@@@##@##MMNNNMMNNNNNNNNHHMNNNNMM'''`````  `
	 `    ```##HHH@@@HHHHHHHNNHHHHH@@@@@#####MMMMMMMNNNNN@HH@@@HHHH##H##HHRHHHH```
	  ````M##@@@@@@@@@@@@HHHHHHHHHHHHHHHHHHHH@@H@@@@HHHHHHHH@@@HHNNNNMHHMMNNNHHH````
	  ``''#@@@@@HH@@@@@@@@@@@@@@@HHHHHHHHHHHH@@HHHHHH@@HH@HHNNMMMNNNNHMMHHNNNNNNMM```
      ```MMRR@##@@@@@@@@@@@@HHHHH@@@@@@@@@@@@HHHHH@@@NNMNNMMMMMNNNNNMMMMNMMMMHNNNNMNNNN`
      ''~AA##@##@@H@@@@@@@@@@@@@@@@@@@@@@@@@@@##MMMNNMMNNNMMNNNMMMNNNNNNNNNMMNNNMMNNNNNH
      ~~A@@RRRHHHH#@@@@@@@@@@@@@@@@@@@@@@@@###RRMMMNNHHHNNMMNNNNNNMMMMNNHNNNNNMMHHMNNNNN@@
      ``'@@##@RR##H@@@@@@@####@##@@@@@@@@@@###@@MMMMMMMNNNHHNNNNNNNNNNNNNNNMMHNNNNHMMHH```
		  ```''M####@##HH##H@@HH#@@HH@HHHH#@@NNNNNNNNNNNNMMMNNNMMNNMMNHHNNN`````  ``
		   ```````MMRRRRR@@#HH@@@##HHH@@HHRRRMMMNNNNMNNNNNMMNNNMMNNHHHNN`````
      ```    ```       `````''R####A@@###HH@@@##MMNMMNNMNNHHNHHNNN``````     `
		   ``               ```````##R@@@@@@@HHMNNNNHNN```       ``
	  ``                         ``'''MMAA#RRMMNHHMM`````          ``   ``
										   ``''     `

*)
{ }
unit ARDBCalendarN;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,ExtCtrls,Buttons,db,dbCtrls,StdCtrls,dsgnintf,shellapi;

type
	TDayStatus = (day_Selected,day_UnSelected,day_Disabled);
	TDayClickNotify = procedure (Sender: TObject; Day: integer; Month: integer; Year: integer; Week: integer; DayStatus: TDayStatus; var AllowChange : boolean) of object;
	TCreatingScheme = procedure (Sender: TObject; var CreateDate: TDateTime ;var CreateDateFormat: string; var CreateScheme: array of TDayStatus) of object;
	TStatusChangeNotify = procedure (Sender: TObject; Selected: integer; UnSelected: integer; Disabled: integer) of object;
	TDatePanelCaptionChange = procedure (Sender: TObject; var Text: string; Date: TDateTime) of object;
	TYearBase = (year_1900,year_2000);
	TARDateFormat = (dat_MonthYear,dat_FullDate);

	{ ********************************************************************************************************}
	{Fashion Code #;.) }
		TAboutProperty = class(TPropertyEditor)
			public
				procedure Edit; override;
				function GetAttributes: TPropertyAttributes; override;
				function GetValue: string; override;
			end;

		TDialogComponent=class(TDefaultEditor)
			public
				procedure ExecuteVerb(Index: Integer); override;
				function GetVerb(Index: Integer): string; override;
				function GetVerbCount: Integer; override;
				procedure CopyRight;
		end;


		TARUrlType = (url_http,url_mailto);

		TARUrlLabel = class(TLabel)
			private
				VUrl					: string;
				VUrlType				: TARUrlType;
				procedure AR_DoClick(Sender:TObject);
				procedure PSetVUrl(Value: string);
				procedure PSetVUrlType(Value: TARUrlType);
			protected
			public
				constructor Create(AOwner : TComponent);override;
				destructor Destroy; override;
			published
				property URL : string read VUrl write PSetVUrl;
				property URLType: TARUrlType read VUrlType write PSetVUrlType;
		end;
		
	{ ********************************************************************************************************}


	TCalendarPanelSettings = class(TPersistent)
		private
			{Private declarations}
			V_Owner: TCustomControl;
			V_BevelInner: TPanelBevel;
			V_BevelOuter: TPanelBevel;
			V_CalendarPanelColor: TColor;

			procedure PSetV_BevelInner(Value: TPanelBevel);
			procedure PSetV_BevelOuter(Value: TPanelBevel);
			procedure PSetV_CalendarPanelColor(Value: TColor);
		protected
			{Protected declarations}
		public
			{Public Declarations}
			constructor Create(AOwner: TCustomControl);
			destructor Destroy; override;
		published
			{Published Declarations}
			property cpv_BevelInner: TPanelBevel read V_BevelInner write PSetV_BevelInner;
			property cpv_BevelOuter: TPanelBevel read V_BevelOuter write PSetV_BevelOuter;
			property cpv_PanelColor: TColor read V_CalendarPanelColor write PSetV_CalendarPanelColor;
	end;

	TSelectedShapeSettings = class(TPersistent)
		private
			{Private declarations}
			V_Owner: TCustomControl;
			V_Pen: TPen;
			V_Brush: TBrush;
			V_Visible : Boolean;

			procedure PSetV_Pen(Value : TPen);
			procedure PSetV_Brush(Value: TBrush);
			procedure PSetV_Visible(Value: boolean);
			procedure RefreshShapeSettings(Sender: TObject);
		protected
			{Protected declarations}
		public
			{Public Declarations}
			constructor Create(AOwner: TCustomControl);
			destructor Destroy; override;
		published
			{Published Declarations}
			property sel_Pen: TPen read V_Pen write PSetV_Pen;
			property sel_Brush: TBrush read V_Brush write PSetV_Brush;
			property sel_Visible: Boolean read V_Visible write PSetV_Visible;
	end;


	TDatePanelSettings = class(TPersistent)
		private
			{Private declarations}
			V_Owner: TCustomControl;
			V_BevelInner: TPanelBevel;
			V_BevelOuter: TPanelBevel;
			V_DatePanelColor: TColor;
			V_DateFont: TFont;

			procedure PSetV_BevelInner(Value: TPanelBevel);
               procedure PSetV_BevelOuter(Value: TPanelBevel);
               procedure PSetV_DatePanelColor(Value: TColor);
               procedure PSetV_DateFont(Value: TFont);
               procedure RefreshFontSettings(Sender: TObject);
		protected
           	{Protected declarations}
		public
           	{Public Declarations}
			constructor Create(AOwner: TCustomControl);
			destructor Destroy; override;
		published
           	{Published Declarations}
               property dpv_BevelInner: TPanelBevel read V_BevelInner write PSetV_BevelInner;
               property dpv_BevelOuter: TPanelBevel read V_BevelOuter write PSetV_BevelOuter;
               property dpv_PanelColor: TColor read V_DatePanelColor write PSetV_DatePanelColor;
               property dpv_DateFont: TFont read V_DateFont write PSetV_DateFont;
       end;

	TDaySettings = class(TPersistent)
		private
			{Private declarations}
               V_Owner: TCustomControl;
               V_Monday: string;
               V_TuesDay: string;
               V_Wednesday: string;
               V_Thursday: string;
			V_Friday: string;
               V_Saturday: string;
               V_Sunday: string;
			V_SundayFirst: boolean;
			V_DayBevelInner: TPanelBevel;
			V_DayBevelOuter: TPanelBevel;
			V_DayPanelColor: TColor;
			V_SundayPanelColor: TColor;
			V_DayFont: TFont;
			V_SundayFont: TFont;
			V_DayButtonFont: TFont;
			V_SundayButtonFont: TFont;
			V_DayButtonFlat: Boolean;
			V_Selected: integer;
			V_UnSelected: integer;
			V_Disabled: integer;

			procedure PSetV_Monday(Value: string);
			procedure PSetV_Tuesday(Value: string);
			procedure PSetV_Wednesday(Value: string);
			procedure PSetV_Thursday(Value: string);
			procedure PSetV_Friday(Value: string);
			procedure PSetV_Saturday(Value: string);
			procedure PSetV_Sunday(Value: string);
			procedure PSetV_SundayFirst(Value: boolean);
			procedure PSetV_DayBevelInner(Value: TPanelBevel);
			procedure PSetV_DayBevelOuter(Value: TPanelBevel);
			procedure PsetV_DayPanelColor(Value: TColor);
			procedure PSetV_SundayPanelColor(Value: TColor);
			procedure PSetV_DayFont(Value: TFont);
			procedure PSetV_SundayFont(Value: TFont);
			procedure PSetV_DayButtonFont(Value: TFont);
			procedure PSetV_SundayButtonFont(Value: TFont);
			procedure PSetV_DayButtonFlat(Value: Boolean);
			procedure RefreshFontSettings(Sender: TObject);



		protected
			{Protected declarations}
		public
			{Public Declarations}
			constructor Create(AOwner: TCustomControl);
			destructor Destroy; override;
		published
			{Published Declarations}
			property day_Monday: string read V_Monday write PSetV_Monday;
			property day_Tuesday: string read V_Tuesday write PSetV_Tuesday;
			property day_Wednesday: string read V_Wednesday write PSetV_Wednesday;
			property day_Thursday: string read V_Thursday write PSetV_Thursday;
			property day_Friday: string read V_Friday write PSetV_Friday;
			property day_Saturday: string read V_Saturday write PSetV_Saturday;
			property day_Sunday: string read V_Sunday write PSetV_Sunday;
			property day_SundayFirst: boolean read V_SundayFirst write PSetV_SundayFirst;
			property day_BevelInner: TPanelBevel read V_DayBevelInner write PSetV_DayBevelInner;
			property day_BevelOuter: TPanelBevel read V_DayBevelOuter write PSetV_DayBevelOuter;
			property day_WeekDayPanelColor: TColor read V_DayPanelColor write PSetV_DayPanelColor;
			property day_SundayPanelColor: TColor read V_SundayPanelColor write PSetV_SundayPanelColor;
			property day_WeekDayFont: TFont read V_DayFont write PSetV_DayFont;
			property day_SundayFont: TFont read V_SundayFont write PSetV_SundayFont;
			property day_DayButtonFont: TFont read V_DayButtonFont write PSetV_DayButtonFont;
			property day_SundayButtonFont: TFont read V_SundayButtonFont write PSetV_SundayButtonFont;
			property day_ButtonFlat: Boolean read V_DayButtonFlat write PSetV_DayButtonFlat;
			property day_Selected: integer read V_Selected;
			property day_UnSelected: integer read V_Unselected;
			property day_Disabled: integer read V_Disabled;
		end;

	TWeekSettings = class(TPersistent)
		private
			{Private declarations}
               V_Owner: TCustomControl;
			V_WeekBevelInner: TPanelBevel;
			V_WeekBevelOuter: TPanelBevel;
			V_WeekPanelColor: TColor;
			V_WeekFont: TFont;

			procedure PSetV_WeekBevelInner(Value: TPanelBevel);
			procedure PSetV_WeekBevelOuter(Value: TPanelBevel);
			procedure PsetV_WeekPanelColor(Value: TColor);
               procedure PSetV_WeekFont(Value: TFont);
               procedure RefreshFontSettings(Sender: TObject);


		protected
           	{Protected declarations}
		public
           	{Public Declarations}
			constructor Create(AOwner: TCustomControl);
			destructor Destroy; override;
		published
			{Published Declarations}
               property week_BevelInner: TPanelBevel read V_WeekBevelInner write PSetV_WeekBevelInner;
               property week_BevelOuter: TPanelBevel read V_WeekBevelOuter write PSetV_WeekBevelOuter;
               property week_WeekPanelColor: TColor read V_WeekPanelColor write PSetV_WeekPanelColor;
               property week_WeekFont: TFont read V_WeekFont write PSetV_WeekFont;

       end;

	TARCalendarButton = class(TSpeedButton)
		private
			{Private declarations}
			V_Day: integer;
               V_Month: integer;
			V_Year: integer;
			V_Week: integer;
			V_DayStatus: TDayStatus;

			procedure PSetV_Day(Value: integer);
			procedure PSetV_Month(Value: integer);
			procedure PSetV_Year(Value: integer);
			procedure PSetV_Week(Value: integer);
			procedure PSetV_DayStatus(Value: TDayStatus);

		protected
			{Protected declarations}
		public
			{Public Declarations}
			constructor Create(AOwner: TCustomControl);
			destructor Destroy; override;
		published
			{Published Declarations}
			property Day: integer read V_Day write PSetV_Day;
			property Month: integer read V_Month write PSetV_Month;
			property Year: integer read V_Year write PSetV_Year;
			property Week: integer read V_Week write PSetV_Week;
			property DayStatus: TDayStatus read V_DayStatus write PSetV_DayStatus;
	end;


	{ARDBCalendar Object}

	TDateFieldSettings = class(TPersistent)
		private
			{Private declarations}
			V_Owner: TCustomControl;
			V_DateFormat: TARDateFormat;
			V_Selected: string;
			V_UnSelected: string;
			V_Disabled: string;
			procedure PSetV_DateFormat(Value: TARDateFormat);
			procedure PSetV_Selected(Value: string);
			procedure PSetV_UnSelected(Value: string);
			procedure PSetV_Disabled(Value: string);
		protected
			{Protected declarations}

		public
			{Public Declarations}
			constructor Create(AOwner: TCustomControl);
			destructor Destroy; override;
		published
			{Published Declarations}
			property dtf_DateFormat: TARDateFormat read V_DateFormat write PSetV_DateFormat;
			property dtf_SelectedValue: string read V_Selected write PSetV_Selected;
			property dtf_UnSelectedValue: string read V_UnSelected write PSetV_UnSelected;
			property dtf_DisabledValue: string read V_Disabled write PSetV_Disabled;
	end;


	TARDBCalendar = class(TCustomControl)

		private
			{ Private declarations }
			V_CalendarPanel : TPanel;
			V_CalendarPanelSettings: TCalendarPanelSettings;

			{Days Panels}
			V_DaysPanel: array[1..7] of TPanel;
			V_DaySettings: TDaySettings;

			{Week Panels}
			V_WeekPanel: array[1..6] of TPanel;
			V_WeekSettings: TWeekSettings;

			{DayButtons}
			V_DayButton: array[1..31] of TARCalendarButton;

			{DatePanel}
			V_DatePanel: TPanel;
			V_DatePanelSettings: TDatePanelSettings;

			{Selected Shape}
			V_SelectedShape: TShape;
			V_SelectedShapeSettings: TSelectedShapeSettings;

			{ARDBCalendar Related Values}
			V_DateText: string;
			V_MonthYear: string;
			V_YearBase: TYearBase;
			V_OnDayClick: TDayClickNotify;

			{DataBase Related}
			V_DateFieldSettings: TDateFieldSettings;
			V_DateFieldLink: TFieldDataLink;
			V_DaysFieldLink: TFieldDataLink;
			V_DataAware: boolean;
			{Events}
			V_DaysReadError: TNotifyEvent;
			V_EditingError: TNotifyEvent;
			V_CreatingScheme: TCreatingScheme;
			V_StatusChange: TStatusChangeNotify;
			V_DatePanelChange: TDatePanelCaptionChange;

			{.. other}
			V_Loaded : boolean;
			V_Enabled: boolean;
			V_DisabledBitmap: TBitMap;
			{..Copyright}
			V_AboutProperty : TAboutProperty;


			{Event related procedures and functions}
			procedure PSetV_CalendarPanelSettings(Value: TCalendarPanelSettings);
			procedure PSetV_SelectedShapeSettings(Value: TSelectedShapeSettings);
			procedure PSetV_DaySettings(Value: TDaySettings);
			procedure PSetV_WeekSettings(Value: TWeekSettings);
			procedure PSetV_DatePanelSettings(Value: TDatePanelSettings);
			procedure PSetV_DateText(Value: string);
			procedure PSetV_MonthYear(Value: string);
			procedure PSetV_YearBase(Value: TYearBase);
			procedure PDoDayClick(Sender: TObject);
			procedure PSetV_Enabled(Value: boolean);
			procedure PSetV_DisabledBitmap(Value: TBitMap);
			procedure RefreshDisabled(Sender: TObject);


			{Windows Messages}
			procedure WMPaint(var Message: TWMPaint); message WM_PAINT;

			{Not Event related procedures and functions}
			procedure DrawWeekDaysRack;
			procedure DrawWeekNumbersRack;
			procedure DrawDayNumbersRack;
			procedure UpdateCalendar;
			procedure UpdateButtonStatus(ButtonValues: String);
			procedure UpdateButton(ButtonNumber: integer);
			procedure SincroDate;
			function InterPretDate(TextDate: string):string;
			function InterPretMonthYear(TextDate: string):string;
			function IsLeapYear(V_Year: Integer): Boolean;
			function DaysPerMonth(V_Year, V_Month: Integer): Integer;
			function WeekNo(V_Year: word; V_Month: word; V_Day: word ): Integer;
			procedure CommonPSetV_MonthYear(Value: string);
			procedure CommonPSetV_DateText(Value: string);
			procedure SetDBAwareStatus(Value: boolean);
			procedure PDoStatusChange;

			{DataBase Related}
			procedure PSetV_DateFieldSettings(const Value: TDateFieldSettings);
			function GetDataSource: TDataSource;
			procedure SetDataSource(Value: TDataSource);

			function GetDateField: string;
			procedure SetDateField(const Value: string);
			procedure DateDataChange(Sender: TObject);
			procedure DateEditingChange(Sender: TObject);
			procedure DaysDataChange(Sender: TObject);
			procedure DaysEditingChange(Sender: TObject);


			function GetDaysField: string;
			procedure SetDaysField(const Value: string);

			{...copyRight}
			procedure CopyRight;



		protected
			{ Protected declarations }
			{DataBase Related}
			procedure Notification(AComponent: TComponent; Operation: TOperation); override;

		public
			{ Public declarations }
			Date: TDateTime;
			{Methods}
			function InitCalendar(var CreateDate: TDateTime ;var CreateDateFormat: string; var CreateScheme: array of TDayStatus):boolean;
			function GetCalendarScheme(var CreateDate: TDateTime ;var MonthYear: string; var CalendarScheme: array of TDayStatus):boolean;

		published
			{ Published declarations }
			constructor Create(AOwner: TComponent); override;
			destructor Destroy;override;
			{Properties}
			property CalendarPanel: TCalendarPanelSettings read V_CalendarPanelSettings write PSetV_CalendarPanelSettings;
			property SelectedSettings: TSelectedShapeSettings read V_SelectedShapeSettings write PSetV_SelectedShapeSettings;
			property DaySettings: TDaySettings read V_DaySettings write PSetV_DaySettings;
			property WeekSettings: TWeekSettings read V_WeekSettings write PSetV_WeekSettings;
			property DatePanel: TDatePanelSettings read V_DatePanelSettings write PSetV_DatePanelSettings;
			property TextDate: string read V_DateText write PSetV_DateText;
			property MonthYear: string read V_MonthYear write PSetV_MonthYear;
			property YearBase: TYearBase read V_YearBase write PSetV_YearBase;
			property Enabled: boolean read V_Enabled write PSetV_Enabled;
			property DisabledBitmap: TBitMap read V_DisabledBitMap write PSetV_DisabledBitmap stored True;
			{DataBase Related}
			property DateFieldSettings: TDateFieldSettings read V_DateFieldSettings write PSetV_DateFieldSettings;
			property DataSource: TDataSource read GetDataSource write SetDataSource;
			property DateField: string read GetDateField write SetDateField;
			property DaysField: string read GetDaysField write SetDaysField;
			{Events}
			property OnDaysReadError: TNotifyEvent read V_DaysReadError write V_DaysReadError;
			property OnDayClick: TDayClickNotify read V_OnDayClick write V_OnDayClick;
			property OnEditingError: TNotifyEvent read V_EditingError write V_EditingError;
			property OnCreatingScheme: TCreatingScheme read V_CreatingScheme write V_CreatingScheme;
			property OnStatusChange: TStatusChangeNotify read V_StatusChange write V_StatusChange;
			property OnDatePanelCaptionChange: TDatePanelCaptionChange read V_DatePanelChange write V_DatePanelChange;
			property Author: TAboutProperty read V_AboutProperty write V_AboutProperty;

	end;

procedure Register;

implementation

{$R ARDBCalendarN.res}


const
	{System Day ShortNames Values}
	sys_Monday 				= 2;
       sys_TuesDay 			= 3;
       sys_Wednesday 			= 4;
       sys_Thursday			= 5;
       sys_Friday 				= 6;
       sys_Saturday  			= 7;
       sys_Sunday 				= 1;

	x_day_Button_offset		= 27;
       y_day_Button_offset		= 27;

       x_weekday_Panel_offset	= 27;

	y_weeknumber_Panel_offset = 27;

	day_ButtonWidth			= 23;
	day_ButtonHeight		= 22;

       week_NumberPanelHeight	= 25;
       week_NumberPanelWidth	= 25;
       week_DayPanelHeight		= 25;
	week_DayPanelWidth		= 25;


	cr_ARHandCalendar		= 1001;

{ ###################### The Famous Register procedure ####################### }
procedure Register;
begin
	RegisterComponentEditor(TARDBCalendar, TDialogComponent);
	RegisterComponents('AR_Albert Research[0]', [TARDBCalendar]);
	RegisterPropertyEditor(TypeInfo(TAboutProperty), TARDBCalendar, 'Author', TAboutProperty);
end;

{ ****************************************** FASHION CODE *****************************************************************}

procedure TDialogComponent.ExecuteVerb(Index: Integer);
begin
	case Index of
		0: CopyRight;

	end;
end;

function TDialogComponent.GetVerb(Index: Integer): String;
begin
	case Index of
		0: Result := 'Albert Research 98';
	end;
end;

function TDialogComponent.GetVerbCount: Integer;
begin
	Result:= 1;
end;

procedure TDialogComponent.CopyRight;
begin
	TARDBCalendar(Component).CopyRight;
end;

procedure TAboutProperty.Edit;
var
	VForm				: TForm;
	VButton				: TButton;
	VLabel				: TLabel;
	VLabel1				: TARUrlLabel;
	VLabel2				: TARUrlLabel;
	VImage				: TImage;	
begin
	VForm := TForm.Create(nil);
	VButton := TButton.Create(VForm);
	VLabel := TLabel.Create(VForm);
	VLabel1 := TARUrlLabel.Create(VForm);
	VLabel2 := TARUrlLabel.Create(VForm);
	VImage := TImage.Create(VForm);	

	VButton.Width := 60;
	VButton.Height := 21;
	VButton.Left := 126;
	VButton.Top := 140;
	VButton.Caption := 'Ok';
	VButton.ModalResult := mrOk;
	Vbutton.Parent := VForm;

	VLabel.Width := 250;
	VLabel.Height := 205;
	VLabel.Left := 64;
	VLabel.Top := 4;
	VLabel.AutoSize := False;
	VLabel.Caption := 'ARDBCalendar. The object that let''s you work with '+#10
					 +'data aware mode and single mode at the same time.  '+#10
					 +'This object is completely Free to use. Please look at'+#10
					 +'the copyright notice at the source code for the legal'+#10
					 +'Stuff. Enjoy it !'+#10+#10+'E-Mail:'+#10+#10+'WWW:';
	VLabel1.Left := 100;
	VLabel1.Top := 82;

	VLabel2.Left := 100;
	VLabel2.Top := 108;

	VLabel1.Url := 'albertrs@redestb.es';
	VLabel1.Caption := 'albertrs@redestb.es';
	VLabel1.UrlType := url_mailto;

	VLabel2.Url := 'http://personal.redestb.es/albertrs';
	VLabel2.Caption := 'http://personal.redestb.es/albertrs';
	VLabel2.URLType := url_http;

	VLabel.Parent := VForm;
	VLabel1.Parent := VForm;
	VLabel2.Parent := VForm;
	VImage.Parent := VForm;
	VImage.Transparent := True;
	
	VImage.Top := 10;
	VImage.Left := 10;

	VImage.Picture.Bitmap.LoadFromResourceID(HInstance,101);

	VForm.BorderStyle := bsToolWindow;
	VForm.Width := 320;
	VForm.Height := 190;
	VForm.Position := poScreenCenter;
	VForm.Caption := 'Albert Research 98 ARDBCalendar V2.0';
	VForm.ShowModal;

end;

function TAboutProperty.GetAttributes: TPropertyAttributes;
begin
	Result := [paMultiSelect, paDialog, paReadOnly];
end;

function TAboutProperty.GetValue: string;
begin
	Result := 'Albert Research 98';
end;

constructor TARUrlLabel.Create(AOwner : TComponent);
begin
	inherited Create(AOwner);
	Screen.Cursors[cr_ARHandCalendar] := LoadCursor(HInstance,'AR_HandCalendar');
	VUrl := 'http://personal.redestb.es/albertrs/';
	VUrlType := url_http;
	Hint := VUrl;
	ParentShowHint := False;
	ShowHint := True;
	OnClick := AR_DoClick;
	Font.Style := [fsUnderline];
	Font.Color := clBlue;
	Cursor := cr_ARHandCalendar;
	Caption := 'Albert Research 98';

end;

destructor TARUrlLabel.Destroy;
begin
	inherited Destroy;

end;

procedure TARUrlLabel.AR_DoClick(Sender:TObject);
begin
{$ifdef win32}
	case VUrlType of
		url_http:
			begin
				ShellExecute(TForm(Owner).Handle, 'open', PChar(VURL), nil, nil, SW_SHOW);
			end;
		url_mailto:
			begin
				ShellExecute(TForm(Owner).Handle, 'open', PChar('mailto:'+VURL), nil, nil, SW_SHOW);
			end;
	end;
{$endif}
end;

procedure TARUrlLabel.PSetVUrl(Value: string);
begin
	if Value <> VUrl then
		begin
			VUrl := Value;
			Hint := VUrl;
		end;
end;

procedure TARUrlLabel.PSetVUrlType(Value: TARUrlType);
begin
	if Value <> VUrlType then
		begin
			VUrlType := Value;
		end;
end;


{ ****************************************** END OF FASHION CODE *****************************************************************}

{#################### Calendar Panel Values #################################}
constructor TCalendarPanelSettings.Create(AOwner: TCustomControl);
begin
	inherited Create;
       V_Owner := AOwner;

       V_BevelInner := bvNone;
       V_BevelOuter := bvRaised;
       V_CalendarPanelColor := $0099BE92;
end;

destructor TCalendarPanelSettings.Destroy;
begin
	inherited Destroy;
end;

procedure TCalendarPanelSettings.PSetV_BevelInner(Value: TPanelBevel);
begin
	if Value <> V_BevelInner then
       	begin
           	V_BevelInner := Value;
               TARDBCalendar(V_Owner).PSetV_CalendarPanelSettings(Self);
           end;
end;

procedure TCalendarPanelSettings.PSetV_BevelOuter(Value: TPanelBevel);
begin
	if Value <> V_BevelOuter then
       	begin
           	V_BevelOuter := Value;
               TARDBCalendar(V_Owner).PSetV_CalendarPanelSettings(Self);
           end;
end;

procedure TCalendarPanelSettings.PSetV_CalendarPanelColor(Value: TColor);
begin
	if Value <> V_CalendarPanelColor then
		begin
           	V_CalendarPanelColor := Value;
			TARDBCalendar(V_Owner).PSetV_CalendarPanelSettings(Self);
           end;
end;


{ ############################################################################ }

{ ############################## Selected Shape Settings #################### }

constructor TSelectedShapeSettings.Create(AOwner: TCustomControl);
begin
	inherited Create;
       V_Owner := AOwner;

       V_Brush := TBrush.Create;
       V_Pen := TPen.Create;

       V_Brush.Style := bsClear;
       V_Pen.Style := psDot;
       V_Pen.Color := clRed;
       V_Pen.Width := 2;

       V_Visible := True;

       V_Brush.OnChange := RefreshShapeSettings;
       V_Pen.OnChange := RefreshShapeSettings;
       
       TARDBCalendar(V_Owner).PSetV_SelectedShapeSettings(Self);
end;

destructor TSelectedShapeSettings.Destroy;
begin
	V_Brush.Onchange := nil;
       V_Pen.OnChange := nil;
       
	V_Brush.Free;
       V_Pen.Free;
	inherited Destroy;
end;

procedure TSelectedShapeSettings.PSetV_Brush(Value: TBrush);
begin
	V_Brush.Assign(Value);
end;

procedure TSelectedShapeSettings.PSetV_Pen(Value: TPen);
begin
	V_Pen.Assign(Value);
end;

procedure TSelectedShapeSettings.PSetV_Visible(Value: boolean);
begin
	if Value <> V_Visible then
       	begin
           	V_Visible := Value;
	       TARDBCalendar(V_Owner).PSetV_SelectedShapeSettings(Self);
           end;
end;

procedure TSelectedShapeSettings.RefreshShapeSettings(Sender: TObject);
begin
       TARDBCalendar(V_Owner).PSetV_SelectedShapeSettings(Self);
end;


{#################### Calendar Panel Values #################################}
constructor TDatePanelSettings.Create(AOwner: TCustomControl);
begin
	inherited Create;
       V_Owner := AOwner;

       V_BevelInner := bvRaised;
       V_BevelOuter := bvRaised;
       V_DatePanelColor := clGreen;

       V_DateFont := TFont.Create;
       V_DateFont.Color := clWhite;
       V_DateFont.Style := [fsbold];

       V_DateFont.OnChange := RefreshFontSettings;

       TARDBCalendar(V_Owner).PSetV_DatePanelSettings(Self);
end;

destructor TDatePanelSettings.Destroy;
begin
	V_DateFont.OnChange := nil;
	V_DateFont.Free;
	inherited Destroy;
end;

procedure TDatePanelSettings.PSetV_BevelInner(Value: TPanelBevel);
begin
	if Value <> V_BevelInner then
       	begin
           	V_BevelInner := Value;
               TARDBCalendar(V_Owner).PSetV_DatePanelSettings(Self);
           end;
end;

procedure TDatePanelSettings.PSetV_BevelOuter(Value: TPanelBevel);
begin
	if Value <> V_BevelOuter then
		begin
           	V_BevelOuter := Value;
               TARDBCalendar(V_Owner).PSetV_DatePanelSettings(Self);
		end;
end;

procedure TDatePanelSettings.PSetV_DatePanelColor(Value: TColor);
begin
	if Value <> V_DatePanelColor then
       	begin
           	V_DatePanelColor := Value;
			TARDBCalendar(V_Owner).PSetV_DatePanelSettings(Self);
           end;
end;

procedure TDatePanelSettings.PSetV_DateFont(Value: TFont);
begin
	V_DateFont.Assign(Value);
end;

procedure TDatePanelSettings.RefreshFontSettings(Sender: TObject);
begin
       TARDBCalendar(V_Owner).PSetV_DatePanelSettings(Self);
end;


{ ############################################################################ }

{ TDaySettings }

constructor TDaySettings.Create(AOwner: TCustomControl);
begin
       inherited Create;
	V_Owner := AOwner;

       V_Monday := ShortDayNames[sys_Monday];
       V_Tuesday := ShortDayNames[sys_Tuesday];
       V_Wednesday := ShortDayNames[sys_Wednesday];
       V_Thursday := ShortDayNames[sys_Thursday];
       V_Friday := ShortDayNames[sys_Friday];
	V_Saturday := ShortDayNames[sys_Saturday];
	V_Sunday := ShortDayNames[sys_Sunday];

	V_Selected := 0;
	V_UnSelected := 0;
	V_Disabled := 0;

       V_SundayFirst := False;

       V_DayBevelInner := bvLowered;
       V_DayBevelOuter := bvRaised;


       V_DayPanelColor := $00C08000;
       V_SundayPanelColor := $00804000;

       V_DayFont := TFont.Create;
       V_DayFont.Color := clYellow;


       V_SundayFont := TFont.Create;
	V_SundayFont.Color := clWhite;

       V_DayButtonFont := TFont.Create;
       V_SundayButtonFont := TFont.Create;

       V_SundayButtonFont.Style := [fsBold];
       V_SundayButtonfont.Color := $00804000;

       V_DayFont.OnChange := RefreshFontSettings;
       V_SundayFont.OnChange := RefreshFontSettings;
       V_DayButtonFont.OnChange := RefreshFontSettings;
	V_SundayButtonFont.OnChange := RefreshFontSettings;

	V_DayButtonFlat := True;


end;

destructor TDaySettings.Destroy;
begin
	V_DayFont.OnChange := nil;
	V_SundayFont.OnChange := nil;
	V_DayButtonFont.OnChange := nil;
	V_SundayButtonFont.OnChange := nil;

	V_DayFont.Free;
	V_SundayFont.Free;
	V_DayButtonFont.Free;
	V_SundayButtonFont.Free;
	inherited Destroy;
end;


procedure TDaySettings.PSetV_Monday(Value: string);
begin
	if Value <> V_Monday then
		begin
			V_Monday := Value;
			TARDBCalendar(V_Owner).PSetV_DaySettings(Self);
		end;
end;

procedure TDaySettings.PSetV_Tuesday(Value: string);
begin
	if Value <> V_Tuesday then
       	begin
           	V_Tuesday := Value;
               TARDBCalendar(V_Owner).PSetV_DaySettings(Self);
           end;

end;
procedure TDaySettings.PSetV_Wednesday(Value: string);
begin
	if Value <> V_Wednesday then
       	begin
           	V_Wednesday := Value;
               TARDBCalendar(V_Owner).PSetV_DaySettings(Self);
           end;

end;


procedure TDaySettings.PSetV_Thursday(Value: string);
begin
	if Value <> V_Thursday then
       	begin
           	V_Thursday := Value;
			TARDBCalendar(V_Owner).PSetV_DaySettings(Self);
           end;

end;


procedure TDaySettings.PSetV_Friday(Value: string);
begin
	if Value <> V_Friday then
       	begin
           	V_Friday := Value;
               TARDBCalendar(V_Owner).PSetV_DaySettings(Self);
           end;

end;

procedure TDaySettings.PSetV_Saturday(Value: string);
begin
	if Value <> V_Saturday then
       	begin
           	V_Saturday := Value;
               TARDBCalendar(V_Owner).PSetV_DaySettings(Self);
           end;

end;

procedure TDaySettings.PSetV_Sunday(Value: string);
begin
	if Value <> V_Sunday then
		begin
           	V_Sunday := Value;
               TARDBCalendar(V_Owner).PSetV_DaySettings(Self);
           end;

end;

procedure TDaySettings.PSetV_SundayFirst(Value: boolean);
begin
	if Value <> V_SundayFirst then
       	begin
			V_SundayFirst := Value;
               TARDBCalendar(V_Owner).PSetV_DaySettings(Self);
               TARDBCalendar(V_Owner).UpdateCalendar;
           end;
end;

procedure TDaySettings.PSetV_DayBevelInner(Value: TPanelBevel);
begin
	if Value <> V_DayBevelInner then
       	begin
           	V_DayBevelInner := Value;
               TARDBCalendar(V_Owner).PSetV_DaySettings(Self);
           end;
end;

procedure TDaySettings.PSetV_DayBevelOuter(Value: TPanelBevel);
begin
	if Value <> V_DayBevelOuter then
       	begin
           	V_DayBevelOuter := Value;
               TARDBCalendar(V_Owner).PSetV_DaySettings(Self);
           end;

end;

procedure TDaySettings.PsetV_DayPanelColor(Value: TColor);
begin
	if Value <> V_DayPanelColor then
       	begin
           	V_DayPanelColor := Value;
			TARDBCalendar(V_Owner).PSetV_DaySettings(Self);
           end;

end;

procedure TDaySettings.PSetV_SundayPanelColor(Value: TColor);
begin
	if Value <> V_SundayPanelColor then
       	begin
           	V_SundayPanelColor := Value;
               TARDBCalendar(V_Owner).PSetV_DaySettings(Self);               
           end;

end;

procedure TDaySettings.PSetV_DayFont(Value: TFont);
begin
	V_DayFont.Assign(Value);
end;

procedure TDaySettings.PSetV_SundayFont(Value: TFont);
begin
	V_SundayFont.Assign(Value);
end;

procedure TDaySettings.PSetV_DayButtonFont(Value: TFont);
begin
	V_DayButtonFont.Assign(Value);
end;

procedure TDaySettings.PSetV_SundayButtonFont(Value: TFont);
begin
	V_SundayButtonFont.Assign(Value);
end;

procedure TDaySettings.PSetV_DayButtonFlat(Value: Boolean);
begin
	if Value <> V_DayButtonFlat then
		begin
			V_DayButtonFlat := Value;
			TARDBCalendar(V_Owner).PSetV_DaySettings(Self);
		end;
end;


procedure TDaySettings.RefreshFontSettings(Sender: TObject);
begin
	TARDBCalendar(V_Owner).PSetV_DaySettings(Self);
end;


{ ############################################################################ }


{ TWeekSettings }

constructor TWeekSettings.Create(AOwner: TCustomControl);
begin
       inherited Create;
       V_Owner := AOwner;


       V_WeekBevelInner := bvNone;
       V_WeekBevelOuter := bvNone;


       V_WeekPanelColor := $0082B079;

       V_WeekFont := TFont.Create;
       V_WeekFont.Name := 'Arial';
       V_WeekFont.Color := clWhite;
       V_WeekFont.Style := [fsBold];       


       V_WeekFont.OnChange := RefreshFontSettings;

end;

destructor TWeekSettings.Destroy;
begin
	V_WeekFont.OnChange := nil;

	V_WeekFont.Free;

	inherited Destroy;

end;

procedure TWeekSettings.PSetV_WeekBevelInner(Value: TPanelBevel);
begin
	if Value <> V_WeekBevelInner then
       	begin
           	V_WeekBevelInner := Value;
               TARDBCalendar(V_Owner).PSetV_WeekSettings(Self);
           end;

end;

procedure TWeekSettings.PSetV_WeekBevelOuter(Value: TPanelBevel);
begin
	if Value <> V_WeekBevelOuter then
		begin
           	V_WeekBevelOuter := Value;
               TARDBCalendar(V_Owner).PSetV_WeekSettings(Self);
		end;

end;
procedure TWeekSettings.PsetV_WeekPanelColor(Value: TColor);
begin
	if Value <> V_WeekPanelColor then
       	begin
           	V_WeekPanelColor := Value;
               TARDBCalendar(V_Owner).PSetV_WeekSettings(Self);
           end;

end;

procedure TWeekSettings.PSetV_WeekFont(Value: TFont);
begin
	V_WeekFont.Assign(Value);
end;

procedure TWeekSettings.RefreshFontSettings(Sender: TObject);
begin
	TARDBCalendar(V_Owner).PSetV_WeekSettings(Self);
end;

{ ################################# TARCalendarButton ################################}

constructor TARCalendarButton.Create(AOwner: TCustomControl);
begin
	inherited Create(AOwner);

       V_Day := 0;
	V_Month := 0;
	V_Week := 0;
	V_Year := 0;

	V_DayStatus := day_UnSelected;
end;

destructor TARCalendarButton.Destroy;
begin
	inherited Destroy;
end;

procedure TARCalendarButton.PSetV_Day(Value: integer);
begin
	if Value <> V_Day then
		begin
			V_Day := Value;
		end;
end;

procedure TARCalendarButton.PSetV_Month(Value: integer);
begin
	if Value <> V_Month then
		begin
			V_Month := Value;
		end;

end;

procedure TARCalendarButton.PSetV_DayStatus(Value: TDayStatus);
begin
	if Value <> V_DayStatus then
		begin
			V_DayStatus := Value;
		end;
end;

procedure TARCalendarButton.PSetV_Week(Value: integer);
begin
	if Value <> V_Week then
		begin
			V_Week := Value;
		end;

end;

procedure TARCalendarButton.PSetV_Year(Value: integer);
begin
	if Value <> V_Year then
		begin
			V_Year := Value;
		end;
end;

{ ######################## Date Field Settings ################################}
constructor TDateFieldSettings.Create(AOwner: TCustomControl);
begin
	inherited Create;

	V_Owner := AOWner;

	V_DateFormat := dat_MonthYear;
	V_Selected := '1';
	V_Disabled := '*';
	V_UnSelected := '0';
end;


destructor TDateFieldSettings.Destroy;
begin

	inherited Destroy;
end;
procedure TDateFieldSettings.PSetV_DateFormat(Value: TARDateFormat);
begin
	if Value <> V_DateFormat then
		begin
			V_DateFormat := Value;
		end;
end;

procedure TDateFieldSettings.PSetV_Disabled(Value: string);
begin
	if Length(Value) <> 1 then
		exit;

	if (ord(Value[1]) < 33) OR (ord(Value[1]) > 122) then
		exit;

	if Value <> V_Disabled then
		begin
			V_Disabled := Value;
		end;

end;

procedure TDateFieldSettings.PSetV_Selected(Value: string);
begin
	if Length(Value) <> 1 then
		exit;

	if (ord(Value[1]) < 33) OR (ord(Value[1]) > 122) then
		exit;

	if Value <> V_Selected then
		begin
			V_Selected := Value;
		end;

end;

procedure TDateFieldSettings.PSetV_UnSelected(Value: string);
begin
	if Length(Value) <> 1 then
		exit;

	if (ord(Value[1]) < 33) OR (ord(Value[1]) > 122) then
		exit;

	if Value <> V_UnSelected then
		begin
			V_UnSelected := Value;
		end;

end;


{ ################################# TARDBCalendar ################################}
constructor TARDBCalendar.Create(AOwner: TComponent);
var
	NumeroItem				: integer;
begin
	{Create}
	inherited Create(AOWner);

	{Creating the BackGround Object}
	V_CalendarPanel := TPanel.Create(Self);
	V_CalendarPanel.Parent := Self;
	V_CalendarPanel.Align := alClient;
	V_CalendarPanel.BevelWidth := 1;
	V_CalendarPanel.BorderWidth := 1;

	{Creating the Selected Shape}
	V_SelectedShape := TShape.Create(V_CalendarPanel);
	V_SelectedShape.Parent := V_CalendarPanel;
	V_SelectedShape.Shape := stSquare;
	V_SelectedShape.Width := 38;
	V_SelectedShape.Height := 28;


	{Day Buttons}
	for NumeroItem := 1 to 31 do
		begin
			V_DayButton[NumeroItem] := TARCalendarButton.Create(V_CalendarPanel);
			V_DayButton[NumeroItem].Parent := V_CalendarPanel;
			V_DayButton[NumeroItem].GroupIndex := NumeroItem;
			V_DayButton[NumeroItem].AllowAllUp := True;
			V_DayButton[NumeroItem].OnClick := PDoDayClick;
			V_DayButton[NumeroItem].LayOut := blGlyphLeft;
			V_DayButton[NumeroITem].Spacing := 0;
			V_DayButton[NumeroItem].Caption := '';
		end;

	V_DisabledBitmap := TBitmap.Create;
	V_DisabledBitmap.OnChange := RefreshDisabled;		

	{DatePanel}
	V_DatePanel := TPanel.Create(V_CalendarPanel);
	V_DatePanel.Parent := V_CalendarPanel;
	V_DatePanel.Left := 5;
	V_DatePanel.Width := 219;
	V_DatePanel.Height := 34;
	V_DatePanel.Top := 6;

	{Creating the Days Rack}
	for NumeroItem := 1 to 7 do
		begin
			V_DaysPanel[NumeroItem] := TPanel.Create(V_CalendarPanel);
			V_DaysPanel[NumeroItem].Parent := V_CalendarPanel;
		end;


	{Creating the Week Rack}
	for NumeroItem := 1 to 6 do
		begin
			V_WeekPanel[NumeroItem] := TPanel.Create(V_CalendarPanel);
			V_WeekPanel[NumeroItem].Parent := V_CalendarPanel;
		end;


	{CalendarPanel Settings}
	V_CalendarPanelSettings := TCalendarPanelSettings.Create(Self);

	{Selected Shape Settings}
	V_SelectedShapeSettings := TSelectedShapeSettings.Create(Self);

	{DatePanel Settings}
	V_DatePanelSettings := TDatePanelSettings.Create(Self);

       {DaySettings Values}
       V_DaySettings := TDaySettings.Create(Self);

       {Week Settings Values}
       V_WeekSettings := TWeekSettings.Create(Self);

       DrawWeekNumbersRack;
	DrawWeekDaysRack;
//	DrawDayNumbersRack;



	{Calendar Canvas Bounds}
	Width := 230;
	Height := 240;

	{First Enabled to let the object initialize}
	V_Enabled := True;

	{Date Related Actions}
	V_YearBase := year_2000;
	V_DateText := FormatDateTime('dd/mm/yyyy',Now);
	SincroDate;
	UpdateCalendar;

	{Database Related}
	V_DateFieldSettings := TDateFieldSettings.Create(Self);

	V_DateFieldLink := TFieldDataLink.Create;
	V_DateFieldLink.Control := Self;

	V_DaysFieldLink := TFieldDataLink.Create;
	V_DaysFieldLink.Control := Self;

	V_DateFieldLink.OnDataChange := DateDataChange;
	V_DateFieldLink.OnEditingChange := DateEditingChange;

	V_DaysFieldLink.OnDataChange := DaysDataChange;
	V_DaysFieldLink.OnEditingChange := DaysEditingChange;


	V_Loaded := False;
end;

destructor TARDBCalendar.Destroy;
var
	NumeroItem				: integer;
begin
	{Freeing Calendar Panel Values}
	V_CalendarPanelSettings.Free;

	{Freeing Selected Shape Settings}
	V_SelectedShapeSettings.Free;

	{Freeing DaySettings}
	V_DaySettings.Free;


	{Freeing Days Rack}
	for NumeroItem := 1 to 7 do
		begin
			V_DaysPanel[NumeroItem].Free;
		end;

	{Freeing Week Settings}
	V_WeekSettings.Free;

	{Freeing the Week Rack}
	for NumeroItem := 1 to 6 do
		begin
			V_WeekPanel[NumeroItem].Free;
		end;

	{Freeing the Day Buttons}
	for NumeroItem := 1 to 31 do
		begin
			V_DayButton[NumeroItem].Free;
		end;

	{Freeing the BitMap}
	V_DisabledBitmap.Free;		

	{Freeing the Selected Shape}
	V_SelectedShape.Free;

	{Freeing de Date Panel}
	V_DatePanel.Free;

	{Freeing the DatePanelSettings}
	V_DatePanelSettings.Free;

	{Freeing the Calendar Panel the last because it is the owner}
	V_CalendarPanel.Free;

	{DataBase Related}
	V_DateFieldSettings.Free;

	V_DateFieldLink.OnDataChange := nil;
	V_DateFieldLink.OnEditingChange := nil;

	V_DaysFieldLink.OnDataChange := nil;
	V_DaysfieldLink.OnEditingChange := nil;

	V_DateFieldLink.Free;
	V_DaysFieldLink.Free;


	{Destroy}
	inherited Destroy;
end;
procedure TARDBCalendar.PSetV_DisabledBitmap(Value: TBitMap);
begin
	if Value <> V_DisabledBitMap then
		begin
			V_DisabledBitMap.Assign(Value);
			RefreshDisabled(Self);
		end;
end;
procedure TARDBCalendar.RefreshDisabled(Sender: TObject);
var
	NumeroItem				: integer;
begin
	for NumeroItem := 1 to 31 do
		begin
			UpdateButton(NumeroItem);
		end;

end;


procedure TARDBCalendar.PSetV_CalendarPanelSettings(Value: TCalendarPanelSettings);
begin
	V_CalendarPanel.BevelInner := Value.cpv_BevelInner;
	V_CalendarPanel.BevelOuter := Value.cpv_BevelOuter;
       V_CalendarPanel.Color := Value.cpv_PanelColor;
end;

procedure TARDBCalendar.PSetV_SelectedShapeSettings(Value: TSelectedShapeSettings);
begin
	V_SelectedShape.Pen := Value.sel_Pen;
	V_SelectedShape.Brush := Value.sel_Brush;
       V_SelectedShape.Visible := Value.sel_Visible;
end;

procedure TARDBCalendar.PSetV_DatePanelSettings(Value: TDatePanelSettings);
begin
	V_DatePanel.BevelInner := Value.dpv_BevelInner;
	V_DatePanel.BevelOuter := Value.dpv_BevelOuter;
       V_DatePanel.Color := Value.dpv_PanelColor;
       V_DatePanel.Font := Value.dpv_DateFont;

end;

procedure TARDBCalendar.PSetV_DaySettings(Value: TDaySettings);
var
	NumeroItem				: integer;
begin
	case Value.day_SundayFirst of
       	True:
           	begin
				V_DaysPanel[2].Caption := Value.day_Monday;
				V_DaysPanel[3].Caption := Value.day_Tuesday;
				V_DaysPanel[4].Caption := Value.day_Wednesday;
				V_DaysPanel[5].Caption := Value.day_Thursday;
				V_DaysPanel[6].Caption := Value.day_Friday;
				V_DaysPanel[7].Caption := Value.day_Saturday;
				V_DaysPanel[1].Caption := Value.day_Sunday;

				for NumeroItem := 2 to 7 do
					begin
						V_DaysPanel[NumeroItem].Font := Value.day_WeekDayFont;
						V_DaysPanel[NumeroItem].Color := Value.day_WeekDayPanelColor;
					end;

				V_DaysPanel[1].Font := Value.day_SundayFont;
				V_DaysPanel[1].Color := Value.day_SundayPanelColor;

			end;
		False:
			begin
				V_DaysPanel[1].Caption := Value.day_Monday;
				V_DaysPanel[2].Caption := Value.day_Tuesday;
				V_DaysPanel[3].Caption := Value.day_Wednesday;
				V_DaysPanel[4].Caption := Value.day_Thursday;
				V_DaysPanel[5].Caption := Value.day_Friday;
				V_DaysPanel[6].Caption := Value.day_Saturday;
				V_DaysPanel[7].Caption := Value.day_Sunday;

                   for NumeroItem := 1 to 6 do
                   	begin
                       	V_DaysPanel[NumeroItem].Font := Value.day_WeekDayFont;
                           V_DaysPanel[NumeroItem].Color := Value.day_WeekDayPanelColor;
                       end;

				V_DaysPanel[7].Font := Value.Day_SundayFont;
                   V_DaysPanel[7].Color := Value.day_SundayPanelColor;

               end;
       end;

       for NumeroItem := 1 to 7 do
		begin
               with V_DaysPanel[NumeroItem] do
                   begin
                       BevelInner := Value.day_BevelInner;
                       BevelOuter := Value.day_BevelOuter;
                   end;
           end;

	for NumeroItem := 1 to 31 do
		begin
			with V_DayButton[NumeroItem] do
				begin
					Flat := Value.day_ButtonFlat;
				end;
		end;

	UpdateCalendar;

end;
procedure TARDBCalendar.PSetV_WeekSettings(Value: TWeekSettings);
var
	NumeroItem				: integer;
begin

	for NumeroItem := 1 to 6 do
		begin
			with V_WeekPanel[NumeroItem] do
				begin
					BevelInner := Value.week_BevelInner;
					BevelOuter := Value.week_BevelOuter;
					Font := Value.week_WeekFont;
					Color := Value.week_WeekPanelColor;
				end;
		end;

end;

{ ###################### Windows Messages #########################################}
procedure TARDBCalendar.WMPaint(var Message: TWMPaint);
begin
	if not V_Loaded then
		begin
			V_CalendarPanel.Enabled := V_Enabled;
			if V_DataAware then
				begin
					SetDBAwareStatus(V_Enabled);
					V_CalendarPanel.Enabled := V_DateFieldLink.Editing;
				end;
			V_Loaded := True;
			{Invoque the status change to initialize}
			PDoStatusChange;
			UpdateCalendar;
		end;
	inherited;
end;

{ ################################################################################33 }

procedure TARDBCalendar.DrawWeekDaysRack;
var
	NumeroItem				: integer;
	X_Offset				: integer;
	Y_Offset				: integer;
begin
	X_Offset := 30;
	Y_Offset := 44;

	for NumeroItem := 1 to 7 do
       	begin
           	with V_DaysPanel[NumeroItem] do
               	begin
		           	Left := X_Offset;
           		    Top := Y_Offset;
                       Width := week_DayPanelWidth;
                       Height := week_DayPanelHeight;
                   end;
               X_Offset := X_Offset + x_weekday_Panel_offset;
           end;

       PSetV_DaySettings(V_DaySettings);

end;

procedure TARDBCalendar.DrawWeekNumbersRack;
var
	NumeroItem				: integer;
       X_Offset				: integer;
       Y_Offset				: integer;
begin
       X_Offset := 4;
       Y_Offset := 72;

       for NumeroItem := 1 to 6 do
       	begin
           	with V_WeekPanel[NumeroItem] do
				begin
		           	Left := X_Offset;
           		    Top := Y_Offset;
                       Width := week_NumberPanelWidth;
                       Height := week_NumberPanelHeight;
                   end;
               Y_Offset := Y_Offset + y_weeknumber_Panel_offset;
           end;

	PSetV_WeekSettings(V_WeekSettings);

end;
procedure TARDBCalendar.DrawDayNumbersRack;
var
	NumeroItem				: integer;
       X_Offset				: integer;
	Y_Offset				: integer;
begin
	X_Offset := 31;
       Y_Offset := 73;

       for NumeroItem := 1 to 31 do
       	begin
           	with V_DayButton[NumeroItem] do
				begin
		           	Left := X_Offset;
					Top := Y_Offset;
                       Width := day_ButtonWidth;
                       Height := day_ButtonHeight;
                   end;

               X_Offset := X_Offset + x_day_Button_offset;

               V_dayButton[NumeroItem].Caption :=IntTostr(NumeroItem);

               if NumeroItem mod 7 = 0 then
               	begin
                   	X_Offset := 31;
                       Y_Offset := Y_Offset + y_day_Button_offset;
				end;

           end;

end;


function TARDBCalendar.InterPretDate(TextDate: string):string;
var
	DateHour				: TSystemTime;
	D_DateHour				: TDateTime;
begin
	{In the reason not to confuse the Delphi Date and the Date property of the object we make an APO call to get the current SystemTime}

	GetSystemTime(DateHour); {API}
	D_DateHour := SystemTimetoDateTime(DateHour); {Convert  API into Delphi}

	case Length(TextDate) of
		2: {dd}
			begin
				result := Format('%s/%s/%s',[TextDate,FormatDateTime('mm',D_DateHour),FormatDateTime('yyyy',D_DateHour)]);
				exit;
			end;
		4: {ddmm}
			begin
				result := Format('%s/%s/%s',[Copy(TextDate,1,2),Copy(TextDate,3,2),FormatDateTime('yyyy',D_DateHour)]);
				exit;
			end;
		5: {dd/mm}
			begin
				result := Format('%s/%s/%s',[Copy(TextDate,1,2),Copy(TextDate,4,2),FormatDateTime('yyyy',D_DateHour)]);
				exit;
			end;
		6: {ddmmyy}
			begin
                   case V_YearBase of
                   	year_1900:
                       	begin
							result := Format('%s/%s/19%s',[Copy(TextDate,1,2),Copy(TextDate,3,2),Copy(TextDate,5,2)]);
							exit;
                           end;
					year_2000:
                       	begin
							result := Format('%s/%s/20%s',[Copy(TextDate,1,2),Copy(TextDate,3,2),Copy(TextDate,5,2)]);
							exit;
                           end;
                   end;
			end;
		8:
			begin
               	{dd/mm/yy}
               	if Pos('/',TextDate) <> 0 then
                   	begin
						case V_YearBase of
							year_1900:
                               	begin
			                       	result := Format('%s/%s/19%s',[Copy(TextDate,1,2),Copy(TextDate,4,2),Copy(TextDate,7,2)]);
               			            exit;

								end;
							year_2000:
                               	begin
			                       	result := Format('%s/%s/20%s',[Copy(TextDate,1,2),Copy(TextDate,4,2),Copy(TextDate,7,2)]);
               			            exit;
                                   end;
                           end;
                       end
                   else
					{ddmmyyyy}
					begin
						result := Format('%s/%s/%s',[Copy(TextDate,1,2),Copy(TextDate,3,2),Copy(TextDate,5,4)]);
						exit;
                       end;
			end;
	else
		begin
			result := TextDate;
		end;
	end;


end;

function TARDBCalendar.InterPretMonthYear(TextDate: string):string;
var
	DateHour				: TSystemTime;
	D_DateHour				: TDateTime;
begin
	{In the reason not to confuse the Delphi Date and the Date property of the object we make an APO call to get the current SystemTime}

	GetSystemTime(DateHour); {API}
	D_DateHour := SystemTimetoDateTime(DateHour); {Convert  API into Delphi}

	case Length(TextDate) of
		2: {mm}
			begin
				result := Format('%s/%s',[TextDate,FormatDateTime('yyyy',D_DateHour)]);
				exit;
			end;
		4: {mmyy}
			begin
				case V_YearBase of
                   	year_1900:
                       	begin
							result := Format('%s/19%s',[Copy(TextDate,1,2),Copy(TextDate,3,2)]);
							exit;
                           end;
                       year_2000:
						begin
							result := Format('%s/20%s',[Copy(TextDate,1,2),Copy(TextDate,3,2)]);
							exit;
                           end;
				end;
			end;
		5: {mm/yy}
			begin
               	case V_YearBase of
                   	year_1900:
                       	begin
							result := Format('%s/19%s',[Copy(TextDate,1,2),Copy(TextDate,4,2)]);
							exit;
                           end;
                       year_2000:
						begin
							result := Format('%s/20%s',[Copy(TextDate,1,2),Copy(TextDate,4,2)]);
							exit;
                           end;
                   end;
			end;
		6: {mmyyyy}
			begin
				result := Format('%s/%s',[Copy(TextDate,1,2),Copy(TextDate,3,4)]);
				exit;
			end;
	else
		begin
			result := TextDate;
		end;
	end;


end;

{This are common PSet's for setting the DateText and MonthYear Settings. this is because I don't want the user to be capable to edit the Value if we are in DataAware mode}
procedure TARDBCalendar.CommonPSetV_DateText(Value: string);
begin
	Value := InterPretDate(Value);
	if Length(Value) <> 10 then
		begin
			exit;
		end
	else
		begin
			try
				StrtoDateTime(Value);
			except
				exit;
			end;
		end;

	V_DateText := Value;
	SincroDate;
	UpdateCalendar;
end;

procedure TARDBCalendar.CommonPSetV_MonthYear(Value: string);
begin
	Value := InterPretMonthYear(Value);
	if Length(Value) <> 7 then
		begin
			Value := FormatDateTime('mm/yyyy',Now);
		end;

	V_MonthYear := Value;
	CommonPSetV_DateText(Format('%s/%s',[FormatDatetime('dd',Now),V_MonthYear]));
	{Date is Sincronized at Here ^]}

end;

procedure TARDBCalendar.PSetV_DateText(Value: string);
begin
	if V_DataAware then
		exit;

	CommonPSetV_DateText(Value);
end;

procedure TARDBCalendar.PSetV_MonthYear(Value: string);
begin
	if V_DataAware then
		exit;


	CommonPSetV_MonthYear(Value);

end;

procedure TARDBCalendar.PSetV_Enabled(Value: boolean);
begin
	if Value <> V_Enabled then
		begin
			if V_DataAware then
				begin
					if V_DateFieldLink.Editing then
						exit;

					SetDBAwareStatus(Value);						

					V_Enabled := Value;					
				end
			else
				begin
					V_Enabled := Value;
					V_CalendarPanel.Enabled := Value;
				end;
		end;
end;

procedure TARDBCalendar.SincroDate;
begin
	Date := StrToDateTime(V_DateText);
       V_MonthYear := FormatDateTime('mm/yyyy',Date);
end;

function TARDBCalendar.IsLeapYear(V_Year: Integer): Boolean;
begin
	Result := (V_Year mod 4 = 0) and ((V_Year mod 100 <> 0) or (V_Year mod 400 = 0));
end;

function TARDBCalendar.DaysPerMonth(V_Year, V_Month: Integer): Integer;
const
	DaysInMonth: array[1..12] of Integer = (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
begin
	Result := DaysInMonth[V_Month];
	if (V_Month = 2) and IsLeapYear(V_Year) then
       	Inc(Result);
end;

function TARDBCalendar.WeekNo(V_Year: word; V_Month: word; V_Day: word ): Integer;
var
	FirstDate				: TDate;
	LastDate				: TDate;
	WeekNumber				: integer;
	DayPos					: integer;
begin
	{To get the week numbers we count the Sundays until we reached the date}
	WeekNumber := 1;

	FirstDate := EncodeDate(V_Year,1,1);

	{All 31 buttons go to here so if they are outside bounds,, we ignore}
	if V_Day > DaysPerMonth(V_Year,V_Month) then
		exit;


	LastDate := EncodeDate(V_Year,V_Month,V_Day);


	if FirstDate = LastDate then
		begin
			WeekNo := WeekNumber;
			exit;
		end;

	repeat
		DayPos := DayOfWeek(FirstDate);
		if DayPos = 1 then
			inc(WeekNumber);

		FirstDate := FirstDate + 1;
	until FirstDate >= LastDate;
	WeekNo := WeekNumber;

end;

procedure TARDBCalendar.PDoDayClick(Sender: TObject);
var
	V_DaysString			: string;
	AllowChange				: boolean;
	V_LastDayStatus			: TDayStatus;
begin
	{We store de Day Status because if there is assigned a OnDayclick and programmer does not allow the change we can put again de Status to its original state}
	V_LastDayStatus := TARCalendarButton(Sender).DayStatus;

	{Change the button status according to it's actual status}	
	case TARCalendarButton(Sender).DayStatus of
		day_Selected:
			begin
				TARCalendarButton(Sender).DayStatus := day_Disabled;
				UpdateButton(TARCalendarButton(Sender).Day);
			end;
		day_UnSelected:
			begin
				TARCalendarButton(Sender).DayStatus := day_Selected;
				UpdateButton(TARCalendarButton(Sender).Day);
			end;
		day_Disabled:
			begin
				TARCalendarButton(Sender).DayStatus := day_UnSelected;
				UpdateButton(TARCalendarButton(Sender).Day);

			end;
	end;

       {if there is an event for day click... then do it !}
	if Assigned(V_OnDayClick) then
		begin
			AllowChange := True;
			V_OnDayClick(Sender,
						TARCalendarButton(Sender).Day,
						TARCalendarButton(Sender).Month,
						TARCalendarButton(Sender).Year,
						TARCalendarButton(Sender).Week,
						TARCalendarButton(Sender).DayStatus,
						AllowChange);
			{if programmer does not allow the change then put button according to its original state before clicking}
			if not AllowChange then
				begin
					TARCalendarButton(Sender).DayStatus := V_LastDayStatus;
					UpdateButton(TARCalendarButton(Sender).Day);
					{it does not matter if we are in DataAware mode... we have to exit because there are no changes}
					exit;
				end;
		end;


	{If in DataAware mode update the changes}
	if V_DataAware then
		begin
			if V_DaysFieldLink.Editing then
				begin
					{Getting the hole field}
					V_DaysString := V_DaysFieldLink.Field.AsString;
					{Depending on the Current Status update the day position}
					case TARCalendarButton(Sender).DayStatus of
						day_Selected:
							begin
								V_DaysString[TARCalendarButton(Sender).Day] := V_DateFieldSettings.dtf_SelectedValue[1];
							end;
						day_Unselected:
							begin
								V_DaysString[TARCalendarButton(Sender).Day] := V_DateFieldSettings.dtf_UnSelectedValue[1];
							end;
						day_Disabled:
							begin
								V_DaysString[TARCalendarButton(Sender).Day] := V_DateFieldSettings.dtf_DisabledValue[1];
							end;
					end;
					{Store}
					V_DaysFieldLink.Field.AsString := V_DaysString;
				end;
		end;

	{Inform the Status}
	PDoStatusChange;

end;
procedure TARDBCalendar.PSetV_YearBase(Value: TYearBase);
begin
	if Value <> V_YearBase then
		begin
			V_YearBase := Value;
		end;
end;
procedure TARDBCalendar.SetDBAwareStatus(Value: boolean);
var
	NumeroItem				: integer;
begin
	 case Value of
		True:
			begin
				{We hace to enabled the object first because on DayDataChange and DateDateChange this value is checked}
				V_Enabled := Value;
				V_SelectedShape.Visible := V_SelectedShapeSettings.sel_Visible;
				DaysDataChange(Self);
				DateDataChange(Self);
				exit;
			end;
		False:
			begin
				V_DatePanel.Caption := '';
				for NumeroItem := 1 to 31 do
					begin
						V_DayButton[NumeroItem].Visible := False;
						V_DayButton[NumeroItem].Glyph.Assign(Nil);
						V_DayButton[NumeroItem].Caption := '';
					end;
				for NumeroItem := 1 to 6 do
					begin
						V_WeekPanel[NumeroItem].Caption := '';
					end;

				V_SelectedShape.Visible := False;

				V_Enabled := Value;
				exit;

			end;
	 end;

end;


procedure TARDBCalendar.UpdateCalendar;
var
	V_DayOfWeek				: integer;
	V_DaysMonth				: integer;
	V_WeekNumber			: integer;
	NumeroItem				: integer;
	X_Offset				: integer;
	Y_Offset				: integer;
	FirstDate				: TDateTime;
	V_Year,V_Month,V_Day	: word;
	V_I_Year,V_I_Month		: integer;
	V_Text					: string;

begin
	if Assigned(V_DatePanelChange) then
		begin
			V_Text := FormatDateTime('mmmm yyyy',Date);
			V_DatePanelChange(Self,V_Text,Date);
			V_DatePanel.Caption := V_Text;
		end
	else
		begin
			V_DatePanel.Caption := FormatDateTime('mmmm yyyy',Date);
		end;


	DecodeDate(Date,V_Year,V_Month,V_Day);
	FirstDate := EncodeDate(V_Year,V_Month,1);
	V_DaysMonth := DaysPerMonth(V_Year,V_Month);
	{This is for the Day Button.. because they values are integer... if we pass a word value it is always cero.. don't know why... Week and Day numbers are allready integer}
	V_I_Year := V_Year;
	V_I_Month := V_Month;


	case V_DaySettings.V_SundayFirst of
		True:
			begin
				V_DayOfWeek := DayOfWeek(FirstDate);

			end;
		False:
			begin
				V_DayOfWeek := DayOfWeek(FirstDate);
				dec(V_DayOfWeek);

				{if it was Sunday then correct}
				if V_DayOfWeek = 0 then
					V_DayOfWeek := 7;
			end;
	end;



	X_Offset := 31 + (x_day_Button_offset * (V_DayOfWeek-1));
       Y_Offset := 73;


	for NumeroItem := 1 to 31 do
       	begin

               {Font and Colors For Sunday and week days}
               case V_DaySettings.day_SundayFirst of
               	True:
                   	begin
                       	if V_DayOfWeek = 1 then
                           	begin
								V_DayButton[NumeroItem].Font := V_DaySettings.day_SundayButtonFont;
                               end
                           else
                           	begin
			                   	V_DayButton[NumeroItem].Font := V_DaySettings.day_DayButtonFont;
                               end;
					end;
                   False:
                   	begin
                       	if V_DayOfWeek = 7 then
							begin
								V_DayButton[NumeroItem].Font := V_DaySettings.day_SundayButtonFont;
                               end
                           else
                           	begin
			                   	V_DayButton[NumeroItem].Font := V_DaySettings.day_DayButtonFont;                               
                               end;
                       end;
               end;

               {Putting the Selected Shape to the coordinates}
               if V_Day = NumeroItem then
               	begin
                   	V_SelectedShape.Left := X_Offset - 8;
                       V_SelectedShape.Top := Y_Offset - 3; 
                   end;


			{if OutSite of Number of Days in Month then make it invisible}

           	if NumeroItem > V_DaysMonth then
               	begin
	               	V_DayButton[NumeroItem].Visible := False;
					V_DayButton[NumeroItem].Caption := '';
					V_DayButton[NumeroItem].Invalidate;
				end
               else
               	begin
	               	V_DayButton[NumeroItem].Visible := True;
		            V_DayButton[NumeroItem].Caption :=Format('%d',[NumeroItem]);
				end;

               {Location at the Calendar of each day}
			with V_DayButton[NumeroItem] do
				begin
					Left := X_Offset;
					Top := Y_Offset;
					Width := day_ButtonWidth;
					Height := day_ButtonHeight;
				end;

			X_Offset := X_Offset + x_day_Button_offset;

			inc(V_DayOfWeek);

			{if the week as finished the go to another row}
			if V_DayOfWeek = 8 then
				begin
					V_DayOfWeek := 1;
					X_Offset := 31;
					Y_Offset := Y_Offset + y_day_Button_offset;
				end;

			{Assign the Month,Day,Year,week value to each day button}
			V_WeekNumber := WeekNo(V_Year,V_Month,NumeroItem);
			with V_DayButton[NumeroItem] do
				begin
					Day := NumeroItem;
					Month := V_I_Month;
					Year := V_I_Year;
					Week := V_WeekNumber;
				end;

		end;


	V_WeekNumber := WeekNo(V_Year,V_Month,1);
	for NumeroItem := 1 to 6 do
		begin
			V_WeekPanel[NumeroItem].Caption := Format('%.2d',[V_WeekNumber]);
			inc(V_WeekNumber);
		end;


end;

procedure TARDBCalendar.UpdateButtonStatus(ButtonValues: string);
var
	NumeroItem				: integer;
	DayValue				: string;
begin
	for NumeroItem := 1 to 31 do
		begin
			DayValue := ButtonValues[NumeroItem];
			if DayValue[1] = V_DateFieldSettings.dtf_SelectedValue[1] then
				begin
					V_DayButton[NumeroItem].DayStatus := day_Selected;
				end;

			if DayValue[1] = V_DateFieldSettings.dtf_UnSelectedValue[1] then
				begin
					V_DayButton[NumeroItem].DayStatus := day_UnSelected;
				end;

			if DayValue[1] = V_DateFieldSettings.dtf_DisabledValue[1] then
				begin
					V_DayButton[NumeroItem].DayStatus := day_Disabled;
				end;

			UpdateButton(NumeroItem);
		end;

	{Inform the StatusChange}
	PDoStatusChange;

end;

procedure TARDBCalendar.UpdateButton(ButtonNumber: integer);
begin
	case V_DayButton[ButtonNumber].DayStatus of
		day_Selected:
			begin
				with V_DayButton[ButtonNumber] do
					begin
						Glyph.Assign(nil);
						Down := True;
						Caption := IntToStr(Day);
					end;
			end;
		day_UnSelected:
			begin
				with V_DayButton[ButtonNumber] do
					begin
						Glyph.Assign(nil);
						Down := False;
						Caption := IntToStr(Day);
					end;
			end;
		day_Disabled:
			begin
				with V_DayButton[ButtonNumber] do
					begin
						if V_DisabledBitMap.Empty then
							begin
								Glyph.Assign(nil);							
								Down := False;
								Caption := 'X';
							end
						else
							begin
								Down := False;
								Caption := '';
								Glyph.Assign(V_DisabledBitMap);
							end;
					end;
			end;
	end;


end;

function TARDBCalendar.InitCalendar(var CreateDate: TDateTime;var CreateDateFormat: string; var CreateScheme: array of TDayStatus):boolean;
var
	NumeroItem				: integer;
	A_DateText				: string;
begin
	if V_DataAware then
		begin
			InitCalendar := False;
			exit;
		end;

	if CreatedateFormat = '' then
		begin
			InitCalendar := False;
			exit;
		end;

	if SizeOf(CreateScheme) < 41 then
		begin
			InitCalendar := False;
			exit;
		end;

	try
		A_DateText := FormatDateTime(CreateDateFormat,CreateDate);
	except
		InitCalendar := False;
		exit;
	end;

	CommonPSetV_DateText(A_DateText);

	for NumeroItem := 1 to 31 do
		begin
			V_DayButton[NumeroItem].DayStatus := CreateScheme[NumeroItem];
			UpdateButton(NumeroItem);
		end;

	{Notify the Status Change}
	PDoStatusChange;

	InitCalendar := True;
end;

function TARDBCalendar.GetCalendarScheme(var CreateDate: TDateTime ;var MonthYear: string; var CalendarScheme: array of TDayStatus):boolean;
var
	NumeroItem				: integer;
begin

	if (V_DataAware) and (not V_Enabled) then
		begin
			GetCalendarScheme := False;
			exit;
		end;
		
	if SizeOf(CalendarScheme) < 41 then
		begin
			GetCalendarScheme := False;
			exit;
		end;

	CreateDate := Date;
	MonthYear := MonthYear;
	FillChar(CalendarScheme,SizeOf(CalendarScheme),day_UnSelected);	
	for NumeroItem := 1 to 31 do
		begin
			CalendarScheme[NumeroItem] := V_DayButton[NumeroItem].DayStatus;
		end;

	GetCalendarScheme := True;

end;

procedure TARDBCalendar.PDoStatusChange;
var
	NumeroItem				: integer;
	S_Selected				: integer;
	S_UnSelected			: integer;
	S_Disabled				: integer;
begin
		
	S_Selected := 0;
	S_UnSelected := 0;
	S_Disabled := 0;
	for NumeroItem := 1 to 31 do
		begin
			case V_DayButton[NumeroItem].DayStatus of
				day_Selected:
					begin
						inc(S_Selected);
					end;
				day_UnSelected:
					begin
						inc(S_UnSelected);
					end;
				day_Disabled:
					begin
						inc(S_Disabled);
					end;
			end;
		end;

	if Assigned(V_StatusChange) then
		begin
			V_StatusChange(Self,S_Selected,S_UnSelected,S_Disabled);
		end;

	V_DaySettings.V_Selected := S_Selected;
	V_DaySettings.V_UnSelected := S_UnSelected;
	V_DaySettings.V_Disabled := S_Disabled;
end;

{ ########################### DATA BASE RELATED ##############################}


procedure TARDBCalendar.Notification(AComponent: TComponent;Operation: TOperation);
begin
	inherited Notification(AComponent, Operation);
end;

procedure TARDBCalendar.PSetV_DateFieldSettings(const Value: TDateFieldSettings);
begin
//
end;

{ Datasource Assign }
function TARDBCalendar.GetDataSource: TDataSource;
begin
	GetDataSource := V_DateFieldLink.DataSource;
end;

procedure TARDBCalendar.SetDataSource(Value: TDataSource);
begin
	V_DateFieldLink.DataSource := Value;
	V_DaysFieldLink.DataSource := Value;
end;

{Date Field Related}

function TARDBCalendar.GetDateField: string;
begin
	GetDateField := V_DateFieldLink.FieldName;
end;

procedure TARDBCalendar.SetDateField(const Value: string);
begin
	V_DateFieldLink.FieldName := Value;
end;

procedure TARDBCalendar.DateDataChange(Sender: TObject);
begin
	if not V_DateFieldLink.Active then
		begin
			V_DataAware := False;
			exit;
		end
	else
		begin
			V_DataAware := True;

			if Not V_Enabled then
				exit;

			{If DataSet is Different that Browsing then we don't need to update nothing.. this event is always triggered at any DataSet Op...} 
			if V_DateFieldLink.DataSet.State <> dsBrowse then
				exit;

			case V_DateFieldSettings.dtf_DateFormat of
				dat_MonthYear:
					begin
						CommonPSetV_MonthYear(V_DateFieldLink.Field.AsString);
					end;
				dat_FullDate:
					begin
						CommonPSetV_DateText(V_DateFieldLink.Field.AsString);
					end;
			end;
		end;
end;

procedure TARDBCalendar.DateEditingChange(Sender: TObject);
begin
	if not V_Enabled then
		exit;
		
	V_CalendarPanel.Enabled := V_DateFieldLink.Editing;
end;


{Days Field Related}
function TARDBCalendar.GetDaysField: string;
begin
	GetDaysField := V_DaysFieldLink.FieldName;
end;

procedure TARDBCalendar.SetDaysField(const Value: string);
begin
	V_DaysFieldLink.FieldName := Value;
end;

procedure TARDBCalendar.DaysDataChange(Sender: TObject);
var
	V_DaysString			: string;
	NumeroItem				: integer;
	CreateScheme			: array[0..31] of TDayStatus; {I had to make it from 0 to 31 because otherwise the array 1 was ignored when passing thru the event}
	CreateDate				: TDateTime;
	CreateDateFormat		: string;
begin

	{if not Active Disable the DataAware part}
	if not V_DaysFieldLink.Active then
		begin
			V_DataAware := False;
			exit;
		end
	else
		begin
			V_DataAware := True;

			if not V_Enabled then
				exit;

			{If DataSet is Different that Browsing then we don't need to update nothing.. this event is always triggered at any DataSet Op...}
			if V_DaysFieldLink.DataSet.State <> dsBrowse then
				exit;

			V_DaysString := V_DaysFieldLink.Field.AsString;

			{if the Day String is not of the Lenght than expected then raise the V_DaysReadError event}
			if (Length(V_DaysString) <> 0) AND (Length(V_DaysString) <> 31) then
				begin
					if Assigned(V_DaysReadError) then
						begin
							V_DaysReadError(Self);
						end;
					exit;
				end;

			{if it is not initialized then}
			if Length(V_DaysString) = 0 then
				begin
					{Initialize...}
					For NumeroItem := 1 to 31 do
						begin
							CreateScheme[NumeroItem] := day_UnSelected;
						end;

					CreateDate := Now;
					CreateDateFormat := 'dd/mm/yyyy';

					{If there is an Creating Scheme Assigned... then Execute}
					if Assigned(V_CreatingScheme) then
						begin
							V_CreatingScheme(Self,CreateDate,CreateDateFormat,CreateScheme);
						end;


					if CreateDateFormat = '' then
						CreateDateFormat := 'dd/mm/yyyy';

					{Convert the Creating Scheme into String Values}
					V_DaysString := '';
					for NumeroItem := 1 to 31 do
						begin
							case CreateScheme[NumeroItem] of
								day_Unselected:
									begin
										V_DaysString := V_DaysString + V_DateFieldSettings.dtf_UnselectedValue;
									end;
								day_Selected:
									begin
										V_DaysString := V_DaysString + V_DateFieldSettings.dtf_SelectedValue;
									end;
								day_Disabled:
									begin
										V_DaysString := V_DaysString + V_DateFieldSettings.dtf_DisabledValue;
									end;
							end;
						end;
					if V_DaysFieldLink.Editing then
						begin
							try
								V_DaysFieldLink.Field.AsString := V_DaysString;
							except
								if Assigned(V_EditingError) then
									begin
										V_EditingError(Self);
									end;
							end;

						end
					else
						begin
							if Assigned(V_EditingError) then
								begin
									V_EditingError(Self);
								end;
						end;

					if V_DateFieldLink.Editing then
						begin
							case V_DateFieldLink.Field.DataType of
								ftString:
									begin
										try
											V_DateFieldLink.Field.AsString := FormatDateTime(CreateDateFormat,CreateDate);
										except
											if Assigned(V_EditingError) then
												begin
													V_EditingError(Self);
												end;
										end;
									end;
								ftDate:
									begin
										try
											V_DateFieldLink.Field.Value := CreateDate;
										except
											if Assigned(V_EditingError) then
												begin
													V_EditingError(Self);
												end;
										end;
									end;
								else
									begin
										if Assigned(V_EditingError) then
											begin
												V_EditingError(Self);
											end;
									end;
							end;
						end
					else
						begin
							if Assigned(V_EditingError) then
								begin
									V_EditingError(Self);
								end;
						end;

				end;

			UpdateButtonStatus(V_DaysString);

		end;

end;

procedure TARDBCalendar.DaysEditingChange(Sender: TObject);
begin
	if not V_Enabled then
		exit;
		
	V_CalendarPanel.Enabled := V_DaysFieldLink.Editing;
end;


procedure TARDBCalendar.CopyRight;
var
	VForm				: TForm;
	VButton				: TButton;
	VLabel				: TLabel;
	VLabel1				: TARUrlLabel;
	VLabel2				: TARUrlLabel;
	VImage				: TImage;
begin
	VForm := TForm.Create(nil);
	VButton := TButton.Create(VForm);
	VLabel := TLabel.Create(VForm);
	VLabel1 := TARUrlLabel.Create(VForm);
	VLabel2 := TARUrlLabel.Create(VForm);
	VImage := TImage.Create(VForm);

	VButton.Width := 60;
	VButton.Height := 21;
	VButton.Left := 126;
	VButton.Top := 140;
	VButton.Caption := 'Ok';
	VButton.ModalResult := mrOk;
	Vbutton.Parent := VForm;

	VLabel.Width := 250;
	VLabel.Height := 205;
	VLabel.Left := 64;
	VLabel.Top := 4;
	VLabel.AutoSize := False;
	VLabel.Caption := 'ARDBCalendar. The object that let''s you work with '+#10
					 +'data aware mode and single mode at the same time.  '+#10
					 +'This object is completely Free to use. Please look at'+#10
					 +'the copyright notice at the source code for the legal'+#10
					 +'Stuff. Enjoy it !'+#10+#10+'E-Mail:'+#10+#10+'WWW:';
	VLabel1.Left := 100;
	VLabel1.Top := 82;

	VLabel2.Left := 100;
	VLabel2.Top := 108;

	VLabel1.Url := 'albertrs@redestb.es';
	VLabel1.Caption := 'albertrs@redestb.es';
	VLabel1.UrlType := url_mailto;

	VLabel2.Url := 'http://personal.redestb.es/albertrs';
	VLabel2.Caption := 'http://personal.redestb.es/albertrs';
	VLabel2.URLType := url_http;

	VLabel.Parent := VForm;
	VLabel1.Parent := VForm;
	VLabel2.Parent := VForm;
	VImage.Parent := VForm;
	VImage.Transparent := True;
	
	VImage.Top := 10;
	VImage.Left := 10;

	VImage.Picture.Bitmap.LoadFromResourceID(HInstance,101);

	VForm.BorderStyle := bsToolWindow;
	VForm.Width := 320;
	VForm.Height := 190;
	VForm.Position := poScreenCenter;
	VForm.Caption := 'Albert Research 98 ARDBCalendar V2.0';
	VForm.ShowModal;

end;





end.


