// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'AppRun.pas' rev: 3.00

#ifndef AppRunHPP
#define AppRunHPP
#include <Dialogs.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Apprun
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TAppRunnerSpyThread;
class DELPHICLASS TAppRunner;
class PASCALIMPLEMENTATION TAppRunner : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	System::AnsiString FApplicationName;
	System::AnsiString FCommandLine;
	_SECURITY_ATTRIBUTES FProcessAttributes;
	_SECURITY_ATTRIBUTES FThreadAttributes;
	bool FInheritHandles;
	int FCreationFlags;
	void *FEnvironment;
	System::AnsiString FCurrentDirectory;
	_STARTUPINFOA FStartupInfo;
	_PROCESS_INFORMATION FProcessInformation;
	bool FIdle;
	bool FTerminated;
	int FAppExitCode;
	Classes::TNotifyEvent FOnIdle;
	Classes::TNotifyEvent FOnTerminated;
	
protected:
	TAppRunnerSpyThread* Spy;
	
public:
	__property _SECURITY_ATTRIBUTES ProcessAttributes = {read=FProcessAttributes, write=FProcessAttributes
		};
	__property _SECURITY_ATTRIBUTES ThreadAttributes = {read=FThreadAttributes, write=FThreadAttributes
		};
	__property bool InheritHandles = {read=FInheritHandles, write=FInheritHandles, default=0};
	__property int CreationFlags = {read=FCreationFlags, write=FCreationFlags, nodefault};
	__property void * Environment = {read=FEnvironment, write=FEnvironment, default=0};
	__property _STARTUPINFOA StartupInfo = {read=FStartupInfo, write=FStartupInfo};
	__property _PROCESS_INFORMATION ProcessInformation = {read=FProcessInformation};
	
__published:
	__property System::AnsiString ApplicationName = {read=FApplicationName, write=FApplicationName};
	__property System::AnsiString CommandLine = {read=FCommandLine, write=FCommandLine};
	__property System::AnsiString CurrentDirectory = {read=FCurrentDirectory, write=FCurrentDirectory};
		
	
protected:
	DYNAMIC void __fastcall DoIdle(void);
	
public:
	__property bool Idle = {read=FIdle, nodefault};
	
__published:
	__property Classes::TNotifyEvent OnIdle = {read=FOnIdle, write=FOnIdle};
	
protected:
	DYNAMIC void __fastcall DoTerminated(void);
	
public:
	__property bool Terminated = {read=FTerminated, nodefault};
	__property int AppExitCode = {read=FAppExitCode, nodefault};
	
__published:
	__property Classes::TNotifyEvent OnTerminated = {read=FOnTerminated, write=FOnTerminated};
	
public:
	__fastcall virtual TAppRunner(Classes::TComponent* AOwner);
	__fastcall virtual ~TAppRunner(void);
	bool __fastcall Execute(void);
};

class PASCALIMPLEMENTATION TAppRunnerSpyThread : public Classes::TThread 
{
	typedef Classes::TThread inherited;
	
protected:
	TAppRunner* AppRunner;
	int AppExitCode;
	void __fastcall DoIdle(void);
	void __fastcall DoTerminated(void);
	
public:
	virtual void __fastcall Execute(void);
public:
	/* TThread.Create */ __fastcall TAppRunnerSpyThread(bool CreateSuspended) : Classes::TThread(CreateSuspended
		) { }
	/* TThread.Destroy */ __fastcall virtual ~TAppRunnerSpyThread(void) { }
	
};

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall Register(void);

}	/* namespace Apprun */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Apprun;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// AppRun
