{******************************************************************************}
{*                                                                            *}
{*             Adirondack Software & Graphics Global Vars Unit                *}
{*            (C) Copyright Adirondack Software & Graphics 1997               *}
{*                                                                            *}
{******************************************************************************}
{Listing Four}
unit Entdlg;  {Unit to Enter Configuration Data}

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SetCfg, SelDir;

type
  TSetCfgDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    ProgOption1: TCheckBox;
    Label1: TLabel;
    InstPath: TEdit;
    SpeedButton1: TSpeedButton;
    Label2: TLabel;
    FilePath: TEdit;
    SpeedButton2: TSpeedButton;
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function Execute: boolean;
  end;

var
  SetCfgDlg: TSetCfgDlg;

implementation
uses Main, ChooseDir;

{$R *.DFM}

function TSetCfgDlg.Execute: boolean;
begin
  If ShowModal=mrOK then begin
    MainForm.InstallPath := InstPath.Text;
    MainForm.FilePath := FilePath.Text;
    MainForm.ProgOptEnabled := ProgOption1.Checked;
    result := true;
  end
  else result := false;
end;

procedure TSetCfgDlg.SpeedButton1Click(Sender: TObject);
begin
   DirDlg.ShowModal;
   InstPath.Text := DirDlg.Directory;
end;

procedure TSetCfgDlg.SpeedButton2Click(Sender: TObject);
begin
   DirDlg.ShowModal;
   FilePath.Text := DirDlg.Directory;
end;

end.
