{******************************************************************************}
{*                                                                            *}
{*                 Adirondack Software & Graphics Splash Unit                 *}
{*            (C) Copyright Adirondack Software & Graphics 1997               *}
{*                                                                            *}
{******************************************************************************}

unit Splash;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, INIFiles, ComCtrls, Feedback;

type
  TSplashForm = class(TForm)
    Panel1: TPanel;
    Image1: TImage;
    Bevel1: TBevel;
    UserNameLbl: TLabel;
    ProgramLabel: TLabel;
    Version: TLabel;
    Label1: TLabel;
    Label6: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label2: TLabel;
    Label7: TLabel;
    Label3: TLabel;
    Label10: TLabel;
    Label12: TLabel;
    Label5: TLabel;
    UserLbl: TLabel;
    Label4: TLabel;
    CompanyLbl: TLabel;
    Label13: TLabel;
    SerialNoLbl: TLabel;
    Copyright: TLabel;
    Label11: TLabel;
    Label8: TLabel;
    procedure OKButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function ReadConfigInfo: boolean;
  end;

var
  SplashForm  : TSplashForm;
  UserName    : String;
  Company     : String;
  SerialNumber: String;
  Password    : String;
  
implementation

{$R *.DFM}

{==============================================================================}
procedure TSplashForm.OKButtonClick(Sender: TObject);
{==============================================================================}
begin
   Close;
end;

{==============================================================================}
function TSplashForm.ReadConfigInfo: boolean;
{==============================================================================}
var
  ApprehendIni: TIniFile;
begin
  ApprehendIni := TIniFile.Create(ExtractFilePath(Application.EXEName) + 'Apprehend.Ini');
  with ApprehendIni do
  begin
      UserName := ReadString('User Info', 'User', 'Unregistered User');
      Company  := ReadString('User Info', 'Company', 'Unregistered Company');
      Password := ReadString('User Info', 'Password', 'Unregistered Password');
      SerialNumber := ReadString('User Info', 'Serial Number', 'Unregistered Password');
    end;
  ApprehendIni.Free;
  Userlbl.Caption := UserName;
  Companylbl.Caption := Company;
  SerialNolbl.Caption := SerialNumber;
end;

procedure TSplashForm.FormCreate(Sender: TObject);
begin
   ReadConfigInfo;
end;

end.
