unit DemoProp;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ComCtrls, ExtCtrls;

type
  TPropDlg = class(TForm)
    pnlPages: TPanel;
    pnlBottom: TPanel;
    pgcMain: TPageControl;
    tabPosition: TTabSheet;
    grpEdge: TGroupBox;
    optEdgeFloat: TRadioButton;
    optEdgeLeft: TRadioButton;
    optEdgeTop: TRadioButton;
    optEdgeRight: TRadioButton;
    optEdgeBottom: TRadioButton;
    grpFlags: TGroupBox;
    chkAllowFloat: TCheckBox;
    chkAllowLeft: TCheckBox;
    chkAllowTop: TCheckBox;
    chkAllowRight: TCheckBox;
    chkAllowBottom: TCheckBox;
    tabAppearance: TTabSheet;
    chkAlwaysOnTop: TCheckBox;
    chkAutohide: TCheckBox;
    tabSizing: TTabSheet;
    tabDocking: TTabSheet;
    tabFloating: TTabSheet;
    lblHorzSizeInc: TLabel;
    lblVertSizeInc: TLabel;
    edtHorzSizeInc: TEdit;
    edtVertSizeInc: TEdit;
    lblZeroIncHint: TLabel;
    updHorzSizeInc: TUpDown;
    updVertSizeInc: TUpDown;
    lblDockTop: TLabel;
    lblDockLeft: TLabel;
    lblDockRight: TLabel;
    lblDockBottom: TLabel;
    edtDockLeft: TEdit;
    edtDockTop: TEdit;
    edtDockRight: TEdit;
    edtDockBottom: TEdit;
    updDockLeft: TUpDown;
    updDockTop: TUpDown;
    updDockRight: TUpDown;
    updDockBottom: TUpDown;
    grpFloatCoords: TGroupBox;
    lblFloatLeft: TLabel;
    edtFloatLeft: TEdit;
    updFloatLeft: TUpDown;
    lblFloatTop: TLabel;
    edtFloatTop: TEdit;
    updFloatTop: TUpDown;
    lblFloatRight: TLabel;
    edtFloatRight: TEdit;
    updFloatRight: TUpDown;
    lblFloatBottom: TLabel;
    edtFloatBottom: TEdit;
    updFloatBottom: TUpDown;
    grpMinMax: TGroupBox;
    lblMinWidth: TLabel;
    edtMinWidth: TEdit;
    updMinWidth: TUpDown;
    lblMinHeight: TLabel;
    edtMinHeight: TEdit;
    updMinHeight: TUpDown;
    lblMaxWidth: TLabel;
    edtMaxWidth: TEdit;
    updMaxWidth: TUpDown;
    lblMaxHeight: TLabel;
    edtMaxHeight: TEdit;
    updMaxHeight: TUpDown;
    lblAuthor: TLabel;
    lblEMail: TLabel;
    lblHomePage: TLabel;
    btnApply: TButton;
    btnCancel: TButton;
    lblProductName: TLabel;
    procedure FormShow(Sender: TObject);
    procedure btnApplyClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PropDlg: TPropDlg;

implementation

uses Demo, AppBar;

{$R *.DFM}


procedure TPropDlg.FormShow(Sender: TObject);
begin
  // Appearance Page
  chkAlwaysOnTop.Checked  := DemoBar.AlwaysOnTop;
  chkAutoHide.Checked     := DemoBar.AutoHide;

  // Position Page
  optEdgeFloat.Checked    := (DemoBar.Edge = abeFloat);
  optEdgeLeft.Checked     := (DemoBar.Edge = abeLeft);
  optEdgeTop.Checked      := (DemoBar.Edge = abeTop);
  optEdgeRight.Checked    := (DemoBar.Edge = abeRight);
  optEdgeBottom.Checked   := (DemoBar.Edge = abeBottom);

  chkAllowFloat.Checked   := (abfAllowFloat  in DemoBar.Flags);
  chkAllowLeft.Checked    := (abfAllowLeft   in DemoBar.Flags);
  chkAllowTop.Checked     := (abfAllowTop    in DemoBar.Flags);
  chkAllowRight.Checked   := (abfAllowRight  in DemoBar.Flags);
  chkAllowBottom.Checked  := (abfAllowBottom in DemoBar.Flags);

  // Sizing Page
  updHorzSizeInc.Position := DemoBar.HorzSizeInc;
  updVertSizeInc.Position := DemoBar.VertSizeInc;

  // Docking Page
  updDockLeft.Position    := DemoBar.DockDims.Left;
  updDockTop.Position     := DemoBar.DockDims.Top;
  updDockRight.Position   := DemoBar.DockDims.Right;
  updDockBottom.Position  := DemoBar.DockDims.Bottom;

  // Floating Page
  updFloatLeft.Position   := DemoBar.FloatRect.Left;
  updFloatTop.Position    := DemoBar.FloatRect.Top;
  updFloatRight.Position  := DemoBar.FloatRect.Right;
  updFloatBottom.Position := DemoBar.FloatRect.Bottom;

  updMinWidth.Position    := DemoBar.MinWidth;
  updMinHeight.Position   := DemoBar.MinHeight;
  updMaxWidth.Position    := DemoBar.MaxWidth;
  updMaxHeight.Position   := DemoBar.MaxHeight;
end;


procedure TPropDlg.btnApplyClick(Sender: TObject);
begin
  // Appearance Page
  DemoBar.AlwaysOnTop := chkAlwaysOnTop.Checked;
  DemoBar.AutoHide    := chkAutoHide.Checked;

  // Position Page
  if optEdgeFloat.Checked then
    DemoBar.Edge := abeFloat
  else if optEdgeLeft.Checked then
    DemoBar.Edge := abeLeft
  else if optEdgeTop.Checked then
    DemoBar.Edge := abeTop
  else if optEdgeRight.Checked then
    DemoBar.Edge := abeRight
  else if optEdgeBottom.Checked then
    DemoBar.Edge := abeBottom;

  if chkAllowFloat.Checked then
    DemoBar.Flags := DemoBar.Flags + [abfAllowFloat]
  else
    DemoBar.Flags := DemoBar.Flags - [abfAllowFloat];

  if chkAllowLeft.Checked then
    DemoBar.Flags := DemoBar.Flags + [abfAllowLeft]
  else
    DemoBar.Flags := DemoBar.Flags - [abfAllowLeft];

  if chkAllowTop.Checked then
    DemoBar.Flags := DemoBar.Flags + [abfAllowTop]
  else
    DemoBar.Flags := DemoBar.Flags - [abfAllowTop];

  if chkAllowRight.Checked then
    DemoBar.Flags := DemoBar.Flags + [abfAllowRight]
  else
    DemoBar.Flags := DemoBar.Flags - [abfAllowRight];

  if chkAllowBottom.Checked then
    DemoBar.Flags := DemoBar.Flags + [abfAllowBottom]
  else
    DemoBar.Flags := DemoBar.Flags - [abfAllowBottom];

  // Sizing Page
  DemoBar.HorzSizeInc := updHorzSizeInc.Position;
  DemoBar.VertSizeInc := updVertSizeInc.Position;

  // Docking Page
  DemoBar.DockDims := Rect(updDockLeft.Position,
                           updDockTop.Position,
                           updDockRight.Position,
                           updDockBottom.Position);

  // Floating Page
  DemoBar.FloatRect := Rect(updFloatLeft.Position,
                            updFloatTop.Position,
                            updFloatRight.Position,
                            updFloatBottom.Position);

  DemoBar.MinWidth  := updMinWidth.Position;
  DemoBar.MinHeight := updMinHeight.Position;
  DemoBar.MaxWidth  := updMaxWidth.Position;
  DemoBar.MaxHeight := updMaxHeight.Position;
end;

end.

