unit anlRuler;
{---------------------
 TanlRuler Version 1.0
 ---------------------

Lefteris Loukis
e-mail : lbst@hotmail.com
           (or try:)
         p93044@poseidon.cs.unipi.gr

 April 1998, aLL nIgHt LoNg, Athens, Greece.


DESCRIPTION:
------------
A FREEWARE ruler component that offers office 97's capabilities, such as
draging margins, draging indents (First,left,right,Hanging),
showing drag-line on associated richedit, office 97 presentation
style, etc.
Full source and demo included, please read the LICENCE and the DISCLAIMER
included in the attached text file.


DELPHI IDE:
---------------
Delphi 1.0 = No
Delphi 2.0 = ? (Not tested, if do so and have problems, please inform me)
Delphi 3.0 = Yes


The code is simple, and in most cases self explained, however if you
have suggestions, questions, bugs, then please report 'em to me via
e-mail : lbst@hotmail.com or p93044@poseidon.cs.unipi.gr}



interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, extctrls, comctrls;

const
 BmpSemi=4; {The width of each Indent divided by two}

type
 { TRulerKind = (rbHorizontal, rbVertical; } {Not used by now}
  TIndentID = (riFirst,riLeft,riRight,riBothLeft);
  TMarginID = (rmLeft,rmRight);
  TIndentEvent =  procedure (Sender: TObject ; IndentID :TIndentID) of object;
  TMarginEvent =  procedure (Sender: TObject ; MarginID :TMarginID) of object;
  TRulerTab = 1..255;
  TRulerFactor = 1..30000;
  TRulerTabdist = 1..30000;


  {TanlRuler}
  TanlRuler = class(TCustomControl)
  private
    FImgFirstIndent :Tpaintbox;
    FImgLeftIndent  :Tpaintbox;
    FImgRightIndent :Tpaintbox;
    FImgBothLeftIndent   :Tpaintbox;

    FDragging : boolean;
    FDragOfs : Integer;
    FDraggingLeft : boolean;
    FDraggingRight : boolean;
    FIndDblClicked :boolean;

    Frichedit :TcustomRichedit;
    Fhdc : HDC;
    Fnewpen : Hpen;

    FRulerTab :TRulerTab;
    FMinIndentDist  :integer;
    FDist :TRulerTabdist;
    FFact :TRulerFactor;
    FMarginRight :integer;
    FMarginLeft  :integer;
    FBorderLeft  :integer;
    FBorderUp    :integer;
    FBorderDown  :integer;
    FBorderRight :integer;
    FShowSmallLines :boolean;
    FShowLargeLines :boolean;
    FShowIndents    :boolean;
    FShowNumbers    :boolean;
    FShowMargHandl  :boolean;

    FOnChangeIndent   : TIndentEvent;
    FOnChangingIndent : TIndentEvent;
    FOnClickIndent    : TIndentEvent;
    FOnDblClickIndent : TIndentEvent;

    FOnChangeMargin   : TMarginEvent;
    FOnChangingMargin : TMarginEvent;
    FOnClickMargin    : TMarginEvent;

    Procedure DrawFocusline(x1,y1,x2,y2 : longint);
    Procedure MoveFocusline(OldOfs,NewOfs : longint);
    Procedure DrawGhostIndent (ind :TindentID);
    Procedure PrepareIndents;

    procedure SetRichedit   (Value : TCustomRichedit);
    procedure SetTabDist    (Value : TRulerTabdist);
    procedure SetFactor     (Value : TRulerFactor);
    procedure SetMarginRight(Value : Integer);
    procedure SetMarginLeft (Value : Integer);
    procedure SetBorderLeft (Value : Integer);
    procedure SetBorderUp   (Value : Integer);
    procedure SetBorderDown (Value : Integer);
    procedure SetBorderRight(Value : Integer);
    procedure SetIndentFirst (Value : Integer);
    procedure SetIndentLeft  (Value : Integer);
    procedure SetIndentRight (Value : Integer);
    Function GetIndentFirst : Integer;
    Function GetIndentLeft  : Integer;
    Function GetIndentRight : Integer;
    procedure SetShowSmallLines(Value : boolean);
    procedure SetShowLargeLines(Value : boolean);
    procedure SetShowIndents   (Value : boolean);
    procedure SetShowNumbers   (Value : boolean);
    procedure SetShowMargHandl (Value : boolean);
    procedure IndentMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure IndentMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure IndentMouseUp(Sender: TObject; Button: TMouseButton;  Shift: TShiftState; X, Y: Integer);
    procedure IndentPaint(Sender: TObject);
    procedure IndentDblClick(Sender: TObject);
  protected
    procedure Paint; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer);override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);override;
  public
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    property Canvas;

    procedure IncreaseIndent;
    procedure DecreaseIndent;
  published
    property Align;
    property Color;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ParentColor default False;
    property ParentCtl3D;
    property ParentFont default False;
    property ParentShowHint;
    property PopupMenu;
{    property ShowHint;}
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;

    property Richedit      :TCustomRichedit read FRichedit  write SetRichedit;
    property RulerTab      :TRulerTab   read FRulerTab      write FRulerTab      default 10;
    property MinIndentDist :Integer     read FMinIndentDist write FMinIndentDist default 50;
    property Factor      :TRulerFactor  read FFact  write SetFactor      default 1;
    property TabDist     :TRulerTabdist read FDist  write SetTabDist     default 10;
    property MarginRight :Integer read FMarginRight write SetMarginRight default 20;
    property MarginLeft  :Integer read FMarginLeft  write SetMarginLeft  default 30;
    property BorderLeft  :Integer read FBorderLeft  write SetBorderLeft  default 5;
    property BorderUp    :Integer read FBorderUp    write SetBorderUp    default 5;
    property BorderDown  :Integer read FBorderDown  write SetBorderDown  default 5;
    property BorderRight :Integer read FBorderRight write SetBorderRight default 5;
    property IndentFirst :Integer read GetIndentFirst write SetIndentFirst default 45;
    property IndentLeft  :Integer read GetIndentLeft  write SetIndentLeft  default 45;
    property IndentRight :Integer read GetIndentRight write SetIndentRight default 170;
    property ShowSmallLines :Boolean read FShowSmallLines write SetShowSmallLines default true;
    property ShowLargeLines :Boolean read FShowLargeLines write SetShowLargeLines default true;
    property ShowIndents    :Boolean read FShowIndents    write SetShowIndents    default true;
    property ShowNumbers    :Boolean read FShowNumbers    write SetShowNumbers    default true;
    property ShowMarginHandlers :Boolean read FShowMargHandl    write SetShowMargHandl    default true;

    property OnIndentChange   : TIndentEvent read FOnChangeIndent   write FOnChangeIndent;
    property OnIndentDrag     : TIndentEvent read FOnChangingIndent write FOnChangingIndent;
    property OnIndentClick    : TIndentEvent read FOnClickIndent    write FOnClickIndent;
    property OnIndentDblClick : TIndentEvent read FOnDblClickIndent write FOnDblClickIndent;
    property OnMarginChange   : TMarginEvent read FOnChangeMargin   write FOnChangeMargin;
    property OnMarginDrag     : TMarginEvent read FOnChangingMargin write FOnChangingMargin;
    property OnMarginClick    : TMarginEvent read FOnClickMargin    write FOnClickMargin;
  end;

procedure Register;

implementation


Procedure TanlRuler.DrawFocusline(x1,y1,x2,y2:longint);
var
   Oldpen:hpen;
   tp:ppoint;
begin
  tp:=nil;
  Oldpen := SelectObject ( Fhdc, Fnewpen);
  movetoex( Fhdc, x1,y1,tp);
  lineto( Fhdc, x2,y2);
  SelectObject ( Fhdc, Oldpen );
end;

Procedure TanlRuler.MoveFocusline(OldOfs,NewOfs : longint);
Begin
 if (OldOfs<>NewOfs)then
  Begin
   DrawFocusline(OldOfs,1,OldOfs,Frichedit.ClientHeight);
   DrawFocusline(NewOfs,1,NewOfs,Frichedit.ClientHeight);
  End;
End;

Procedure TanlRuler.DrawGhostIndent (Ind : TindentID);
var x,y :integer;
Begin
With canvas do
Begin
 pen.color := clBtnShadow;
 Brush.color := clBtnFace;

 if (ind = riFirst) and (FImgFirstIndent.Left<>FImgFirstIndent.tag) then
  Begin
   x := FImgFirstIndent.Tag;
   y := FImgFirstIndent.Top;
   polygon([ point(x+0,y+0),
             point(x+8,y+0),
             point(x+8,y+3),
             point(x+4,y+7),
             point(x+0,y+3)]);
  End;

 if (ind = riRight) and (FImgRightIndent.Left<>FImgRightIndent.tag) then
  Begin
   x := FImgRightIndent.Tag;
   y := FImgRightIndent.Top;
   polygon([ point(x+0,y+7),
             point(x+0,y+4),
             point(x+4,y+0),
             point(x+8,y+4),
             point(x+8,y+7)]);
  End;

 if (ind = riLeft) and (FImgLeftIndent.Left<>FImgBothLeftIndent.tag) then
  Begin
   x := FImgBothLeftIndent.Tag;
   y := FImgLeftIndent.Top;
   Polygon([point(x+0,y+7),
            point(x+0,y+4),
            point(x+4,y+0),
            point(x+8,y+4),
            point(x+8,y+7)]);
  End;

  if (ind = riBothLeft) and (FImgBothLeftIndent.Left<>FImgBothLeftIndent.tag) then
  Begin
   x := FImgBothLeftIndent.Tag;
   y := FImgBothLeftIndent.Top;
   moveto(x+0,y+0);
   lineto(x+0,y+4);
   lineto(x+8,y+4);
   lineto(x+8,y+0);
   lineto(x+7,y+0);
  End;
End;
End;



Procedure TanlRuler.PrepareIndents;
Begin
 If FBorderUp-3 < 0 then FImgFirstIndent.top:=0 else
    If FBorderUp-3 > Height-8 then FImgFirstIndent.top := Height-8
                              else FImgFirstIndent.top := FBorderUp-3;

 If Height-FborderDown-8 < 0 then FImgLeftIndent.top:=0 else
    If Height-FborderDown-8 > Height-13 then FImgLeftIndent.top:=Height-13
                                        else FImgLeftIndent.Top := Height-FborderDown-8;

 FImgRightIndent.top    := FImgLeftIndent.top;
 FImgBothLeftIndent.top := FImgLeftIndent.top+8;
End;


procedure TanlRuler.IndentPaint(Sender: TObject);
Begin
 if (sender = FImgFirstIndent) and Fdragging then DrawGhostIndent(riFirst);
 if (sender = FImgRightIndent) and Fdragging then DrawGhostIndent(riRight);
 if (sender = FImgLeftIndent)  and Fdragging then DrawGhostIndent(riLeft);
 if (sender = FImgBothLeftIndent) and Fdragging then DrawGhostIndent(riBothLeft);

with (Sender as Tpaintbox).canvas do
Begin
 Brush.style:=bsclear;
 if sender<> FImgBothLeftIndent then fillRect(Rect(0, 0, (Sender as Tpaintbox).width, (Sender as Tpaintbox).Height));
 Brush.style:=bssolid;
 brush.color := clBtnface;
 pen.color:=clblack;

if sender = FImgFirstIndent then
Begin
 Polygon([point(0,0),
          point(8,0),
          point(8,3),
          point(4,7),
          point(0,3)]);
 pen.color:=clbtnHighLight;
 moveto(6,1);
 lineto(1,1);
 lineto(1,3);
 lineto(4,6);
End;

if (sender = FImgLeftIndent) or (sender = FImgRightIndent) then
Begin
 Polygon([point(0,7),
          point(0,4),
          point(4,0),
          point(8,4),
          point(8,7)]);
 pen.color:=clbtnHighLight;
 moveto(1,5);
 lineto(1,4);
 lineto(5,0);
End;

if sender = FImgBothLeftIndent then
Begin
 fillRect(Rect(0, 0, (Sender as Tpaintbox).width, (Sender as Tpaintbox).Height));
 moveto(0,0);
 lineto(0,4);
 lineto(8,4);
 lineto(8,0);
 lineto(7,0);
 pen.color:=clbtnHighLight;
 moveto(1,2);
 lineto(1,0);
 lineto(7,0);
End;
End;
End;



constructor TanlRuler.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  Fnewpen :=  CreatePen(PS_dot,0,0);

  Width := 300;
  Height := 25;
  Font.Name := 'Small Fonts';
  Font.Size := 7;
  ParentColor := False;

  FMinIndentDist:=50;
  FRulerTab    := 10;
  FDist        := 10;
  FFact        :=  1;
  FMarginRight := 20;
  FMarginLeft  := 30;
  FBorderLeft  := 5;
  FBorderUp    := 5;
  FBorderDown  := 5;
  FBorderRight := 5;
  FShowSmalllines :=true;
  FShowLargelines :=true;
  FShowIndents    :=true;
  FShowNumbers    :=true;
  FShowMargHandl  :=true;

  FDragging :=False;
  FDraggingLeft :=False;
  FDraggingRight :=False;

  FIndDblClicked := false;

  FImgLeftIndent := Tpaintbox.Create(Self);
  FImgLeftIndent.Parent := self;
  FImgLeftIndent.boundsrect:=rect(0,0,9,8);
  FImgLeftIndent.Visible  := True;
{  FImgLeftIndent.Hint  := 'Hanging Indent';
  FImgLeftIndent.ParentShowHint  := true;   }
  FImgLeftIndent.Cursor  := crArrow;
  FImgLeftIndent.OnMouseDown := IndentMouseDown;
  FImgLeftIndent.OnMouseMove := IndentMouseMove;
  FImgLeftIndent.OnMouseUp   := IndentMouseUp;
  FImgLeftIndent.OnDblClick  := IndentDblClick;
  FImgLeftIndent.OnPaint  := IndentPaint;

  FImgFirstIndent := Tpaintbox.Create(Self);
  FImgFirstIndent.Parent := self;
  FImgFirstIndent.boundsrect:=rect(0,0,9,8);
  FImgFirstIndent.Visible  := true;
{  FImgFirstIndent.Hint  := 'First line Indent';
  FImgFirstIndent.ParentShowHint  := true;}
  FImgFirstIndent.Cursor  := crArrow;
  FImgFirstIndent.OnMouseDown := IndentMouseDown;
  FImgFirstIndent.OnMouseMove := IndentMouseMove;
  FImgFirstIndent.OnMouseUp   := IndentMouseUp;
  FImgFirstIndent.OnDblClick  := IndentDblClick;
  FImgFirstIndent.OnPaint  := IndentPaint;


  FImgRightIndent := Tpaintbox.Create(Self);
  FImgRightIndent.Parent := self;
  FImgRightIndent.boundsrect:=rect(0,0,9,8);
  FImgRightIndent.Visible  := True;
{  FImgRightIndent.Hint  := 'Right Indent';
  FImgRightIndent.ParentShowHint  := true;}
  FImgRightIndent.Cursor  := crArrow;
  FImgRightIndent.OnMouseDown := IndentMouseDown;
  FImgRightIndent.OnMouseMove := IndentMouseMove;
  FImgRightIndent.OnMouseUp   := IndentMouseUp;
  FImgRightIndent.OnDblClick  := IndentDblClick;
  FImgRightIndent.OnPaint  := IndentPaint;

  FImgBothLeftIndent := Tpaintbox.Create(Self);
  FImgBothLeftIndent.Parent := self;
  FImgBothLeftIndent.boundsrect:=rect(0,0,9,7);
  FImgBothLeftIndent.Visible  := True;
{  FImgBothLeftIndent.Hint  := 'Left Indent';
  FImgBothLeftIndent.ParentShowHint  := true;}
  FImgBothLeftIndent.Cursor  := crArrow;
  FImgBothLeftIndent.OnMouseDown := IndentMouseDown;
  FImgBothLeftIndent.OnMouseMove := IndentMouseMove;
  FImgBothLeftIndent.OnMouseUp   := IndentMouseUp;
  FImgBothLeftIndent.OnDblClick  := IndentDblClick;
  FImgBothLeftIndent.OnPaint  := IndentPaint;

  IndentFirst := 45;
  IndentLeft  := 45;
  IndentRight := 250;

end;


destructor TanlRuler.Destroy;
begin
  inherited Destroy;
  DeleteObject(Fnewpen);
  if Frichedit<>nil then ReleaseDC ( 0, Fhdc );
end;


procedure TanlRuler.Paint;
var f,i,dist2,dist4:integer;
    s:string;
Begin
   PrepareIndents;
   dist2:=Fdist*2;
   dist4:=Fdist*4;
   {Draw Borders}
   Canvas.Brush.color := ClBtnFace;
   Canvas.Fillrect(Rect(0, 0, Width, FborderUp));
   Canvas.Fillrect(Rect(0, Height-FborderDown,width, Height));
   Canvas.Fillrect(Rect(0, 0, FborderLeft, Height));
   Canvas.Fillrect(Rect(Width-FborderRight, 0, width, Height));
   {Draw Margins}
   canvas.Brush.color := clBtnShadow;
   Canvas.Fillrect(Rect(Fborderleft, FborderUp,  Fborderleft+FmarginLeft, Height-FborderDown));
   Canvas.Fillrect(Rect(Width-FborderRight-FmarginRight, FborderUp,  Width-FborderRight, Height-FborderDown));
   {Draw Main Area}
   Canvas.Brush.color := color;
   Canvas.Fillrect(Rect(Fborderleft+FMarginLeft,FborderUp,Width-FborderRight-FMarginRight,Height-FborderDown));
   {Draw Margin Handlers}
   if FShowMargHandl then
    Begin
     if FmarginLeft=0 then canvas.Brush.color := clBtnShadow
                      else canvas.Brush.color := clBtnFace;
     Canvas.Fillrect(Rect(Fborderleft+FmarginLeft-1, FborderUp,  Fborderleft+FmarginLeft+1, Height-FborderDown));
     if FmarginRight=0 then canvas.Brush.color := clBtnShadow
                       else canvas.Brush.color := clBtnFace;
     Canvas.Fillrect(Rect(Width-FborderRight-FmarginRight-1, FborderUp,  Width-FborderRight-FmarginRight+1, Height-FborderDown));
    End;

   canvas.Brush.color := color;
   canvas.Brush.style := bsClear;
   canvas.pen.color   := font.color;
   Canvas.font := font;
   for f := Fborderleft to Width-FborderRight-1 do
    begin
     i:= abs(f-Fborderleft-FMarginLeft);
     S:=inttostr((i div dist4)*FFact);
     If S='0' then S:='';
     if (i mod dist4)= 0  then if FshowNumbers
       then canvas.textout(f-Canvas.TextWidth(S) div 2,(Height-Canvas.TextHeight(S)) div 2,S)
       else if FShowLargeLines then
                            Begin
                             canvas.moveto(f,(Height-5) div 2);
                             canvas.lineto(f,((Height-5) div 2)+5);
                            End;
     if FShowLargeLines then
       if (i mod dist4)=dist2 then
                            Begin
                             canvas.moveto(f,(Height-5) div 2);
                             canvas.lineto(f,((Height-5) div 2)+5);
                            End;
     if FShowSmallLines then
       if (i mod dist2) = Fdist then
                            Begin
                             canvas.moveto(f,(Height-2) div 2);
                             canvas.lineto(f,((Height-2) div 2)+2);
                            End;
    end;
End;




procedure TanlRuler.SetTabDist    (Value : TRulerTabdist);
Begin
 if FDist <> Value then begin FDist := Value; Invalidate; end;
End;

procedure TanlRuler.SetFactor     (Value : TRulerFactor);
Begin
 if FFact <> Value then begin FFact := Value; Invalidate; end;
End;

procedure TanlRuler.SetMarginRight(Value : Integer);
Begin
 if (FMarginRight <> Value) and
    (Value>=0) and
    (Value<=Width-FMarginLeft-FborderLeft-FBorderRight)
 then begin
       IndentRight  := IndentRight - Value + FmarginRight;
       FMarginRight := Value;
       Invalidate;
       If (FDraggingRight) and (Assigned(FOnChangingMargin)) then FOnChangingMargin(Self,rmRight)
      end;
End;

procedure TanlRuler.SetMarginLeft (Value : Integer);
Begin
 if (FMarginLeft <> Value) and
    (Value>=0) and
    (Value<=Width-FMarginRight-FborderRight-FBorderleft)
 then begin
       IndentFirst := IndentFirst + Value - FmarginLeft;
       IndentLeft  := IndentLeft  + Value - FmarginLeft;
       FMarginLeft := Value;
       Invalidate;
       If (FDraggingLeft) and (Assigned(FOnChangingMargin)) then FOnChangingMargin(Self,rmLeft)
      end;
End;

procedure TanlRuler.SetBorderLeft (Value : Integer);
Begin
 if FBorderLeft <> Value then begin FBorderLeft := Value; Invalidate; end;
End;

procedure TanlRuler.SetBorderUp   (Value : Integer);
Begin
 if FBorderUp <> Value then begin FBorderUp := Value; Invalidate; end;
End;

procedure TanlRuler.SetBorderDown (Value : Integer);
Begin
 if FBorderDown <> Value then begin FBorderDown := Value; Invalidate; end;
End;

procedure TanlRuler.SetBorderRight(Value : Integer);
Begin
 if FBorderRight <> Value then begin FBorderRight := Value; Invalidate; end;
End;

procedure TanlRuler.SetIndentFirst(Value : Integer);
Begin
 if (FImgFirstIndent.left  <> Value) and
    (Value >=0) and (Value < Width-BmpSemi) and
    ((FImgRightIndent.left-Value)>FMinIndentDist)
    then
     Begin
      FImgFirstIndent.left:=Value;
      If (FDragging) and (Assigned(FOnChangingIndent)) then FOnChangingIndent(Self,riFirst);
     End;
End;

procedure TanlRuler.SetIndentLeft (Value : Integer);
Begin
 if (FImgLeftIndent.left  <> Value) and
    (Value >=0) and (Value < Width-BmpSemi) and
    ((FImgRightIndent.left-Value)>FMinIndentDist)
    then begin
          FImgBothLeftIndent.left:=Value;
          FImgLeftIndent.left:=Value;
          If (FDragging) and (Assigned(FOnChangingIndent)) then FOnChangingIndent(Self,riLeft);
         end;
End;

procedure TanlRuler.SetIndentRight(Value : Integer);
Begin
 if (FImgRightIndent.left  <> Value) and
    (Value >=0) and (Value < Width-BmpSemi) and
    ((Value-FImgLeftIndent.left)>FMinIndentDist) and
    ((Value-FImgFirstIndent.left)>FMinIndentDist)
 then Begin
       FImgRightIndent.left:=Value;
       If (FDragging) and (Assigned(FOnChangingIndent)) then FOnChangingIndent(Self,riRight);
      End;
End;

Function TanlRuler.GetIndentFirst : Integer;
Begin
 Result := FImgFirstIndent.left;
End;

Function TanlRuler.GetIndentLeft : Integer;
Begin
 Result:= FImgLeftIndent.left;
End;

Function TanlRuler.GetIndentRight : Integer;
Begin
 Result:= FImgRightIndent.left;
End;

procedure TanlRuler.SetShowSmallLines(Value : Boolean);
Begin
 if FShowSmallLines <> Value then begin FShowSmallLines := Value; Invalidate; end;
End;

procedure TanlRuler.SetShowLargeLines(Value : Boolean);
Begin
 if FShowLargeLines <> Value then begin FShowLargeLines := Value; Invalidate; end;
End;

procedure TanlRuler.SetShowIndents(Value : Boolean);
Begin
 if FShowIndents <> Value then
  begin
    FShowIndents := Value;
    FImgFirstIndent.visible:=Value;
    FImgLeftIndent .visible:=Value;
    FImgRightIndent.visible:=Value;
    FImgBothLeftIndent  .visible:=Value;
    Invalidate;
  end;
End;

procedure TanlRuler.SetShowNumbers(Value : Boolean);
Begin
 if FShowNumbers <> Value then begin FShowNumbers := Value; Invalidate; end;
End;

procedure TanlRuler.SetShowMargHandl(Value : Boolean);
Begin
 if FShowMargHandl<> Value then begin FShowMargHandl := Value; Invalidate; end;
End;


procedure TanlRuler.SetRichedit   (Value : TCustomRichedit);
Begin
 if FRichedit <> Value then
   begin
     If Frichedit<>nil then ReleaseDC ( 0, FHdc );
     FRichedit := Value;
     If Frichedit<>nil then
        Begin
         Fhdc := GetDCEx(Frichedit.Handle, 0, DCX_CACHE or DCX_CLIPSIBLINGS or DCX_LOCKWINDOWUPDATE);
         SetROP2 (Fhdc, R2_NOTXORPEN);
        End;
   end;
End;


procedure TanlRuler.IndentMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbLeft) and (not FIndDblClicked) then
   begin
    FDragging := True;
    FDragOfs := X;
    FImgFirstIndent.tag    := FImgFirstIndent.left ;
    FImgRightIndent.tag    := FImgRightIndent.left ;
    FImgBothLeftIndent.tag := FImgBothLeftIndent.left ;
    if Frichedit <> nil then DrawFocusline(Left-Frichedit.left+Timage(Sender).Left+BmpSemi,1,Left-Frichedit.left+Timage(Sender).Left+BmpSemi,Frichedit.ClientHeight);
    if Assigned(FOnClickIndent) then
       begin
        If (Sender = FImgFirstIndent)    then  FOnClickIndent(Self,riFirst);
        If (Sender = FImgRightIndent)    then  FOnClickIndent(Self,riRight);
        If (Sender = FImgLeftIndent)     then  FOnClickIndent(Self,riLeft);
        If (Sender = FImgBothLeftIndent) then  FOnClickIndent(Self,riBothLeft);
       end;
   End;
  FIndDblClicked:=false;
end;


procedure TanlRuler.IndentMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var OldOfs,NewOfs : longint;
begin
  if FDragging then
   Begin
    if Frichedit <> nil then OldOfs := Left-Frichedit.left+Timage(Sender).Left+BmpSemi;
    If Sender=FImgLeftIndent  then IndentLeft  := (Timage(Sender).Left+X-FDragOfs) div FrulerTab *FrulerTab;
    If Sender=FImgFirstIndent then IndentFirst := (Timage(Sender).Left+X-FDragOfs) div FrulerTab *FrulerTab;
    If Sender=FImgRightIndent then IndentRight := (Timage(Sender).Left+X-FDragOfs) div FrulerTab *FrulerTab;
    If Sender=FImgBothLeftIndent then
        Begin
         IndentLeft :=  (Timage(Sender).Left+X-FDragOfs) div FrulerTab *FrulerTab;
         IndentFirst := (FImgFirstIndent.Left+X-FDragOfs) div FrulerTab * FrulerTab;
        End;
    if Frichedit <> nil then
      Begin
       Newofs := Left-Frichedit.left+Timage(Sender).Left+BmpSemi;
       MoveFocusLine(OldOfs,NewOfs);
      End; 
   End;
end;

procedure TanlRuler.IndentMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
if FDragging and (Button = mbLeft) then
 Begin
  if Frichedit <> nil then DrawFocusline(Left-Frichedit.left+Timage(Sender).Left+BmpSemi,1,Left-Frichedit.left+Timage(Sender).Left+BmpSemi,Frichedit.ClientHeight);
  Invalidate;
  FDragging := False;
  if Assigned(FOnChangeIndent) then
   begin
    If (Sender = FImgFirstIndent) then  FOnChangeIndent(Self,riFirst);
    If (Sender = FImgRightIndent) then  FOnChangeIndent(Self,riRight);
    If (Sender = FImgLeftIndent)  then  FOnChangeIndent(Self,riLeft);
    If (Sender = FImgBothLeftIndent)   then  FOnChangeIndent(Self,riBothLeft);
   end;
 End;
end;



procedure TanlRuler.IndentDblClick(Sender: TObject);
begin
 FIndDblClicked := true;
 if Assigned(FOnDblClickIndent) then
 begin
  If (Sender = FImgFirstIndent) then  FOnDblClickIndent(Self,riFirst);
  If (Sender = FImgRightIndent) then  FOnDblClickIndent(Self,riRight);
  If (Sender = FImgLeftIndent)  then  FOnDblClickIndent(Self,riLeft);
  If (Sender = FImgBothLeftIndent)   then  FOnDblClickIndent(Self,riBothLeft);
 end;
end;


procedure TanlRuler.IncreaseIndent;
Begin
  IndentLeft  := FImgBothLeftIndent.Left + FrulerTab;;
  IndentFirst := FImgFirstIndent.Left + FrulerTab;
  if Assigned(FOnChangeIndent) then FOnChangeIndent(Self,riBothLeft);
End;

procedure TanlRuler.DecreaseIndent;
begin
  IndentLeft  := FImgBothLeftIndent.Left - FrulerTab;;
  IndentFirst := FImgFirstIndent.Left - FrulerTab;
  if Assigned(FOnChangeIndent) then FOnChangeIndent(Self,riBothLeft);
End;


procedure TanlRuler.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
Begin
inherited MouseDown(Button,Shift, X, Y);
 if (Button = mbLeft) and (FShowMargHandl) then
    if (X > FMarginLeft+FBorderLeft-3) and (x < Fmarginleft+FBorderLeft+3)
      then
        Begin
        FDraggingLeft := True ;
        if Frichedit <> nil then DrawFocusline(Left-Frichedit.left+FBorderLeft+FMarginLeft,1,Left-Frichedit.left+FBorderLeft+FMarginLeft,Frichedit.ClientHeight);
        if assigned(FOnClickMargin) then FOnClickMargin(Self,rmLeft)
        End
      else if (X > Width-FMarginRight-FBorderRight-3) and (x < Width-FMarginRight-FBorderRight+3)
       then
        Begin
        FDraggingRight := True ;
        if Frichedit <> nil then DrawFocusline(Left-Frichedit.left+Width-FBorderRight-FMarginRight,1,Left-Frichedit.left+Width-FBorderRight-FMarginRight,Frichedit.ClientHeight);
        if assigned(FOnClickMargin) then FOnClickMargin(Self,rmRight)
        End;
End;


procedure TanlRuler.MouseMove(Shift: TShiftState; X, Y: Integer);
var OldOfs,NewOfs :Longint;
Begin
inherited MouseMove(Shift, X, Y);
 if FShowMargHandl then
 if (X > FMarginLeft+FBorderLeft-3) and (x < Fmarginleft+FBorderLeft+3)
        then cursor:=crSizeWE
        else if (X > Width-FMarginRight-FBorderRight-3) and (x < Width-FMarginRight-FBorderRight+3)
               then cursor:=crSizeWE
               else cursor:=crDefault;
  if FDraggingLeft  then Begin
                          if Frichedit <> nil then OldOfs := Left-Frichedit.left+FBorderLeft+FMarginLeft;
                          Marginleft  := (X-FborderLeft) div FrulerTab * FrulerTab;
                          if Frichedit <> nil then
                            Begin
                             Newofs := Left-Frichedit.left+FBorderLeft+FMarginLeft;
                             MoveFocusLine(OldOfs,NewOfs);
                            End;
                         End;
  if FDraggingRight then Begin
                          if Frichedit <> nil then OldOfs := Left-Frichedit.left+Width-FBorderRight-FMarginRight;
                          MarginRight := (Width-FBorderRight-X) div FrulerTab * FrulerTab;
                          if Frichedit <> nil then
                            Begin
                             Newofs := Left-Frichedit.left+Width-FBorderRight-FMarginRight;
                             MoveFocusLine(OldOfs,NewOfs);
                            End;
                         End;
End;


procedure TanlRuler.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
Begin
 inherited MouseUp(Button, Shift, X, Y);
 if FdraggingLeft  then
  Begin
   if Frichedit <> nil then DrawFocusline(Left-Frichedit.left+FBorderLeft+FMarginLeft,1,Left-Frichedit.left+FBorderLeft+FMarginLeft,Frichedit.ClientHeight);
   if Assigned(FOnChangeMargin) then FOnChangeMargin(Self,rmLeft);
   FDraggingLeft  := False;
  End;
 if FdraggingRight then
  Begin
   if Frichedit <> nil then DrawFocusline(Left-Frichedit.left+Width-FBorderRight-FMarginRight,1,Left-Frichedit.left+Width-FBorderRight-FMarginRight,Frichedit.ClientHeight);
   if Assigned(FOnChangeMargin) then FOnChangeMargin(Self,rmRight);
   FDraggingRight := False;
  End;
End;


procedure Register;
begin
  RegisterComponents('Extra', [TanlRuler]);
end;

end.
