unit Comptest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, AnalogMeter, Spin, ComCtrls;

type
  TForm1 = class(TForm)
    Panel3: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    edLow: TSpinEdit;
    rgAngle: TRadioGroup;
    cbShowValue: TCheckBox;
    edHigh: TSpinEdit;
    cbZoneEvents: TCheckBox;
    cbShowTicks: TCheckBox;
    cbShowFrame: TCheckBox;
    Edit1: TEdit;
    TrackBar1: TTrackBar;
    Label3: TLabel;
    Memo1: TMemo;
    Label4: TLabel;
    edTickCount: TSpinEdit;
    FontDialog1: TFontDialog;
    btnFont: TButton;
    procedure FormShow(Sender: TObject);
    procedure AnalogMeter1FallBelowDanger(Sender: TObject);
    procedure AnalogMeter1FallBelowLow(Sender: TObject);
    procedure AnalogMeter1RiseAboveDanger(Sender: TObject);
    procedure cbShowValueClick(Sender: TObject);
    procedure rgAngleClick(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure cbZoneEventsClick(Sender: TObject);
    procedure cbShowTicksClick(Sender: TObject);
    procedure cbShowFrameClick(Sender: TObject);
    procedure AnalogMeter1Resize(Sender: TObject);
    procedure AnalogMeter1Change(Sender: TObject);
    procedure edTickCountChange(Sender: TObject);
    procedure edLowChange(Sender: TObject);
    procedure edHighChange(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnFontClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    AnalogMeter1: TAnalogMeter;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  AnalogMeter1 := TAnalogMeter.Create(Self);
  with AnalogMeter1 do begin
    Parent := Form1;
    Align := alClient; //allows testing resize
    Max := 65535; //Max(Word)
    onChange        := AnalogMeter1Change;
    onRiseAboveHigh := AnalogMeter1RiseAboveDanger;
    onFallBelowHigh := AnalogMeter1FallBelowDanger;
    onRiseAboveLow  := AnalogMeter1FallBelowDanger;
    onFallBelowLow  := AnalogMeter1FallBelowLow;
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  AnalogMeter1.Free;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  TrackBar1.Max := AnalogMeter1.Max;
  Edit1Change(Self); //set caption of AnalogMeter
end;

procedure TForm1.AnalogMeter1FallBelowDanger(Sender: TObject);
begin
  Memo1.Lines.Add('Back in Normal');
end;

procedure TForm1.AnalogMeter1FallBelowLow(Sender: TObject);
begin
  Memo1.Lines.Add('LOW!');
end;

procedure TForm1.AnalogMeter1RiseAboveDanger(Sender: TObject);
begin
  Memo1.Lines.Add('HIGH!');
end;

procedure TForm1.cbShowValueClick(Sender: TObject);
begin
  AnalogMeter1.ShowValue := cbShowValue.Checked;
end;

procedure TForm1.rgAngleClick(Sender: TObject);
begin
  case rgAngle.ItemIndex of
    0 : AnalogMeter1.AngularRange := 90;
    1 : AnalogMeter1.AngularRange := 180;
    2 : AnalogMeter1.AngularRange := 270;
    3 : AnalogMeter1.AngularRange := 360;
  end;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  AnalogMeter1.Value := TrackBar1.Position;
end;

procedure TForm1.cbZoneEventsClick(Sender: TObject);
begin
  AnalogMeter1.EnableZoneEvents := cbZoneEvents.Checked;
end;

procedure TForm1.cbShowTicksClick(Sender: TObject);
begin
  AnalogMeter1.ShowTicks := cbShowTicks.Checked;
end;

procedure TForm1.cbShowFrameClick(Sender: TObject);
begin
  AnalogMeter1.ShowFrame := cbShowFrame.Checked;
end;

procedure TForm1.AnalogMeter1Resize(Sender: TObject);
begin
  memo1.Lines.Add('resized');
end;

procedure TForm1.AnalogMeter1Change(Sender: TObject);
begin
  Label3.Caption := IntToStr(AnalogMeter1.Value);
end;

procedure TForm1.edTickCountChange(Sender: TObject);
begin
  AnalogMeter1.TickCount := edTickCount.Value;
end;

procedure TForm1.edLowChange(Sender: TObject);
begin
  AnalogMeter1.LowZone := edLow.Value;
end;

procedure TForm1.edHighChange(Sender: TObject);
begin
  AnalogMeter1.HighZone := edHigh.Value;
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  AnalogMeter1.Caption := Edit1.Text;
end;

procedure TForm1.btnFontClick(Sender: TObject);
begin
  If not FontDialog1.Execute then Exit;
  AnalogMeter1.Font := FontDialog1.Font;
end;

end.
