{*******************************************************************************
*  TAllSystemPaths version 0.2                                                 *
********************************************************************************
* Author: Raoul Snyman                                                         *
* ---------------------------------------------------------------------------- *
* E-Mail: components@saturnlaboratories.gq.nu                                  *
* ---------------------------------------------------------------------------- *
* Copyright: 2002-2003 Saturn Laboratories, All rights reserved.              *
* ---------------------------------------------------------------------------- *
* Description: I've come across so many components with system information,    *
*              some lack in one area, where others lack elsewhere. So having   *
*              got fed up with this, I decided to write a component that would *
*              contain EVERYTHING. Now this contains about 95% of all the sys- *
*              tem paths available (I think). The ones I've left out have been *
*              left out because I didn't think they would be needed.           *
********************************************************************************
* This component is FREEWARE.                                                  *
* ---------------------------------------------------------------------------- *
* Please let me know if you find it useful!!                                   *
* ---------------------------------------------------------------------------- *
* It may be used for commercial purposes on the condition that you give me     *
* credit (i.e. place it in your credits list). Check out my TScrollingCredits. *
* ---------------------------------------------------------------------------- *
* If used in freeware, it's not necessary to give me credit, although it would *
* be appreciated.                                                              *
* ---------------------------------------------------------------------------- *
* If you modify this code, please send me an e-mail with a copy of the code    *
* attached, letting me know what it was that you changed/modified/added.       *
*******************************************************************************}

unit AllSystemPaths;

interface

uses
  Windows, Messages, SysUtils, Classes, Registry;

type
  TAllSystemPaths = class(TComponent)
  private
    { Private declarations }
    FDummy: string;
    function GetProgramFilesPath: string;
    function GetProgramFilesDir: string;
    function GetWinDir: string;
    function GetWinBootDir: string;
    function GetBootDir: string;
    function GetCommonFilesDir: string;
    function GetConfigPath: string;
    function GetDevicePath: string;
    function GetMediaPath: string;
    function GetProductID: string;
    function GetProductName: string;
    function GetRegisteredOrganization: string;
    function GetRegisteredOwner: string;
    function GetSystemRoot: string;
    function GetVersion: string;
    function GetVersionNumber: string;
    function GetBootHost: string;
    function GetHostWinBootDir: string;
    function GetMachineDir: string;
    function GetSharedDir: string;
    function GetSysDir: string;
    function GetWallpaper: string;
    function GetWinAdminDir: string;
    function GetAppData: string;
    function GetCache: string;
    function GetCookies: string;
    function GetDesktop: string;
    function GetFavorites: string;
    function GetFonts: string;
    function GetHistory: string;
    function GetMyPictures: string;
    function GetNetHood: string;
    function GetMyDocuments: string; // Personal
    function GetStartMenuPrograms: string;
    function GetRecent: string;
    function GetSendTo: string;
    function GetStartMenu: string;
    function GetStartMenuStartup: string;
  protected
    { Protected declarations }
  public
    { Public declarations }
  published
    { Published declarations }
    property ProgramFilesPath: string read GetProgramFilesPath write FDummy stored False;
    property ProgramFilesDir: string read GetProgramFilesDir write FDummy stored False;
    property WinDir: string read GetWinDir write FDummy stored False;
    property WinBootDir: string read GetWinBootDir write FDummy stored False;
    property BootDir: string read GetBootDir write FDummy stored False;
    property CommonFilesDir: string read GetCommonFilesDir write FDummy stored False;
    property ConfigPath: string read GetConfigPath write FDummy stored False;
    property DevicePath: string read GetDevicePath write FDummy stored False;
    property MediaPath: string read GetMediaPath write FDummy stored False;
    property ProductID: string read GetProductID write FDummy stored False;
    property ProductName: string read GetProductName write FDummy stored False;
    property RegisteredOrganization: string read GetRegisteredOrganization write FDummy stored False;
    property RegisteredOwner: string read GetRegisteredOwner write FDummy stored False;
    property SystemRoot: string read GetSystemRoot write FDummy stored False;
    property Version: string read GetVersion write FDummy stored False;
    property VersionNumber: string read GetVersionNumber write FDummy stored False;
    property BootHost: string read GetBootHost write FDummy stored False;
    property HostWinBootDir: string read GetHostWinBootDir write FDummy stored False;
    property MachineDir: string read GetMachineDir write FDummy stored False;
    property SharedDir: string read GetSharedDir write FDummy stored False;
    property SysDir: string read GetSysDir write FDummy stored False;
    property Wallpaper: string read GetWallpaper write FDummy stored False;
    property WinAdminDir: string read GetWinAdminDir write FDummy stored False;
    property AppData: string read GetAppData write FDummy stored False;
    property Cache: string read GetCache write FDummy stored False;
    property Cookies: string read GetCookies write FDummy stored False;
    property Desktop: string read GetDesktop write FDummy stored False;
    property Favorites: string read GetFavorites write FDummy stored False;
    property Fonts: string read GetFonts write FDummy stored False;
    property History: string read GetHistory write FDummy stored False;
    property MyPictures: string read GetMyPictures write FDummy stored False;
    property NetHood: string read GetNetHood write FDummy stored False;
    property MyDocuments: string read GetMyDocuments write FDummy stored False; // Personal
    property StartMenuPrograms: string read GetStartMenuPrograms write FDummy stored False;
    property Recent: string read GetRecent write FDummy stored False;
    property SendTo: string read GetSendTo write FDummy stored False;
    property StartMenu: string read GetStartMenu write FDummy stored False;
    property StartMenuStartup: string read GetStartMenuStartup write FDummy stored False;
  end;

procedure Register;

implementation

var Reg: TRegistry;

function TAllSystemPaths.GetProgramFilesPath: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False);
 GetProgramFilesPath := Reg.ReadString('ProgramFilesPath');
 Reg.Free;
end;

function TAllSystemPaths.GetProgramFilesDir: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False);
 GetProgramFilesDir := Reg.ReadString('ProgramFilesDir');
 Reg.Free;
end;

function TAllSystemPaths.GetWinDir: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Setup', False);
 GetWinDir := Reg.ReadString('WinDir');
 Reg.Free;
end;

function TAllSystemPaths.GetWinBootDir: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Setup', False);
 GetWinBootDir := Reg.ReadString('WinBootDir');
 Reg.Free;
end;

function TAllSystemPaths.GetBootDir: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Setup', False);
 GetBootDir := Reg.ReadString('BootDir');
 Reg.Free;
end;

function TAllSystemPaths.GetCommonFilesDir: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False);
 GetCommonFilesDir := Reg.ReadString('CommonFilesDir');
 Reg.Free;
end;

function TAllSystemPaths.GetConfigPath: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False);
 GetConfigPath := Reg.ReadString('ConfigPath');
 Reg.Free;
end;

function TAllSystemPaths.GetDevicePath: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False);
 GetDevicePath := Reg.ReadString('DevicePath');
 Reg.Free;
end;

function TAllSystemPaths.GetMediaPath: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False);
 GetMediaPath := Reg.ReadString('MediaPath');
 Reg.Free;
end;

function TAllSystemPaths.GetProductID: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False);
 GetProductID := Reg.ReadString('ProductID');
 Reg.Free;
end;

function TAllSystemPaths.GetProductName: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False);
 GetProductName := Reg.ReadString('ProductName');
 Reg.Free;
end;

function TAllSystemPaths.GetRegisteredOrganization: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False);
 GetRegisteredOrganization := Reg.ReadString('RegisteredOrganization');
 Reg.Free;
end;

function TAllSystemPaths.GetRegisteredOwner: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False);
 GetRegisteredOwner := Reg.ReadString('RegisteredOwner');
 Reg.Free;
end;

function TAllSystemPaths.GetSystemRoot: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False);
 GetSystemRoot := Reg.ReadString('SystemRoot');
 Reg.Free;
end;

function TAllSystemPaths.GetVersion: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False);
 GetVersion := Reg.ReadString('Version');
 Reg.Free;
end;

function TAllSystemPaths.GetVersionNumber: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False);
 GetVersionNumber := Reg.ReadString('VersionNumber');
 Reg.Free;
end;

function TAllSystemPaths.GetBootHost: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Setup', False);
 GetBootHost := Reg.ReadString('BootHost');
 Reg.Free;
end;

function TAllSystemPaths.GetHostWinBootDir: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Setup', False);
 GetHostWinBootDir := Reg.ReadString('HostWinBootDir');
 Reg.Free;
end;

function TAllSystemPaths.GetMachineDir: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Setup', False);
 GetMachineDir := Reg.ReadString('MachineDir');
 Reg.Free;
end;

function TAllSystemPaths.GetSharedDir: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Setup', False);
 GetSharedDir := Reg.ReadString('SharedDir');
 Reg.Free;
end;

function TAllSystemPaths.GetSysDir: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Setup', False);
 GetSysDir := Reg.ReadString('SysDir');
 Reg.Free;
end;

function TAllSystemPaths.GetWallpaper: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Setup', False);
 GetWallpaper := Reg.ReadString('Wallpaper');
 Reg.Free;
end;

function TAllSystemPaths.GetWinAdminDir: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_LOCAL_MACHINE;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Setup', False);
 GetWinAdminDir := Reg.ReadString('WinAdminDir');
 Reg.Free;
end;

function TAllSystemPaths.GetAppData: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetAppData := Reg.ReadString('AppData');
 Reg.Free;
end;

function TAllSystemPaths.GetCache: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetCache := Reg.ReadString('Cache');
 Reg.Free;
end;

function TAllSystemPaths.GetCookies: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetCookies := Reg.ReadString('Cookies');
 Reg.Free;
end;

function TAllSystemPaths.GetDesktop: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetDesktop := Reg.ReadString('Desktop');
 Reg.Free;
end;

function TAllSystemPaths.GetFavorites: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetFavorites := Reg.ReadString('Favorites');
 Reg.Free;
end;

function TAllSystemPaths.GetFonts: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetFonts := Reg.ReadString('Fonts');
 Reg.Free;
end;

function TAllSystemPaths.GetHistory: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetHistory := Reg.ReadString('History');
 Reg.Free;
end;

function TAllSystemPaths.GetMyPictures: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetMyPictures := Reg.ReadString('My Pictures');
 Reg.Free;
end;

function TAllSystemPaths.GetNetHood: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetNetHood := Reg.ReadString('NetHood');
 Reg.Free;
end;

function TAllSystemPaths.GetMyDocuments: string; // Personal
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetMyDocuments := Reg.ReadString('Personal');
 Reg.Free;
end;

function TAllSystemPaths.GetStartMenuPrograms: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetStartMenuPrograms := Reg.ReadString('Programs');
 Reg.Free;
end;

function TAllSystemPaths.GetRecent: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetRecent := Reg.ReadString('Recent');
 Reg.Free;
end;

function TAllSystemPaths.GetSendTo: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetSendTo := Reg.ReadString('SendTo');
 Reg.Free;
end;

function TAllSystemPaths.GetStartMenu: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetStartMenu := Reg.ReadString('Start Menu');
 Reg.Free;
end;

function TAllSystemPaths.GetStartMenuStartup: string;
begin
 Reg := TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False);
 GetStartMenuStartup := Reg.ReadString('Startup');
 Reg.Free;
end;


procedure Register;
begin
  RegisterComponents('Samples', [TAllSystemPaths]);
end;

end.
