unit AliasCB;

{
 Component derived from TComboBox
 "TAliasComboBox.GetAliases" fills TAliasComboBox-Items with Alias-Names
 If AliasesOnly is set to false, then the first Item is a dummy String,
 which can be set with the ItemNoAlias-Property.
 The Directory choosen from the User via Alias you find in
 "TAliasComboBox.Directory".
 Matthias 'KaosMki' Baerens 1999

 Please send any Enhancements to 'kaosmaki@yahoo.com' Thank you!

 YOU MAY FREELY DISTRIBUTE AND ENHANCE THE CODE, AS LONG AS YOU DON'T
 FORGET TO PUT MY NAME INTO THE COPYRIGHT AND SHOW YOUR CHANGINGS IN
 THE SOURCE CODE.

 NO WARRENTY FOR ANY KIND OF FAULTS IN HARD OR SOFTWARE IS GIVEN!!!
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DB, FileCtrl;

type
  TAliasComboBox = class(TComboBox)
  private
    { Private-Deklarationen }
    FNoAlias: String;
    FAliasesOnly: Boolean;
    Function GetDir: String;
  protected
    { Protected-Deklarationen }
  public
    Constructor Create(AOwner: TComponent); override;

  published
    { Published-Deklarationen }
    Procedure GetAliases;
    Property Directory: String Read GetDir;
    Property ItemNoAlias: String Read FNoAlias Write FNoAlias;
    Property AliasesOnly: Boolean Read FAliasesOnly Write FAliasesOnly;
  end;

procedure Register;

implementation

Constructor TAliasComboBox.Create(AOwner: TComponent);
Begin
  inherited;
  Style := csDropDownList;
  FNoAlias := '[No Alias]';
End;

procedure TAliasComboBox.GetAliases;
Begin
  Session.GetAliasNames(Items);
  If Not FAliasesOnly Then Begin
    Items.Insert(0,FNoAlias);
    ItemIndex := 0;
  End;
End;

function TAliasComboBox.GetDir: String;
Var
  ParList: TStringList;
Begin
  If ItemIndex>0 Then Begin
  ParList := TStringList.Create;
  Session.GetAliasParams(Items[ItemIndex],ParList);
  Result := ParList.Values['PATH'];
  ParList.Free;
  End Else Result := '';
End;

procedure Register;
begin
  RegisterComponents('KaosMki', [TAliasComboBox]);
end;

end.
