unit CMain;

interface

uses
  Windows, Messages, Classes, Controls, Forms, SysUtils,
  StdCtrls, Buttons, Mailslot;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    SendBtn: TBitBtn;
    Label1: TLabel;
    CompNameLabel: TLabel;
    WorkgroupNameLabel: TLabel;
    Mailslot: TMailslot;
    procedure SendBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Msg: PChar;
    St: String;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.SendBtnClick(Sender: TObject);
begin
  St := Memo1.Text;
  GetMem(Msg, Length(St) + 1);
  StrPCopy(Msg, St);
  try
   Mailslot.WriteMailslot('*', 'Server', Msg, Length(St) + 1, 0);
  except
   Application.MessageBox('Can''t send message to Server.','Error', mb_Ok or mb_IconStop);
  end;
  FreeMem(Msg, Length(St) + 1);
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  CompNameLabel.Caption := 'Computer Name: ' + Mailslot.GetMyComputerName;
  WorkgroupNameLabel.Caption := 'Workgroup: ' + Mailslot.GetMyWorkgroup;
end;

end.
