{*************************************************************}
{            TMailslot Component for Delphi 32                }
{ Version:   1.4                                              }
{ Author:    Aleksey Kuznetsov, Kiev, Ukraine                 }
{              (Xacker), ,          }
{ E-Mail:    xacker@phreaker.net                              }
{ Home Page: http://www.angen.net/~xacker/                    }
{ Created:   December, 13, 1998                               }
{ Modified:  March, 17, 1999                                  }
{ Legal:     Copyright (c) 1999 by Aleksey Xacker             }
{*************************************************************}
{                       MAILSLOTS:                            }
{ A mailslot is a mechanism for one-way interprocess          }
{ communications (IPC). An application written for Microsoft  }
{ Windows can store messages in a mailslot. The owner of the  }
{ mailslot can retrieve messages that are stored there. These }
{ messages are typically sent over a network to either a      }
{ specified computer or to all computers in a specified       }
{ domain. A domain is a group of workstations and servers     }
{ that share a group name.                                    }
{*************************************************************}
{                     IMPORTANT NOTE:                         }
{ This software is provided 'as-is', without any express or   }
{ implied warranty. In no event will the author be held       }
{ liable for any damages arising from the use of this         }
{ software.                                                   }
{ Permission is granted to anyone to use this software for    }
{ any purpose, including commercial applications, and to      }
{ alter it and redistribute it freely, subject to the         }
{ following restrictions:                                     }
{ 1. The origin of this software must not be misrepresented,  }
{    you must not claim that you wrote the original software. }
{    If you use this software in a product, an acknowledgment }
{    in the product documentation would be appreciated but is }
{    not required.                                            }
{ 2. Altered source versions must be plainly marked as such,  }
{    and must not be misrepresented as being the original     }
{    software.                                                }
{ 3. This notice may not be removed or altered from any       }
{    source distribution.                                     }
{*************************************************************}
{
Chronicles:

  13.XII.98: Creation of a component. An occassion for a spelling
             was the program - observer for screens of another's
             computers + local mailer (like WinPopup).
  14.XII.98: Added GetMyComputerName, GetMyWorkgroup, GetMyDescription
             for reception of the information about the current
             computer in a network.
  16.XII.98: Fixed annoying error arising in a case if Server has
             no time to accept the message from Client. For that
             added internal variable FMailSlotBusy, determining
             readiness to accept the following data.
             Also, added an opportunity of determination of a name
             Mailslot-Sender and protocol sended data. Protocol
             number has not importance by transfer of data and
             serves only for determinate type of data in the
             program, in which is used Mailslot component. This
             variable can be always zero.
             WARNING: If CreateFile (WriteMailslot) specifies a
             domain or uses the asterisk format to specify the
             system's primary domain, the application cannot write
             more than 400 (424) bytes at a time to the mailslot.
             If the application attempts to do so, the WriteFile
             function fails and GetLastError returns
             ERROR_BAD_NETPATH.
  17.XII.98: Note in Russian:
               .     
             .      
                  424
             .     .  
                 WriteMailslot , 
                  
             ,       
             .      .
             ,       ,
                .     
                   ,
              .
  24.XII.98: Great! Program Network Advisor v1.0 beta Freeware 
   (http://droids.virtualave.net/hyperspace/software/netadvisor.zip)
             is completed. This program perfectly demonstrates
             opportunities these components. Send me beer on
             E-mail, if you wish to receive the source code of
             Network Advisor. ;-))
             Added new function - GetMySharedDiskName, which
             returns network name of a disk (if a disk - common
             resource of a local network).
    10.I.99: As was found out, LanManager works in DOS code table.
             Necessary corrections are brought in (works with Registry).
             Added 'Recipient' property, which determinates
             return address of the slot or domain name. (Slot OR Domain)
  17.III.99: Corrected lNextSize and SimpleBytes variables types from
  	     LongInt to DWORD.
             Delphi4 for some reason does not perceive LongInt type
             in GetMailslotInfo function.
             Thanks Alberto from Spain for descripting of error via e-mail.

*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*
Properties:
             Active - Flag of Mailslot presence
           SlotName - Mailslot Name (\\<?>\mailslot\<SlotName>)
                      <?> - Computer name, domain name, '.' or '*'.
            TimeOut - I always set it in a zero. It means that
                      meaning will be returns immediately if no
                      messag is present.
   DispatchInterval - (in MSecs) Works like TTimer and with the
                      specified frequency checks presence of the
                      new messages.
          Recipient - Which return address of message ?
                      SLOT OR DOMAIN ?

Events:
        OnDataExist - Processing coming data

Methods:
      WriteMailslot - Transfers data on other Mailslot
  GetMyComputerName - Returns computer name in network
     GetMyWorkgroup - Returns workgroup name
   GetMyDescription - Returns the computer description in network
GetMySharedDiskName - Returns shared disk name (or '' if disk not exist)

*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*!*
Questions or problems regarding TMailslot should be
directed to xacker@phreaker.net

  Thanks for using TMailslot :) and sorry for bad English :( }

unit Mailslot;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms,
  Registry;

const
  msloterrNoError     = 0;
  msloterrInvHandle   = 1; InvHandle = 'Can not create Mailslot Handle.';
  msloterrNoTimers    = 2; NoTimers = 'Out of system resources. No timers.';
  msloterrBadInfo     = 3; BadInfo = 'Can not read Mailslot Info.';
  msloterrBadTimeOut  = 4; BadTimeOut = 'Can not change TimeOut.';
  msloterrCantRead    = 5; CantRead = 'Can not read data from Mailslot.';
  msloterrCantWrite   = 6; CantWrite = 'Can not write data to Mailslot.';

type
  LongType = record
    case Word of
      0: (Ptr: Pointer);
      1: (Long: Longint);
      2: (Lo: Word;
	  Hi: Word);
  end;

  Giant = Array[0..$FFFF] of Byte;

  EMailslotException = class(Exception)
    ErrorCode : Word;
    constructor Create(const Msg : String; ErrCode : Word);
  end;

  TOnDataExistEvent = procedure(Sender: TObject;
                                Recipient: String;
                                Buffer: Pointer;
                                Size: Word;
                                Protocol: Byte) of object;

  TRecipientDef = (rSlot, rDomain);                              
  TMailslot = class(TComponent)
  private
    PC: Array[0..$FF] of char;
    FWindowHandle: hWnd;

    FSlotName: String;
    FTimeOut: LongInt;
    FDispatchInterval: LongInt;
    FActive: Boolean;
    FRecipient: TRecipientDef;

    FOnDataExist: TOnDataExistEvent;

    Buffer: Pointer;
    lMaxMessageSize, lMessageCount, lTimeOut: Pointer;
    lNextSize, SimpleBytes: DWord; // or LongInt 
    SlotFile: THandle;

    FMailslotBusy: Boolean;

    procedure SetActive(Value: Boolean);
    procedure SetSlotName(Value: String);
    procedure SetTimeOut(Value: LongInt);
    procedure SetDispatchInterval(Value: LongInt);
    procedure WndProc(var Msg: TMessage);
    procedure Timer; dynamic;
  protected
    procedure CreateSlot;
    procedure KillSlot;
  public
    MailslotError: Boolean;
    MailslotHandle: THandle;

    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;

    { DomainName may be asterisk (*) or Computer_Name }
    function WriteMailslot(DomainName, SlotName: String; Buffer: pointer;
                           Size: Word; Protocol: Byte): Boolean;
    function GetMyComputerName: String;
    function GetMyWorkgroup: String;
    function GetMyDescription: String;

    { Path may be 'C:\' or 'D:\' or 'D:\GAMES\' ... }
    function GetMySharedDiskName(Path: String): String;
  published
    property SlotName: String read FSlotName write SetSlotName;
    property TimeOut: LongInt read FTimeOut write SetTimeOut;
    property DispatchInterval: LongInt read FDispatchInterval write SetDispatchInterval;
    property Active: Boolean read FActive write SetActive;
    property Recipient: TRecipientDef read FRecipient write FRecipient;

    property OnDataExist: TOnDataExistEvent read FOnDataExist write FOnDataExist;
  end;

procedure Register;

implementation

function DOSToWin(St: String): String;
var
  PC: Array[0..$FF] of Char;
begin
  StrPCopy(PC, St);
  OEMToANSI(PC, PC);
  Result := StrPas(PC);
end;

constructor EMailslotException.Create(const Msg: String; ErrCode: Word);
begin
  inherited Create(Msg);
  ErrorCode := ErrCode;
end;

procedure TMailslot.CreateSlot;
begin
  if not (csDesigning in ComponentState) and FActive then
   begin
    if FDispatchInterval <> 0 then
     if SetTimer(FWindowHandle, 123, FDispatchInterval, nil) = 0 then
      raise EMailslotException.Create(NoTimers, msloterrNoTimers);
    StrPCopy(PC, '\\.\mailslot\' + FSlotName);
    MailslotHandle := CreateMailslot(PC, { Null terminated needed }
                                     0,  { Any size }
                                     FTimeOut,
                                     nil { No security ! });
    if MailslotHandle = INVALID_HANDLE_VALUE then
     begin
      MailslotError := True;
      FActive := False;
      if FDispatchInterval <> 0 then
       KillTimer(FWindowHandle, 123);
      Application.MessageBox(InvHandle, 'Network error', mb_Ok or mb_IconStop);
{      raise EMailslotException.Create(InvHandle, msloterrInvHandle);}
     end;
  end;
end;

procedure TMailslot.KillSlot;
begin
  if not (csDesigning in ComponentState) then
   begin
    if FDispatchInterval <> 0 then
     KillTimer(FWindowHandle, 123);
    CloseHandle(MailslotHandle);
   end;
end;

constructor TMailslot.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  FMailslotBusy := False;
  if (csDesigning in ComponentState) then
   begin
    TimeOut := 0;              { Returns immediately if no message
                                 is present. (The system does not
                                 treat an immediate return as an
                                 error) }
    SlotName := 'Slot';
    DispatchInterval := 10000; { 10 Seconds }
   end;
  FWindowHandle := AllocateHWnd(WndProc);
end;

destructor TMailslot.Destroy;
begin
  Active := False;
  DeallocateHWnd(FWindowHandle);
  inherited Destroy;
end;

procedure TMailslot.SetActive(Value: Boolean);
var
  V: Boolean;
begin
  V := FActive;
  FActive := Value;
  if not V and Value then CreateSlot;
  if V and not Value then KillSlot;
end;

procedure TMailslot.SetSlotName(Value: String);
begin
  if FSlotName <> Value then
   begin
    KillSlot;
    FSlotName := Value;
    CreateSlot;
   end;
end;

procedure TMailslot.SetTimeOut(Value: LongInt);
begin
  if (FTimeOut <> Value) and
     not (csDesigning in ComponentState) and FActive then
   if not SetMailslotInfo(MailslotHandle, Value) then
   raise EMailslotException.Create(BadTimeOut, msloterrBadTimeOut);   
  FTimeOut := Value;
end;

procedure TMailslot.SetDispatchInterval(Value: LongInt);
begin
  if FDispatchInterval <> Value then
   begin
    FDispatchInterval := Value;
    if FDispatchInterval <> 0 then
     begin
      KillTimer(FWindowHandle, 123);
      if SetTimer(FWindowHandle, 123, FDispatchInterval, nil) = 0 then
      raise EMailslotException.Create(NoTimers, msloterrNoTimers)
     end;
   end;
end;

procedure TMailslot.WndProc(var Msg: TMessage);
begin
  with Msg do
    if Msg = WM_TIMER then
      try
        if Assigned(FOnDataExist) and not FMailslotBusy then Timer;
      except
        Application.HandleException(Self);
      end
    else
      Result := DefWindowProc(FWindowHandle, Msg, wParam, lParam);
end;

procedure TMailslot.Timer;
var
  Recipient: ShortString;
  Protocol: Byte;
  Sz: Word;
begin
  if Windows.GetMailslotInfo(MailslotHandle,
                     lMaxMessageSize,
                     lNextSize,  {Change lNextSize type (see Windows unit or mail me) }
                     lMessageCount,
                     lTimeOut) then
   if lNextSize <> MAILSLOT_NO_MESSAGE then
    begin
     GetMem(Buffer, lNextSize);
     if ReadFile(MailslotHandle, Buffer^, lNextSize, SimpleBytes, nil) then
      begin
       FMailslotBusy := True; { Updates from 16.XII.98 }

       Move(Buffer^, Protocol, SizeOf(Protocol));
       Move(Giant(Buffer^)[SizeOf(Protocol)], Recipient, 1);
       Move(Giant(Buffer^)[SizeOf(Protocol) + 1], Recipient[1], Byte(Recipient[0]));
       Sz := lNextSize - (Length(Recipient) + SizeOf(Protocol) + 1);
       Move(Giant(Buffer^)[Length(Recipient) + SizeOf(Protocol) + 1], Buffer^, Sz);
       FOnDataExist(Self, Recipient, Buffer, Sz, Protocol);
       FMailslotBusy := False;
      end
     else
      raise EMailslotException.Create(CantRead, msloterrCantRead);
     FreeMem(Buffer, lNextSize); 
    end
   else
  else
    raise EMailslotException.Create(BadInfo, msloterrBadInfo);
end;

function TMailslot.WriteMailslot(DomainName, SlotName: String;
                                 Buffer: Pointer; Size: Word;
                                 Protocol: Byte): Boolean;
var
  SwapBuf: Pointer;
  Sz: Word;
  SName: ShortString;
begin
  { DomainName may be asterisk (*) or Computer_Name }
  StrPCopy(PC, '\\'+DomainName+'\mailslot\' + SlotName);

  SlotFile := CreateFile(PC, GENERIC_WRITE, 0, nil,
                         OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
  if SlotFile <> INVALID_HANDLE_VALUE then
   begin
    if FRecipient = rSlot then SName := FSlotName
    else SName := GetMyComputerName;
    Sz := Length(SName) + Size + SizeOf(Protocol) + 1;
    GetMem(SwapBuf, Sz);
    Move(Protocol, SwapBuf^, SizeOf(Protocol));
    Move(SName, Giant(SwapBuf^)[SizeOf(Protocol)], Length(SName) + 1);
    Move(Buffer^, Giant(SwapBuf^)[Sz - Size], Size);
    if not WriteFile(SlotFile, SwapBuf^, Sz, SimpleBytes, nil) then
     raise EMailslotException.Create(CantWrite, msloterrCantWrite);
    FreeMem(SwapBuf, Sz);
   end          
  else
   raise EMailslotException.Create(CantWrite, msloterrCantWrite);
  CloseHandle(SlotFile);
  Result := True;
end;

function TMailslot.GetMyComputerName: String;
var
  Reg: TRegistry;
begin
  Reg := TRegistry.Create;
  try
    with Reg do
     begin
      RootKey := HKEY_LOCAL_MACHINE;
      OpenKey('\System\CurrentControlSet\Services\VxD\VNETSUP\', False);
      Result := DOSToWin(ReadString('ComputerName'));
     end;
  finally
   Reg.Free;
  end;
end;

function TMailslot.GetMyWorkgroup: String;
var
  Reg: TRegistry;
begin
  Reg := TRegistry.Create;
  try
    with Reg do
     begin
      RootKey := HKEY_LOCAL_MACHINE;
      OpenKey('\System\CurrentControlSet\Services\VxD\VNETSUP\', False);
      Result := DOSToWin(ReadString('Workgroup'));
     end;
  finally
   Reg.Free;
  end;
end;

function TMailslot.GetMyDescription: String;
var
  Reg: TRegistry;
begin
  Reg := TRegistry.Create;
  try
    with Reg do
     begin
      RootKey := HKEY_LOCAL_MACHINE;
      OpenKey('\System\CurrentControlSet\Services\VxD\VNETSUP\', False);
      Result := DOSToWin(ReadString('Comment'));
     end;
  finally
   Reg.Free;
  end;
end;

function TMailslot.GetMySharedDiskName(Path: String): String;
var
  Reg: TRegistry;
  St: TStringList;
  w: DWord;
begin
  Result := '';
  St := TStringList.Create;
  Reg := TRegistry.Create;
  try
    with Reg do
     begin
      RootKey := HKEY_LOCAL_MACHINE;
      OpenKey('\SOFTWARE\Microsoft\Windows\CurrentVersion\Network\LanMan\', False);
      GetKeyNames(St);
      w := St.Count;
      if w <> 0 then
       for w := 0 to w - 1 do
        begin
         OpenKey('\SOFTWARE\Microsoft\Windows\CurrentVersion\Network\LanMan\' + St[w], False);
         if Path = ReadString('Path') then
          begin
           Result := DOSToWin(St[w]);
           Break;
          end;
        end;
     end;
  finally
    Reg.Free;
  end;
  St.Free;
end;

procedure Register;
begin
  RegisterComponents('Xacker', [TMailSlot]);
end;

end.
