unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ToolWin, ExtCtrls;

type
  Tfrm = class(TForm)
    TreeView1: TTreeView;
    Splitter1: TSplitter;
    ListView1: TListView;
    StatusBar1: TStatusBar;
    ImageList1: TImageList;
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure TreeView1Expanding(Sender: TObject; Node: TTreeNode;
      var AllowExpansion: Boolean);
  private
    procedure ShowError(const ErrCode: integer);
    function QuerySubKeys(const RootKey: HKey): integer;//; var lpcSubKeys:integer):Integer;
    function QueryValues(const RootKey: HKey): integer;//; var lpcSubKeys:integer):Integer;
    function EnumKeys(const RootKey: hKey; const dwindex:DWORD):String;
    procedure DigKeys(const Key: HKey; const node :TTreeNode); //ADD ALWAYS
    procedure Explode(node:TTreeNode);
    function DigPath(node:TTreeNode):String;
  public
    { Public declarations }
  end;

 function ErrStr(const ErrNo:WORD):String;

var
  frm: Tfrm;

implementation

{$R *.DFM}

const
  HK_CR=HKEY_CLASSES_ROOT;    // $8000 0000
  HK_CU=HKEY_CURRENT_USER;    // $8000 0001
  HK_LM=HKEY_LOCAL_MACHINE;   // $8000 0002
  HK_U=HKEY_USERS;            // $8000 0003
  HK_PD=HKEY_PERFORMANCE_DATA;// $8000 0004
  HK_CC=HKEY_CURRENT_CONFIG;  // $8000 0005
  HK_DD=HKEY_DYN_DATA;        // $8000 0006

  CR=#13;

  BMP_RO_ACCESS=1;
  BMP_RW_ACCESS=5;
  BMP_ALL_ACCESS=6;
  
 function ErrStr(const ErrNo:WORD):String;
 begin
   // Get System Error Message
   SetLength(Result, 255);
   FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, nil,
     ErrNo, 0, pChar(Result), 255, nil);
   //formatting quirk, C & Pascal string conversion
   Result:= pChar(Result);
 end;

procedure Tfrm.ShowError(const ErrCode: integer);
begin
  ShowMessage('Error number: ' + inttohex(ErrCode, 2) + #13 + ErrStr(ErrCode));
end;

function tfrm.QuerySubKeys(const RootKey: HKey):integer;
const
  lpClass:String='-';
  lpcbClass: DWORD=0;              // address of size of class string buffer
  lpReserved: DWORD=0;             // reserved
  lpcSubKeys:DWORD=0;              // address of buffer for number of subkeys
  lpcbMaxSubKeyLen:DWORD=0;        // address of buffer for longest subkey name length
  lpcbMaxClassLen:DWORD=0;         // address of buffer for longest class string length
  lpcValues:DWORD=0;               // address of buffer for number of value entries
  lpcbMaxValueNameLen:DWORD=0;     // address of buffer for longest value name length
  lpcbMaxValueLen:DWORD=0;         // address of buffer for longest value data length
  lpcbSecurityDescriptor:DWORD=0;  // address of buffer for security descriptor length
  lpftLastWriteTime:TFILETIME=();     // address of buffer for last write time

begin
  SetLength(lpClass, 255);
  lpcbClass:=255;              // address of size of class string buffer
  lpReserved:=0;             // reserved
  lpcSubKeys:=0;              // address of buffer for number of subkeys
  lpcbMaxSubKeyLen:=255;        // address of buffer for longest subkey name length
  lpcbMaxClassLen:=255;         // address of buffer for longest class string length
  lpcValues:=0;               // address of buffer for number of value entries
  lpcbMaxValueNameLen:=255;     // address of buffer for longest value name length
  lpcbMaxValueLen:=255;         // address of buffer for longest value data length
  lpcbSecurityDescriptor:=255;  // address of buffer for security descriptor length

  Result:=RegQueryInfoKey(RootKey, nil{pChar(lpClass)}, nil{@lpcbClass}, nil{@lpReserved}, @lpcSubKeys,
    @lpcbMaxSubKeyLen, @lpcbMaxClassLen, @lpcValues, @lpcbMaxValueNameLen, @lpcbMaxValueLen,
    nil{@lpcbSecurityDescriptor}, @lpftLastWriteTime);
  if Result<>0 then begin
    raise exception.create(ErrStr(Result))
  end
  else
    Result:= lpcSubKeys;
end;

function tfrm.EnumKeys(const RootKey: HKey; const dwindex:DWORD):String;
const
  lpftLastWriteTime:TFILETIME=();     // address of buffer for last write time
  lpcbName:DWORD = (255);
  lpcbClass:DWORD = (255);
var
  nmc:String;
  i:integer;
  errc:integer;
begin
//  for i:= 0 to dwIndex-1 do begin
  errc:=0; i:=0;
  while errc = 0 do begin
    setlength(nmc, 255); ZeroMemory(@nmc[1], 255);
    SetLength(Result, 255); //ZeroMemory(@Result[1], 255);
    lpcbName:=255; lpcbClass:=255;
    lpftLastWriteTime.dwHighDateTime:=0;
    lpftLastWriteTime.dwLowDateTime:=0;
    errc:= RegEnumKeyEx(RootKey, (i){dwIndex}, (pChar(Result)), lpcbName, nil, pChar(nmc),
      @lpcbClass, @lpftLastWriteTime);
    if errc <> 0 then begin
        raise exception.Create(ErrStr(errc));
        break;
      end;

    showmessage(
      'hKey'#9#9#9 + ': ' + inttohex(RootKey, 8) + CR+// handle of key to enumerate
  //    'dwIndex'#9#9 + ': ' + inttostr(dwIndex) + CR + // index of subkey to enumerate
      'dwIndex'#9#9 + ': ' + inttostr(i) + CR + // index of subkey to enumerate
  //    'lpName'#9 + ': ' + pChar(nmk) + CR + // address of buffer for subkey name
      'lpName'#9#9#9 + ': ' + pChar(Result) + CR + // address of buffer for subkey name
      'lpcbName'#9#9 + ': ' + inttostr(lpcbName) + CR + // address for size of subkey buffer
      'lpReserved'#9#9 + ': ' + inttostr(0) + CR + // reserved
      'lpClass'#9#9#9 + ': ' + pChar(nmc) + CR + // address of buffer for class string
      'lpcbClass'#9#9 + ': ' + inttostr(lpcbClass) + CR + // address for size of class buffer
      'lpftLastWriteTimeHi'#9 + ': '+ InttoStr(lpftLastWriteTime.dwHighDateTime) + CR + // address for time key last written to
      'lpftLastWriteTimeLo'#9 + ': '+ InttoStr(lpftLastWriteTime.dwLowDateTime) // address for time key last written to
    );

    inc(i);
  end;
end;
procedure tfrm.DigKeys(const Key: HKey; const node: TTreeNode); //ADD
const
  lpftLastWriteTime:TFILETIME=();     // address of buffer for last write time
  lpcbName:DWORD = 255;
  lpcbClass:DWORD = 255;
var
  nmk:pChar;//String[255];
  nmc:pChar;//String[255];
  i:integer;
  errc:integer;
  subkey:integer;
  NodeAdded:TTreeNode;
begin
  errc:=0; i:=0;
  GetMem(nmk, 255);
  GetMem(nmc, 255);
  while errc = 0 do begin
    //SetLength(nmk, 255);
    ZeroMemory(@nmk[1], 255);
    //setlength(nmc, 255);
    ZeroMemory(@nmc[1], 255);
    lpcbName:=255; lpcbClass:=255;
    lpftLastWriteTime.dwHighDateTime:=0;
    lpftLastWriteTime.dwLowDateTime:=0;
    errc:= RegEnumKeyEx(Key, (i){dwIndex}, (pChar(nmk)), lpcbName, nil, pChar(nmc),
      @lpcbClass, @lpftLastWriteTime);
    if errc = 0 then begin
      NodeAdded:=TreeView1.Items.AddChild(node, pChar(nmk));
      NodeAdded.StateIndex:=0;
      if RegOpenKeyEx(Key, pChar(nmk), 0, KEY_READ, subKey) = 0 then begin
        NodeAdded.StateIndex:=BMP_RO_ACCESS;//1+i mod 15;
        if QuerySubKeys(SubKey)>0 then
          TreeView1.Items.AddChild(NodeAdded, 'NewSub');
        RegCloseKey(subKey);
      end;
      if RegOpenKeyEx(Key, pChar(nmk), 0, KEY_WRITE or KEY_READ, subKey) = 0 then begin
        //if QuerySubKeys(SubKey)>0 then
        //  TreeView1.Items.AddChild(NodeAdded, 'NewSub');
        NodeAdded.StateIndex:=BMP_RW_ACCESS;//1+i mod 15;
        RegCloseKey(subKey);
      end;
      if RegOpenKeyEx(Key, pChar(nmk), 0, KEY_ALL_ACCESS, subKey) = 0 then begin
        //if QuerySubKeys(SubKey)>0 then
        //  TreeView1.Items.AddChild(NodeAdded, 'NewSub');
        NodeAdded.StateIndex:=BMP_ALL_ACCESS;//1+i mod 15;
        RegCloseKey(subKey);
      end;
    end;
    inc(i);
  end;
  FreeMem(nmc);FreeMem(nmk);
end;

function tfrm.DigPath(node:TTreeNode):String;
begin
  if node.Level>0 then
    Result:= DigPath(node.parent) + Result + '\' + node.Text
  else Result:= InttoStr(node.Index) + Result;
end;

procedure tfrm.Explode(node:TTreeNode);
begin
end;

function tfrm.QueryValues(const RootKey:integer):integer;
const KB=1024;
  function fmt(const p:pByteArray; const z:integer):String;
  var i:integer;
  begin
    Result:='';
    for i:=0 to z-1 do begin
      Result:=Result+ inttohex(p^[i],2)+',';
    end;
  end;
var
  i, ln, tp, sz, errc, dt:integer;
  data: pbyte;
  vname:pChar;
  L:TListItem;
//  tb:TByteArray;
  S:String;
begin
  GetMem(vname, 255);
  GetMem(data, 8*1024);
  ListView1.Items.BeginUpdate;
  i:=0; errc:=0;
  ListView1.Items.Clear;
  while errc=0 do begin
    ZeroMemory(vname, 255);
    ZeroMemory(data, 8*KB);
    tp:=0; ln:=255; sz:=8*KB;
    errc:= RegEnumValueA(RootKey, i, vname, ln, nil, @tp, data, @sz);
    if errc<>0 then break;
    //errc:= RegEnumValue(RootKey, i, vname, ln, nil, @tp, data, @sz);
    //if errc<>0 then break;
    L:= ListView1.Items.Add;
    if ln=0 then
      move('Default'#0, vname[0], sizeof('Default')*2+1);
    L.Caption:= pChar(vname);
    L.SubItems.Add(Inttostr(sz));
    case tp of
      REG_BINARY: begin         //Binary data in any form.
        L.SubItems.Add('Binary');
        L.SubItems.Add(pChar(fmt(@data, sz)));
      end;
      //      REG_DWORD:	         //A 32-bit number.
      //      L.SubItems.Add('DWORD');
      REG_DWORD_LITTLE_ENDIAN:   //A 32-bit number in little-endian format
                                 //(same as REG_DWORD). In little-endian format,
                                 //the most significant byte of a word is the high-order
                                 //byte. This is the most common format for computers
                                 //running Windows NT and Windows 95.
        begin
        L.SubItems.Add('DW-Intel');
        move(data^, dt, sizeof(integer));
        L.SubItems.Add(IntToSTr(dt)+ ' = '+InttoHex(dt,0)+'H');
      end;
      REG_DWORD_BIG_ENDIAN:      //A 32-bit number in big-endian format. In big-endian format, the most significant byte of a word is the low-order byte.
        begin
        move(data^, dt, sizeof(integer));
        asm
          mov eax, dt
          xchg ah, al
          rol eax, 16
          xchg ah, al
          mov dt, eax
        end;
        L.SubItems.Add('DW-Mac');
        L.SubItems.Add(Inttostr(dt));
      end;
      REG_EXPAND_SZ: begin     //A null-terminated string that contains unexpanded
                               //references to environment variables (for example,
                               //"%PATH%"). It will be a Unicode or ANSI string depending
                               //on whether you use the Unicode or ANSI functions.
        L.SubItems.Add('ParamStr');
        L.SubItems.Add(pChar(data));
      end;
      REG_LINK:	begin            //A Unicode symbolic link.
        L.SubItems.Add('LINK');
        L.SubItems.Add(pChar(data));
      end;
      REG_MULTI_SZ: begin        //An array of null-terminated strings, terminated by two
                                 //null characters.
        L.SubItems.Add('STRINGS');
        L.SubItems.Add(pChar(data));
      end;
      REG_NONE:	 begin           //No defined value type.
        L.SubItems.Add('Undefined');
      end;
      REG_RESOURCE_LIST: begin   //A device-driver resource list.
        L.SubItems.Add('Resources');
        L.SubItems.Add(pChar(fmt(@data, sz)));
      end;
      REG_SZ: begin         //A null-terminated string. It will be a Unicode or ANSI string,
                            //depending on whether you use the Unicode or ANSI functions.
        L.SubItems.Add('ASCIIZ');
        L.SubItems.Add(pChar(data));
      end;
      else
        L.SubItems.Add('Unknown');
        L.SubItems.Add(pChar(fmt(@data, sz)));
    end;
    inc(i);
  end;
  FreeMem(data);
  FreeMem(vname);
  ListView1.Items.EndUpdate;
end;

procedure Tfrm.TreeView1Change(Sender: TObject; Node: TTreeNode);
var
  SubStr:String;
  Key:HKey;
begin
  SubStr:=DigPath(node);
  with StatusBar1 do
    case node.StateIndex of
      BMP_RO_ACCESS:SimpleText:=SubStr+' (ReadOnly)';
      BMP_RW_ACCESS:SimpleText:=SubSTr+' (ReadWRite)';
      BMP_ALL_ACCESS:SimpleText:=SubSTr+' (FullAccess)';
    end;
  Key:=StrToInt('$8000000'+SubStr[1]);
  SubStr:=copy(SubStr, 3, length(SubStr));
  if RegOpenKeyEx(Key, pChar(SubStr), 0, KEY_READ , Key) = 0 then begin
    QueryValues(Key);
    RegCloseKey(Key);
  end;

end;

procedure Tfrm.TreeView1Expanding(Sender: TObject; Node: TTreeNode;
  var AllowExpansion: Boolean);
var
  SubKeyStr: String;
  Key: HKey;
begin
  SubKeyStr:=DigPath(node);
  Key:=StrToInt('$8000000'+SubKeyStr[1]);
  SubKeyStr:=copy(SubKeyStr, 3, length(SubKeyStr));
  TreeView1.items.BeginUpdate;
  node.DeleteChildren;
  if RegOpenKeyEx(Key, pChar(SubKeyStr), 0, KEY_READ , Key) = 0 then begin
    DigKeys(Key, node);
    RegCloseKey(Key);
  end;
  TreeView1.items.EndUpdate;
end;

END.

