unit aboutdlg;

interface
uses
   Classes, Windows, Dialogs, SysUtils, CPUType, Forms;

type
  TAboutBoxDlg = Class(TComponent)

  private
  FProductName, FVersion, FCopyright, FComments1, FComments2: string;

  public
  function Execute: Boolean;

  published
  property ProductName: string read FProductName write FProductName;
  property Version: string read FVersion write FVersion;
  property Copyright: string read FCopyright write FCopyright;
  property Comments1: string read FComments1 write FComments1;
  property Comments2: string read FComments2 write FComments2;
  end;

  procedure Register;

implementation
uses About;
var
  AboutBox: TAboutBox;

function TAboutBoxDlg.Execute: Boolean;
var
  OsInfo: TOSVERSIONINFO;
  SysInfo: TSYSTEMINFO;
  MemStat: TMEMORYSTATUS;
  DiskNo: Integer;
begin
     AboutBox := TAboutBox.Create(Application);

     OsInfo.dwOSVersionInfoSize := sizeof(TOSVERSIONINFO);
     GetVersionEx(OsInfo);

     case OsInfo.dwPlatformId of
          VER_PLATFORM_WIN32s        : AboutBox.OSName.Caption := 'Windows 3.1';
          VER_PLATFORM_WIN32_WINDOWS : AboutBox.OSName.Caption := 'Windows 95';
          VER_PLATFORM_WIN32_NT	     : AboutBox.OSName.Caption := 'Windows NT';
     end;

     AboutBox.OSVersion.Caption := format('%d.%d   Build : %d',
     [OsInfo.dwMajorVersion,OsInfo.dwMinorVersion,LOWORD(OsInfo.dwBuildNumber)]);

     GetSystemInfo(SysInfo);

     case SysInfo.dwProcessorType of
          PROCESSOR_INTEL_386     : AboutBox.CPUName.Caption := format('%d %s',[SysInfo.dwNumberOfProcessors, 'Intel 80386']);
          PROCESSOR_INTEL_486     : AboutBox.CPUName.Caption := format('%d %s',[SysInfo.dwNumberOfProcessors, 'Intel 80486']);
          PROCESSOR_INTEL_PENTIUM : AboutBox.CPUName.Caption := format('%d %s',[SysInfo.dwNumberOfProcessors, 'Intel Pentium']);
          PROCESSOR_MIPS_R4000    : AboutBox.CPUName.Caption := format('%d %s',[SysInfo.dwNumberOfProcessors, 'MIPS R4000']);
          PROCESSOR_ALPHA_21064   : AboutBox.CPUName.Caption := format('%d %s',[SysInfo.dwNumberOfProcessors, 'ALPHA 21064']);
     end;

     MemStat.dwLength := sizeof(TMEMORYSTATUS);
     GlobalMemoryStatus(MemStat);

     AboutBox.Memory.Caption := format('Tot: %d KB     Avl: %d KB',[Trunc(MemStat.dwAvailPhys/1024),Trunc(MemStat.dwTotalPhys/1024)]);

     DiskNo := 3;
     AboutBox.DiskFree.Caption := '';
     AboutBox.DiskFree1.Caption := '';
     repeat
           if DiskNo < 7 then
              AboutBox.DiskFree.Caption := AboutBox.DiskFree.Caption + format('%s: %d MB  ',[Chr(DiskNo + Ord('A')- 1),Trunc(DiskFree(DiskNo)/1024/1024)])
           else
              AboutBox.DiskFree1.Caption := AboutBox.DiskFree1.Caption + format('%s: %d MB  ',[Chr(DiskNo + Ord('A')- 1),Trunc(DiskFree(DiskNo)/1024/1024)]);
           inc(DiskNo);
     until DiskFree(DiskNo)=-1;

     with AboutBox do begin
          ProductName.Caption := FProductName;
          Version.Caption := FVersion;
          Copyright.Caption := FCopyRight;
          Comments1.Caption := FComments1;
          Comments2.Caption := FComments2;
          ProgramIcon.Picture.Graphic := Application.Icon;
          Caption := 'About ' + FProductName;
          Result := (ShowModal = IDOK);
     end;
     AboutBox.Free;
end;

procedure Register;
begin
  RegisterComponents('Dialogs', [TAboutBoxDlg]);
end;

end.
