unit _BRQueryDetail;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB, DBTables;

Type

  TBRQueryDetail = class(TQuery)
  Private
    { Private declarations }
    FAddParameters : Boolean;
  Protected
    { Protected declarations }
    Procedure DoAfterInsert; Override;
  Public
   Constructor Create(AOwner:TComponent); Override;
   Destructor Destroy; Override;
    { Public declarations }
  Published
   Property AddParameters : Boolean Read FAddParameters Write FAddParameters;
    { Published declarations }
  End;

Procedure Register;

Implementation

Procedure Register;
Begin
  RegisterComponents('Bienvenido', [TBRQueryDetail]);
End;

Constructor TBRQueryDetail.Create(AOwner:TComponent); 
Begin
  Inherited Create(AOwner);
  FAddParameters:=False;
End;

Procedure TBRQueryDetail.DoAfterInsert;
 Var I:Integer;
Begin
  Inherited DoAfterInsert;
  If Not FAddParameters Then Exit;
  If ParamCount > 0 Then
  For i:=0 To ParamCount-1 Do
  Begin
      Case Params[i].DataType Of
       ftUnkNown        :
        Begin
          ShowMessage('Incorrect DataType for '+Params[i].Name);
          Exit;
        End;
       ftBoolean        :
         FieldByName(Params[i].Name).AsBoolean:=Params[i].AsBoolean;
       ftCurrency       :
         FieldByName(Params[i].Name).AsCurrency:=Params[i].AsCurrency;
       ftDateTime       :
         FieldByName(Params[i].Name).AsDateTime:=Params[i].AsDateTime;
       ftFloat          :
         FieldByName(Params[i].Name).AsFloat:=Params[i].AsFloat;
       ftInteger        :
        FieldByName(Params[i].Name).AsInteger:=Params[i].AsInteger;
       ftString         :
         FieldByName(Params[i].Name).AsString:=Params[i].AsString;
     End;
  End; 
End;

Destructor TBRQueryDetail.Destroy;
Begin
  Inherited Destroy;
End;

End.
