unit StatesAndCounties;
{ provides lists of states and counties for each state                    }
{ provides conversion of state name to postal abbreviation and vice-versa }
{ nothing fancy, just a bunch of work someone else won't have to repeat   }
{ written by Dennis Sedgwick <dgsedg@pacbell.net>   8/4/2001              }
{ donated to the public domain; use it in good health                     }
{ if you come up with a great enhancement, send me a copy                 }


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  SCRec = record
          state: string[2];
          idnum: integer;
          county: string[25];
          end;

const
  SCRecordCount = 3156;
  SCData: array[1..SCRecordCount] of SCRec =(
          (state: 'AK'; idnum: 0; county: 'Alaska'),
          (state: 'AK'; idnum: 1; county: 'Aleutian Islands East'),
          (state: 'AK'; idnum: 2; county: 'Aleutian Islands West'),
          (state: 'AK'; idnum: 3; county: 'Anchorage'),
          (state: 'AK'; idnum: 4; county: 'Angoon'),
          (state: 'AK'; idnum: 5; county: 'Barrow'),
          (state: 'AK'; idnum: 6; county: 'Bethel'),
          (state: 'AK'; idnum: 7; county: 'Bristol Bay'),
          (state: 'AK'; idnum: 8; county: 'Cordova-McCarthy'),
          (state: 'AK'; idnum: 9; county: 'Fairbanks'),
          (state: 'AK'; idnum: 10; county: 'Haines'),
          (state: 'AK'; idnum: 11; county: 'Juneau'),
          (state: 'AK'; idnum: 12; county: 'Kenai-Cook Inlet'),
          (state: 'AK'; idnum: 13; county: 'Ketchikan'),
          (state: 'AK'; idnum: 14; county: 'Kobuk'),
          (state: 'AK'; idnum: 15; county: 'Kodiak'),
          (state: 'AK'; idnum: 16; county: 'Matanuska-Susitna'),
          (state: 'AK'; idnum: 17; county: 'Nome'),
          (state: 'AK'; idnum: 18; county: 'Outer Ketchikan'),
          (state: 'AK'; idnum: 19; county: 'Prince of Wales'),
          (state: 'AK'; idnum: 20; county: 'Seward'),
          (state: 'AK'; idnum: 21; county: 'Sitka'),
          (state: 'AK'; idnum: 22; county: 'Skagway-Yakutat'),
          (state: 'AK'; idnum: 23; county: 'Southeast Fairbanks'),
          (state: 'AK'; idnum: 24; county: 'Upper Ukon'),
          (state: 'AK'; idnum: 25; county: 'Valdez-Chitina-Whittier'),
          (state: 'AK'; idnum: 26; county: 'Wade-Hampton'),
          (state: 'AK'; idnum: 27; county: 'Wrangell-Petersburg'),
          (state: 'AK'; idnum: 28; county: 'Yukon-Koyukuk'),
          (state: 'AL'; idnum: 0; county: 'Alabama'),
          (state: 'AL'; idnum: 1; county: 'Autauga'),
          (state: 'AL'; idnum: 2; county: 'Baldwin'),
          (state: 'AL'; idnum: 3; county: 'Barbour'),
          (state: 'AL'; idnum: 4; county: 'Bibb'),
          (state: 'AL'; idnum: 5; county: 'Blount'),
          (state: 'AL'; idnum: 6; county: 'Bullock'),
          (state: 'AL'; idnum: 7; county: 'Butler'),
          (state: 'AL'; idnum: 8; county: 'Calhoun'),
          (state: 'AL'; idnum: 9; county: 'Chambers'),
          (state: 'AL'; idnum: 10; county: 'Cherokee'),
          (state: 'AL'; idnum: 11; county: 'Chilton'),
          (state: 'AL'; idnum: 12; county: 'Choctaw'),
          (state: 'AL'; idnum: 13; county: 'Clarke'),
          (state: 'AL'; idnum: 14; county: 'Clay'),
          (state: 'AL'; idnum: 15; county: 'Cleburne'),
          (state: 'AL'; idnum: 16; county: 'Coffee'),
          (state: 'AL'; idnum: 17; county: 'Colbert'),
          (state: 'AL'; idnum: 18; county: 'Conecuh'),
          (state: 'AL'; idnum: 19; county: 'Coosa'),
          (state: 'AL'; idnum: 20; county: 'Covington'),
          (state: 'AL'; idnum: 21; county: 'Crenshaw'),
          (state: 'AL'; idnum: 22; county: 'Cullman'),
          (state: 'AL'; idnum: 23; county: 'Dale'),
          (state: 'AL'; idnum: 24; county: 'Dallas'),
          (state: 'AL'; idnum: 25; county: 'Dekalb'),
          (state: 'AL'; idnum: 26; county: 'Elmore'),
          (state: 'AL'; idnum: 27; county: 'Escambia'),
          (state: 'AL'; idnum: 28; county: 'Etowah'),
          (state: 'AL'; idnum: 29; county: 'Fayette'),
          (state: 'AL'; idnum: 30; county: 'Franklin'),
          (state: 'AL'; idnum: 31; county: 'Geneva'),
          (state: 'AL'; idnum: 32; county: 'Greene'),
          (state: 'AL'; idnum: 33; county: 'Hale'),
          (state: 'AL'; idnum: 34; county: 'Henry'),
          (state: 'AL'; idnum: 35; county: 'Houston'),
          (state: 'AL'; idnum: 36; county: 'Jackson'),
          (state: 'AL'; idnum: 37; county: 'Jefferson'),
          (state: 'AL'; idnum: 38; county: 'Lamar'),
          (state: 'AL'; idnum: 39; county: 'Lauderdale'),
          (state: 'AL'; idnum: 40; county: 'Lawrence'),
          (state: 'AL'; idnum: 41; county: 'Lee'),
          (state: 'AL'; idnum: 42; county: 'Limestone'),
          (state: 'AL'; idnum: 43; county: 'Lowndes'),
          (state: 'AL'; idnum: 44; county: 'Macon'),
          (state: 'AL'; idnum: 45; county: 'Madison'),
          (state: 'AL'; idnum: 46; county: 'Marengo'),
          (state: 'AL'; idnum: 47; county: 'Marion'),
          (state: 'AL'; idnum: 48; county: 'Marshall'),
          (state: 'AL'; idnum: 49; county: 'Mobile'),
          (state: 'AL'; idnum: 50; county: 'Monroe'),
          (state: 'AL'; idnum: 51; county: 'Montgomery'),
          (state: 'AL'; idnum: 52; county: 'Morgan'),
          (state: 'AL'; idnum: 53; county: 'Perry'),
          (state: 'AL'; idnum: 54; county: 'Pickens'),
          (state: 'AL'; idnum: 55; county: 'Pike'),
          (state: 'AL'; idnum: 56; county: 'Randolph'),
          (state: 'AL'; idnum: 57; county: 'Russell'),
          (state: 'AL'; idnum: 58; county: 'Shelby'),
          (state: 'AL'; idnum: 59; county: 'St. Clair'),
          (state: 'AL'; idnum: 60; county: 'Sumter'),
          (state: 'AL'; idnum: 61; county: 'Talladega'),
          (state: 'AL'; idnum: 62; county: 'Tallapoosa'),
          (state: 'AL'; idnum: 63; county: 'Tuscaloosa'),
          (state: 'AL'; idnum: 64; county: 'Walker'),
          (state: 'AL'; idnum: 65; county: 'Washington'),
          (state: 'AL'; idnum: 66; county: 'Wilcox'),
          (state: 'AL'; idnum: 67; county: 'Winston'),
          (state: 'AR'; idnum: 0; county: 'Arkansas'),
          (state: 'AR'; idnum: 1; county: 'Arkansas'),
          (state: 'AR'; idnum: 2; county: 'Ashley'),
          (state: 'AR'; idnum: 3; county: 'Baxter'),
          (state: 'AR'; idnum: 4; county: 'Benton'),
          (state: 'AR'; idnum: 5; county: 'Boone'),
          (state: 'AR'; idnum: 6; county: 'Bradley'),
          (state: 'AR'; idnum: 7; county: 'Calhoun'),
          (state: 'AR'; idnum: 8; county: 'Carroll'),
          (state: 'AR'; idnum: 9; county: 'Chicot'),
          (state: 'AR'; idnum: 10; county: 'Clark'),
          (state: 'AR'; idnum: 11; county: 'Clay'),
          (state: 'AR'; idnum: 12; county: 'Cleburne'),
          (state: 'AR'; idnum: 13; county: 'Cleveland'),
          (state: 'AR'; idnum: 14; county: 'Columbia'),
          (state: 'AR'; idnum: 15; county: 'Conway'),
          (state: 'AR'; idnum: 16; county: 'Craighead'),
          (state: 'AR'; idnum: 17; county: 'Crawford'),
          (state: 'AR'; idnum: 18; county: 'Crittenden'),
          (state: 'AR'; idnum: 19; county: 'Cross'),
          (state: 'AR'; idnum: 20; county: 'Dallas'),
          (state: 'AR'; idnum: 21; county: 'Desha'),
          (state: 'AR'; idnum: 22; county: 'Drew'),
          (state: 'AR'; idnum: 23; county: 'Faulkner'),
          (state: 'AR'; idnum: 24; county: 'Franklin'),
          (state: 'AR'; idnum: 25; county: 'Fulton'),
          (state: 'AR'; idnum: 26; county: 'Garland'),
          (state: 'AR'; idnum: 27; county: 'Grant'),
          (state: 'AR'; idnum: 28; county: 'Greene'),
          (state: 'AR'; idnum: 29; county: 'Hempstead'),
          (state: 'AR'; idnum: 30; county: 'Hot'),
          (state: 'AR'; idnum: 31; county: 'Spring'),
          (state: 'AR'; idnum: 32; county: 'Howard'),
          (state: 'AR'; idnum: 33; county: 'Independence'),
          (state: 'AR'; idnum: 34; county: 'Izard'),
          (state: 'AR'; idnum: 35; county: 'Jackson'),
          (state: 'AR'; idnum: 36; county: 'Jefferson'),
          (state: 'AR'; idnum: 37; county: 'Johnson'),
          (state: 'AR'; idnum: 38; county: 'Lafayette'),
          (state: 'AR'; idnum: 39; county: 'Lawrence'),
          (state: 'AR'; idnum: 40; county: 'Lee'),
          (state: 'AR'; idnum: 41; county: 'Lincoln'),
          (state: 'AR'; idnum: 42; county: 'Little River'),
          (state: 'AR'; idnum: 43; county: 'Logan'),
          (state: 'AR'; idnum: 44; county: 'Lonoke'),
          (state: 'AR'; idnum: 45; county: 'Madison'),
          (state: 'AR'; idnum: 46; county: 'Marion'),
          (state: 'AR'; idnum: 47; county: 'Miller'),
          (state: 'AR'; idnum: 48; county: 'Mississippi'),
          (state: 'AR'; idnum: 49; county: 'Monroe'),
          (state: 'AR'; idnum: 50; county: 'Montgomery'),
          (state: 'AR'; idnum: 51; county: 'Nevada'),
          (state: 'AR'; idnum: 52; county: 'Newton'),
          (state: 'AR'; idnum: 53; county: 'Ouachita'),
          (state: 'AR'; idnum: 54; county: 'Perry'),
          (state: 'AR'; idnum: 55; county: 'Phillips'),
          (state: 'AR'; idnum: 56; county: 'Pike'),
          (state: 'AR'; idnum: 57; county: 'Poinsett'),
          (state: 'AR'; idnum: 58; county: 'Polk'),
          (state: 'AR'; idnum: 59; county: 'Pope'),
          (state: 'AR'; idnum: 60; county: 'Prairie'),
          (state: 'AR'; idnum: 61; county: 'Pulaski'),
          (state: 'AR'; idnum: 62; county: 'Randolph'),
          (state: 'AR'; idnum: 63; county: 'Saline'),
          (state: 'AR'; idnum: 64; county: 'Scott'),
          (state: 'AR'; idnum: 65; county: 'Searcy'),
          (state: 'AR'; idnum: 66; county: 'Sebastian'),
          (state: 'AR'; idnum: 67; county: 'Sevier'),
          (state: 'AR'; idnum: 68; county: 'Sharp'),
          (state: 'AR'; idnum: 69; county: 'St. Francis'),
          (state: 'AR'; idnum: 70; county: 'Stone'),
          (state: 'AR'; idnum: 71; county: 'Union'),
          (state: 'AR'; idnum: 72; county: 'Van Buren'),
          (state: 'AR'; idnum: 73; county: 'Washington'),
          (state: 'AR'; idnum: 74; county: 'White'),
          (state: 'AR'; idnum: 75; county: 'Woodruff'),
          (state: 'AR'; idnum: 76; county: 'Yell'),
          (state: 'AZ'; idnum: 0; county: 'Arizona'),
          (state: 'AZ'; idnum: 1; county: 'Apache'),
          (state: 'AZ'; idnum: 2; county: 'Cochise'),
          (state: 'AZ'; idnum: 3; county: 'Coconino'),
          (state: 'AZ'; idnum: 4; county: 'Gila'),
          (state: 'AZ'; idnum: 5; county: 'Graham'),
          (state: 'AZ'; idnum: 6; county: 'Greenlee'),
          (state: 'AZ'; idnum: 7; county: 'La Paz'),
          (state: 'AZ'; idnum: 8; county: 'Maricopa'),
          (state: 'AZ'; idnum: 9; county: 'Mohave'),
          (state: 'AZ'; idnum: 10; county: 'Navajo'),
          (state: 'AZ'; idnum: 11; county: 'Pima'),
          (state: 'AZ'; idnum: 12; county: 'Pinal'),
          (state: 'AZ'; idnum: 13; county: 'Santa Cruz'),
          (state: 'AZ'; idnum: 14; county: 'Yavapai'),
          (state: 'AZ'; idnum: 15; county: 'Yuma'),
          (state: 'CA'; idnum: 0; county: 'California'),
          (state: 'CA'; idnum: 1; county: 'Alameda'),
          (state: 'CA'; idnum: 2; county: 'Alpine'),
          (state: 'CA'; idnum: 3; county: 'Amador'),
          (state: 'CA'; idnum: 4; county: 'Butte'),
          (state: 'CA'; idnum: 5; county: 'Calaveras'),
          (state: 'CA'; idnum: 6; county: 'Colusa'),
          (state: 'CA'; idnum: 7; county: 'Contra Costa'),
          (state: 'CA'; idnum: 8; county: 'Del Norte'),
          (state: 'CA'; idnum: 9; county: 'El Dorado'),
          (state: 'CA'; idnum: 10; county: 'Fresno'),
          (state: 'CA'; idnum: 11; county: 'Glenn'),
          (state: 'CA'; idnum: 12; county: 'Humboldt'),
          (state: 'CA'; idnum: 13; county: 'Imperial'),
          (state: 'CA'; idnum: 14; county: 'Inyo'),
          (state: 'CA'; idnum: 15; county: 'Kern'),
          (state: 'CA'; idnum: 16; county: 'Kings'),
          (state: 'CA'; idnum: 17; county: 'Lake'),
          (state: 'CA'; idnum: 18; county: 'Lassen'),
          (state: 'CA'; idnum: 19; county: 'Los Angeles'),
          (state: 'CA'; idnum: 20; county: 'Madera'),
          (state: 'CA'; idnum: 21; county: 'Marin'),
          (state: 'CA'; idnum: 22; county: 'Mariposa'),
          (state: 'CA'; idnum: 23; county: 'Mendocino'),
          (state: 'CA'; idnum: 24; county: 'Merced'),
          (state: 'CA'; idnum: 25; county: 'Modoc'),
          (state: 'CA'; idnum: 26; county: 'Mono'),
          (state: 'CA'; idnum: 27; county: 'Monterey'),
          (state: 'CA'; idnum: 28; county: 'Napa'),
          (state: 'CA'; idnum: 29; county: 'Nevada'),
          (state: 'CA'; idnum: 30; county: 'Orange'),
          (state: 'CA'; idnum: 31; county: 'Placer'),
          (state: 'CA'; idnum: 32; county: 'Plumas'),
          (state: 'CA'; idnum: 33; county: 'Riverside'),
          (state: 'CA'; idnum: 34; county: 'Sacramento'),
          (state: 'CA'; idnum: 35; county: 'San Benito'),
          (state: 'CA'; idnum: 36; county: 'San Bernardino'),
          (state: 'CA'; idnum: 37; county: 'San Diego'),
          (state: 'CA'; idnum: 38; county: 'San Francisco'),
          (state: 'CA'; idnum: 39; county: 'San Joaquin'),
          (state: 'CA'; idnum: 40; county: 'San Luis Obispo'),
          (state: 'CA'; idnum: 41; county: 'San Mateo'),
          (state: 'CA'; idnum: 42; county: 'Santa Barbara'),
          (state: 'CA'; idnum: 43; county: 'Santa Clara'),
          (state: 'CA'; idnum: 44; county: 'Santa Cruz'),
          (state: 'CA'; idnum: 45; county: 'Shasta'),
          (state: 'CA'; idnum: 46; county: 'Sierra'),
          (state: 'CA'; idnum: 47; county: 'Siskiyou'),
          (state: 'CA'; idnum: 48; county: 'Solano'),
          (state: 'CA'; idnum: 49; county: 'Sonoma'),
          (state: 'CA'; idnum: 50; county: 'Stanislaus'),
          (state: 'CA'; idnum: 51; county: 'Sutter'),
          (state: 'CA'; idnum: 52; county: 'Tehama'),
          (state: 'CA'; idnum: 53; county: 'Trinity'),
          (state: 'CA'; idnum: 54; county: 'Tulare'),
          (state: 'CA'; idnum: 55; county: 'Tuolumne'),
          (state: 'CA'; idnum: 56; county: 'Ventura'),
          (state: 'CA'; idnum: 57; county: 'Yolo'),
          (state: 'CA'; idnum: 58; county: 'Yuba'),
          (state: 'CO'; idnum: 0; county: 'Colorado'),
          (state: 'CO'; idnum: 1; county: 'Adams'),
          (state: 'CO'; idnum: 2; county: 'Alamosa'),
          (state: 'CO'; idnum: 3; county: 'Arapahoe'),
          (state: 'CO'; idnum: 4; county: 'Archuleta'),
          (state: 'CO'; idnum: 5; county: 'Baca'),
          (state: 'CO'; idnum: 6; county: 'Bent'),
          (state: 'CO'; idnum: 7; county: 'Boulder'),
          (state: 'CO'; idnum: 8; county: 'Chaffee'),
          (state: 'CO'; idnum: 9; county: 'Cheyenne'),
          (state: 'CO'; idnum: 10; county: 'Clear Creek'),
          (state: 'CO'; idnum: 11; county: 'Conejos'),
          (state: 'CO'; idnum: 12; county: 'Costilla'),
          (state: 'CO'; idnum: 13; county: 'Crowley'),
          (state: 'CO'; idnum: 14; county: 'Custer'),
          (state: 'CO'; idnum: 15; county: 'Delta'),
          (state: 'CO'; idnum: 16; county: 'Denver'),
          (state: 'CO'; idnum: 17; county: 'Dolores'),
          (state: 'CO'; idnum: 18; county: 'Douglas'),
          (state: 'CO'; idnum: 19; county: 'Eagle'),
          (state: 'CO'; idnum: 20; county: 'El Paso'),
          (state: 'CO'; idnum: 21; county: 'Elbert'),
          (state: 'CO'; idnum: 22; county: 'Fremont'),
          (state: 'CO'; idnum: 23; county: 'Garfield'),
          (state: 'CO'; idnum: 24; county: 'Gilpin'),
          (state: 'CO'; idnum: 25; county: 'Grand'),
          (state: 'CO'; idnum: 26; county: 'Gunnison'),
          (state: 'CO'; idnum: 27; county: 'Hinsdale'),
          (state: 'CO'; idnum: 28; county: 'Huerfano'),
          (state: 'CO'; idnum: 29; county: 'Jackson'),
          (state: 'CO'; idnum: 30; county: 'Jefferson'),
          (state: 'CO'; idnum: 31; county: 'Kiowa'),
          (state: 'CO'; idnum: 32; county: 'Kit Carson'),
          (state: 'CO'; idnum: 33; county: 'La Plata'),
          (state: 'CO'; idnum: 34; county: 'Lake'),
          (state: 'CO'; idnum: 35; county: 'Larimer'),
          (state: 'CO'; idnum: 36; county: 'Las Animas'),
          (state: 'CO'; idnum: 37; county: 'Lincoln'),
          (state: 'CO'; idnum: 38; county: 'Logan'),
          (state: 'CO'; idnum: 39; county: 'Mesa'),
          (state: 'CO'; idnum: 40; county: 'Mineral'),
          (state: 'CO'; idnum: 41; county: 'Moffat'),
          (state: 'CO'; idnum: 42; county: 'Montezuma'),
          (state: 'CO'; idnum: 43; county: 'Montrose'),
          (state: 'CO'; idnum: 44; county: 'Morgan'),
          (state: 'CO'; idnum: 45; county: 'Otero'),
          (state: 'CO'; idnum: 46; county: 'Ouray'),
          (state: 'CO'; idnum: 47; county: 'Park'),
          (state: 'CO'; idnum: 48; county: 'Phillips'),
          (state: 'CO'; idnum: 49; county: 'Pitkin'),
          (state: 'CO'; idnum: 50; county: 'Prowers'),
          (state: 'CO'; idnum: 51; county: 'Pueblo'),
          (state: 'CO'; idnum: 52; county: 'Rio Blanco'),
          (state: 'CO'; idnum: 53; county: 'Rio'),
          (state: 'CO'; idnum: 54; county: 'Grande'),
          (state: 'CO'; idnum: 55; county: 'Routt'),
          (state: 'CO'; idnum: 56; county: 'Saguache'),
          (state: 'CO'; idnum: 57; county: 'San Juan'),
          (state: 'CO'; idnum: 58; county: 'San Miguel'),
          (state: 'CO'; idnum: 59; county: 'Sedgwick'),
          (state: 'CO'; idnum: 60; county: 'Summit'),
          (state: 'CO'; idnum: 61; county: 'Teller'),
          (state: 'CO'; idnum: 62; county: 'Washington'),
          (state: 'CO'; idnum: 63; county: 'Weld'),
          (state: 'CO'; idnum: 64; county: 'Yuma'),
          (state: 'CT'; idnum: 0; county: 'Connecticut'),
          (state: 'CT'; idnum: 1; county: 'Fairfield'),
          (state: 'CT'; idnum: 2; county: 'Hartford'),
          (state: 'CT'; idnum: 3; county: 'Litchfield'),
          (state: 'CT'; idnum: 4; county: 'Middlesex'),
          (state: 'CT'; idnum: 5; county: 'New Haven'),
          (state: 'CT'; idnum: 6; county: 'New London'),
          (state: 'CT'; idnum: 7; county: 'Tolland'),
          (state: 'CT'; idnum: 8; county: 'Windham'),
          (state: 'DC'; idnum: 0; county: 'District of Columbia'),
          (state: 'DC'; idnum: 1; county: 'Washington'),
          (state: 'DE'; idnum: 0; county: 'Delaware'),
          (state: 'DE'; idnum: 1; county: 'Kent'),
          (state: 'DE'; idnum: 2; county: 'New Castle'),
          (state: 'DE'; idnum: 3; county: 'Sussex'),
          (state: 'FL'; idnum: 0; county: 'Florida'),
          (state: 'FL'; idnum: 1; county: 'Alachua'),
          (state: 'FL'; idnum: 2; county: 'Baker'),
          (state: 'FL'; idnum: 3; county: 'Bay'),
          (state: 'FL'; idnum: 4; county: 'Bradford'),
          (state: 'FL'; idnum: 5; county: 'Brevard'),
          (state: 'FL'; idnum: 6; county: 'Broward'),
          (state: 'FL'; idnum: 7; county: 'Calhoun'),
          (state: 'FL'; idnum: 8; county: 'Charlotte'),
          (state: 'FL'; idnum: 9; county: 'Citrus'),
          (state: 'FL'; idnum: 10; county: 'Clay'),
          (state: 'FL'; idnum: 11; county: 'Collier'),
          (state: 'FL'; idnum: 12; county: 'Columbia'),
          (state: 'FL'; idnum: 13; county: 'Dade'),
          (state: 'FL'; idnum: 14; county: 'Desoto'),
          (state: 'FL'; idnum: 15; county: 'Dixie'),
          (state: 'FL'; idnum: 16; county: 'Duval'),
          (state: 'FL'; idnum: 17; county: 'Escambia'),
          (state: 'FL'; idnum: 18; county: 'Flagler'),
          (state: 'FL'; idnum: 19; county: 'Franklin'),
          (state: 'FL'; idnum: 20; county: 'Gadsden'),
          (state: 'FL'; idnum: 21; county: 'Gilchrist'),
          (state: 'FL'; idnum: 22; county: 'Glades'),
          (state: 'FL'; idnum: 23; county: 'Gulf'),
          (state: 'FL'; idnum: 24; county: 'Hamilton'),
          (state: 'FL'; idnum: 25; county: 'Hardee'),
          (state: 'FL'; idnum: 26; county: 'Hendry'),
          (state: 'FL'; idnum: 27; county: 'Hernando'),
          (state: 'FL'; idnum: 28; county: 'Highlands'),
          (state: 'FL'; idnum: 29; county: 'Hillsborough'),
          (state: 'FL'; idnum: 30; county: 'Holmes'),
          (state: 'FL'; idnum: 31; county: 'Indian River'),
          (state: 'FL'; idnum: 32; county: 'Jackson'),
          (state: 'FL'; idnum: 33; county: 'Jefferson'),
          (state: 'FL'; idnum: 34; county: 'Lafayette'),
          (state: 'FL'; idnum: 35; county: 'Lake'),
          (state: 'FL'; idnum: 36; county: 'Lee'),
          (state: 'FL'; idnum: 37; county: 'Leon'),
          (state: 'FL'; idnum: 38; county: 'Levy'),
          (state: 'FL'; idnum: 39; county: 'Liberty'),
          (state: 'FL'; idnum: 40; county: 'Madison'),
          (state: 'FL'; idnum: 41; county: 'Manatee'),
          (state: 'FL'; idnum: 42; county: 'Marion'),
          (state: 'FL'; idnum: 43; county: 'Martin'),
          (state: 'FL'; idnum: 44; county: 'Monroe'),
          (state: 'FL'; idnum: 45; county: 'Nassau'),
          (state: 'FL'; idnum: 46; county: 'Okaloosa'),
          (state: 'FL'; idnum: 47; county: 'Okeechobee'),
          (state: 'FL'; idnum: 48; county: 'Orange'),
          (state: 'FL'; idnum: 49; county: 'Osceola'),
          (state: 'FL'; idnum: 50; county: 'Palm Beach'),
          (state: 'FL'; idnum: 51; county: 'Pasco'),
          (state: 'FL'; idnum: 52; county: 'Pinellas'),
          (state: 'FL'; idnum: 53; county: 'Polk'),
          (state: 'FL'; idnum: 54; county: 'Putnam'),
          (state: 'FL'; idnum: 55; county: 'Santa Rosa'),
          (state: 'FL'; idnum: 56; county: 'Sarasota'),
          (state: 'FL'; idnum: 57; county: 'Seminole'),
          (state: 'FL'; idnum: 58; county: 'St. Johns'),
          (state: 'FL'; idnum: 59; county: 'St. Lucie'),
          (state: 'FL'; idnum: 60; county: 'Sumter'),
          (state: 'FL'; idnum: 61; county: 'Suwannee'),
          (state: 'FL'; idnum: 62; county: 'Taylor'),
          (state: 'FL'; idnum: 63; county: 'Union'),
          (state: 'FL'; idnum: 64; county: 'Volusia'),
          (state: 'FL'; idnum: 65; county: 'Wakulla'),
          (state: 'FL'; idnum: 66; county: 'Walton'),
          (state: 'FL'; idnum: 67; county: 'Washington'),
          (state: 'GA'; idnum: 0; county: 'Georgia'),
          (state: 'GA'; idnum: 1; county: 'Appling'),
          (state: 'GA'; idnum: 2; county: 'Atkinson'),
          (state: 'GA'; idnum: 3; county: 'Bacon'),
          (state: 'GA'; idnum: 4; county: 'Baker'),
          (state: 'GA'; idnum: 5; county: 'Baldwin'),
          (state: 'GA'; idnum: 6; county: 'Banks'),
          (state: 'GA'; idnum: 7; county: 'Barrow'),
          (state: 'GA'; idnum: 8; county: 'Bartow'),
          (state: 'GA'; idnum: 9; county: 'Ben Hill'),
          (state: 'GA'; idnum: 10; county: 'Berrien'),
          (state: 'GA'; idnum: 11; county: 'Bibb'),
          (state: 'GA'; idnum: 12; county: 'Bleckley'),
          (state: 'GA'; idnum: 13; county: 'Brantley'),
          (state: 'GA'; idnum: 14; county: 'Brooks'),
          (state: 'GA'; idnum: 15; county: 'Bryan'),
          (state: 'GA'; idnum: 16; county: 'Bulloch'),
          (state: 'GA'; idnum: 17; county: 'Burke'),
          (state: 'GA'; idnum: 18; county: 'Butts'),
          (state: 'GA'; idnum: 19; county: 'Calhoun'),
          (state: 'GA'; idnum: 20; county: 'Camden'),
          (state: 'GA'; idnum: 21; county: 'Candler'),
          (state: 'GA'; idnum: 22; county: 'Carroll'),
          (state: 'GA'; idnum: 23; county: 'Catoosa'),
          (state: 'GA'; idnum: 24; county: 'Charlton'),
          (state: 'GA'; idnum: 25; county: 'Chatham'),
          (state: 'GA'; idnum: 26; county: 'Chattahoochee'),
          (state: 'GA'; idnum: 27; county: 'Chattooga'),
          (state: 'GA'; idnum: 28; county: 'Cherokee'),
          (state: 'GA'; idnum: 29; county: 'Clarke'),
          (state: 'GA'; idnum: 30; county: 'Clay'),
          (state: 'GA'; idnum: 31; county: 'Clayton'),
          (state: 'GA'; idnum: 32; county: 'Clinch'),
          (state: 'GA'; idnum: 33; county: 'Cobb'),
          (state: 'GA'; idnum: 34; county: 'Coffee'),
          (state: 'GA'; idnum: 35; county: 'Colquitt'),
          (state: 'GA'; idnum: 36; county: 'Columbia'),
          (state: 'GA'; idnum: 37; county: 'Cook'),
          (state: 'GA'; idnum: 38; county: 'Coweta'),
          (state: 'GA'; idnum: 39; county: 'Crawford'),
          (state: 'GA'; idnum: 40; county: 'Crisp'),
          (state: 'GA'; idnum: 41; county: 'Dade'),
          (state: 'GA'; idnum: 42; county: 'Dawson'),
          (state: 'GA'; idnum: 43; county: 'De Kalb'),
          (state: 'GA'; idnum: 44; county: 'Decatur'),
          (state: 'GA'; idnum: 45; county: 'Dodge'),
          (state: 'GA'; idnum: 46; county: 'Dooly'),
          (state: 'GA'; idnum: 47; county: 'Dougherty'),
          (state: 'GA'; idnum: 48; county: 'Douglas'),
          (state: 'GA'; idnum: 49; county: 'Early'),
          (state: 'GA'; idnum: 50; county: 'Echols'),
          (state: 'GA'; idnum: 51; county: 'Effingham'),
          (state: 'GA'; idnum: 52; county: 'Elbert'),
          (state: 'GA'; idnum: 53; county: 'Emanuel'),
          (state: 'GA'; idnum: 54; county: 'Evans'),
          (state: 'GA'; idnum: 55; county: 'Fannin'),
          (state: 'GA'; idnum: 56; county: 'Fayette'),
          (state: 'GA'; idnum: 57; county: 'Floyd'),
          (state: 'GA'; idnum: 58; county: 'Forsyth'),
          (state: 'GA'; idnum: 59; county: 'Franklin'),
          (state: 'GA'; idnum: 60; county: 'Fulton'),
          (state: 'GA'; idnum: 61; county: 'Gilmer'),
          (state: 'GA'; idnum: 62; county: 'Glascock'),
          (state: 'GA'; idnum: 63; county: 'Glynn'),
          (state: 'GA'; idnum: 64; county: 'Gordon'),
          (state: 'GA'; idnum: 65; county: 'Grady'),
          (state: 'GA'; idnum: 66; county: 'Greene'),
          (state: 'GA'; idnum: 67; county: 'Gwinnett'),
          (state: 'GA'; idnum: 68; county: 'Habersham'),
          (state: 'GA'; idnum: 69; county: 'Hall'),
          (state: 'GA'; idnum: 70; county: 'Hancock'),
          (state: 'GA'; idnum: 71; county: 'Haralson'),
          (state: 'GA'; idnum: 72; county: 'Harris'),
          (state: 'GA'; idnum: 73; county: 'Hart'),
          (state: 'GA'; idnum: 74; county: 'Heard'),
          (state: 'GA'; idnum: 75; county: 'Henry'),
          (state: 'GA'; idnum: 76; county: 'Houston'),
          (state: 'GA'; idnum: 77; county: 'Irwin'),
          (state: 'GA'; idnum: 78; county: 'Jackson'),
          (state: 'GA'; idnum: 79; county: 'Jasper'),
          (state: 'GA'; idnum: 80; county: 'Jeff Davis'),
          (state: 'GA'; idnum: 81; county: 'Jefferson'),
          (state: 'GA'; idnum: 82; county: 'Jenkins'),
          (state: 'GA'; idnum: 83; county: 'Johnson'),
          (state: 'GA'; idnum: 84; county: 'Jones'),
          (state: 'GA'; idnum: 85; county: 'Lamar'),
          (state: 'GA'; idnum: 86; county: 'Lanier'),
          (state: 'GA'; idnum: 87; county: 'Laurens'),
          (state: 'GA'; idnum: 88; county: 'Lee'),
          (state: 'GA'; idnum: 89; county: 'Liberty'),
          (state: 'GA'; idnum: 90; county: 'Lincoln'),
          (state: 'GA'; idnum: 91; county: 'Long'),
          (state: 'GA'; idnum: 92; county: 'Lowndes'),
          (state: 'GA'; idnum: 93; county: 'Lumpkin'),
          (state: 'GA'; idnum: 94; county: 'Macon'),
          (state: 'GA'; idnum: 95; county: 'Madison'),
          (state: 'GA'; idnum: 96; county: 'Marion'),
          (state: 'GA'; idnum: 97; county: 'McDuffie'),
          (state: 'GA'; idnum: 98; county: 'McIntosh'),
          (state: 'GA'; idnum: 99; county: 'Meriwether'),
          (state: 'GA'; idnum: 100; county: 'Miller'),
          (state: 'GA'; idnum: 101; county: 'Mitchell'),
          (state: 'GA'; idnum: 102; county: 'Monroe'),
          (state: 'GA'; idnum: 103; county: 'Montgomery'),
          (state: 'GA'; idnum: 104; county: 'Morgan'),
          (state: 'GA'; idnum: 105; county: 'Murray'),
          (state: 'GA'; idnum: 106; county: 'Muscogee'),
          (state: 'GA'; idnum: 107; county: 'Newton'),
          (state: 'GA'; idnum: 108; county: 'Oconee'),
          (state: 'GA'; idnum: 109; county: 'Oglethorpe'),
          (state: 'GA'; idnum: 110; county: 'Paulding'),
          (state: 'GA'; idnum: 111; county: 'Peach'),
          (state: 'GA'; idnum: 112; county: 'Pickens'),
          (state: 'GA'; idnum: 113; county: 'Pierce'),
          (state: 'GA'; idnum: 114; county: 'Pike'),
          (state: 'GA'; idnum: 115; county: 'Polk'),
          (state: 'GA'; idnum: 116; county: 'Pulaski'),
          (state: 'GA'; idnum: 117; county: 'Putnam'),
          (state: 'GA'; idnum: 118; county: 'Quitman'),
          (state: 'GA'; idnum: 119; county: 'Rabun'),
          (state: 'GA'; idnum: 120; county: 'Randolph'),
          (state: 'GA'; idnum: 121; county: 'Richmond'),
          (state: 'GA'; idnum: 122; county: 'Rockdale'),
          (state: 'GA'; idnum: 123; county: 'Schley'),
          (state: 'GA'; idnum: 124; county: 'Screven'),
          (state: 'GA'; idnum: 125; county: 'Seminole'),
          (state: 'GA'; idnum: 126; county: 'Spalding'),
          (state: 'GA'; idnum: 127; county: 'Stephens'),
          (state: 'GA'; idnum: 128; county: 'Stewart'),
          (state: 'GA'; idnum: 129; county: 'Sumter'),
          (state: 'GA'; idnum: 130; county: 'Talbot'),
          (state: 'GA'; idnum: 131; county: 'Taliaferro'),
          (state: 'GA'; idnum: 132; county: 'Tattnall'),
          (state: 'GA'; idnum: 133; county: 'Taylor'),
          (state: 'GA'; idnum: 134; county: 'Telfair'),
          (state: 'GA'; idnum: 135; county: 'Terrell'),
          (state: 'GA'; idnum: 136; county: 'Thomas'),
          (state: 'GA'; idnum: 137; county: 'Tift'),
          (state: 'GA'; idnum: 138; county: 'Toombs'),
          (state: 'GA'; idnum: 139; county: 'Towns'),
          (state: 'GA'; idnum: 140; county: 'Treutlen'),
          (state: 'GA'; idnum: 141; county: 'Troup'),
          (state: 'GA'; idnum: 142; county: 'Turner'),
          (state: 'GA'; idnum: 143; county: 'Twiggs'),
          (state: 'GA'; idnum: 144; county: 'Union'),
          (state: 'GA'; idnum: 145; county: 'Upson'),
          (state: 'GA'; idnum: 146; county: 'Walker'),
          (state: 'GA'; idnum: 147; county: 'Walton'),
          (state: 'GA'; idnum: 148; county: 'Ware'),
          (state: 'GA'; idnum: 149; county: 'Warren'),
          (state: 'GA'; idnum: 150; county: 'Washington'),
          (state: 'GA'; idnum: 151; county: 'Wayne'),
          (state: 'GA'; idnum: 152; county: 'Webster'),
          (state: 'GA'; idnum: 153; county: 'Wheeler'),
          (state: 'GA'; idnum: 154; county: 'White'),
          (state: 'GA'; idnum: 155; county: 'Whitfield'),
          (state: 'GA'; idnum: 156; county: 'Wilcox'),
          (state: 'GA'; idnum: 157; county: 'Wilkes'),
          (state: 'GA'; idnum: 158; county: 'Wilkinson'),
          (state: 'GA'; idnum: 159; county: 'Worth'),
          (state: 'HI'; idnum: 0; county: 'Hawaii'),
          (state: 'HI'; idnum: 1; county: 'Hawaii'),
          (state: 'HI'; idnum: 2; county: 'Honolulu'),
          (state: 'HI'; idnum: 3; county: 'Kalawao'),
          (state: 'HI'; idnum: 4; county: 'Kauai'),
          (state: 'HI'; idnum: 5; county: 'Maui'),
          (state: 'IA'; idnum: 0; county: 'Iowa'),
          (state: 'IA'; idnum: 1; county: 'Adair'),
          (state: 'IA'; idnum: 2; county: 'Adams'),
          (state: 'IA'; idnum: 3; county: 'Allamakee'),
          (state: 'IA'; idnum: 4; county: 'Appanoose'),
          (state: 'IA'; idnum: 5; county: 'Audubon'),
          (state: 'IA'; idnum: 6; county: 'Benton'),
          (state: 'IA'; idnum: 7; county: 'Black Hawk'),
          (state: 'IA'; idnum: 8; county: 'Boone'),
          (state: 'IA'; idnum: 9; county: 'Bremer'),
          (state: 'IA'; idnum: 10; county: 'Buchanan'),
          (state: 'IA'; idnum: 11; county: 'Buena Vista'),
          (state: 'IA'; idnum: 12; county: 'Butler'),
          (state: 'IA'; idnum: 13; county: 'Calhoun'),
          (state: 'IA'; idnum: 14; county: 'Carroll'),
          (state: 'IA'; idnum: 15; county: 'Cass'),
          (state: 'IA'; idnum: 16; county: 'Cedar'),
          (state: 'IA'; idnum: 17; county: 'Cerro Gordo'),
          (state: 'IA'; idnum: 18; county: 'Cherokee'),
          (state: 'IA'; idnum: 19; county: 'Chickasaw'),
          (state: 'IA'; idnum: 20; county: 'Clarke'),
          (state: 'IA'; idnum: 21; county: 'Clay'),
          (state: 'IA'; idnum: 22; county: 'Clayton'),
          (state: 'IA'; idnum: 23; county: 'Clinton'),
          (state: 'IA'; idnum: 24; county: 'Crawford'),
          (state: 'IA'; idnum: 25; county: 'Dallas'),
          (state: 'IA'; idnum: 26; county: 'Davis'),
          (state: 'IA'; idnum: 27; county: 'Decatur'),
          (state: 'IA'; idnum: 28; county: 'Delaware'),
          (state: 'IA'; idnum: 29; county: 'Des Moines'),
          (state: 'IA'; idnum: 30; county: 'Dickinson'),
          (state: 'IA'; idnum: 31; county: 'Dubuque'),
          (state: 'IA'; idnum: 32; county: 'Emmet'),
          (state: 'IA'; idnum: 33; county: 'Fayette'),
          (state: 'IA'; idnum: 34; county: 'Floyd'),
          (state: 'IA'; idnum: 35; county: 'Franklin'),
          (state: 'IA'; idnum: 36; county: 'Fremont'),
          (state: 'IA'; idnum: 37; county: 'Greene'),
          (state: 'IA'; idnum: 38; county: 'Grundy'),
          (state: 'IA'; idnum: 39; county: 'Guthrie'),
          (state: 'IA'; idnum: 40; county: 'Hamilton'),
          (state: 'IA'; idnum: 41; county: 'Hancock'),
          (state: 'IA'; idnum: 42; county: 'Hardin'),
          (state: 'IA'; idnum: 43; county: 'Harrison'),
          (state: 'IA'; idnum: 44; county: 'Henry'),
          (state: 'IA'; idnum: 45; county: 'Howard'),
          (state: 'IA'; idnum: 46; county: 'Humboldt'),
          (state: 'IA'; idnum: 47; county: 'Ida'),
          (state: 'IA'; idnum: 48; county: 'Iowa'),
          (state: 'IA'; idnum: 49; county: 'Jackson'),
          (state: 'IA'; idnum: 50; county: 'Jasper'),
          (state: 'IA'; idnum: 51; county: 'Jefferson'),
          (state: 'IA'; idnum: 52; county: 'Johnson'),
          (state: 'IA'; idnum: 53; county: 'Jones'),
          (state: 'IA'; idnum: 54; county: 'Keokuk'),
          (state: 'IA'; idnum: 55; county: 'Kossuth'),
          (state: 'IA'; idnum: 56; county: 'Lee'),
          (state: 'IA'; idnum: 57; county: 'Linn'),
          (state: 'IA'; idnum: 58; county: 'Louisa'),
          (state: 'IA'; idnum: 59; county: 'Lucas'),
          (state: 'IA'; idnum: 60; county: 'Lyon'),
          (state: 'IA'; idnum: 61; county: 'Madison'),
          (state: 'IA'; idnum: 62; county: 'Mahaska'),
          (state: 'IA'; idnum: 63; county: 'Marion'),
          (state: 'IA'; idnum: 64; county: 'Marshall'),
          (state: 'IA'; idnum: 65; county: 'Mills'),
          (state: 'IA'; idnum: 66; county: 'Mitchell'),
          (state: 'IA'; idnum: 67; county: 'Monona'),
          (state: 'IA'; idnum: 68; county: 'Monroe'),
          (state: 'IA'; idnum: 69; county: 'Montgomery'),
          (state: 'IA'; idnum: 70; county: 'Muscatine'),
          (state: 'IA'; idnum: 71; county: 'O''Brien'),
          (state: 'IA'; idnum: 72; county: 'Osceola'),
          (state: 'IA'; idnum: 73; county: 'Page'),
          (state: 'IA'; idnum: 74; county: 'Palo Alto'),
          (state: 'IA'; idnum: 75; county: 'Plymouth'),
          (state: 'IA'; idnum: 76; county: 'Pocahontas'),
          (state: 'IA'; idnum: 77; county: 'Polk'),
          (state: 'IA'; idnum: 78; county: 'Pottawattamie'),
          (state: 'IA'; idnum: 79; county: 'Poweshiek'),
          (state: 'IA'; idnum: 80; county: 'Ringgold'),
          (state: 'IA'; idnum: 81; county: 'Sac'),
          (state: 'IA'; idnum: 82; county: 'Scott'),
          (state: 'IA'; idnum: 83; county: 'Shelby'),
          (state: 'IA'; idnum: 84; county: 'Sioux'),
          (state: 'IA'; idnum: 85; county: 'Story'),
          (state: 'IA'; idnum: 86; county: 'Tama'),
          (state: 'IA'; idnum: 87; county: 'Taylor'),
          (state: 'IA'; idnum: 88; county: 'Union'),
          (state: 'IA'; idnum: 89; county: 'Van Buren'),
          (state: 'IA'; idnum: 90; county: 'Wapello'),
          (state: 'IA'; idnum: 91; county: 'Warren'),
          (state: 'IA'; idnum: 92; county: 'Washington'),
          (state: 'IA'; idnum: 93; county: 'Wayne'),
          (state: 'IA'; idnum: 94; county: 'Webster'),
          (state: 'IA'; idnum: 95; county: 'Winnebago'),
          (state: 'IA'; idnum: 96; county: 'Winneshiek'),
          (state: 'IA'; idnum: 97; county: 'Woodbury'),
          (state: 'IA'; idnum: 98; county: 'Worth'),
          (state: 'IA'; idnum: 99; county: 'Wright'),
          (state: 'ID'; idnum: 0; county: 'Idaho'),
          (state: 'ID'; idnum: 1; county: 'Ada'),
          (state: 'ID'; idnum: 2; county: 'Adams'),
          (state: 'ID'; idnum: 3; county: 'Bannock'),
          (state: 'ID'; idnum: 4; county: 'Bear Lake'),
          (state: 'ID'; idnum: 5; county: 'Benewah'),
          (state: 'ID'; idnum: 6; county: 'Bingham'),
          (state: 'ID'; idnum: 7; county: 'Blaine'),
          (state: 'ID'; idnum: 8; county: 'Boise'),
          (state: 'ID'; idnum: 9; county: 'Bonner'),
          (state: 'ID'; idnum: 10; county: 'Bonneville'),
          (state: 'ID'; idnum: 11; county: 'Boundary'),
          (state: 'ID'; idnum: 12; county: 'Butte'),
          (state: 'ID'; idnum: 13; county: 'Camas'),
          (state: 'ID'; idnum: 14; county: 'Canyon'),
          (state: 'ID'; idnum: 15; county: 'Caribou'),
          (state: 'ID'; idnum: 16; county: 'Cassia'),
          (state: 'ID'; idnum: 17; county: 'Clark'),
          (state: 'ID'; idnum: 18; county: 'Clearwater'),
          (state: 'ID'; idnum: 19; county: 'Custer'),
          (state: 'ID'; idnum: 20; county: 'Elmore'),
          (state: 'ID'; idnum: 21; county: 'Franklin'),
          (state: 'ID'; idnum: 22; county: 'Fremont'),
          (state: 'ID'; idnum: 23; county: 'Gem'),
          (state: 'ID'; idnum: 24; county: 'Gooding'),
          (state: 'ID'; idnum: 25; county: 'Idaho'),
          (state: 'ID'; idnum: 26; county: 'Jefferson'),
          (state: 'ID'; idnum: 27; county: 'Jerome'),
          (state: 'ID'; idnum: 28; county: 'Kootenai'),
          (state: 'ID'; idnum: 29; county: 'Latah'),
          (state: 'ID'; idnum: 30; county: 'Lemhi'),
          (state: 'ID'; idnum: 31; county: 'Lewis'),
          (state: 'ID'; idnum: 32; county: 'Lincoln'),
          (state: 'ID'; idnum: 33; county: 'Madison'),
          (state: 'ID'; idnum: 34; county: 'Minidoka'),
          (state: 'ID'; idnum: 35; county: 'Nez Perce'),
          (state: 'ID'; idnum: 36; county: 'Oneida'),
          (state: 'ID'; idnum: 37; county: 'Owyhee'),
          (state: 'ID'; idnum: 38; county: 'Payette'),
          (state: 'ID'; idnum: 39; county: 'Power'),
          (state: 'ID'; idnum: 40; county: 'Shoshone'),
          (state: 'ID'; idnum: 41; county: 'Teton'),
          (state: 'ID'; idnum: 42; county: 'Twin Falls'),
          (state: 'ID'; idnum: 43; county: 'Valley'),
          (state: 'ID'; idnum: 44; county: 'Washington'),
          (state: 'IL'; idnum: 0; county: 'Illinois'),
          (state: 'IL'; idnum: 1; county: 'Adams'),
          (state: 'IL'; idnum: 2; county: 'Alexander'),
          (state: 'IL'; idnum: 3; county: 'Bond'),
          (state: 'IL'; idnum: 4; county: 'Boone'),
          (state: 'IL'; idnum: 5; county: 'Brown'),
          (state: 'IL'; idnum: 6; county: 'Bureau'),
          (state: 'IL'; idnum: 7; county: 'Calhoun'),
          (state: 'IL'; idnum: 8; county: 'Carroll'),
          (state: 'IL'; idnum: 9; county: 'Cass'),
          (state: 'IL'; idnum: 10; county: 'Champaign'),
          (state: 'IL'; idnum: 11; county: 'Christian'),
          (state: 'IL'; idnum: 12; county: 'Clark'),
          (state: 'IL'; idnum: 13; county: 'Clay'),
          (state: 'IL'; idnum: 14; county: 'Clinton'),
          (state: 'IL'; idnum: 15; county: 'Coles'),
          (state: 'IL'; idnum: 16; county: 'Cook'),
          (state: 'IL'; idnum: 17; county: 'Crawford'),
          (state: 'IL'; idnum: 18; county: 'Cumberland'),
          (state: 'IL'; idnum: 19; county: 'Dekalb'),
          (state: 'IL'; idnum: 20; county: 'De Witt'),
          (state: 'IL'; idnum: 21; county: 'Douglas'),
          (state: 'IL'; idnum: 22; county: 'Dupage'),
          (state: 'IL'; idnum: 23; county: 'Edgar'),
          (state: 'IL'; idnum: 24; county: 'Edwards'),
          (state: 'IL'; idnum: 25; county: 'Effingham'),
          (state: 'IL'; idnum: 26; county: 'Fayette'),
          (state: 'IL'; idnum: 27; county: 'Ford'),
          (state: 'IL'; idnum: 28; county: 'Franklin'),
          (state: 'IL'; idnum: 29; county: 'Fulton'),
          (state: 'IL'; idnum: 30; county: 'Gallatin'),
          (state: 'IL'; idnum: 31; county: 'Greene'),
          (state: 'IL'; idnum: 32; county: 'Grundy'),
          (state: 'IL'; idnum: 33; county: 'Hamilton'),
          (state: 'IL'; idnum: 34; county: 'Hancock'),
          (state: 'IL'; idnum: 35; county: 'Hardin'),
          (state: 'IL'; idnum: 36; county: 'Henderson'),
          (state: 'IL'; idnum: 37; county: 'Henry'),
          (state: 'IL'; idnum: 38; county: 'Iroquois'),
          (state: 'IL'; idnum: 39; county: 'Jackson'),
          (state: 'IL'; idnum: 40; county: 'Jasper'),
          (state: 'IL'; idnum: 41; county: 'Jefferson'),
          (state: 'IL'; idnum: 42; county: 'Jersey'),
          (state: 'IL'; idnum: 43; county: 'Jo Daviess'),
          (state: 'IL'; idnum: 44; county: 'Johnson'),
          (state: 'IL'; idnum: 45; county: 'Kane'),
          (state: 'IL'; idnum: 46; county: 'Kankakee'),
          (state: 'IL'; idnum: 47; county: 'Kendall'),
          (state: 'IL'; idnum: 48; county: 'Knox'),
          (state: 'IL'; idnum: 49; county: 'La Salle'),
          (state: 'IL'; idnum: 50; county: 'Lake'),
          (state: 'IL'; idnum: 51; county: 'Lawrence'),
          (state: 'IL'; idnum: 52; county: 'Lee'),
          (state: 'IL'; idnum: 53; county: 'Livingston'),
          (state: 'IL'; idnum: 54; county: 'Logan'),
          (state: 'IL'; idnum: 55; county: 'Macon'),
          (state: 'IL'; idnum: 56; county: 'Macoupin'),
          (state: 'IL'; idnum: 57; county: 'Madison'),
          (state: 'IL'; idnum: 58; county: 'Marion'),
          (state: 'IL'; idnum: 59; county: 'Marshall'),
          (state: 'IL'; idnum: 60; county: 'Mason'),
          (state: 'IL'; idnum: 61; county: 'Massac'),
          (state: 'IL'; idnum: 62; county: 'McDonough'),
          (state: 'IL'; idnum: 63; county: 'McHenry'),
          (state: 'IL'; idnum: 64; county: 'McLean'),
          (state: 'IL'; idnum: 65; county: 'Menard'),
          (state: 'IL'; idnum: 66; county: 'Mercer'),
          (state: 'IL'; idnum: 67; county: 'Monroe'),
          (state: 'IL'; idnum: 68; county: 'Montgomery'),
          (state: 'IL'; idnum: 69; county: 'Morgan'),
          (state: 'IL'; idnum: 70; county: 'Moultrie'),
          (state: 'IL'; idnum: 71; county: 'Ogle'),
          (state: 'IL'; idnum: 72; county: 'Peoria'),
          (state: 'IL'; idnum: 73; county: 'Perry'),
          (state: 'IL'; idnum: 74; county: 'Piatt'),
          (state: 'IL'; idnum: 75; county: 'Pike'),
          (state: 'IL'; idnum: 76; county: 'Pope'),
          (state: 'IL'; idnum: 77; county: 'Pulaski'),
          (state: 'IL'; idnum: 78; county: 'Putnam'),
          (state: 'IL'; idnum: 79; county: 'Randolph'),
          (state: 'IL'; idnum: 80; county: 'Richland'),
          (state: 'IL'; idnum: 81; county: 'Rock Island'),
          (state: 'IL'; idnum: 82; county: 'Saline'),
          (state: 'IL'; idnum: 83; county: 'Sangamon'),
          (state: 'IL'; idnum: 84; county: 'Schuyler'),
          (state: 'IL'; idnum: 85; county: 'Scott'),
          (state: 'IL'; idnum: 86; county: 'Shelby'),
          (state: 'IL'; idnum: 87; county: 'St. Clair'),
          (state: 'IL'; idnum: 88; county: 'Stark'),
          (state: 'IL'; idnum: 89; county: 'Stephenson'),
          (state: 'IL'; idnum: 90; county: 'Tazewell'),
          (state: 'IL'; idnum: 91; county: 'Union'),
          (state: 'IL'; idnum: 92; county: 'Vermilion'),
          (state: 'IL'; idnum: 93; county: 'Wabash'),
          (state: 'IL'; idnum: 94; county: 'Warren'),
          (state: 'IL'; idnum: 95; county: 'Washington'),
          (state: 'IL'; idnum: 96; county: 'Wayne'),
          (state: 'IL'; idnum: 97; county: 'White'),
          (state: 'IL'; idnum: 98; county: 'Whiteside'),
          (state: 'IL'; idnum: 99; county: 'Will'),
          (state: 'IL'; idnum: 100; county: 'Williamson'),
          (state: 'IL'; idnum: 101; county: 'Winnebago'),
          (state: 'IL'; idnum: 102; county: 'Woodford'),
          (state: 'IN'; idnum: 0; county: 'Indiana'),
          (state: 'IN'; idnum: 1; county: 'Adams'),
          (state: 'IN'; idnum: 2; county: 'Allen'),
          (state: 'IN'; idnum: 3; county: 'Bartholomew'),
          (state: 'IN'; idnum: 4; county: 'Benton'),
          (state: 'IN'; idnum: 5; county: 'Blackford'),
          (state: 'IN'; idnum: 6; county: 'Boone'),
          (state: 'IN'; idnum: 7; county: 'Brown'),
          (state: 'IN'; idnum: 8; county: 'Carroll'),
          (state: 'IN'; idnum: 9; county: 'Cass'),
          (state: 'IN'; idnum: 10; county: 'Clark'),
          (state: 'IN'; idnum: 11; county: 'Clay'),
          (state: 'IN'; idnum: 12; county: 'Clinton'),
          (state: 'IN'; idnum: 13; county: 'Crawford'),
          (state: 'IN'; idnum: 14; county: 'Daviess'),
          (state: 'IN'; idnum: 15; county: 'De Kalb'),
          (state: 'IN'; idnum: 16; county: 'Dearborn'),
          (state: 'IN'; idnum: 17; county: 'Decatur'),
          (state: 'IN'; idnum: 18; county: 'Delaware'),
          (state: 'IN'; idnum: 19; county: 'Dubois'),
          (state: 'IN'; idnum: 20; county: 'Elkhart'),
          (state: 'IN'; idnum: 21; county: 'Fayette'),
          (state: 'IN'; idnum: 22; county: 'Floyd'),
          (state: 'IN'; idnum: 23; county: 'Fountain'),
          (state: 'IN'; idnum: 24; county: 'Franklin'),
          (state: 'IN'; idnum: 25; county: 'Fulton'),
          (state: 'IN'; idnum: 26; county: 'Gibson'),
          (state: 'IN'; idnum: 27; county: 'Grant'),
          (state: 'IN'; idnum: 28; county: 'Greene'),
          (state: 'IN'; idnum: 29; county: 'Hamilton'),
          (state: 'IN'; idnum: 30; county: 'Hancock'),
          (state: 'IN'; idnum: 31; county: 'Harrison'),
          (state: 'IN'; idnum: 32; county: 'Hendricks'),
          (state: 'IN'; idnum: 33; county: 'Henry'),
          (state: 'IN'; idnum: 34; county: 'Howard'),
          (state: 'IN'; idnum: 35; county: 'Huntington'),
          (state: 'IN'; idnum: 36; county: 'Jackson'),
          (state: 'IN'; idnum: 37; county: 'Jasper'),
          (state: 'IN'; idnum: 38; county: 'Jay'),
          (state: 'IN'; idnum: 39; county: 'Jefferson'),
          (state: 'IN'; idnum: 40; county: 'Jennings'),
          (state: 'IN'; idnum: 41; county: 'Johnson'),
          (state: 'IN'; idnum: 42; county: 'Knox'),
          (state: 'IN'; idnum: 43; county: 'Kosciusko'),
          (state: 'IN'; idnum: 44; county: 'Lagrange'),
          (state: 'IN'; idnum: 45; county: 'Lake'),
          (state: 'IN'; idnum: 46; county: 'La Porte'),
          (state: 'IN'; idnum: 47; county: 'Lawrence'),
          (state: 'IN'; idnum: 48; county: 'Madison'),
          (state: 'IN'; idnum: 49; county: 'Marion'),
          (state: 'IN'; idnum: 50; county: 'Marshall'),
          (state: 'IN'; idnum: 51; county: 'Martin'),
          (state: 'IN'; idnum: 52; county: 'Miami'),
          (state: 'IN'; idnum: 53; county: 'Monroe'),
          (state: 'IN'; idnum: 54; county: 'Montgomery'),
          (state: 'IN'; idnum: 55; county: 'Morgan'),
          (state: 'IN'; idnum: 56; county: 'Newton'),
          (state: 'IN'; idnum: 57; county: 'Noble'),
          (state: 'IN'; idnum: 58; county: 'Ohio'),
          (state: 'IN'; idnum: 59; county: 'Orange'),
          (state: 'IN'; idnum: 60; county: 'Owen'),
          (state: 'IN'; idnum: 61; county: 'Parke'),
          (state: 'IN'; idnum: 62; county: 'Perry'),
          (state: 'IN'; idnum: 63; county: 'Pike'),
          (state: 'IN'; idnum: 64; county: 'Porter'),
          (state: 'IN'; idnum: 65; county: 'Posey'),
          (state: 'IN'; idnum: 66; county: 'Pulaski'),
          (state: 'IN'; idnum: 67; county: 'Putnam'),
          (state: 'IN'; idnum: 68; county: 'Randolph'),
          (state: 'IN'; idnum: 69; county: 'Ripley'),
          (state: 'IN'; idnum: 70; county: 'Rush'),
          (state: 'IN'; idnum: 71; county: 'Scott'),
          (state: 'IN'; idnum: 72; county: 'Shelby'),
          (state: 'IN'; idnum: 73; county: 'Spencer'),
          (state: 'IN'; idnum: 74; county: 'St. Joseph'),
          (state: 'IN'; idnum: 75; county: 'Starke'),
          (state: 'IN'; idnum: 76; county: 'Steuben'),
          (state: 'IN'; idnum: 77; county: 'Sullivan'),
          (state: 'IN'; idnum: 78; county: 'Switzerland'),
          (state: 'IN'; idnum: 79; county: 'Tippecanoe'),
          (state: 'IN'; idnum: 80; county: 'Tipton'),
          (state: 'IN'; idnum: 81; county: 'Union'),
          (state: 'IN'; idnum: 82; county: 'Vanderburgh'),
          (state: 'IN'; idnum: 83; county: 'Vermillion'),
          (state: 'IN'; idnum: 84; county: 'Vigo'),
          (state: 'IN'; idnum: 85; county: 'Wabash'),
          (state: 'IN'; idnum: 86; county: 'Warren'),
          (state: 'IN'; idnum: 87; county: 'Warrick'),
          (state: 'IN'; idnum: 88; county: 'Washington'),
          (state: 'IN'; idnum: 89; county: 'Wayne'),
          (state: 'IN'; idnum: 90; county: 'Wells'),
          (state: 'IN'; idnum: 91; county: 'White'),
          (state: 'IN'; idnum: 92; county: 'Whitley'),
          (state: 'KS'; idnum: 0; county: 'Kansas'),
          (state: 'KS'; idnum: 1; county: 'Allen'),
          (state: 'KS'; idnum: 2; county: 'Anderson'),
          (state: 'KS'; idnum: 3; county: 'Atchison'),
          (state: 'KS'; idnum: 4; county: 'Barber'),
          (state: 'KS'; idnum: 5; county: 'Barton'),
          (state: 'KS'; idnum: 6; county: 'Bourbon'),
          (state: 'KS'; idnum: 7; county: 'Brown'),
          (state: 'KS'; idnum: 8; county: 'Butler'),
          (state: 'KS'; idnum: 9; county: 'Chase'),
          (state: 'KS'; idnum: 10; county: 'Chautauqua'),
          (state: 'KS'; idnum: 11; county: 'Cherokee'),
          (state: 'KS'; idnum: 12; county: 'Cheyenne'),
          (state: 'KS'; idnum: 13; county: 'Clark'),
          (state: 'KS'; idnum: 14; county: 'Clay'),
          (state: 'KS'; idnum: 15; county: 'Cloud'),
          (state: 'KS'; idnum: 16; county: 'Coffey'),
          (state: 'KS'; idnum: 17; county: 'Comanche'),
          (state: 'KS'; idnum: 18; county: 'Cowley'),
          (state: 'KS'; idnum: 19; county: 'Crawford'),
          (state: 'KS'; idnum: 20; county: 'Decatur'),
          (state: 'KS'; idnum: 21; county: 'Dickinson'),
          (state: 'KS'; idnum: 22; county: 'Doniphan'),
          (state: 'KS'; idnum: 23; county: 'Douglas'),
          (state: 'KS'; idnum: 24; county: 'Edwards'),
          (state: 'KS'; idnum: 25; county: 'Elk'),
          (state: 'KS'; idnum: 26; county: 'Ellis'),
          (state: 'KS'; idnum: 27; county: 'Ellsworth'),
          (state: 'KS'; idnum: 28; county: 'Finney'),
          (state: 'KS'; idnum: 29; county: 'Ford'),
          (state: 'KS'; idnum: 30; county: 'Franklin'),
          (state: 'KS'; idnum: 31; county: 'Geary'),
          (state: 'KS'; idnum: 32; county: 'Gove'),
          (state: 'KS'; idnum: 33; county: 'Graham'),
          (state: 'KS'; idnum: 34; county: 'Grant'),
          (state: 'KS'; idnum: 35; county: 'Gray'),
          (state: 'KS'; idnum: 36; county: 'Greeley'),
          (state: 'KS'; idnum: 37; county: 'Greenwood'),
          (state: 'KS'; idnum: 38; county: 'Hamilton'),
          (state: 'KS'; idnum: 39; county: 'Harper'),
          (state: 'KS'; idnum: 40; county: 'Harvey'),
          (state: 'KS'; idnum: 41; county: 'Haskell'),
          (state: 'KS'; idnum: 42; county: 'Hodgeman'),
          (state: 'KS'; idnum: 43; county: 'Jackson'),
          (state: 'KS'; idnum: 44; county: 'Jefferson'),
          (state: 'KS'; idnum: 45; county: 'Jewell'),
          (state: 'KS'; idnum: 46; county: 'Johnson'),
          (state: 'KS'; idnum: 47; county: 'Kearny'),
          (state: 'KS'; idnum: 48; county: 'Kingman'),
          (state: 'KS'; idnum: 49; county: 'Kiowa'),
          (state: 'KS'; idnum: 50; county: 'Labette'),
          (state: 'KS'; idnum: 51; county: 'Lane'),
          (state: 'KS'; idnum: 52; county: 'Leavenworth'),
          (state: 'KS'; idnum: 53; county: 'Lincoln'),
          (state: 'KS'; idnum: 54; county: 'Linn'),
          (state: 'KS'; idnum: 55; county: 'Logan'),
          (state: 'KS'; idnum: 56; county: 'Lyon'),
          (state: 'KS'; idnum: 57; county: 'Marion'),
          (state: 'KS'; idnum: 58; county: 'Marshall'),
          (state: 'KS'; idnum: 59; county: 'McPherson'),
          (state: 'KS'; idnum: 60; county: 'Meade'),
          (state: 'KS'; idnum: 61; county: 'Miami'),
          (state: 'KS'; idnum: 62; county: 'Mitchell'),
          (state: 'KS'; idnum: 63; county: 'Montgomery'),
          (state: 'KS'; idnum: 64; county: 'Morris'),
          (state: 'KS'; idnum: 65; county: 'Morton'),
          (state: 'KS'; idnum: 66; county: 'Nemaha'),
          (state: 'KS'; idnum: 67; county: 'Neosho'),
          (state: 'KS'; idnum: 68; county: 'Ness'),
          (state: 'KS'; idnum: 69; county: 'Norton'),
          (state: 'KS'; idnum: 70; county: 'Osage'),
          (state: 'KS'; idnum: 71; county: 'Osborne'),
          (state: 'KS'; idnum: 72; county: 'Ottawa'),
          (state: 'KS'; idnum: 73; county: 'Pawnee'),
          (state: 'KS'; idnum: 74; county: 'Phillips'),
          (state: 'KS'; idnum: 75; county: 'Pottawatomie'),
          (state: 'KS'; idnum: 76; county: 'Pratt'),
          (state: 'KS'; idnum: 77; county: 'Rawlins'),
          (state: 'KS'; idnum: 78; county: 'Reno'),
          (state: 'KS'; idnum: 79; county: 'Republic'),
          (state: 'KS'; idnum: 80; county: 'Rice'),
          (state: 'KS'; idnum: 81; county: 'Riley'),
          (state: 'KS'; idnum: 82; county: 'Rooks'),
          (state: 'KS'; idnum: 83; county: 'Rush'),
          (state: 'KS'; idnum: 84; county: 'Russell'),
          (state: 'KS'; idnum: 85; county: 'Saline'),
          (state: 'KS'; idnum: 86; county: 'Scott'),
          (state: 'KS'; idnum: 87; county: 'Sedgwick'),
          (state: 'KS'; idnum: 88; county: 'Seward'),
          (state: 'KS'; idnum: 89; county: 'Shawnee'),
          (state: 'KS'; idnum: 90; county: 'Sheridan'),
          (state: 'KS'; idnum: 91; county: 'Sherman'),
          (state: 'KS'; idnum: 92; county: 'Smith'),
          (state: 'KS'; idnum: 93; county: 'Stafford'),
          (state: 'KS'; idnum: 94; county: 'Stanton'),
          (state: 'KS'; idnum: 95; county: 'Stevens'),
          (state: 'KS'; idnum: 96; county: 'Sumner'),
          (state: 'KS'; idnum: 97; county: 'Thomas'),
          (state: 'KS'; idnum: 98; county: 'Trego'),
          (state: 'KS'; idnum: 99; county: 'Wabaunsee'),
          (state: 'KS'; idnum: 100; county: 'Wallace'),
          (state: 'KS'; idnum: 101; county: 'Washington'),
          (state: 'KS'; idnum: 102; county: 'Wichita'),
          (state: 'KS'; idnum: 103; county: 'Wilson'),
          (state: 'KS'; idnum: 104; county: 'Woodson'),
          (state: 'KS'; idnum: 105; county: 'Wyandotte'),
          (state: 'KY'; idnum: 0; county: 'Kentucky'),
          (state: 'KY'; idnum: 1; county: 'Adair'),
          (state: 'KY'; idnum: 2; county: 'Allen'),
          (state: 'KY'; idnum: 3; county: 'Anderson'),
          (state: 'KY'; idnum: 4; county: 'Ballard'),
          (state: 'KY'; idnum: 5; county: 'Barren'),
          (state: 'KY'; idnum: 6; county: 'Bath'),
          (state: 'KY'; idnum: 7; county: 'Bell'),
          (state: 'KY'; idnum: 8; county: 'Boone'),
          (state: 'KY'; idnum: 9; county: 'Bourbon'),
          (state: 'KY'; idnum: 10; county: 'Boyd'),
          (state: 'KY'; idnum: 11; county: 'Boyle'),
          (state: 'KY'; idnum: 12; county: 'Bracken'),
          (state: 'KY'; idnum: 13; county: 'Breathitt'),
          (state: 'KY'; idnum: 14; county: 'Breckinridge'),
          (state: 'KY'; idnum: 15; county: 'Bullitt'),
          (state: 'KY'; idnum: 16; county: 'Butler'),
          (state: 'KY'; idnum: 17; county: 'Caldwell'),
          (state: 'KY'; idnum: 18; county: 'Calloway'),
          (state: 'KY'; idnum: 19; county: 'Campbell'),
          (state: 'KY'; idnum: 20; county: 'Carlisle'),
          (state: 'KY'; idnum: 21; county: 'Carroll'),
          (state: 'KY'; idnum: 22; county: 'Carter'),
          (state: 'KY'; idnum: 23; county: 'Casey'),
          (state: 'KY'; idnum: 24; county: 'Christian'),
          (state: 'KY'; idnum: 25; county: 'Clark'),
          (state: 'KY'; idnum: 26; county: 'Clay'),
          (state: 'KY'; idnum: 27; county: 'Clinton'),
          (state: 'KY'; idnum: 28; county: 'Crittenden'),
          (state: 'KY'; idnum: 29; county: 'Cumberland'),
          (state: 'KY'; idnum: 30; county: 'Daviess'),
          (state: 'KY'; idnum: 31; county: 'Edmonson'),
          (state: 'KY'; idnum: 32; county: 'Elliott'),
          (state: 'KY'; idnum: 33; county: 'Estill'),
          (state: 'KY'; idnum: 34; county: 'Fayette'),
          (state: 'KY'; idnum: 35; county: 'Fleming'),
          (state: 'KY'; idnum: 36; county: 'Floyd'),
          (state: 'KY'; idnum: 37; county: 'Franklin'),
          (state: 'KY'; idnum: 38; county: 'Fulton'),
          (state: 'KY'; idnum: 39; county: 'Gallatin'),
          (state: 'KY'; idnum: 40; county: 'Garrard'),
          (state: 'KY'; idnum: 41; county: 'Grant'),
          (state: 'KY'; idnum: 42; county: 'Graves'),
          (state: 'KY'; idnum: 43; county: 'Grayson'),
          (state: 'KY'; idnum: 44; county: 'Green'),
          (state: 'KY'; idnum: 45; county: 'Greenup'),
          (state: 'KY'; idnum: 46; county: 'Hancock'),
          (state: 'KY'; idnum: 47; county: 'Hardin'),
          (state: 'KY'; idnum: 48; county: 'Harlan'),
          (state: 'KY'; idnum: 49; county: 'Harrison'),
          (state: 'KY'; idnum: 50; county: 'Hart'),
          (state: 'KY'; idnum: 51; county: 'Henderson'),
          (state: 'KY'; idnum: 52; county: 'Henry'),
          (state: 'KY'; idnum: 53; county: 'Hickman'),
          (state: 'KY'; idnum: 54; county: 'Hopkins'),
          (state: 'KY'; idnum: 55; county: 'Jackson'),
          (state: 'KY'; idnum: 56; county: 'Jefferson'),
          (state: 'KY'; idnum: 57; county: 'Jessamine'),
          (state: 'KY'; idnum: 58; county: 'Johnson'),
          (state: 'KY'; idnum: 59; county: 'Kenton'),
          (state: 'KY'; idnum: 60; county: 'Knott'),
          (state: 'KY'; idnum: 61; county: 'Knox'),
          (state: 'KY'; idnum: 62; county: 'Larue'),
          (state: 'KY'; idnum: 63; county: 'Laurel'),
          (state: 'KY'; idnum: 64; county: 'Lawrence'),
          (state: 'KY'; idnum: 65; county: 'Lee'),
          (state: 'KY'; idnum: 66; county: 'Leslie'),
          (state: 'KY'; idnum: 67; county: 'Letcher'),
          (state: 'KY'; idnum: 68; county: 'Lewis'),
          (state: 'KY'; idnum: 69; county: 'Lincoln'),
          (state: 'KY'; idnum: 70; county: 'Livingston'),
          (state: 'KY'; idnum: 71; county: 'Logan'),
          (state: 'KY'; idnum: 72; county: 'Lyon'),
          (state: 'KY'; idnum: 73; county: 'Madison'),
          (state: 'KY'; idnum: 74; county: 'Magoffin'),
          (state: 'KY'; idnum: 75; county: 'Marion'),
          (state: 'KY'; idnum: 76; county: 'Marshall'),
          (state: 'KY'; idnum: 77; county: 'Martin'),
          (state: 'KY'; idnum: 78; county: 'Mason'),
          (state: 'KY'; idnum: 79; county: 'McCracken'),
          (state: 'KY'; idnum: 80; county: 'McCreary'),
          (state: 'KY'; idnum: 81; county: 'McLean'),
          (state: 'KY'; idnum: 82; county: 'Meade'),
          (state: 'KY'; idnum: 83; county: 'Menifee'),
          (state: 'KY'; idnum: 84; county: 'Mercer'),
          (state: 'KY'; idnum: 85; county: 'Metcalfe'),
          (state: 'KY'; idnum: 86; county: 'Monroe'),
          (state: 'KY'; idnum: 87; county: 'Montgomery'),
          (state: 'KY'; idnum: 88; county: 'Morgan'),
          (state: 'KY'; idnum: 89; county: 'Muhlenberg'),
          (state: 'KY'; idnum: 90; county: 'Nelson'),
          (state: 'KY'; idnum: 91; county: 'Nicholas'),
          (state: 'KY'; idnum: 92; county: 'Ohio'),
          (state: 'KY'; idnum: 93; county: 'Oldham'),
          (state: 'KY'; idnum: 94; county: 'Owen'),
          (state: 'KY'; idnum: 95; county: 'Owsley'),
          (state: 'KY'; idnum: 96; county: 'Pendleton'),
          (state: 'KY'; idnum: 97; county: 'Perry'),
          (state: 'KY'; idnum: 98; county: 'Pike'),
          (state: 'KY'; idnum: 99; county: 'Powell'),
          (state: 'KY'; idnum: 100; county: 'Pulaski'),
          (state: 'KY'; idnum: 101; county: 'Robertson'),
          (state: 'KY'; idnum: 102; county: 'Rockcastle'),
          (state: 'KY'; idnum: 103; county: 'Rowan'),
          (state: 'KY'; idnum: 104; county: 'Russell'),
          (state: 'KY'; idnum: 105; county: 'Scott'),
          (state: 'KY'; idnum: 106; county: 'Shelby'),
          (state: 'KY'; idnum: 107; county: 'Simpson'),
          (state: 'KY'; idnum: 108; county: 'Spencer'),
          (state: 'KY'; idnum: 109; county: 'Taylor'),
          (state: 'KY'; idnum: 110; county: 'Todd'),
          (state: 'KY'; idnum: 111; county: 'Trigg'),
          (state: 'KY'; idnum: 112; county: 'Trimble'),
          (state: 'KY'; idnum: 113; county: 'Union'),
          (state: 'KY'; idnum: 114; county: 'Warren'),
          (state: 'KY'; idnum: 115; county: 'Washington'),
          (state: 'KY'; idnum: 116; county: 'Wayne'),
          (state: 'KY'; idnum: 117; county: 'Webster'),
          (state: 'KY'; idnum: 118; county: 'Whitley'),
          (state: 'KY'; idnum: 119; county: 'Wolfe'),
          (state: 'KY'; idnum: 120; county: 'Woodford'),
          (state: 'LA'; idnum: 0; county: 'Louisiana'),
          (state: 'LA'; idnum: 1; county: 'Acadia'),
          (state: 'LA'; idnum: 2; county: 'Allen'),
          (state: 'LA'; idnum: 3; county: 'Ascension'),
          (state: 'LA'; idnum: 4; county: 'Assumption'),
          (state: 'LA'; idnum: 5; county: 'Avoyelles'),
          (state: 'LA'; idnum: 6; county: 'Beauregard'),
          (state: 'LA'; idnum: 7; county: 'Bienville'),
          (state: 'LA'; idnum: 8; county: 'Bossier'),
          (state: 'LA'; idnum: 9; county: 'Caddo'),
          (state: 'LA'; idnum: 10; county: 'Calcasieu'),
          (state: 'LA'; idnum: 11; county: 'Caldwell'),
          (state: 'LA'; idnum: 12; county: 'Cameron'),
          (state: 'LA'; idnum: 13; county: 'Catahoula'),
          (state: 'LA'; idnum: 14; county: 'Claiborne'),
          (state: 'LA'; idnum: 15; county: 'Concordia'),
          (state: 'LA'; idnum: 16; county: 'De Soto'),
          (state: 'LA'; idnum: 17; county: 'East Baton Rouge'),
          (state: 'LA'; idnum: 18; county: 'East Carroll'),
          (state: 'LA'; idnum: 19; county: 'East'),
          (state: 'LA'; idnum: 20; county: 'Feliciana'),
          (state: 'LA'; idnum: 21; county: 'Evangeline'),
          (state: 'LA'; idnum: 22; county: 'Franklin'),
          (state: 'LA'; idnum: 23; county: 'Grant'),
          (state: 'LA'; idnum: 24; county: 'Iberia'),
          (state: 'LA'; idnum: 25; county: 'Iberville'),
          (state: 'LA'; idnum: 26; county: 'Jackson'),
          (state: 'LA'; idnum: 27; county: 'Jefferson'),
          (state: 'LA'; idnum: 28; county: 'Jefferson Davis'),
          (state: 'LA'; idnum: 29; county: 'La Salle'),
          (state: 'LA'; idnum: 30; county: 'Lafayette'),
          (state: 'LA'; idnum: 31; county: 'Lafourche'),
          (state: 'LA'; idnum: 32; county: 'Lincoln'),
          (state: 'LA'; idnum: 33; county: 'Livingston'),
          (state: 'LA'; idnum: 34; county: 'Madison'),
          (state: 'LA'; idnum: 35; county: 'Morehouse'),
          (state: 'LA'; idnum: 36; county: 'Natchitoches'),
          (state: 'LA'; idnum: 37; county: 'Orleans'),
          (state: 'LA'; idnum: 38; county: 'Ouachita'),
          (state: 'LA'; idnum: 39; county: 'Plaquemines'),
          (state: 'LA'; idnum: 40; county: 'Pointe Coupee'),
          (state: 'LA'; idnum: 41; county: 'Rapides'),
          (state: 'LA'; idnum: 42; county: 'Red River'),
          (state: 'LA'; idnum: 43; county: 'Richland'),
          (state: 'LA'; idnum: 44; county: 'Sabine'),
          (state: 'LA'; idnum: 45; county: 'St. Bernard'),
          (state: 'LA'; idnum: 46; county: 'St. Charles'),
          (state: 'LA'; idnum: 47; county: 'St. Helena'),
          (state: 'LA'; idnum: 48; county: 'St. James'),
          (state: 'LA'; idnum: 49; county: 'St. John Baptist'),
          (state: 'LA'; idnum: 50; county: 'St. Landry'),
          (state: 'LA'; idnum: 51; county: 'St. Martin'),
          (state: 'LA'; idnum: 52; county: 'St. Mary'),
          (state: 'LA'; idnum: 53; county: 'St. Tammany'),
          (state: 'LA'; idnum: 54; county: 'Tangipahoa'),
          (state: 'LA'; idnum: 55; county: 'Tensas'),
          (state: 'LA'; idnum: 56; county: 'Terrebonne'),
          (state: 'LA'; idnum: 57; county: 'Union'),
          (state: 'LA'; idnum: 58; county: 'Vermilion'),
          (state: 'LA'; idnum: 59; county: 'Vernon'),
          (state: 'LA'; idnum: 60; county: 'Washington'),
          (state: 'LA'; idnum: 61; county: 'Webster'),
          (state: 'LA'; idnum: 62; county: 'West Baton'),
          (state: 'LA'; idnum: 63; county: 'Rouge'),
          (state: 'LA'; idnum: 64; county: 'West Carroll'),
          (state: 'LA'; idnum: 65; county: 'West Feliciana'),
          (state: 'LA'; idnum: 66; county: 'Winn'),
          (state: 'MA'; idnum: 0; county: 'Massachusetts'),
          (state: 'MA'; idnum: 1; county: 'Barnstable'),
          (state: 'MA'; idnum: 2; county: 'Berkshire'),
          (state: 'MA'; idnum: 3; county: 'Bristol'),
          (state: 'MA'; idnum: 4; county: 'Dukes'),
          (state: 'MA'; idnum: 5; county: 'Essex'),
          (state: 'MA'; idnum: 6; county: 'Franklin'),
          (state: 'MA'; idnum: 7; county: 'Hampden'),
          (state: 'MA'; idnum: 8; county: 'Hampshire'),
          (state: 'MA'; idnum: 9; county: 'Middlesex'),
          (state: 'MA'; idnum: 10; county: 'Nantucket'),
          (state: 'MA'; idnum: 11; county: 'Norfolk'),
          (state: 'MA'; idnum: 12; county: 'Plymouth'),
          (state: 'MA'; idnum: 13; county: 'Suffolk'),
          (state: 'MA'; idnum: 14; county: 'Worcester'),
          (state: 'MD'; idnum: 0; county: 'Maryland'),
          (state: 'MD'; idnum: 1; county: 'Allegany'),
          (state: 'MD'; idnum: 2; county: 'Anne Arundel'),
          (state: 'MD'; idnum: 3; county: 'Baltimore'),
          (state: 'MD'; idnum: 4; county: 'Calvert'),
          (state: 'MD'; idnum: 5; county: 'Caroline'),
          (state: 'MD'; idnum: 6; county: 'Carroll'),
          (state: 'MD'; idnum: 7; county: 'Cecil'),
          (state: 'MD'; idnum: 8; county: 'Charles'),
          (state: 'MD'; idnum: 9; county: 'Dorchester'),
          (state: 'MD'; idnum: 10; county: 'Frederick'),
          (state: 'MD'; idnum: 11; county: 'Garrett'),
          (state: 'MD'; idnum: 12; county: 'Harford'),
          (state: 'MD'; idnum: 13; county: 'Howard'),
          (state: 'MD'; idnum: 14; county: 'Kent'),
          (state: 'MD'; idnum: 15; county: 'Montgomery'),
          (state: 'MD'; idnum: 16; county: 'Prince George''s'),
          (state: 'MD'; idnum: 17; county: 'Queen Anne''s'),
          (state: 'MD'; idnum: 18; county: 'Somerset'),
          (state: 'MD'; idnum: 19; county: 'St. Marys'),
          (state: 'MD'; idnum: 20; county: 'Talbot'),
          (state: 'MD'; idnum: 21; county: 'Washington'),
          (state: 'MD'; idnum: 22; county: 'Wicomico'),
          (state: 'MD'; idnum: 23; county: 'Worchester'),
          (state: 'ME'; idnum: 0; county: 'Maine'),
          (state: 'ME'; idnum: 1; county: 'Androscoggin'),
          (state: 'ME'; idnum: 2; county: 'Aroostook'),
          (state: 'ME'; idnum: 3; county: 'Cumberland'),
          (state: 'ME'; idnum: 4; county: 'Franklin'),
          (state: 'ME'; idnum: 5; county: 'Hancock'),
          (state: 'ME'; idnum: 6; county: 'Kennebec'),
          (state: 'ME'; idnum: 7; county: 'Knox'),
          (state: 'ME'; idnum: 8; county: 'Lincoln'),
          (state: 'ME'; idnum: 9; county: 'Oxford'),
          (state: 'ME'; idnum: 10; county: 'Penobscot'),
          (state: 'ME'; idnum: 11; county: 'Piscataquis'),
          (state: 'ME'; idnum: 12; county: 'Sagadahoc'),
          (state: 'ME'; idnum: 13; county: 'Somerset'),
          (state: 'ME'; idnum: 14; county: 'Waldo'),
          (state: 'ME'; idnum: 15; county: 'Washington'),
          (state: 'ME'; idnum: 16; county: 'York'),
          (state: 'MI'; idnum: 0; county: 'Michigan'),
          (state: 'MI'; idnum: 1; county: 'Alcona'),
          (state: 'MI'; idnum: 2; county: 'Alger'),
          (state: 'MI'; idnum: 3; county: 'Allegan'),
          (state: 'MI'; idnum: 4; county: 'Alpena'),
          (state: 'MI'; idnum: 5; county: 'Antrim'),
          (state: 'MI'; idnum: 6; county: 'Arenac'),
          (state: 'MI'; idnum: 7; county: 'Baraga'),
          (state: 'MI'; idnum: 8; county: 'Barry'),
          (state: 'MI'; idnum: 9; county: 'Bay'),
          (state: 'MI'; idnum: 10; county: 'Benzie'),
          (state: 'MI'; idnum: 11; county: 'Berrien'),
          (state: 'MI'; idnum: 12; county: 'Branch'),
          (state: 'MI'; idnum: 13; county: 'Calhoun'),
          (state: 'MI'; idnum: 14; county: 'Cass'),
          (state: 'MI'; idnum: 15; county: 'Charlevoix'),
          (state: 'MI'; idnum: 16; county: 'Cheboygan'),
          (state: 'MI'; idnum: 17; county: 'Chippewa'),
          (state: 'MI'; idnum: 18; county: 'Clare'),
          (state: 'MI'; idnum: 19; county: 'Clinton'),
          (state: 'MI'; idnum: 20; county: 'Crawford'),
          (state: 'MI'; idnum: 21; county: 'Delta'),
          (state: 'MI'; idnum: 22; county: 'Dickinson'),
          (state: 'MI'; idnum: 23; county: 'Eaton'),
          (state: 'MI'; idnum: 24; county: 'Emmet'),
          (state: 'MI'; idnum: 25; county: 'Genesee'),
          (state: 'MI'; idnum: 26; county: 'Gladwin'),
          (state: 'MI'; idnum: 27; county: 'Gogebic'),
          (state: 'MI'; idnum: 28; county: 'Grand Traverse'),
          (state: 'MI'; idnum: 29; county: 'Gratiot'),
          (state: 'MI'; idnum: 30; county: 'Hillsdale'),
          (state: 'MI'; idnum: 31; county: 'Houghton'),
          (state: 'MI'; idnum: 32; county: 'Huron'),
          (state: 'MI'; idnum: 33; county: 'Ingham'),
          (state: 'MI'; idnum: 34; county: 'Ionia'),
          (state: 'MI'; idnum: 35; county: 'Iosco'),
          (state: 'MI'; idnum: 36; county: 'Iron'),
          (state: 'MI'; idnum: 37; county: 'Isabella'),
          (state: 'MI'; idnum: 38; county: 'Jackson'),
          (state: 'MI'; idnum: 39; county: 'Kalamazoo'),
          (state: 'MI'; idnum: 40; county: 'Kalkaska'),
          (state: 'MI'; idnum: 41; county: 'Kent'),
          (state: 'MI'; idnum: 42; county: 'Keweenaw'),
          (state: 'MI'; idnum: 43; county: 'Lake'),
          (state: 'MI'; idnum: 44; county: 'Lapeer'),
          (state: 'MI'; idnum: 45; county: 'Leelanau'),
          (state: 'MI'; idnum: 46; county: 'Lenawee'),
          (state: 'MI'; idnum: 47; county: 'Livingston'),
          (state: 'MI'; idnum: 48; county: 'Luce'),
          (state: 'MI'; idnum: 49; county: 'Mackinac'),
          (state: 'MI'; idnum: 50; county: 'Macomb'),
          (state: 'MI'; idnum: 51; county: 'Manistee'),
          (state: 'MI'; idnum: 52; county: 'Marquette'),
          (state: 'MI'; idnum: 53; county: 'Mason'),
          (state: 'MI'; idnum: 54; county: 'Mecosta'),
          (state: 'MI'; idnum: 55; county: 'Menominee'),
          (state: 'MI'; idnum: 56; county: 'Midland'),
          (state: 'MI'; idnum: 57; county: 'Missaukee'),
          (state: 'MI'; idnum: 58; county: 'Monroe'),
          (state: 'MI'; idnum: 59; county: 'Montcalm'),
          (state: 'MI'; idnum: 60; county: 'Montmorency'),
          (state: 'MI'; idnum: 61; county: 'Muskegon'),
          (state: 'MI'; idnum: 62; county: 'Newaygo'),
          (state: 'MI'; idnum: 63; county: 'Oakland'),
          (state: 'MI'; idnum: 64; county: 'Oceana'),
          (state: 'MI'; idnum: 65; county: 'Ogemaw'),
          (state: 'MI'; idnum: 66; county: 'Ontonagon'),
          (state: 'MI'; idnum: 67; county: 'Osceola'),
          (state: 'MI'; idnum: 68; county: 'Oscoda'),
          (state: 'MI'; idnum: 69; county: 'Otsego'),
          (state: 'MI'; idnum: 70; county: 'Ottawa'),
          (state: 'MI'; idnum: 71; county: 'Presque Isle'),
          (state: 'MI'; idnum: 72; county: 'Roscommon'),
          (state: 'MI'; idnum: 73; county: 'Saginaw'),
          (state: 'MI'; idnum: 74; county: 'Sanilac'),
          (state: 'MI'; idnum: 75; county: 'Schoolcraft'),
          (state: 'MI'; idnum: 76; county: 'Shiawassee'),
          (state: 'MI'; idnum: 77; county: 'St. Clair'),
          (state: 'MI'; idnum: 78; county: 'St. Joseph'),
          (state: 'MI'; idnum: 79; county: 'Tuscola'),
          (state: 'MI'; idnum: 80; county: 'Van Buren'),
          (state: 'MI'; idnum: 81; county: 'Washtenaw'),
          (state: 'MI'; idnum: 82; county: 'Wayne'),
          (state: 'MI'; idnum: 83; county: 'Wexford'),
          (state: 'MN'; idnum: 0; county: 'Minnesota'),
          (state: 'MN'; idnum: 1; county: 'Aitkin'),
          (state: 'MN'; idnum: 2; county: 'Anoka'),
          (state: 'MN'; idnum: 3; county: 'Becker'),
          (state: 'MN'; idnum: 4; county: 'Beltrami'),
          (state: 'MN'; idnum: 5; county: 'Benton'),
          (state: 'MN'; idnum: 6; county: 'Big Stone'),
          (state: 'MN'; idnum: 7; county: 'Blue Earth'),
          (state: 'MN'; idnum: 8; county: 'Brown'),
          (state: 'MN'; idnum: 9; county: 'Carlton'),
          (state: 'MN'; idnum: 10; county: 'Carver'),
          (state: 'MN'; idnum: 11; county: 'Cass'),
          (state: 'MN'; idnum: 12; county: 'Chippewa'),
          (state: 'MN'; idnum: 13; county: 'Chisago'),
          (state: 'MN'; idnum: 14; county: 'Clay'),
          (state: 'MN'; idnum: 15; county: 'Clearwater'),
          (state: 'MN'; idnum: 16; county: 'Cook'),
          (state: 'MN'; idnum: 17; county: 'Cottonwood'),
          (state: 'MN'; idnum: 18; county: 'Crow Wing'),
          (state: 'MN'; idnum: 19; county: 'Dakota'),
          (state: 'MN'; idnum: 20; county: 'Dodge'),
          (state: 'MN'; idnum: 21; county: 'Douglas'),
          (state: 'MN'; idnum: 22; county: 'Faribault'),
          (state: 'MN'; idnum: 23; county: 'Fillmore'),
          (state: 'MN'; idnum: 24; county: 'Freeborn'),
          (state: 'MN'; idnum: 25; county: 'Goodhue'),
          (state: 'MN'; idnum: 26; county: 'Grant'),
          (state: 'MN'; idnum: 27; county: 'Hennepin'),
          (state: 'MN'; idnum: 28; county: 'Houston'),
          (state: 'MN'; idnum: 29; county: 'Hubbard'),
          (state: 'MN'; idnum: 30; county: 'Isanti'),
          (state: 'MN'; idnum: 31; county: 'Itasca'),
          (state: 'MN'; idnum: 32; county: 'Jackson'),
          (state: 'MN'; idnum: 33; county: 'Kanabec'),
          (state: 'MN'; idnum: 34; county: 'Kandiyohi'),
          (state: 'MN'; idnum: 35; county: 'Kittson'),
          (state: 'MN'; idnum: 36; county: 'Koochiching'),
          (state: 'MN'; idnum: 37; county: 'Lac Qui Parle'),
          (state: 'MN'; idnum: 38; county: 'Lake'),
          (state: 'MN'; idnum: 39; county: 'Lake of Woods'),
          (state: 'MN'; idnum: 40; county: 'Le Sueur'),
          (state: 'MN'; idnum: 41; county: 'Lincoln'),
          (state: 'MN'; idnum: 42; county: 'Lyon'),
          (state: 'MN'; idnum: 43; county: 'Mahnomen'),
          (state: 'MN'; idnum: 44; county: 'Marshall'),
          (state: 'MN'; idnum: 45; county: 'Martin'),
          (state: 'MN'; idnum: 46; county: 'McLeod'),
          (state: 'MN'; idnum: 47; county: 'Meeker'),
          (state: 'MN'; idnum: 48; county: 'Mille Lacs'),
          (state: 'MN'; idnum: 49; county: 'Morrison'),
          (state: 'MN'; idnum: 50; county: 'Mower'),
          (state: 'MN'; idnum: 51; county: 'Murray'),
          (state: 'MN'; idnum: 52; county: 'Nicollet'),
          (state: 'MN'; idnum: 53; county: 'Nobles'),
          (state: 'MN'; idnum: 54; county: 'Norman'),
          (state: 'MN'; idnum: 55; county: 'Olmsted'),
          (state: 'MN'; idnum: 56; county: 'Otter Tail'),
          (state: 'MN'; idnum: 57; county: 'Pennington'),
          (state: 'MN'; idnum: 58; county: 'Pine'),
          (state: 'MN'; idnum: 59; county: 'Pipestone'),
          (state: 'MN'; idnum: 60; county: 'Polk'),
          (state: 'MN'; idnum: 61; county: 'Pope'),
          (state: 'MN'; idnum: 62; county: 'Ramsey'),
          (state: 'MN'; idnum: 63; county: 'Red Lake'),
          (state: 'MN'; idnum: 64; county: 'Redwood'),
          (state: 'MN'; idnum: 65; county: 'Renville'),
          (state: 'MN'; idnum: 66; county: 'Rice'),
          (state: 'MN'; idnum: 67; county: 'Rock'),
          (state: 'MN'; idnum: 68; county: 'Roseau'),
          (state: 'MN'; idnum: 69; county: 'Scott'),
          (state: 'MN'; idnum: 70; county: 'Sherburne'),
          (state: 'MN'; idnum: 71; county: 'Sibley'),
          (state: 'MN'; idnum: 72; county: 'St. Louis'),
          (state: 'MN'; idnum: 73; county: 'Stearns'),
          (state: 'MN'; idnum: 74; county: 'Steele'),
          (state: 'MN'; idnum: 75; county: 'Stevens'),
          (state: 'MN'; idnum: 76; county: 'Swift'),
          (state: 'MN'; idnum: 77; county: 'Todd'),
          (state: 'MN'; idnum: 78; county: 'Traverse'),
          (state: 'MN'; idnum: 79; county: 'Wabasha'),
          (state: 'MN'; idnum: 80; county: 'Wadena'),
          (state: 'MN'; idnum: 81; county: 'Waseca'),
          (state: 'MN'; idnum: 82; county: 'Washington'),
          (state: 'MN'; idnum: 83; county: 'Watonwan'),
          (state: 'MN'; idnum: 84; county: 'Wilkin'),
          (state: 'MN'; idnum: 85; county: 'Winona'),
          (state: 'MN'; idnum: 86; county: 'Wright'),
          (state: 'MN'; idnum: 87; county: 'Yellow Medicine'),
          (state: 'MO'; idnum: 0; county: 'Missouri'),
          (state: 'MO'; idnum: 1; county: 'Adair'),
          (state: 'MO'; idnum: 2; county: 'Andrew'),
          (state: 'MO'; idnum: 3; county: 'Atchison'),
          (state: 'MO'; idnum: 4; county: 'Audrain'),
          (state: 'MO'; idnum: 5; county: 'Barry'),
          (state: 'MO'; idnum: 6; county: 'Barton'),
          (state: 'MO'; idnum: 7; county: 'Bates'),
          (state: 'MO'; idnum: 8; county: 'Benton'),
          (state: 'MO'; idnum: 9; county: 'Bollinger'),
          (state: 'MO'; idnum: 10; county: 'Boone'),
          (state: 'MO'; idnum: 11; county: 'Buchanan'),
          (state: 'MO'; idnum: 12; county: 'Butler'),
          (state: 'MO'; idnum: 13; county: 'Caldwell'),
          (state: 'MO'; idnum: 14; county: 'Callaway'),
          (state: 'MO'; idnum: 15; county: 'Camden'),
          (state: 'MO'; idnum: 16; county: 'Cape Girardeau'),
          (state: 'MO'; idnum: 17; county: 'Carroll'),
          (state: 'MO'; idnum: 18; county: 'Carter'),
          (state: 'MO'; idnum: 19; county: 'Cass'),
          (state: 'MO'; idnum: 20; county: 'Cedar'),
          (state: 'MO'; idnum: 21; county: 'Charlton'),
          (state: 'MO'; idnum: 22; county: 'Christian'),
          (state: 'MO'; idnum: 23; county: 'Clark'),
          (state: 'MO'; idnum: 24; county: 'Clay'),
          (state: 'MO'; idnum: 25; county: 'Clinton'),
          (state: 'MO'; idnum: 26; county: 'Cole'),
          (state: 'MO'; idnum: 27; county: 'Cooper'),
          (state: 'MO'; idnum: 28; county: 'Crawford'),
          (state: 'MO'; idnum: 29; county: 'Dade'),
          (state: 'MO'; idnum: 30; county: 'Dallas'),
          (state: 'MO'; idnum: 31; county: 'Daviess'),
          (state: 'MO'; idnum: 32; county: 'DeKalb'),
          (state: 'MO'; idnum: 33; county: 'Dent'),
          (state: 'MO'; idnum: 34; county: 'Douglas'),
          (state: 'MO'; idnum: 35; county: 'Dunklin'),
          (state: 'MO'; idnum: 36; county: 'Franklin'),
          (state: 'MO'; idnum: 37; county: 'Gasconade'),
          (state: 'MO'; idnum: 38; county: 'Gentry'),
          (state: 'MO'; idnum: 39; county: 'Greene'),
          (state: 'MO'; idnum: 40; county: 'Grundy'),
          (state: 'MO'; idnum: 41; county: 'Harrison'),
          (state: 'MO'; idnum: 42; county: 'Henry'),
          (state: 'MO'; idnum: 43; county: 'Hickory'),
          (state: 'MO'; idnum: 44; county: 'Holt'),
          (state: 'MO'; idnum: 45; county: 'Howard'),
          (state: 'MO'; idnum: 46; county: 'Howell'),
          (state: 'MO'; idnum: 47; county: 'Iron'),
          (state: 'MO'; idnum: 48; county: 'Jackson'),
          (state: 'MO'; idnum: 49; county: 'Jasper'),
          (state: 'MO'; idnum: 50; county: 'Jefferson'),
          (state: 'MO'; idnum: 51; county: 'Johnson'),
          (state: 'MO'; idnum: 52; county: 'Knox'),
          (state: 'MO'; idnum: 53; county: 'Laclede'),
          (state: 'MO'; idnum: 54; county: 'Lafayette'),
          (state: 'MO'; idnum: 55; county: 'Lawrence'),
          (state: 'MO'; idnum: 56; county: 'Lewis'),
          (state: 'MO'; idnum: 57; county: 'Lincoln'),
          (state: 'MO'; idnum: 58; county: 'Linn'),
          (state: 'MO'; idnum: 59; county: 'Livingston'),
          (state: 'MO'; idnum: 60; county: 'Macon'),
          (state: 'MO'; idnum: 61; county: 'Madison'),
          (state: 'MO'; idnum: 62; county: 'Marion'),
          (state: 'MO'; idnum: 63; county: 'Maries'),
          (state: 'MO'; idnum: 64; county: 'McDonald'),
          (state: 'MO'; idnum: 65; county: 'Mercer'),
          (state: 'MO'; idnum: 66; county: 'Miller'),
          (state: 'MO'; idnum: 67; county: 'Mississippi'),
          (state: 'MO'; idnum: 68; county: 'Moniteau'),
          (state: 'MO'; idnum: 69; county: 'Monroe'),
          (state: 'MO'; idnum: 70; county: 'Montgomery'),
          (state: 'MO'; idnum: 71; county: 'Morgan'),
          (state: 'MO'; idnum: 72; county: 'New Madrid'),
          (state: 'MO'; idnum: 73; county: 'Newton'),
          (state: 'MO'; idnum: 74; county: 'Nodaway'),
          (state: 'MO'; idnum: 75; county: 'Oregon'),
          (state: 'MO'; idnum: 76; county: 'Osage'),
          (state: 'MO'; idnum: 77; county: 'Ozark'),
          (state: 'MO'; idnum: 78; county: 'Pemiscot'),
          (state: 'MO'; idnum: 79; county: 'Perry'),
          (state: 'MO'; idnum: 80; county: 'Pettis'),
          (state: 'MO'; idnum: 81; county: 'Phelps'),
          (state: 'MO'; idnum: 82; county: 'Pike'),
          (state: 'MO'; idnum: 83; county: 'Platte'),
          (state: 'MO'; idnum: 84; county: 'Polk'),
          (state: 'MO'; idnum: 85; county: 'Pulaski'),
          (state: 'MO'; idnum: 86; county: 'Putnam'),
          (state: 'MO'; idnum: 87; county: 'Ralls'),
          (state: 'MO'; idnum: 88; county: 'Randolph'),
          (state: 'MO'; idnum: 89; county: 'Ray'),
          (state: 'MO'; idnum: 90; county: 'Reynolds'),
          (state: 'MO'; idnum: 91; county: 'Ripley'),
          (state: 'MO'; idnum: 92; county: 'Saline'),
          (state: 'MO'; idnum: 93; county: 'Schuyler'),
          (state: 'MO'; idnum: 94; county: 'Scotland'),
          (state: 'MO'; idnum: 95; county: 'Scott'),
          (state: 'MO'; idnum: 96; county: 'Shannon'),
          (state: 'MO'; idnum: 97; county: 'Shelby'),
          (state: 'MO'; idnum: 98; county: 'St. Charles'),
          (state: 'MO'; idnum: 99; county: 'St. Clair'),
          (state: 'MO'; idnum: 100; county: 'St. Francois'),
          (state: 'MO'; idnum: 101; county: 'Ste. Genevieve'),
          (state: 'MO'; idnum: 102; county: 'St. Louis'),
          (state: 'MO'; idnum: 103; county: 'Stoddard'),
          (state: 'MO'; idnum: 104; county: 'Stone'),
          (state: 'MO'; idnum: 105; county: 'Sullivan'),
          (state: 'MO'; idnum: 106; county: 'Taney'),
          (state: 'MO'; idnum: 107; county: 'Texas'),
          (state: 'MO'; idnum: 108; county: 'Vernon'),
          (state: 'MO'; idnum: 109; county: 'Warren'),
          (state: 'MO'; idnum: 110; county: 'Washington'),
          (state: 'MO'; idnum: 111; county: 'Wayne'),
          (state: 'MO'; idnum: 112; county: 'Webster'),
          (state: 'MO'; idnum: 113; county: 'Worth'),
          (state: 'MO'; idnum: 114; county: 'Wright'),
          (state: 'MS'; idnum: 0; county: 'Mississippi'),
          (state: 'MS'; idnum: 1; county: 'Adams'),
          (state: 'MS'; idnum: 2; county: 'Alcorn'),
          (state: 'MS'; idnum: 3; county: 'Amite'),
          (state: 'MS'; idnum: 4; county: 'Attala'),
          (state: 'MS'; idnum: 5; county: 'Benton'),
          (state: 'MS'; idnum: 6; county: 'Bolivar'),
          (state: 'MS'; idnum: 7; county: 'Calhoun'),
          (state: 'MS'; idnum: 8; county: 'Carroll'),
          (state: 'MS'; idnum: 9; county: 'Chickasaw'),
          (state: 'MS'; idnum: 10; county: 'Choctaw'),
          (state: 'MS'; idnum: 11; county: 'Claiborne'),
          (state: 'MS'; idnum: 12; county: 'Clarke'),
          (state: 'MS'; idnum: 13; county: 'Clay'),
          (state: 'MS'; idnum: 14; county: 'Coahoma'),
          (state: 'MS'; idnum: 15; county: 'Copiah'),
          (state: 'MS'; idnum: 16; county: 'Covington'),
          (state: 'MS'; idnum: 17; county: 'Desoto'),
          (state: 'MS'; idnum: 18; county: 'Forrest'),
          (state: 'MS'; idnum: 19; county: 'Franklin'),
          (state: 'MS'; idnum: 20; county: 'George'),
          (state: 'MS'; idnum: 21; county: 'Greene'),
          (state: 'MS'; idnum: 22; county: 'Grenada'),
          (state: 'MS'; idnum: 23; county: 'Hancock'),
          (state: 'MS'; idnum: 24; county: 'Harrison'),
          (state: 'MS'; idnum: 25; county: 'Hinds'),
          (state: 'MS'; idnum: 26; county: 'Holmes'),
          (state: 'MS'; idnum: 27; county: 'Humphreys'),
          (state: 'MS'; idnum: 28; county: 'Issaquena'),
          (state: 'MS'; idnum: 29; county: 'Itawamba'),
          (state: 'MS'; idnum: 30; county: 'Jackson'),
          (state: 'MS'; idnum: 31; county: 'Jasper'),
          (state: 'MS'; idnum: 32; county: 'Jefferson'),
          (state: 'MS'; idnum: 33; county: 'Jefferson Davis'),
          (state: 'MS'; idnum: 34; county: 'Jones'),
          (state: 'MS'; idnum: 35; county: 'Kemper'),
          (state: 'MS'; idnum: 36; county: 'Lafayette'),
          (state: 'MS'; idnum: 37; county: 'Lamar'),
          (state: 'MS'; idnum: 38; county: 'Lauderdale'),
          (state: 'MS'; idnum: 39; county: 'Lawrence'),
          (state: 'MS'; idnum: 40; county: 'Leake'),
          (state: 'MS'; idnum: 41; county: 'Lee'),
          (state: 'MS'; idnum: 42; county: 'Leflore'),
          (state: 'MS'; idnum: 43; county: 'Lincoln'),
          (state: 'MS'; idnum: 44; county: 'Lowndes'),
          (state: 'MS'; idnum: 45; county: 'Madison'),
          (state: 'MS'; idnum: 46; county: 'Marion'),
          (state: 'MS'; idnum: 47; county: 'Marshall'),
          (state: 'MS'; idnum: 48; county: 'Monroe'),
          (state: 'MS'; idnum: 49; county: 'Montgomery'),
          (state: 'MS'; idnum: 50; county: 'Neshoba'),
          (state: 'MS'; idnum: 51; county: 'Newton'),
          (state: 'MS'; idnum: 52; county: 'Noxubee'),
          (state: 'MS'; idnum: 53; county: 'Oktibbeha'),
          (state: 'MS'; idnum: 54; county: 'Panola'),
          (state: 'MS'; idnum: 55; county: 'Pearl River'),
          (state: 'MS'; idnum: 56; county: 'Perry'),
          (state: 'MS'; idnum: 57; county: 'Pike'),
          (state: 'MS'; idnum: 58; county: 'Pontotoc'),
          (state: 'MS'; idnum: 59; county: 'Prentiss'),
          (state: 'MS'; idnum: 60; county: 'Quitman'),
          (state: 'MS'; idnum: 61; county: 'Rankin'),
          (state: 'MS'; idnum: 62; county: 'Scott'),
          (state: 'MS'; idnum: 63; county: 'Sharkey'),
          (state: 'MS'; idnum: 64; county: 'Simpson'),
          (state: 'MS'; idnum: 65; county: 'Smith'),
          (state: 'MS'; idnum: 66; county: 'Stone'),
          (state: 'MS'; idnum: 67; county: 'Sunflower'),
          (state: 'MS'; idnum: 68; county: 'Tallahatchie'),
          (state: 'MS'; idnum: 69; county: 'Tate'),
          (state: 'MS'; idnum: 70; county: 'Tippah'),
          (state: 'MS'; idnum: 71; county: 'Tishomingo'),
          (state: 'MS'; idnum: 72; county: 'Tunica'),
          (state: 'MS'; idnum: 73; county: 'Union'),
          (state: 'MS'; idnum: 74; county: 'Walthall'),
          (state: 'MS'; idnum: 75; county: 'Warren'),
          (state: 'MS'; idnum: 76; county: 'Washington'),
          (state: 'MS'; idnum: 77; county: 'Wayne'),
          (state: 'MS'; idnum: 78; county: 'Webster'),
          (state: 'MS'; idnum: 79; county: 'Wilkinson'),
          (state: 'MS'; idnum: 80; county: 'Winston'),
          (state: 'MS'; idnum: 81; county: 'Yalobusha'),
          (state: 'MS'; idnum: 82; county: 'Yazoo'),
          (state: 'MT'; idnum: 0; county: 'Montana'),
          (state: 'MT'; idnum: 1; county: 'Beaverhead'),
          (state: 'MT'; idnum: 2; county: 'Big Horn'),
          (state: 'MT'; idnum: 3; county: 'Blaine'),
          (state: 'MT'; idnum: 4; county: 'Broadwater'),
          (state: 'MT'; idnum: 5; county: 'Carbon'),
          (state: 'MT'; idnum: 6; county: 'Carter'),
          (state: 'MT'; idnum: 7; county: 'Cascade'),
          (state: 'MT'; idnum: 8; county: 'Chouteau'),
          (state: 'MT'; idnum: 9; county: 'Custer'),
          (state: 'MT'; idnum: 10; county: 'Daniels'),
          (state: 'MT'; idnum: 11; county: 'Dawson'),
          (state: 'MT'; idnum: 12; county: 'Deer Lodge'),
          (state: 'MT'; idnum: 13; county: 'Fallon'),
          (state: 'MT'; idnum: 14; county: 'Fergus'),
          (state: 'MT'; idnum: 15; county: 'Flathead'),
          (state: 'MT'; idnum: 16; county: 'Gallatin'),
          (state: 'MT'; idnum: 17; county: 'Garfield'),
          (state: 'MT'; idnum: 18; county: 'Glacier'),
          (state: 'MT'; idnum: 19; county: 'Golden Valley'),
          (state: 'MT'; idnum: 20; county: 'Granite'),
          (state: 'MT'; idnum: 21; county: 'Hill'),
          (state: 'MT'; idnum: 22; county: 'Jefferson'),
          (state: 'MT'; idnum: 23; county: 'Judith Basin'),
          (state: 'MT'; idnum: 24; county: 'Lake'),
          (state: 'MT'; idnum: 25; county: 'Lewis and Clark'),
          (state: 'MT'; idnum: 26; county: 'Liberty'),
          (state: 'MT'; idnum: 27; county: 'Lincoln'),
          (state: 'MT'; idnum: 28; county: 'Madison'),
          (state: 'MT'; idnum: 29; county: 'McCone'),
          (state: 'MT'; idnum: 30; county: 'Meagher'),
          (state: 'MT'; idnum: 31; county: 'Mineral'),
          (state: 'MT'; idnum: 32; county: 'Missoula'),
          (state: 'MT'; idnum: 33; county: 'Musselshell'),
          (state: 'MT'; idnum: 34; county: 'Park'),
          (state: 'MT'; idnum: 35; county: 'Petroleum'),
          (state: 'MT'; idnum: 36; county: 'Phillips'),
          (state: 'MT'; idnum: 37; county: 'Pondera'),
          (state: 'MT'; idnum: 38; county: 'Powder River'),
          (state: 'MT'; idnum: 39; county: 'Powell'),
          (state: 'MT'; idnum: 40; county: 'Prairie'),
          (state: 'MT'; idnum: 41; county: 'Ravalli'),
          (state: 'MT'; idnum: 42; county: 'Richland'),
          (state: 'MT'; idnum: 43; county: 'Roosevelt'),
          (state: 'MT'; idnum: 44; county: 'Rosebud'),
          (state: 'MT'; idnum: 45; county: 'Sanders'),
          (state: 'MT'; idnum: 46; county: 'Sheridan'),
          (state: 'MT'; idnum: 47; county: 'Silver Bow'),
          (state: 'MT'; idnum: 48; county: 'Stillwater'),
          (state: 'MT'; idnum: 49; county: 'Sweet Grass'),
          (state: 'MT'; idnum: 50; county: 'Teton'),
          (state: 'MT'; idnum: 51; county: 'Toole'),
          (state: 'MT'; idnum: 52; county: 'Treasure'),
          (state: 'MT'; idnum: 53; county: 'Valley'),
          (state: 'MT'; idnum: 54; county: 'Wheatland'),
          (state: 'MT'; idnum: 55; county: 'Wibaux'),
          (state: 'MT'; idnum: 56; county: 'Yellowstone'),
          (state: 'MT'; idnum: 57; county: 'Yellowstone National Park'),
          (state: 'NC'; idnum: 0; county: 'North Carolina'),
          (state: 'NC'; idnum: 1; county: 'Alamance'),
          (state: 'NC'; idnum: 2; county: 'Alexander'),
          (state: 'NC'; idnum: 3; county: 'Alleghany'),
          (state: 'NC'; idnum: 4; county: 'Anson'),
          (state: 'NC'; idnum: 5; county: 'Ashe'),
          (state: 'NC'; idnum: 6; county: 'Avery'),
          (state: 'NC'; idnum: 7; county: 'Beaufort'),
          (state: 'NC'; idnum: 8; county: 'Bertie'),
          (state: 'NC'; idnum: 9; county: 'Bladen'),
          (state: 'NC'; idnum: 10; county: 'Brunswick'),
          (state: 'NC'; idnum: 11; county: 'Buncombe'),
          (state: 'NC'; idnum: 12; county: 'Burke'),
          (state: 'NC'; idnum: 13; county: 'Cabarrus'),
          (state: 'NC'; idnum: 14; county: 'Caldwell'),
          (state: 'NC'; idnum: 15; county: 'Camden'),
          (state: 'NC'; idnum: 16; county: 'Carteret'),
          (state: 'NC'; idnum: 17; county: 'Caswell'),
          (state: 'NC'; idnum: 18; county: 'Catawba'),
          (state: 'NC'; idnum: 19; county: 'Chatham'),
          (state: 'NC'; idnum: 20; county: 'Cherokee'),
          (state: 'NC'; idnum: 21; county: 'Chowan'),
          (state: 'NC'; idnum: 22; county: 'Clay'),
          (state: 'NC'; idnum: 23; county: 'Cleveland'),
          (state: 'NC'; idnum: 24; county: 'Columbus'),
          (state: 'NC'; idnum: 25; county: 'Craven'),
          (state: 'NC'; idnum: 26; county: 'Cumberland'),
          (state: 'NC'; idnum: 27; county: 'Currituck'),
          (state: 'NC'; idnum: 28; county: 'Dare'),
          (state: 'NC'; idnum: 29; county: 'Davidson'),
          (state: 'NC'; idnum: 30; county: 'Davie'),
          (state: 'NC'; idnum: 31; county: 'Duplin'),
          (state: 'NC'; idnum: 32; county: 'Durham'),
          (state: 'NC'; idnum: 33; county: 'Edgecombe'),
          (state: 'NC'; idnum: 34; county: 'Forsyth'),
          (state: 'NC'; idnum: 35; county: 'Franklin'),
          (state: 'NC'; idnum: 36; county: 'Gaston'),
          (state: 'NC'; idnum: 37; county: 'Gates'),
          (state: 'NC'; idnum: 38; county: 'Graham'),
          (state: 'NC'; idnum: 39; county: 'Granville'),
          (state: 'NC'; idnum: 40; county: 'Greene'),
          (state: 'NC'; idnum: 41; county: 'Guilford'),
          (state: 'NC'; idnum: 42; county: 'Halifax'),
          (state: 'NC'; idnum: 43; county: 'Harnett'),
          (state: 'NC'; idnum: 44; county: 'Haywood'),
          (state: 'NC'; idnum: 45; county: 'Henderson'),
          (state: 'NC'; idnum: 46; county: 'Hertford'),
          (state: 'NC'; idnum: 47; county: 'Hoke'),
          (state: 'NC'; idnum: 48; county: 'Hyde'),
          (state: 'NC'; idnum: 49; county: 'Iredell'),
          (state: 'NC'; idnum: 50; county: 'Jackson'),
          (state: 'NC'; idnum: 51; county: 'Johnston'),
          (state: 'NC'; idnum: 52; county: 'Jones'),
          (state: 'NC'; idnum: 53; county: 'Lee'),
          (state: 'NC'; idnum: 54; county: 'Lenoir'),
          (state: 'NC'; idnum: 55; county: 'Lincoln'),
          (state: 'NC'; idnum: 56; county: 'Macon'),
          (state: 'NC'; idnum: 57; county: 'Madison'),
          (state: 'NC'; idnum: 58; county: 'Martin'),
          (state: 'NC'; idnum: 59; county: 'McDowell'),
          (state: 'NC'; idnum: 60; county: 'Mecklenburg'),
          (state: 'NC'; idnum: 61; county: 'Mitchell'),
          (state: 'NC'; idnum: 62; county: 'Montgomery'),
          (state: 'NC'; idnum: 63; county: 'Moore'),
          (state: 'NC'; idnum: 64; county: 'Nash'),
          (state: 'NC'; idnum: 65; county: 'New Hanover'),
          (state: 'NC'; idnum: 66; county: 'Northampton'),
          (state: 'NC'; idnum: 67; county: 'Onslow'),
          (state: 'NC'; idnum: 68; county: 'Orange'),
          (state: 'NC'; idnum: 69; county: 'Pamlico'),
          (state: 'NC'; idnum: 70; county: 'Pasquotank'),
          (state: 'NC'; idnum: 71; county: 'Pender'),
          (state: 'NC'; idnum: 72; county: 'Perquimans'),
          (state: 'NC'; idnum: 73; county: 'Person'),
          (state: 'NC'; idnum: 74; county: 'Pitt'),
          (state: 'NC'; idnum: 75; county: 'Polk'),
          (state: 'NC'; idnum: 76; county: 'Randolph'),
          (state: 'NC'; idnum: 77; county: 'Richmond'),
          (state: 'NC'; idnum: 78; county: 'Robeson'),
          (state: 'NC'; idnum: 79; county: 'Rockingham'),
          (state: 'NC'; idnum: 80; county: 'Rowan'),
          (state: 'NC'; idnum: 81; county: 'Rutherford'),
          (state: 'NC'; idnum: 82; county: 'Sampson'),
          (state: 'NC'; idnum: 83; county: 'Scotland'),
          (state: 'NC'; idnum: 84; county: 'Stanly'),
          (state: 'NC'; idnum: 85; county: 'Stokes'),
          (state: 'NC'; idnum: 86; county: 'Surry'),
          (state: 'NC'; idnum: 87; county: 'Swain'),
          (state: 'NC'; idnum: 88; county: 'Transylvania'),
          (state: 'NC'; idnum: 89; county: 'Tyrrell'),
          (state: 'NC'; idnum: 90; county: 'Union'),
          (state: 'NC'; idnum: 91; county: 'Vance'),
          (state: 'NC'; idnum: 92; county: 'Wake'),
          (state: 'NC'; idnum: 93; county: 'Warren'),
          (state: 'NC'; idnum: 94; county: 'Washington'),
          (state: 'NC'; idnum: 95; county: 'Watauga'),
          (state: 'NC'; idnum: 96; county: 'Wayne'),
          (state: 'NC'; idnum: 97; county: 'Wilkes'),
          (state: 'NC'; idnum: 98; county: 'Wilson'),
          (state: 'NC'; idnum: 99; county: 'Yadkin'),
          (state: 'NC'; idnum: 100; county: 'Yancey'),
          (state: 'ND'; idnum: 0; county: 'North Dakota'),
          (state: 'ND'; idnum: 1; county: 'Adams'),
          (state: 'ND'; idnum: 2; county: 'Barnes'),
          (state: 'ND'; idnum: 3; county: 'Benson'),
          (state: 'ND'; idnum: 4; county: 'Billings'),
          (state: 'ND'; idnum: 5; county: 'Bottineau'),
          (state: 'ND'; idnum: 6; county: 'Bowman'),
          (state: 'ND'; idnum: 7; county: 'Burke'),
          (state: 'ND'; idnum: 8; county: 'Burleigh'),
          (state: 'ND'; idnum: 9; county: 'Cass'),
          (state: 'ND'; idnum: 10; county: 'Cavalier'),
          (state: 'ND'; idnum: 11; county: 'Dickey'),
          (state: 'ND'; idnum: 12; county: 'Divide'),
          (state: 'ND'; idnum: 13; county: 'Dunn'),
          (state: 'ND'; idnum: 14; county: 'Eddy'),
          (state: 'ND'; idnum: 15; county: 'Emmons'),
          (state: 'ND'; idnum: 16; county: 'Foster'),
          (state: 'ND'; idnum: 17; county: 'Golden Valley'),
          (state: 'ND'; idnum: 18; county: 'Grand Forks'),
          (state: 'ND'; idnum: 19; county: 'Grant'),
          (state: 'ND'; idnum: 20; county: 'Griggs'),
          (state: 'ND'; idnum: 21; county: 'Hettinger'),
          (state: 'ND'; idnum: 22; county: 'Kidder'),
          (state: 'ND'; idnum: 23; county: 'Lamoure'),
          (state: 'ND'; idnum: 24; county: 'Logan'),
          (state: 'ND'; idnum: 25; county: 'McHenry'),
          (state: 'ND'; idnum: 26; county: 'McIntosh'),
          (state: 'ND'; idnum: 27; county: 'McKenzie'),
          (state: 'ND'; idnum: 28; county: 'McLean'),
          (state: 'ND'; idnum: 29; county: 'Mercer'),
          (state: 'ND'; idnum: 30; county: 'Morton'),
          (state: 'ND'; idnum: 31; county: 'Mountrail'),
          (state: 'ND'; idnum: 32; county: 'Nelson'),
          (state: 'ND'; idnum: 33; county: 'Oliver'),
          (state: 'ND'; idnum: 34; county: 'Pembina'),
          (state: 'ND'; idnum: 35; county: 'Pierce'),
          (state: 'ND'; idnum: 36; county: 'Ramsey'),
          (state: 'ND'; idnum: 37; county: 'Ransom'),
          (state: 'ND'; idnum: 38; county: 'Renville'),
          (state: 'ND'; idnum: 39; county: 'Richland'),
          (state: 'ND'; idnum: 40; county: 'Rolette'),
          (state: 'ND'; idnum: 41; county: 'Sargent'),
          (state: 'ND'; idnum: 42; county: 'Sheridan'),
          (state: 'ND'; idnum: 43; county: 'Sioux'),
          (state: 'ND'; idnum: 44; county: 'Slope'),
          (state: 'ND'; idnum: 45; county: 'Stark'),
          (state: 'ND'; idnum: 46; county: 'Steele'),
          (state: 'ND'; idnum: 47; county: 'Stutsman'),
          (state: 'ND'; idnum: 48; county: 'Towner'),
          (state: 'ND'; idnum: 49; county: 'Traill'),
          (state: 'ND'; idnum: 50; county: 'Walsh'),
          (state: 'ND'; idnum: 51; county: 'Ward'),
          (state: 'ND'; idnum: 52; county: 'Wells'),
          (state: 'ND'; idnum: 53; county: 'Williams'),
          (state: 'NE'; idnum: 0; county: 'Nebraska'),
          (state: 'NE'; idnum: 1; county: 'Adams'),
          (state: 'NE'; idnum: 2; county: 'Antelope'),
          (state: 'NE'; idnum: 3; county: 'Arthur'),
          (state: 'NE'; idnum: 4; county: 'Banner'),
          (state: 'NE'; idnum: 5; county: 'Blaine'),
          (state: 'NE'; idnum: 6; county: 'Boone'),
          (state: 'NE'; idnum: 7; county: 'Box Butte'),
          (state: 'NE'; idnum: 8; county: 'Boyd'),
          (state: 'NE'; idnum: 9; county: 'Brown'),
          (state: 'NE'; idnum: 10; county: 'Buffalo'),
          (state: 'NE'; idnum: 11; county: 'Burt'),
          (state: 'NE'; idnum: 12; county: 'Butler'),
          (state: 'NE'; idnum: 13; county: 'Cass'),
          (state: 'NE'; idnum: 14; county: 'Cedar'),
          (state: 'NE'; idnum: 15; county: 'Chase'),
          (state: 'NE'; idnum: 16; county: 'Cherry'),
          (state: 'NE'; idnum: 17; county: 'Cheyenne'),
          (state: 'NE'; idnum: 18; county: 'Clay'),
          (state: 'NE'; idnum: 19; county: 'Colfax'),
          (state: 'NE'; idnum: 20; county: 'Cuming'),
          (state: 'NE'; idnum: 21; county: 'Custer'),
          (state: 'NE'; idnum: 22; county: 'Dakota'),
          (state: 'NE'; idnum: 23; county: 'Dawes'),
          (state: 'NE'; idnum: 24; county: 'Dawson'),
          (state: 'NE'; idnum: 25; county: 'Deuel'),
          (state: 'NE'; idnum: 26; county: 'Dixon'),
          (state: 'NE'; idnum: 27; county: 'Dodge'),
          (state: 'NE'; idnum: 28; county: 'Douglas'),
          (state: 'NE'; idnum: 29; county: 'Dundy'),
          (state: 'NE'; idnum: 30; county: 'Fillmore'),
          (state: 'NE'; idnum: 31; county: 'Franklin'),
          (state: 'NE'; idnum: 32; county: 'Frontier'),
          (state: 'NE'; idnum: 33; county: 'Furnas'),
          (state: 'NE'; idnum: 34; county: 'Gage'),
          (state: 'NE'; idnum: 35; county: 'Garden'),
          (state: 'NE'; idnum: 36; county: 'Garfield'),
          (state: 'NE'; idnum: 37; county: 'Gosper'),
          (state: 'NE'; idnum: 38; county: 'Grant'),
          (state: 'NE'; idnum: 39; county: 'Greeley'),
          (state: 'NE'; idnum: 40; county: 'Hall'),
          (state: 'NE'; idnum: 41; county: 'Hamilton'),
          (state: 'NE'; idnum: 42; county: 'Harlan'),
          (state: 'NE'; idnum: 43; county: 'Hayes'),
          (state: 'NE'; idnum: 44; county: 'Hitchcock'),
          (state: 'NE'; idnum: 45; county: 'Holt'),
          (state: 'NE'; idnum: 46; county: 'Hooker'),
          (state: 'NE'; idnum: 47; county: 'Howard'),
          (state: 'NE'; idnum: 48; county: 'Jefferson'),
          (state: 'NE'; idnum: 49; county: 'Johnson'),
          (state: 'NE'; idnum: 50; county: 'Kearney'),
          (state: 'NE'; idnum: 51; county: 'Keith'),
          (state: 'NE'; idnum: 52; county: 'Keya Paha'),
          (state: 'NE'; idnum: 53; county: 'Kimball'),
          (state: 'NE'; idnum: 54; county: 'Knox'),
          (state: 'NE'; idnum: 55; county: 'Lancaster'),
          (state: 'NE'; idnum: 56; county: 'Lincoln'),
          (state: 'NE'; idnum: 57; county: 'Logan'),
          (state: 'NE'; idnum: 58; county: 'Loup'),
          (state: 'NE'; idnum: 59; county: 'Madison'),
          (state: 'NE'; idnum: 60; county: 'McPherson'),
          (state: 'NE'; idnum: 61; county: 'Merrick'),
          (state: 'NE'; idnum: 62; county: 'Morrill'),
          (state: 'NE'; idnum: 63; county: 'Nance'),
          (state: 'NE'; idnum: 64; county: 'Nemaha'),
          (state: 'NE'; idnum: 65; county: 'Nuckolls'),
          (state: 'NE'; idnum: 66; county: 'Otoe'),
          (state: 'NE'; idnum: 67; county: 'Pawnee'),
          (state: 'NE'; idnum: 68; county: 'Perkins'),
          (state: 'NE'; idnum: 69; county: 'Phelps'),
          (state: 'NE'; idnum: 70; county: 'Pierce'),
          (state: 'NE'; idnum: 71; county: 'Platte'),
          (state: 'NE'; idnum: 72; county: 'Polk'),
          (state: 'NE'; idnum: 73; county: 'Red Willow'),
          (state: 'NE'; idnum: 74; county: 'Richardson'),
          (state: 'NE'; idnum: 75; county: 'Rock'),
          (state: 'NE'; idnum: 76; county: 'Saline'),
          (state: 'NE'; idnum: 77; county: 'Sarpy'),
          (state: 'NE'; idnum: 78; county: 'Saunders'),
          (state: 'NE'; idnum: 79; county: 'Scotts Bluff'),
          (state: 'NE'; idnum: 80; county: 'Seward'),
          (state: 'NE'; idnum: 81; county: 'Sheridan'),
          (state: 'NE'; idnum: 82; county: 'Sherman'),
          (state: 'NE'; idnum: 83; county: 'Sioux'),
          (state: 'NE'; idnum: 84; county: 'Stanton'),
          (state: 'NE'; idnum: 85; county: 'Thayer'),
          (state: 'NE'; idnum: 86; county: 'Thomas'),
          (state: 'NE'; idnum: 87; county: 'Thurston'),
          (state: 'NE'; idnum: 88; county: 'Valley'),
          (state: 'NE'; idnum: 89; county: 'Washington'),
          (state: 'NE'; idnum: 90; county: 'Wayne'),
          (state: 'NE'; idnum: 91; county: 'Webster'),
          (state: 'NE'; idnum: 92; county: 'Wheeler'),
          (state: 'NE'; idnum: 93; county: 'York'),
          (state: 'NH'; idnum: 0; county: 'New Hampshire'),
          (state: 'NH'; idnum: 1; county: 'Belknap'),
          (state: 'NH'; idnum: 2; county: 'Carroll'),
          (state: 'NH'; idnum: 3; county: 'Cheshire'),
          (state: 'NH'; idnum: 4; county: 'Coos'),
          (state: 'NH'; idnum: 5; county: 'Grafton'),
          (state: 'NH'; idnum: 6; county: 'Hillsborough'),
          (state: 'NH'; idnum: 7; county: 'Merrimack'),
          (state: 'NH'; idnum: 8; county: 'Rockingham'),
          (state: 'NH'; idnum: 9; county: 'Strafford'),
          (state: 'NH'; idnum: 10; county: 'Sullivan'),
          (state: 'NJ'; idnum: 0; county: 'New Jersey'),
          (state: 'NJ'; idnum: 1; county: 'Atlantic'),
          (state: 'NJ'; idnum: 2; county: 'Bergen'),
          (state: 'NJ'; idnum: 3; county: 'Burlington'),
          (state: 'NJ'; idnum: 4; county: 'Camden'),
          (state: 'NJ'; idnum: 5; county: 'Cape May'),
          (state: 'NJ'; idnum: 6; county: 'Cumberland'),
          (state: 'NJ'; idnum: 7; county: 'Essex'),
          (state: 'NJ'; idnum: 8; county: 'Gloucester'),
          (state: 'NJ'; idnum: 9; county: 'Hudson'),
          (state: 'NJ'; idnum: 10; county: 'Hunterdon'),
          (state: 'NJ'; idnum: 11; county: 'Mercer'),
          (state: 'NJ'; idnum: 12; county: 'Middlesex'),
          (state: 'NJ'; idnum: 13; county: 'Monmouth'),
          (state: 'NJ'; idnum: 14; county: 'Morris'),
          (state: 'NJ'; idnum: 15; county: 'Ocean'),
          (state: 'NJ'; idnum: 16; county: 'Passaic'),
          (state: 'NJ'; idnum: 17; county: 'Salem'),
          (state: 'NJ'; idnum: 18; county: 'Somerset'),
          (state: 'NJ'; idnum: 19; county: 'Sussex'),
          (state: 'NJ'; idnum: 20; county: 'Union'),
          (state: 'NJ'; idnum: 21; county: 'Warren'),
          (state: 'NM'; idnum: 0; county: 'New Mexico'),
          (state: 'NM'; idnum: 1; county: 'Bernalillo'),
          (state: 'NM'; idnum: 2; county: 'Catron'),
          (state: 'NM'; idnum: 3; county: 'Chaves'),
          (state: 'NM'; idnum: 4; county: 'Cibola'),
          (state: 'NM'; idnum: 5; county: 'Colfax'),
          (state: 'NM'; idnum: 6; county: 'Curry'),
          (state: 'NM'; idnum: 7; county: 'Debaca'),
          (state: 'NM'; idnum: 8; county: 'Dona Ana'),
          (state: 'NM'; idnum: 9; county: 'Eddy'),
          (state: 'NM'; idnum: 10; county: 'Grant'),
          (state: 'NM'; idnum: 11; county: 'Guadalupe'),
          (state: 'NM'; idnum: 12; county: 'Harding'),
          (state: 'NM'; idnum: 13; county: 'Hidalgo'),
          (state: 'NM'; idnum: 14; county: 'Lea'),
          (state: 'NM'; idnum: 15; county: 'Lincoln'),
          (state: 'NM'; idnum: 16; county: 'Los Alamos'),
          (state: 'NM'; idnum: 17; county: 'Luna'),
          (state: 'NM'; idnum: 18; county: 'McKinley'),
          (state: 'NM'; idnum: 19; county: 'Mora'),
          (state: 'NM'; idnum: 20; county: 'Otero'),
          (state: 'NM'; idnum: 21; county: 'Quay'),
          (state: 'NM'; idnum: 22; county: 'Rio Arriba'),
          (state: 'NM'; idnum: 23; county: 'Roosevelt'),
          (state: 'NM'; idnum: 24; county: 'San Juan'),
          (state: 'NM'; idnum: 25; county: 'San Miguel'),
          (state: 'NM'; idnum: 26; county: 'Sandoval'),
          (state: 'NM'; idnum: 27; county: 'Santa Fe'),
          (state: 'NM'; idnum: 28; county: 'Sierra'),
          (state: 'NM'; idnum: 29; county: 'Socorro'),
          (state: 'NM'; idnum: 30; county: 'Taos'),
          (state: 'NM'; idnum: 31; county: 'Torrance'),
          (state: 'NM'; idnum: 32; county: 'Union'),
          (state: 'NM'; idnum: 33; county: 'Valencia'),
          (state: 'NV'; idnum: 0; county: 'Nevada'),
          (state: 'NV'; idnum: 1; county: 'Churchill'),
          (state: 'NV'; idnum: 2; county: 'Clark'),
          (state: 'NV'; idnum: 3; county: 'Douglas'),
          (state: 'NV'; idnum: 4; county: 'Elko'),
          (state: 'NV'; idnum: 5; county: 'Esmeralda'),
          (state: 'NV'; idnum: 6; county: 'Eureka'),
          (state: 'NV'; idnum: 7; county: 'Humboldt'),
          (state: 'NV'; idnum: 8; county: 'Lander'),
          (state: 'NV'; idnum: 9; county: 'Lincoln'),
          (state: 'NV'; idnum: 10; county: 'Lyon'),
          (state: 'NV'; idnum: 11; county: 'Mineral'),
          (state: 'NV'; idnum: 12; county: 'Nye'),
          (state: 'NV'; idnum: 13; county: 'Pershing'),
          (state: 'NV'; idnum: 14; county: 'Storey'),
          (state: 'NV'; idnum: 15; county: 'Washoe'),
          (state: 'NV'; idnum: 16; county: 'White Pine'),
          (state: 'NY'; idnum: 0; county: 'New York'),
          (state: 'NY'; idnum: 1; county: 'Albany'),
          (state: 'NY'; idnum: 2; county: 'Allegany'),
          (state: 'NY'; idnum: 3; county: 'Bronx'),
          (state: 'NY'; idnum: 4; county: 'Broome'),
          (state: 'NY'; idnum: 5; county: 'Cattaraugus'),
          (state: 'NY'; idnum: 6; county: 'Cayuga'),
          (state: 'NY'; idnum: 7; county: 'Chautauqua'),
          (state: 'NY'; idnum: 8; county: 'Chemung'),
          (state: 'NY'; idnum: 9; county: 'Chenango'),
          (state: 'NY'; idnum: 10; county: 'Clinton'),
          (state: 'NY'; idnum: 11; county: 'Columbia'),
          (state: 'NY'; idnum: 12; county: 'Cortland'),
          (state: 'NY'; idnum: 13; county: 'Delaware'),
          (state: 'NY'; idnum: 14; county: 'Dutchess'),
          (state: 'NY'; idnum: 15; county: 'Erie'),
          (state: 'NY'; idnum: 16; county: 'Essex'),
          (state: 'NY'; idnum: 17; county: 'Franklin'),
          (state: 'NY'; idnum: 18; county: 'Fulton'),
          (state: 'NY'; idnum: 19; county: 'Genesee'),
          (state: 'NY'; idnum: 20; county: 'Greene'),
          (state: 'NY'; idnum: 21; county: 'Hamilton'),
          (state: 'NY'; idnum: 22; county: 'Herkimer'),
          (state: 'NY'; idnum: 23; county: 'Jefferson'),
          (state: 'NY'; idnum: 24; county: 'Kings'),
          (state: 'NY'; idnum: 25; county: 'Lewis'),
          (state: 'NY'; idnum: 26; county: 'Livingston'),
          (state: 'NY'; idnum: 27; county: 'Madison'),
          (state: 'NY'; idnum: 28; county: 'Monroe'),
          (state: 'NY'; idnum: 29; county: 'Montgomery'),
          (state: 'NY'; idnum: 30; county: 'Nassau'),
          (state: 'NY'; idnum: 31; county: 'New York'),
          (state: 'NY'; idnum: 32; county: 'Niagara'),
          (state: 'NY'; idnum: 33; county: 'Oneida'),
          (state: 'NY'; idnum: 34; county: 'Onondaga'),
          (state: 'NY'; idnum: 35; county: 'Ontario'),
          (state: 'NY'; idnum: 36; county: 'Orange'),
          (state: 'NY'; idnum: 37; county: 'Orleans'),
          (state: 'NY'; idnum: 38; county: 'Oswego'),
          (state: 'NY'; idnum: 39; county: 'Otsego'),
          (state: 'NY'; idnum: 40; county: 'Putnam'),
          (state: 'NY'; idnum: 41; county: 'Queens'),
          (state: 'NY'; idnum: 42; county: 'Rensselaer'),
          (state: 'NY'; idnum: 43; county: 'Richmond'),
          (state: 'NY'; idnum: 44; county: 'Rockland'),
          (state: 'NY'; idnum: 45; county: 'Saratoga'),
          (state: 'NY'; idnum: 46; county: 'Schenectady'),
          (state: 'NY'; idnum: 47; county: 'Schoharie'),
          (state: 'NY'; idnum: 48; county: 'Schuyler'),
          (state: 'NY'; idnum: 49; county: 'Senecca'),
          (state: 'NY'; idnum: 50; county: 'St. Lawrence'),
          (state: 'NY'; idnum: 51; county: 'Steuben'),
          (state: 'NY'; idnum: 52; county: 'Suffolk'),
          (state: 'NY'; idnum: 53; county: 'Sullivan'),
          (state: 'NY'; idnum: 54; county: 'Tioga'),
          (state: 'NY'; idnum: 55; county: 'Tompkins'),
          (state: 'NY'; idnum: 56; county: 'Ulster'),
          (state: 'NY'; idnum: 57; county: 'Warren'),
          (state: 'NY'; idnum: 58; county: 'Washington'),
          (state: 'NY'; idnum: 59; county: 'Wayne'),
          (state: 'NY'; idnum: 60; county: 'Westchester'),
          (state: 'NY'; idnum: 61; county: 'Wyoming'),
          (state: 'NY'; idnum: 62; county: 'Yates'),
          (state: 'OH'; idnum: 0; county: 'Ohio'),
          (state: 'OH'; idnum: 1; county: 'Adams'),
          (state: 'OH'; idnum: 2; county: 'Allen'),
          (state: 'OH'; idnum: 3; county: 'Ashland'),
          (state: 'OH'; idnum: 4; county: 'Ashtabula'),
          (state: 'OH'; idnum: 5; county: 'Athens'),
          (state: 'OH'; idnum: 6; county: 'Auglaize'),
          (state: 'OH'; idnum: 7; county: 'Belmont'),
          (state: 'OH'; idnum: 8; county: 'Brown'),
          (state: 'OH'; idnum: 9; county: 'Butler'),
          (state: 'OH'; idnum: 10; county: 'Carroll'),
          (state: 'OH'; idnum: 11; county: 'Champaign'),
          (state: 'OH'; idnum: 12; county: 'Clark'),
          (state: 'OH'; idnum: 13; county: 'Clermont'),
          (state: 'OH'; idnum: 14; county: 'Clinton'),
          (state: 'OH'; idnum: 15; county: 'Columbiana'),
          (state: 'OH'; idnum: 16; county: 'Coshocton'),
          (state: 'OH'; idnum: 17; county: 'Crawford'),
          (state: 'OH'; idnum: 18; county: 'Cuyahoga'),
          (state: 'OH'; idnum: 19; county: 'Darke'),
          (state: 'OH'; idnum: 20; county: 'Defiance'),
          (state: 'OH'; idnum: 21; county: 'Delaware'),
          (state: 'OH'; idnum: 22; county: 'Erie'),
          (state: 'OH'; idnum: 23; county: 'Fairfield'),
          (state: 'OH'; idnum: 24; county: 'Fayette'),
          (state: 'OH'; idnum: 25; county: 'Franklin'),
          (state: 'OH'; idnum: 26; county: 'Fulton'),
          (state: 'OH'; idnum: 27; county: 'Gallia'),
          (state: 'OH'; idnum: 28; county: 'Geauga'),
          (state: 'OH'; idnum: 29; county: 'Greene'),
          (state: 'OH'; idnum: 30; county: 'Guernsey'),
          (state: 'OH'; idnum: 31; county: 'Hamilton'),
          (state: 'OH'; idnum: 32; county: 'Hancock'),
          (state: 'OH'; idnum: 33; county: 'Hardin'),
          (state: 'OH'; idnum: 34; county: 'Harrison'),
          (state: 'OH'; idnum: 35; county: 'Henry'),
          (state: 'OH'; idnum: 36; county: 'Highland'),
          (state: 'OH'; idnum: 37; county: 'Hocking'),
          (state: 'OH'; idnum: 38; county: 'Holmes'),
          (state: 'OH'; idnum: 39; county: 'Huron'),
          (state: 'OH'; idnum: 40; county: 'Jackson'),
          (state: 'OH'; idnum: 41; county: 'Jefferson'),
          (state: 'OH'; idnum: 42; county: 'Knox'),
          (state: 'OH'; idnum: 43; county: 'Lake'),
          (state: 'OH'; idnum: 44; county: 'Lawrence'),
          (state: 'OH'; idnum: 45; county: 'Licking'),
          (state: 'OH'; idnum: 46; county: 'Logan'),
          (state: 'OH'; idnum: 47; county: 'Lorain'),
          (state: 'OH'; idnum: 48; county: 'Lucas'),
          (state: 'OH'; idnum: 49; county: 'Madison'),
          (state: 'OH'; idnum: 50; county: 'Mahoning'),
          (state: 'OH'; idnum: 51; county: 'Marion'),
          (state: 'OH'; idnum: 52; county: 'Medina'),
          (state: 'OH'; idnum: 53; county: 'Meigs'),
          (state: 'OH'; idnum: 54; county: 'Mercer'),
          (state: 'OH'; idnum: 55; county: 'Miami'),
          (state: 'OH'; idnum: 56; county: 'Monroe'),
          (state: 'OH'; idnum: 57; county: 'Montgomery'),
          (state: 'OH'; idnum: 58; county: 'Morgan'),
          (state: 'OH'; idnum: 59; county: 'Morrow'),
          (state: 'OH'; idnum: 60; county: 'Muskingum'),
          (state: 'OH'; idnum: 61; county: 'Noble'),
          (state: 'OH'; idnum: 62; county: 'Ottawa'),
          (state: 'OH'; idnum: 63; county: 'Paulding'),
          (state: 'OH'; idnum: 64; county: 'Perry'),
          (state: 'OH'; idnum: 65; county: 'Pickaway'),
          (state: 'OH'; idnum: 66; county: 'Pike'),
          (state: 'OH'; idnum: 67; county: 'Portage'),
          (state: 'OH'; idnum: 68; county: 'Preble'),
          (state: 'OH'; idnum: 69; county: 'Putnam'),
          (state: 'OH'; idnum: 70; county: 'Richland'),
          (state: 'OH'; idnum: 71; county: 'Ross'),
          (state: 'OH'; idnum: 72; county: 'Sandusky'),
          (state: 'OH'; idnum: 73; county: 'Scioto'),
          (state: 'OH'; idnum: 74; county: 'Seneca'),
          (state: 'OH'; idnum: 75; county: 'Shelby'),
          (state: 'OH'; idnum: 76; county: 'Stark'),
          (state: 'OH'; idnum: 77; county: 'Summit'),
          (state: 'OH'; idnum: 78; county: 'Trumbull'),
          (state: 'OH'; idnum: 79; county: 'Tuscarawas'),
          (state: 'OH'; idnum: 80; county: 'Union'),
          (state: 'OH'; idnum: 81; county: 'Van Wert'),
          (state: 'OH'; idnum: 82; county: 'Vinton'),
          (state: 'OH'; idnum: 83; county: 'Warren'),
          (state: 'OH'; idnum: 84; county: 'Washington'),
          (state: 'OH'; idnum: 85; county: 'Wayne'),
          (state: 'OH'; idnum: 86; county: 'Williams'),
          (state: 'OH'; idnum: 87; county: 'Wood'),
          (state: 'OH'; idnum: 88; county: 'Wyandot'),
          (state: 'OK'; idnum: 0; county: 'Oklahoma'),
          (state: 'OK'; idnum: 1; county: 'Adair'),
          (state: 'OK'; idnum: 2; county: 'Alfalfa'),
          (state: 'OK'; idnum: 3; county: 'Atoka'),
          (state: 'OK'; idnum: 4; county: 'Beaver'),
          (state: 'OK'; idnum: 5; county: 'Beckham'),
          (state: 'OK'; idnum: 6; county: 'Blaine'),
          (state: 'OK'; idnum: 7; county: 'Bryan'),
          (state: 'OK'; idnum: 8; county: 'Caddo'),
          (state: 'OK'; idnum: 9; county: 'Canadian'),
          (state: 'OK'; idnum: 10; county: 'Carter'),
          (state: 'OK'; idnum: 11; county: 'Cherokee'),
          (state: 'OK'; idnum: 12; county: 'Choctaw'),
          (state: 'OK'; idnum: 13; county: 'Cimarron'),
          (state: 'OK'; idnum: 14; county: 'Cleveland'),
          (state: 'OK'; idnum: 15; county: 'Coal'),
          (state: 'OK'; idnum: 16; county: 'Comanche'),
          (state: 'OK'; idnum: 17; county: 'Cotton'),
          (state: 'OK'; idnum: 18; county: 'Craig'),
          (state: 'OK'; idnum: 19; county: 'Creek'),
          (state: 'OK'; idnum: 20; county: 'Custer'),
          (state: 'OK'; idnum: 21; county: 'Delaware'),
          (state: 'OK'; idnum: 22; county: 'Dewey'),
          (state: 'OK'; idnum: 23; county: 'Ellis'),
          (state: 'OK'; idnum: 24; county: 'Garfield'),
          (state: 'OK'; idnum: 25; county: 'Garvin'),
          (state: 'OK'; idnum: 26; county: 'Grady'),
          (state: 'OK'; idnum: 27; county: 'Grant'),
          (state: 'OK'; idnum: 28; county: 'Greer'),
          (state: 'OK'; idnum: 29; county: 'Harmon'),
          (state: 'OK'; idnum: 30; county: 'Harper'),
          (state: 'OK'; idnum: 31; county: 'Haskell'),
          (state: 'OK'; idnum: 32; county: 'Hughes'),
          (state: 'OK'; idnum: 33; county: 'Jackson'),
          (state: 'OK'; idnum: 34; county: 'Jefferson'),
          (state: 'OK'; idnum: 35; county: 'Johnston'),
          (state: 'OK'; idnum: 36; county: 'Kay'),
          (state: 'OK'; idnum: 37; county: 'Kingfisher'),
          (state: 'OK'; idnum: 38; county: 'Kiowa'),
          (state: 'OK'; idnum: 39; county: 'Latimer'),
          (state: 'OK'; idnum: 40; county: 'Le Flore'),
          (state: 'OK'; idnum: 41; county: 'Lincoln'),
          (state: 'OK'; idnum: 42; county: 'Logan'),
          (state: 'OK'; idnum: 43; county: 'Love'),
          (state: 'OK'; idnum: 44; county: 'Major'),
          (state: 'OK'; idnum: 45; county: 'Marshall'),
          (state: 'OK'; idnum: 46; county: 'Mayes'),
          (state: 'OK'; idnum: 47; county: 'McClain'),
          (state: 'OK'; idnum: 48; county: 'McCurtain'),
          (state: 'OK'; idnum: 49; county: 'McIntosh'),
          (state: 'OK'; idnum: 50; county: 'Murray'),
          (state: 'OK'; idnum: 51; county: 'Muskogee'),
          (state: 'OK'; idnum: 52; county: 'Noble'),
          (state: 'OK'; idnum: 53; county: 'Nowata'),
          (state: 'OK'; idnum: 54; county: 'Okfuskee'),
          (state: 'OK'; idnum: 55; county: 'Oklahoma'),
          (state: 'OK'; idnum: 56; county: 'Okmulgee'),
          (state: 'OK'; idnum: 57; county: 'Osage'),
          (state: 'OK'; idnum: 58; county: 'Ottawa'),
          (state: 'OK'; idnum: 59; county: 'Pawnee'),
          (state: 'OK'; idnum: 60; county: 'Payne'),
          (state: 'OK'; idnum: 61; county: 'Pittsburg'),
          (state: 'OK'; idnum: 62; county: 'Pontotoc'),
          (state: 'OK'; idnum: 63; county: 'Pottawatomie'),
          (state: 'OK'; idnum: 64; county: 'Pushmataha'),
          (state: 'OK'; idnum: 65; county: 'Roger Mills'),
          (state: 'OK'; idnum: 66; county: 'Rogers'),
          (state: 'OK'; idnum: 67; county: 'Seminole'),
          (state: 'OK'; idnum: 68; county: 'Sequoyah'),
          (state: 'OK'; idnum: 69; county: 'Stephens'),
          (state: 'OK'; idnum: 70; county: 'Texas'),
          (state: 'OK'; idnum: 71; county: 'Tillman'),
          (state: 'OK'; idnum: 72; county: 'Tulsa'),
          (state: 'OK'; idnum: 73; county: 'Wagoner'),
          (state: 'OK'; idnum: 74; county: 'Washington'),
          (state: 'OK'; idnum: 75; county: 'Washita'),
          (state: 'OK'; idnum: 76; county: 'Woods'),
          (state: 'OK'; idnum: 77; county: 'Woodward'),
          (state: 'OR'; idnum: 0; county: 'Oregon'),
          (state: 'OR'; idnum: 1; county: 'Baker'),
          (state: 'OR'; idnum: 2; county: 'Benton'),
          (state: 'OR'; idnum: 3; county: 'Clackamas'),
          (state: 'OR'; idnum: 4; county: 'Clatsop'),
          (state: 'OR'; idnum: 5; county: 'Columbia'),
          (state: 'OR'; idnum: 6; county: 'Coos'),
          (state: 'OR'; idnum: 7; county: 'Crook'),
          (state: 'OR'; idnum: 8; county: 'Curry'),
          (state: 'OR'; idnum: 9; county: 'Deschutes'),
          (state: 'OR'; idnum: 10; county: 'Douglas'),
          (state: 'OR'; idnum: 11; county: 'Gilliam'),
          (state: 'OR'; idnum: 12; county: 'Grant'),
          (state: 'OR'; idnum: 13; county: 'Harney'),
          (state: 'OR'; idnum: 14; county: 'Hood River'),
          (state: 'OR'; idnum: 15; county: 'Jackson'),
          (state: 'OR'; idnum: 16; county: 'Jefferson'),
          (state: 'OR'; idnum: 17; county: 'Josephine'),
          (state: 'OR'; idnum: 18; county: 'Klamath'),
          (state: 'OR'; idnum: 19; county: 'Lake'),
          (state: 'OR'; idnum: 20; county: 'Lane'),
          (state: 'OR'; idnum: 21; county: 'Lincoln'),
          (state: 'OR'; idnum: 22; county: 'Linn'),
          (state: 'OR'; idnum: 23; county: 'Malheur'),
          (state: 'OR'; idnum: 24; county: 'Marion'),
          (state: 'OR'; idnum: 25; county: 'Morrow'),
          (state: 'OR'; idnum: 26; county: 'Multnomah'),
          (state: 'OR'; idnum: 27; county: 'Polk'),
          (state: 'OR'; idnum: 28; county: 'Sherman'),
          (state: 'OR'; idnum: 29; county: 'Tillamook'),
          (state: 'OR'; idnum: 30; county: 'Umatilla'),
          (state: 'OR'; idnum: 31; county: 'Union'),
          (state: 'OR'; idnum: 32; county: 'Wallowa'),
          (state: 'OR'; idnum: 33; county: 'Wasco'),
          (state: 'OR'; idnum: 34; county: 'Washington'),
          (state: 'OR'; idnum: 35; county: 'Wheeler'),
          (state: 'OR'; idnum: 36; county: 'Yamhill'),
          (state: 'PA'; idnum: 0; county: 'Pennsylvania'),
          (state: 'PA'; idnum: 1; county: 'Adams'),
          (state: 'PA'; idnum: 2; county: 'Allegheny'),
          (state: 'PA'; idnum: 3; county: 'Armstrong'),
          (state: 'PA'; idnum: 4; county: 'Beaver'),
          (state: 'PA'; idnum: 5; county: 'Bedford'),
          (state: 'PA'; idnum: 6; county: 'Berks'),
          (state: 'PA'; idnum: 7; county: 'Blair'),
          (state: 'PA'; idnum: 8; county: 'Bradford'),
          (state: 'PA'; idnum: 9; county: 'Bucks'),
          (state: 'PA'; idnum: 10; county: 'Butler'),
          (state: 'PA'; idnum: 11; county: 'Cambria'),
          (state: 'PA'; idnum: 12; county: 'Cameron'),
          (state: 'PA'; idnum: 13; county: 'Carbon'),
          (state: 'PA'; idnum: 14; county: 'Centre'),
          (state: 'PA'; idnum: 15; county: 'Chester'),
          (state: 'PA'; idnum: 16; county: 'Clarion'),
          (state: 'PA'; idnum: 17; county: 'Clearfield'),
          (state: 'PA'; idnum: 18; county: 'Clinton'),
          (state: 'PA'; idnum: 19; county: 'Columbia'),
          (state: 'PA'; idnum: 20; county: 'Crawford'),
          (state: 'PA'; idnum: 21; county: 'Cumberland'),
          (state: 'PA'; idnum: 22; county: 'Dauphin'),
          (state: 'PA'; idnum: 23; county: 'Delaware'),
          (state: 'PA'; idnum: 24; county: 'Elk'),
          (state: 'PA'; idnum: 25; county: 'Erie'),
          (state: 'PA'; idnum: 26; county: 'Fayette'),
          (state: 'PA'; idnum: 27; county: 'Forest'),
          (state: 'PA'; idnum: 28; county: 'Franklin'),
          (state: 'PA'; idnum: 29; county: 'Fulton'),
          (state: 'PA'; idnum: 30; county: 'Greene'),
          (state: 'PA'; idnum: 31; county: 'Huntingdon'),
          (state: 'PA'; idnum: 32; county: 'Indiana'),
          (state: 'PA'; idnum: 33; county: 'Jefferson'),
          (state: 'PA'; idnum: 34; county: 'Juniata'),
          (state: 'PA'; idnum: 35; county: 'Lackawanna'),
          (state: 'PA'; idnum: 36; county: 'Lancaster'),
          (state: 'PA'; idnum: 37; county: 'Lawrence'),
          (state: 'PA'; idnum: 38; county: 'Lebanon'),
          (state: 'PA'; idnum: 39; county: 'Lehigh'),
          (state: 'PA'; idnum: 40; county: 'Luzerne'),
          (state: 'PA'; idnum: 41; county: 'Lycoming'),
          (state: 'PA'; idnum: 42; county: 'McKean'),
          (state: 'PA'; idnum: 43; county: 'Mercer'),
          (state: 'PA'; idnum: 44; county: 'Mifflin'),
          (state: 'PA'; idnum: 45; county: 'Monroe'),
          (state: 'PA'; idnum: 46; county: 'Montgomery'),
          (state: 'PA'; idnum: 47; county: 'Montour'),
          (state: 'PA'; idnum: 48; county: 'Northampton'),
          (state: 'PA'; idnum: 49; county: 'Northumberland'),
          (state: 'PA'; idnum: 50; county: 'Perry'),
          (state: 'PA'; idnum: 51; county: 'Philadelphia'),
          (state: 'PA'; idnum: 52; county: 'Pike'),
          (state: 'PA'; idnum: 53; county: 'Potter'),
          (state: 'PA'; idnum: 54; county: 'Schuylkill'),
          (state: 'PA'; idnum: 55; county: 'Snyder'),
          (state: 'PA'; idnum: 56; county: 'Somerset'),
          (state: 'PA'; idnum: 57; county: 'Sullivan'),
          (state: 'PA'; idnum: 58; county: 'Susquehanna'),
          (state: 'PA'; idnum: 59; county: 'Tioga'),
          (state: 'PA'; idnum: 60; county: 'Union'),
          (state: 'PA'; idnum: 61; county: 'Venango'),
          (state: 'PA'; idnum: 62; county: 'Warren'),
          (state: 'PA'; idnum: 63; county: 'Washington'),
          (state: 'PA'; idnum: 64; county: 'Wayne'),
          (state: 'PA'; idnum: 65; county: 'Westmoreland'),
          (state: 'PA'; idnum: 66; county: 'Wyoming'),
          (state: 'PA'; idnum: 67; county: 'York'),
          (state: 'RI'; idnum: 0; county: 'Rhode Island'),
          (state: 'RI'; idnum: 1; county: 'Bristol'),
          (state: 'RI'; idnum: 2; county: 'Kent'),
          (state: 'RI'; idnum: 3; county: 'Newport'),
          (state: 'RI'; idnum: 4; county: 'Providence'),
          (state: 'RI'; idnum: 5; county: 'Washington'),
          (state: 'SC'; idnum: 0; county: 'South Carolina'),
          (state: 'SC'; idnum: 1; county: 'Abbeville'),
          (state: 'SC'; idnum: 2; county: 'Aiken'),
          (state: 'SC'; idnum: 3; county: 'Allendale'),
          (state: 'SC'; idnum: 4; county: 'Anderson'),
          (state: 'SC'; idnum: 5; county: 'Bamberg'),
          (state: 'SC'; idnum: 6; county: 'Barnwell'),
          (state: 'SC'; idnum: 7; county: 'Beaufort'),
          (state: 'SC'; idnum: 8; county: 'Berkeley'),
          (state: 'SC'; idnum: 9; county: 'Calhoun'),
          (state: 'SC'; idnum: 10; county: 'Charleston'),
          (state: 'SC'; idnum: 11; county: 'Cherokee'),
          (state: 'SC'; idnum: 12; county: 'Chester'),
          (state: 'SC'; idnum: 13; county: 'Chesterfield'),
          (state: 'SC'; idnum: 14; county: 'Clarendon'),
          (state: 'SC'; idnum: 15; county: 'Colleton'),
          (state: 'SC'; idnum: 16; county: 'Darlington'),
          (state: 'SC'; idnum: 17; county: 'Dillon'),
          (state: 'SC'; idnum: 18; county: 'Dorchester'),
          (state: 'SC'; idnum: 19; county: 'Edgefield'),
          (state: 'SC'; idnum: 20; county: 'Fairfield'),
          (state: 'SC'; idnum: 21; county: 'Florence'),
          (state: 'SC'; idnum: 22; county: 'Georgetown'),
          (state: 'SC'; idnum: 23; county: 'Greenville'),
          (state: 'SC'; idnum: 24; county: 'Greenwood'),
          (state: 'SC'; idnum: 25; county: 'Hampton'),
          (state: 'SC'; idnum: 26; county: 'Horry'),
          (state: 'SC'; idnum: 27; county: 'Jasper'),
          (state: 'SC'; idnum: 28; county: 'Kershaw'),
          (state: 'SC'; idnum: 29; county: 'Lancaster'),
          (state: 'SC'; idnum: 30; county: 'Laurens'),
          (state: 'SC'; idnum: 31; county: 'Lee'),
          (state: 'SC'; idnum: 32; county: 'Lexington'),
          (state: 'SC'; idnum: 33; county: 'Marion'),
          (state: 'SC'; idnum: 34; county: 'Marlboro'),
          (state: 'SC'; idnum: 35; county: 'McCormick'),
          (state: 'SC'; idnum: 36; county: 'Newberry'),
          (state: 'SC'; idnum: 37; county: 'Oconee'),
          (state: 'SC'; idnum: 38; county: 'Orangeburg'),
          (state: 'SC'; idnum: 39; county: 'Pickens'),
          (state: 'SC'; idnum: 40; county: 'Richland'),
          (state: 'SC'; idnum: 41; county: 'Saluda'),
          (state: 'SC'; idnum: 42; county: 'Spartanburg'),
          (state: 'SC'; idnum: 43; county: 'Sumter'),
          (state: 'SC'; idnum: 44; county: 'Union'),
          (state: 'SC'; idnum: 45; county: 'Williamsburg'),
          (state: 'SC'; idnum: 46; county: 'York'),
          (state: 'SD'; idnum: 0; county: 'South Dakota'),
          (state: 'SD'; idnum: 1; county: 'Aurora'),
          (state: 'SD'; idnum: 2; county: 'Beadle'),
          (state: 'SD'; idnum: 3; county: 'Bennett'),
          (state: 'SD'; idnum: 4; county: 'Bon Homme'),
          (state: 'SD'; idnum: 5; county: 'Brookings'),
          (state: 'SD'; idnum: 6; county: 'Brown'),
          (state: 'SD'; idnum: 7; county: 'Brule'),
          (state: 'SD'; idnum: 8; county: 'Buffalo'),
          (state: 'SD'; idnum: 9; county: 'Butte'),
          (state: 'SD'; idnum: 10; county: 'Campbell'),
          (state: 'SD'; idnum: 11; county: 'Charles Mix'),
          (state: 'SD'; idnum: 12; county: 'Clark'),
          (state: 'SD'; idnum: 13; county: 'Clay'),
          (state: 'SD'; idnum: 14; county: 'Codington'),
          (state: 'SD'; idnum: 15; county: 'Corson'),
          (state: 'SD'; idnum: 16; county: 'Custer'),
          (state: 'SD'; idnum: 17; county: 'Davison'),
          (state: 'SD'; idnum: 18; county: 'Day'),
          (state: 'SD'; idnum: 19; county: 'Deuel'),
          (state: 'SD'; idnum: 20; county: 'Dewey'),
          (state: 'SD'; idnum: 21; county: 'Douglas'),
          (state: 'SD'; idnum: 22; county: 'Edmunds'),
          (state: 'SD'; idnum: 23; county: 'Fall River'),
          (state: 'SD'; idnum: 24; county: 'Faulk'),
          (state: 'SD'; idnum: 25; county: 'Grant'),
          (state: 'SD'; idnum: 26; county: 'Gregory'),
          (state: 'SD'; idnum: 27; county: 'Haakon'),
          (state: 'SD'; idnum: 28; county: 'Hamlin'),
          (state: 'SD'; idnum: 29; county: 'Hand'),
          (state: 'SD'; idnum: 30; county: 'Hanson'),
          (state: 'SD'; idnum: 31; county: 'Harding'),
          (state: 'SD'; idnum: 32; county: 'Hughes'),
          (state: 'SD'; idnum: 33; county: 'Hutchinson'),
          (state: 'SD'; idnum: 34; county: 'Hyde'),
          (state: 'SD'; idnum: 35; county: 'Jackson'),
          (state: 'SD'; idnum: 36; county: 'Jerauld'),
          (state: 'SD'; idnum: 37; county: 'Jones'),
          (state: 'SD'; idnum: 38; county: 'Kingsbury'),
          (state: 'SD'; idnum: 39; county: 'Lake'),
          (state: 'SD'; idnum: 40; county: 'Lawrence'),
          (state: 'SD'; idnum: 41; county: 'Lincoln'),
          (state: 'SD'; idnum: 42; county: 'Lyman'),
          (state: 'SD'; idnum: 43; county: 'Marshall'),
          (state: 'SD'; idnum: 44; county: 'McCook'),
          (state: 'SD'; idnum: 45; county: 'McPherson'),
          (state: 'SD'; idnum: 46; county: 'Meade'),
          (state: 'SD'; idnum: 47; county: 'Mellette'),
          (state: 'SD'; idnum: 48; county: 'Miner'),
          (state: 'SD'; idnum: 49; county: 'Minnehaha'),
          (state: 'SD'; idnum: 50; county: 'Moody'),
          (state: 'SD'; idnum: 51; county: 'Pennington'),
          (state: 'SD'; idnum: 52; county: 'Perkins'),
          (state: 'SD'; idnum: 53; county: 'Potter'),
          (state: 'SD'; idnum: 54; county: 'Roberts'),
          (state: 'SD'; idnum: 55; county: 'Sanborn'),
          (state: 'SD'; idnum: 56; county: 'Shannon'),
          (state: 'SD'; idnum: 57; county: 'Spink'),
          (state: 'SD'; idnum: 58; county: 'Stanley'),
          (state: 'SD'; idnum: 59; county: 'Sully'),
          (state: 'SD'; idnum: 60; county: 'Todd'),
          (state: 'SD'; idnum: 61; county: 'Tripp'),
          (state: 'SD'; idnum: 62; county: 'Turner'),
          (state: 'SD'; idnum: 63; county: 'Union'),
          (state: 'SD'; idnum: 64; county: 'Walworth'),
          (state: 'SD'; idnum: 65; county: 'Yankton'),
          (state: 'SD'; idnum: 66; county: 'Ziebach'),
          (state: 'TN'; idnum: 0; county: 'Tennessee'),
          (state: 'TN'; idnum: 1; county: 'Anderson'),
          (state: 'TN'; idnum: 2; county: 'Bedford'),
          (state: 'TN'; idnum: 3; county: 'Benton'),
          (state: 'TN'; idnum: 4; county: 'Bledsoe'),
          (state: 'TN'; idnum: 5; county: 'Blount'),
          (state: 'TN'; idnum: 6; county: 'Bradley'),
          (state: 'TN'; idnum: 7; county: 'Campbell'),
          (state: 'TN'; idnum: 8; county: 'Cannon'),
          (state: 'TN'; idnum: 9; county: 'Carroll'),
          (state: 'TN'; idnum: 10; county: 'Carter'),
          (state: 'TN'; idnum: 11; county: 'Cheatham'),
          (state: 'TN'; idnum: 12; county: 'Chester'),
          (state: 'TN'; idnum: 13; county: 'Claiborne'),
          (state: 'TN'; idnum: 14; county: 'Clay'),
          (state: 'TN'; idnum: 15; county: 'Cocke'),
          (state: 'TN'; idnum: 16; county: 'Coffee'),
          (state: 'TN'; idnum: 17; county: 'Crockett'),
          (state: 'TN'; idnum: 18; county: 'Cumberland'),
          (state: 'TN'; idnum: 19; county: 'Davidson'),
          (state: 'TN'; idnum: 20; county: 'Dekalb'),
          (state: 'TN'; idnum: 21; county: 'Decatur'),
          (state: 'TN'; idnum: 22; county: 'Dickson'),
          (state: 'TN'; idnum: 23; county: 'Dyer'),
          (state: 'TN'; idnum: 24; county: 'Fayette'),
          (state: 'TN'; idnum: 25; county: 'Fentress'),
          (state: 'TN'; idnum: 26; county: 'Franklin'),
          (state: 'TN'; idnum: 27; county: 'Gibson'),
          (state: 'TN'; idnum: 28; county: 'Giles'),
          (state: 'TN'; idnum: 29; county: 'Grainger'),
          (state: 'TN'; idnum: 30; county: 'Greene'),
          (state: 'TN'; idnum: 31; county: 'Grundy'),
          (state: 'TN'; idnum: 32; county: 'Hamblen'),
          (state: 'TN'; idnum: 33; county: 'Hamilton'),
          (state: 'TN'; idnum: 34; county: 'Hancock'),
          (state: 'TN'; idnum: 35; county: 'Hardeman'),
          (state: 'TN'; idnum: 36; county: 'Hardin'),
          (state: 'TN'; idnum: 37; county: 'Hawkins'),
          (state: 'TN'; idnum: 38; county: 'Haywood'),
          (state: 'TN'; idnum: 39; county: 'Henderson'),
          (state: 'TN'; idnum: 40; county: 'Henry'),
          (state: 'TN'; idnum: 41; county: 'Hickman'),
          (state: 'TN'; idnum: 42; county: 'Houston'),
          (state: 'TN'; idnum: 43; county: 'Humphreys'),
          (state: 'TN'; idnum: 44; county: 'Jackson'),
          (state: 'TN'; idnum: 45; county: 'Jefferson'),
          (state: 'TN'; idnum: 46; county: 'Johnson'),
          (state: 'TN'; idnum: 47; county: 'Knox'),
          (state: 'TN'; idnum: 48; county: 'Lake'),
          (state: 'TN'; idnum: 49; county: 'Lauderdale'),
          (state: 'TN'; idnum: 50; county: 'Lawrence'),
          (state: 'TN'; idnum: 51; county: 'Lewis'),
          (state: 'TN'; idnum: 52; county: 'Lincoln'),
          (state: 'TN'; idnum: 53; county: 'Loudon'),
          (state: 'TN'; idnum: 54; county: 'Macon'),
          (state: 'TN'; idnum: 55; county: 'Madison'),
          (state: 'TN'; idnum: 56; county: 'Marion'),
          (state: 'TN'; idnum: 57; county: 'Marshall'),
          (state: 'TN'; idnum: 58; county: 'Maury'),
          (state: 'TN'; idnum: 59; county: 'McMinn'),
          (state: 'TN'; idnum: 60; county: 'McNairy'),
          (state: 'TN'; idnum: 61; county: 'Meigs'),
          (state: 'TN'; idnum: 62; county: 'Monroe'),
          (state: 'TN'; idnum: 63; county: 'Montgomery'),
          (state: 'TN'; idnum: 64; county: 'Moore'),
          (state: 'TN'; idnum: 65; county: 'Morgan'),
          (state: 'TN'; idnum: 66; county: 'Obion'),
          (state: 'TN'; idnum: 67; county: 'Overton'),
          (state: 'TN'; idnum: 68; county: 'Perry'),
          (state: 'TN'; idnum: 69; county: 'Pickett'),
          (state: 'TN'; idnum: 70; county: 'Polk'),
          (state: 'TN'; idnum: 71; county: 'Putnam'),
          (state: 'TN'; idnum: 72; county: 'Rhea'),
          (state: 'TN'; idnum: 73; county: 'Roane'),
          (state: 'TN'; idnum: 74; county: 'Robertson'),
          (state: 'TN'; idnum: 75; county: 'Rutherford'),
          (state: 'TN'; idnum: 76; county: 'Scott'),
          (state: 'TN'; idnum: 77; county: 'Sequatchie'),
          (state: 'TN'; idnum: 78; county: 'Sevier'),
          (state: 'TN'; idnum: 79; county: 'Shelby'),
          (state: 'TN'; idnum: 80; county: 'Smith'),
          (state: 'TN'; idnum: 81; county: 'Stewart'),
          (state: 'TN'; idnum: 82; county: 'Sullivan'),
          (state: 'TN'; idnum: 83; county: 'Sumner'),
          (state: 'TN'; idnum: 84; county: 'Tipton'),
          (state: 'TN'; idnum: 85; county: 'Trousdale'),
          (state: 'TN'; idnum: 86; county: 'Unicoi'),
          (state: 'TN'; idnum: 87; county: 'Union'),
          (state: 'TN'; idnum: 88; county: 'Van Buren'),
          (state: 'TN'; idnum: 89; county: 'Warren'),
          (state: 'TN'; idnum: 90; county: 'Washington'),
          (state: 'TN'; idnum: 91; county: 'Wayne'),
          (state: 'TN'; idnum: 92; county: 'Weakley'),
          (state: 'TN'; idnum: 93; county: 'White'),
          (state: 'TN'; idnum: 94; county: 'Williamson'),
          (state: 'TN'; idnum: 95; county: 'Wilson'),
          (state: 'TX'; idnum: 0; county: 'Texas'),
          (state: 'TX'; idnum: 1; county: 'Anderson'),
          (state: 'TX'; idnum: 2; county: 'Andrews'),
          (state: 'TX'; idnum: 3; county: 'Angelina'),
          (state: 'TX'; idnum: 4; county: 'Aransas'),
          (state: 'TX'; idnum: 5; county: 'Archer'),
          (state: 'TX'; idnum: 6; county: 'Armstrong'),
          (state: 'TX'; idnum: 7; county: 'Atascosa'),
          (state: 'TX'; idnum: 8; county: 'Austin'),
          (state: 'TX'; idnum: 9; county: 'Bailey'),
          (state: 'TX'; idnum: 10; county: 'Bandera'),
          (state: 'TX'; idnum: 11; county: 'Bastrop'),
          (state: 'TX'; idnum: 12; county: 'Baylor'),
          (state: 'TX'; idnum: 13; county: 'Bee'),
          (state: 'TX'; idnum: 14; county: 'Bell'),
          (state: 'TX'; idnum: 15; county: 'Bexar'),
          (state: 'TX'; idnum: 16; county: 'Blanco'),
          (state: 'TX'; idnum: 17; county: 'Borden'),
          (state: 'TX'; idnum: 18; county: 'Bosque'),
          (state: 'TX'; idnum: 19; county: 'Bowie'),
          (state: 'TX'; idnum: 20; county: 'Brazoria'),
          (state: 'TX'; idnum: 21; county: 'Brazos'),
          (state: 'TX'; idnum: 22; county: 'Brewster'),
          (state: 'TX'; idnum: 23; county: 'Briscoe'),
          (state: 'TX'; idnum: 24; county: 'Brooks'),
          (state: 'TX'; idnum: 25; county: 'Brown'),
          (state: 'TX'; idnum: 26; county: 'Burleson'),
          (state: 'TX'; idnum: 27; county: 'Burnet'),
          (state: 'TX'; idnum: 28; county: 'Caldwell'),
          (state: 'TX'; idnum: 29; county: 'Calhoun'),
          (state: 'TX'; idnum: 30; county: 'Callahan'),
          (state: 'TX'; idnum: 31; county: 'Cameron'),
          (state: 'TX'; idnum: 32; county: 'Camp'),
          (state: 'TX'; idnum: 33; county: 'Carson'),
          (state: 'TX'; idnum: 34; county: 'Cass'),
          (state: 'TX'; idnum: 35; county: 'Castro'),
          (state: 'TX'; idnum: 36; county: 'Chambers'),
          (state: 'TX'; idnum: 37; county: 'Cherokee'),
          (state: 'TX'; idnum: 38; county: 'Childress'),
          (state: 'TX'; idnum: 39; county: 'Clay'),
          (state: 'TX'; idnum: 40; county: 'Cochran'),
          (state: 'TX'; idnum: 41; county: 'Coke'),
          (state: 'TX'; idnum: 42; county: 'Coleman'),
          (state: 'TX'; idnum: 43; county: 'Collin'),
          (state: 'TX'; idnum: 44; county: 'Collingsworth'),
          (state: 'TX'; idnum: 45; county: 'Colorado'),
          (state: 'TX'; idnum: 46; county: 'Comal'),
          (state: 'TX'; idnum: 47; county: 'Comanche'),
          (state: 'TX'; idnum: 48; county: 'Concho'),
          (state: 'TX'; idnum: 49; county: 'Cooke'),
          (state: 'TX'; idnum: 50; county: 'Coryell'),
          (state: 'TX'; idnum: 51; county: 'Cottle'),
          (state: 'TX'; idnum: 52; county: 'Crane'),
          (state: 'TX'; idnum: 53; county: 'Crockett'),
          (state: 'TX'; idnum: 54; county: 'Crosby'),
          (state: 'TX'; idnum: 55; county: 'Culberson'),
          (state: 'TX'; idnum: 56; county: 'Dallam'),
          (state: 'TX'; idnum: 57; county: 'Dallas'),
          (state: 'TX'; idnum: 58; county: 'Dawson'),
          (state: 'TX'; idnum: 59; county: 'Dewitt'),
          (state: 'TX'; idnum: 60; county: 'Deaf Smith'),
          (state: 'TX'; idnum: 61; county: 'Delta'),
          (state: 'TX'; idnum: 62; county: 'Denton'),
          (state: 'TX'; idnum: 63; county: 'Dickens'),
          (state: 'TX'; idnum: 64; county: 'Dimmit'),
          (state: 'TX'; idnum: 65; county: 'Donley'),
          (state: 'TX'; idnum: 66; county: 'Duval'),
          (state: 'TX'; idnum: 67; county: 'Eastland'),
          (state: 'TX'; idnum: 68; county: 'Ector'),
          (state: 'TX'; idnum: 69; county: 'Edwards'),
          (state: 'TX'; idnum: 70; county: 'El Paso'),
          (state: 'TX'; idnum: 71; county: 'Ellis'),
          (state: 'TX'; idnum: 72; county: 'Erath'),
          (state: 'TX'; idnum: 73; county: 'Falls'),
          (state: 'TX'; idnum: 74; county: 'Fannin'),
          (state: 'TX'; idnum: 75; county: 'Fayette'),
          (state: 'TX'; idnum: 76; county: 'Fisher'),
          (state: 'TX'; idnum: 77; county: 'Floyd'),
          (state: 'TX'; idnum: 78; county: 'Foard'),
          (state: 'TX'; idnum: 79; county: 'Fort Bend'),
          (state: 'TX'; idnum: 80; county: 'Franklin'),
          (state: 'TX'; idnum: 81; county: 'Freestone'),
          (state: 'TX'; idnum: 82; county: 'Frio'),
          (state: 'TX'; idnum: 83; county: 'Gaines'),
          (state: 'TX'; idnum: 84; county: 'Galveston'),
          (state: 'TX'; idnum: 85; county: 'Garza'),
          (state: 'TX'; idnum: 86; county: 'Gillespie'),
          (state: 'TX'; idnum: 87; county: 'Glasscock'),
          (state: 'TX'; idnum: 88; county: 'Goliad'),
          (state: 'TX'; idnum: 89; county: 'Gonzales'),
          (state: 'TX'; idnum: 90; county: 'Gray'),
          (state: 'TX'; idnum: 91; county: 'Grayson'),
          (state: 'TX'; idnum: 92; county: 'Gregg'),
          (state: 'TX'; idnum: 93; county: 'Grimes'),
          (state: 'TX'; idnum: 94; county: 'Guadalupe'),
          (state: 'TX'; idnum: 95; county: 'Hale'),
          (state: 'TX'; idnum: 96; county: 'Hall'),
          (state: 'TX'; idnum: 97; county: 'Hamilton'),
          (state: 'TX'; idnum: 98; county: 'Hansford'),
          (state: 'TX'; idnum: 99; county: 'Hardeman'),
          (state: 'TX'; idnum: 100; county: 'Hardin'),
          (state: 'TX'; idnum: 101; county: 'Harris'),
          (state: 'TX'; idnum: 102; county: 'Harrison'),
          (state: 'TX'; idnum: 103; county: 'Hartley'),
          (state: 'TX'; idnum: 104; county: 'Haskell'),
          (state: 'TX'; idnum: 105; county: 'Hays'),
          (state: 'TX'; idnum: 106; county: 'Hemphill'),
          (state: 'TX'; idnum: 107; county: 'Henderson'),
          (state: 'TX'; idnum: 108; county: 'Hidalgo'),
          (state: 'TX'; idnum: 109; county: 'Hill'),
          (state: 'TX'; idnum: 110; county: 'Hockley'),
          (state: 'TX'; idnum: 111; county: 'Hood'),
          (state: 'TX'; idnum: 112; county: 'Hopkins'),
          (state: 'TX'; idnum: 113; county: 'Houston'),
          (state: 'TX'; idnum: 114; county: 'Howard'),
          (state: 'TX'; idnum: 115; county: 'Hudspeth'),
          (state: 'TX'; idnum: 116; county: 'Hunt'),
          (state: 'TX'; idnum: 117; county: 'Hutchinson'),
          (state: 'TX'; idnum: 118; county: 'Irion'),
          (state: 'TX'; idnum: 119; county: 'Jack'),
          (state: 'TX'; idnum: 120; county: 'Jackson'),
          (state: 'TX'; idnum: 121; county: 'Jasper'),
          (state: 'TX'; idnum: 122; county: 'Jeff Davis'),
          (state: 'TX'; idnum: 123; county: 'Jefferson'),
          (state: 'TX'; idnum: 124; county: 'Jim Hogg'),
          (state: 'TX'; idnum: 125; county: 'Jim Wells'),
          (state: 'TX'; idnum: 126; county: 'Johnson'),
          (state: 'TX'; idnum: 127; county: 'Jones'),
          (state: 'TX'; idnum: 128; county: 'Karnes'),
          (state: 'TX'; idnum: 129; county: 'Kaufman'),
          (state: 'TX'; idnum: 130; county: 'Kendall'),
          (state: 'TX'; idnum: 131; county: 'Kenedy'),
          (state: 'TX'; idnum: 132; county: 'Kent'),
          (state: 'TX'; idnum: 133; county: 'Kerr'),
          (state: 'TX'; idnum: 134; county: 'Kimble'),
          (state: 'TX'; idnum: 135; county: 'King'),
          (state: 'TX'; idnum: 136; county: 'Kinney'),
          (state: 'TX'; idnum: 137; county: 'Kleberg'),
          (state: 'TX'; idnum: 138; county: 'Knox'),
          (state: 'TX'; idnum: 139; county: 'La Salle'),
          (state: 'TX'; idnum: 140; county: 'Lamar'),
          (state: 'TX'; idnum: 141; county: 'Lamb'),
          (state: 'TX'; idnum: 142; county: 'Lampasas'),
          (state: 'TX'; idnum: 143; county: 'Lavaca'),
          (state: 'TX'; idnum: 144; county: 'Lee'),
          (state: 'TX'; idnum: 145; county: 'Leon'),
          (state: 'TX'; idnum: 146; county: 'Liberty'),
          (state: 'TX'; idnum: 147; county: 'Limestone'),
          (state: 'TX'; idnum: 148; county: 'Lipscomb'),
          (state: 'TX'; idnum: 149; county: 'Live Oak'),
          (state: 'TX'; idnum: 150; county: 'Llano'),
          (state: 'TX'; idnum: 151; county: 'Loving'),
          (state: 'TX'; idnum: 152; county: 'Lubbock'),
          (state: 'TX'; idnum: 153; county: 'Lynn'),
          (state: 'TX'; idnum: 154; county: 'Madison'),
          (state: 'TX'; idnum: 155; county: 'Marion'),
          (state: 'TX'; idnum: 156; county: 'Martin'),
          (state: 'TX'; idnum: 157; county: 'Mason'),
          (state: 'TX'; idnum: 158; county: 'Matagorda'),
          (state: 'TX'; idnum: 159; county: 'Maverick'),
          (state: 'TX'; idnum: 160; county: 'McCulloch'),
          (state: 'TX'; idnum: 161; county: 'McLennan'),
          (state: 'TX'; idnum: 162; county: 'McMullen'),
          (state: 'TX'; idnum: 163; county: 'Medina'),
          (state: 'TX'; idnum: 164; county: 'Menard'),
          (state: 'TX'; idnum: 165; county: 'Midland'),
          (state: 'TX'; idnum: 166; county: 'Milam'),
          (state: 'TX'; idnum: 167; county: 'Mills'),
          (state: 'TX'; idnum: 168; county: 'Mitchell'),
          (state: 'TX'; idnum: 169; county: 'Montague'),
          (state: 'TX'; idnum: 170; county: 'Montgomery'),
          (state: 'TX'; idnum: 171; county: 'Moore'),
          (state: 'TX'; idnum: 172; county: 'Morris'),
          (state: 'TX'; idnum: 173; county: 'Motley'),
          (state: 'TX'; idnum: 174; county: 'Nacogdoches'),
          (state: 'TX'; idnum: 175; county: 'Navarro'),
          (state: 'TX'; idnum: 176; county: 'Newton'),
          (state: 'TX'; idnum: 177; county: 'Nolan'),
          (state: 'TX'; idnum: 178; county: 'Nueces'),
          (state: 'TX'; idnum: 179; county: 'Ochiltree'),
          (state: 'TX'; idnum: 180; county: 'Oldham'),
          (state: 'TX'; idnum: 181; county: 'Orange'),
          (state: 'TX'; idnum: 182; county: 'Palo Pinto'),
          (state: 'TX'; idnum: 183; county: 'Panola'),
          (state: 'TX'; idnum: 184; county: 'Parker'),
          (state: 'TX'; idnum: 185; county: 'Parmer'),
          (state: 'TX'; idnum: 186; county: 'Pecos'),
          (state: 'TX'; idnum: 187; county: 'Polk'),
          (state: 'TX'; idnum: 188; county: 'Potter'),
          (state: 'TX'; idnum: 189; county: 'Presidio'),
          (state: 'TX'; idnum: 190; county: 'Rains'),
          (state: 'TX'; idnum: 191; county: 'Randall'),
          (state: 'TX'; idnum: 192; county: 'Reagan'),
          (state: 'TX'; idnum: 193; county: 'Real'),
          (state: 'TX'; idnum: 194; county: 'Red River'),
          (state: 'TX'; idnum: 195; county: 'Reeves'),
          (state: 'TX'; idnum: 196; county: 'Refugio'),
          (state: 'TX'; idnum: 197; county: 'Roberts'),
          (state: 'TX'; idnum: 198; county: 'Robertson'),
          (state: 'TX'; idnum: 199; county: 'Rockwall'),
          (state: 'TX'; idnum: 200; county: 'Runnels'),
          (state: 'TX'; idnum: 201; county: 'Rusk'),
          (state: 'TX'; idnum: 202; county: 'Sabine'),
          (state: 'TX'; idnum: 203; county: 'San Augustine'),
          (state: 'TX'; idnum: 204; county: 'San Jacinto'),
          (state: 'TX'; idnum: 205; county: 'San Patricio'),
          (state: 'TX'; idnum: 206; county: 'San Saba'),
          (state: 'TX'; idnum: 207; county: 'Schleicher'),
          (state: 'TX'; idnum: 208; county: 'Scurry'),
          (state: 'TX'; idnum: 209; county: 'Shackelford'),
          (state: 'TX'; idnum: 210; county: 'Shelby'),
          (state: 'TX'; idnum: 211; county: 'Sherman'),
          (state: 'TX'; idnum: 212; county: 'Smith'),
          (state: 'TX'; idnum: 213; county: 'Somervell'),
          (state: 'TX'; idnum: 214; county: 'Starr'),
          (state: 'TX'; idnum: 215; county: 'Stephens'),
          (state: 'TX'; idnum: 216; county: 'Sterling'),
          (state: 'TX'; idnum: 217; county: 'Stonewall'),
          (state: 'TX'; idnum: 218; county: 'Sutton'),
          (state: 'TX'; idnum: 219; county: 'Swisher'),
          (state: 'TX'; idnum: 220; county: 'Tarrant'),
          (state: 'TX'; idnum: 221; county: 'Taylor'),
          (state: 'TX'; idnum: 222; county: 'Terrell'),
          (state: 'TX'; idnum: 223; county: 'Terry'),
          (state: 'TX'; idnum: 224; county: 'Throckmorton'),
          (state: 'TX'; idnum: 225; county: 'Titus'),
          (state: 'TX'; idnum: 226; county: 'Tom Green'),
          (state: 'TX'; idnum: 227; county: 'Travis'),
          (state: 'TX'; idnum: 228; county: 'Trinity'),
          (state: 'TX'; idnum: 229; county: 'Tyler'),
          (state: 'TX'; idnum: 230; county: 'Upshur'),
          (state: 'TX'; idnum: 231; county: 'Upton'),
          (state: 'TX'; idnum: 232; county: 'Uvalde'),
          (state: 'TX'; idnum: 233; county: 'Val Verde'),
          (state: 'TX'; idnum: 234; county: 'Van Zandt'),
          (state: 'TX'; idnum: 235; county: 'Victoria'),
          (state: 'TX'; idnum: 236; county: 'Walker'),
          (state: 'TX'; idnum: 237; county: 'Waller'),
          (state: 'TX'; idnum: 238; county: 'Ward'),
          (state: 'TX'; idnum: 239; county: 'Washington'),
          (state: 'TX'; idnum: 240; county: 'Webb'),
          (state: 'TX'; idnum: 241; county: 'Wharton'),
          (state: 'TX'; idnum: 242; county: 'Wheeler'),
          (state: 'TX'; idnum: 243; county: 'Wichita'),
          (state: 'TX'; idnum: 244; county: 'Wilbarger'),
          (state: 'TX'; idnum: 245; county: 'Willacy'),
          (state: 'TX'; idnum: 246; county: 'Williamson'),
          (state: 'TX'; idnum: 247; county: 'Wilson'),
          (state: 'TX'; idnum: 248; county: 'Winkler'),
          (state: 'TX'; idnum: 249; county: 'Wise'),
          (state: 'TX'; idnum: 250; county: 'Wood'),
          (state: 'TX'; idnum: 251; county: 'Yoakum'),
          (state: 'TX'; idnum: 252; county: 'Young'),
          (state: 'TX'; idnum: 253; county: 'Zapata'),
          (state: 'TX'; idnum: 254; county: 'Zavala'),
          (state: 'UT'; idnum: 0; county: 'Utah'),
          (state: 'UT'; idnum: 1; county: 'Beaver'),
          (state: 'UT'; idnum: 2; county: 'Box Elder'),
          (state: 'UT'; idnum: 3; county: 'Cache'),
          (state: 'UT'; idnum: 4; county: 'Carbon'),
          (state: 'UT'; idnum: 5; county: 'Daggett'),
          (state: 'UT'; idnum: 6; county: 'Davis'),
          (state: 'UT'; idnum: 7; county: 'Duchesne'),
          (state: 'UT'; idnum: 8; county: 'Emery'),
          (state: 'UT'; idnum: 9; county: 'Garfield'),
          (state: 'UT'; idnum: 10; county: 'Grand'),
          (state: 'UT'; idnum: 11; county: 'Iron'),
          (state: 'UT'; idnum: 12; county: 'Juab'),
          (state: 'UT'; idnum: 13; county: 'Kane'),
          (state: 'UT'; idnum: 14; county: 'Millard'),
          (state: 'UT'; idnum: 15; county: 'Morgan'),
          (state: 'UT'; idnum: 16; county: 'Piute'),
          (state: 'UT'; idnum: 17; county: 'Rich'),
          (state: 'UT'; idnum: 18; county: 'Salt'),
          (state: 'UT'; idnum: 19; county: 'Lake'),
          (state: 'UT'; idnum: 20; county: 'San Juan'),
          (state: 'UT'; idnum: 21; county: 'Sanpete'),
          (state: 'UT'; idnum: 22; county: 'Sevier'),
          (state: 'UT'; idnum: 23; county: 'Summit'),
          (state: 'UT'; idnum: 24; county: 'Tooele'),
          (state: 'UT'; idnum: 25; county: 'Uintah'),
          (state: 'UT'; idnum: 26; county: 'Utah'),
          (state: 'UT'; idnum: 27; county: 'Wasatch'),
          (state: 'UT'; idnum: 28; county: 'Washington'),
          (state: 'UT'; idnum: 29; county: 'Wayne'),
          (state: 'UT'; idnum: 30; county: 'Weber'),
          (state: 'VA'; idnum: 0; county: 'Virginia'),
          (state: 'VA'; idnum: 1; county: 'Accomack'),
          (state: 'VA'; idnum: 2; county: 'Albemarle'),
          (state: 'VA'; idnum: 3; county: 'Alleghany'),
          (state: 'VA'; idnum: 4; county: 'Amelia'),
          (state: 'VA'; idnum: 5; county: 'Amherst'),
          (state: 'VA'; idnum: 6; county: 'Appomattox'),
          (state: 'VA'; idnum: 7; county: 'Arlington'),
          (state: 'VA'; idnum: 8; county: 'Augusta'),
          (state: 'VA'; idnum: 9; county: 'Bath'),
          (state: 'VA'; idnum: 10; county: 'Bedford'),
          (state: 'VA'; idnum: 11; county: 'Bland'),
          (state: 'VA'; idnum: 12; county: 'Botetourt'),
          (state: 'VA'; idnum: 13; county: 'Brunswick'),
          (state: 'VA'; idnum: 14; county: 'Buchanan'),
          (state: 'VA'; idnum: 15; county: 'Buckingham'),
          (state: 'VA'; idnum: 16; county: 'Campbell'),
          (state: 'VA'; idnum: 17; county: 'Caroline'),
          (state: 'VA'; idnum: 18; county: 'Carroll'),
          (state: 'VA'; idnum: 19; county: 'Charles City'),
          (state: 'VA'; idnum: 20; county: 'Charlotte'),
          (state: 'VA'; idnum: 21; county: 'Chesterfield'),
          (state: 'VA'; idnum: 22; county: 'Clarke'),
          (state: 'VA'; idnum: 23; county: 'Craig'),
          (state: 'VA'; idnum: 24; county: 'Culpeper'),
          (state: 'VA'; idnum: 25; county: 'Cumberland'),
          (state: 'VA'; idnum: 26; county: 'Dickenson'),
          (state: 'VA'; idnum: 27; county: 'Dinwiddie'),
          (state: 'VA'; idnum: 28; county: 'Essex'),
          (state: 'VA'; idnum: 29; county: 'Fairfax'),
          (state: 'VA'; idnum: 30; county: 'Fauquier'),
          (state: 'VA'; idnum: 31; county: 'Floyd'),
          (state: 'VA'; idnum: 32; county: 'Fluvanna'),
          (state: 'VA'; idnum: 33; county: 'Franklin'),
          (state: 'VA'; idnum: 34; county: 'Frederick'),
          (state: 'VA'; idnum: 35; county: 'Giles'),
          (state: 'VA'; idnum: 36; county: 'Gloucester'),
          (state: 'VA'; idnum: 37; county: 'Goochland'),
          (state: 'VA'; idnum: 38; county: 'Grayson'),
          (state: 'VA'; idnum: 39; county: 'Greene'),
          (state: 'VA'; idnum: 40; county: 'Greensville'),
          (state: 'VA'; idnum: 41; county: 'Halifax'),
          (state: 'VA'; idnum: 42; county: 'Hanover'),
          (state: 'VA'; idnum: 43; county: 'Henrico'),
          (state: 'VA'; idnum: 44; county: 'Henry'),
          (state: 'VA'; idnum: 45; county: 'Highland'),
          (state: 'VA'; idnum: 46; county: 'Isle of Wight'),
          (state: 'VA'; idnum: 47; county: 'James City'),
          (state: 'VA'; idnum: 48; county: 'King and Queen'),
          (state: 'VA'; idnum: 49; county: 'King George'),
          (state: 'VA'; idnum: 50; county: 'King William'),
          (state: 'VA'; idnum: 51; county: 'Lancaster'),
          (state: 'VA'; idnum: 52; county: 'Lee'),
          (state: 'VA'; idnum: 53; county: 'Loudoun'),
          (state: 'VA'; idnum: 54; county: 'Louisa'),
          (state: 'VA'; idnum: 55; county: 'Lunenburg'),
          (state: 'VA'; idnum: 56; county: 'Madison'),
          (state: 'VA'; idnum: 57; county: 'Mathews'),
          (state: 'VA'; idnum: 58; county: 'Mecklenburg'),
          (state: 'VA'; idnum: 59; county: 'Middlesex'),
          (state: 'VA'; idnum: 60; county: 'Montgomery'),
          (state: 'VA'; idnum: 61; county: 'Nelson'),
          (state: 'VA'; idnum: 62; county: 'New Kent'),
          (state: 'VA'; idnum: 63; county: 'Northampton'),
          (state: 'VA'; idnum: 64; county: 'Northumberland'),
          (state: 'VA'; idnum: 65; county: 'Nottoway'),
          (state: 'VA'; idnum: 66; county: 'Orange'),
          (state: 'VA'; idnum: 67; county: 'Page'),
          (state: 'VA'; idnum: 68; county: 'Patrick'),
          (state: 'VA'; idnum: 69; county: 'Pittsylvania'),
          (state: 'VA'; idnum: 70; county: 'Powhatan'),
          (state: 'VA'; idnum: 71; county: 'Prince Edward'),
          (state: 'VA'; idnum: 72; county: 'Prince George'),
          (state: 'VA'; idnum: 73; county: 'Prince William'),
          (state: 'VA'; idnum: 74; county: 'Pulaski'),
          (state: 'VA'; idnum: 75; county: 'Rappahannock'),
          (state: 'VA'; idnum: 76; county: 'Richmond'),
          (state: 'VA'; idnum: 77; county: 'Roanoke'),
          (state: 'VA'; idnum: 78; county: 'Rockbridge'),
          (state: 'VA'; idnum: 79; county: 'Rockingham'),
          (state: 'VA'; idnum: 80; county: 'Russell'),
          (state: 'VA'; idnum: 81; county: 'Scott'),
          (state: 'VA'; idnum: 82; county: 'Shenandoah'),
          (state: 'VA'; idnum: 83; county: 'Smyth'),
          (state: 'VA'; idnum: 84; county: 'Southampton'),
          (state: 'VA'; idnum: 85; county: 'Spotsylvania'),
          (state: 'VA'; idnum: 86; county: 'Stafford'),
          (state: 'VA'; idnum: 87; county: 'Surry'),
          (state: 'VA'; idnum: 88; county: 'Sussex'),
          (state: 'VA'; idnum: 89; county: 'Tazewell'),
          (state: 'VA'; idnum: 90; county: 'Warren'),
          (state: 'VA'; idnum: 91; county: 'Washington'),
          (state: 'VA'; idnum: 92; county: 'Westmoreland'),
          (state: 'VA'; idnum: 93; county: 'Wise'),
          (state: 'VA'; idnum: 94; county: 'Wythe'),
          (state: 'VA'; idnum: 95; county: 'York'),
          (state: 'VT'; idnum: 0; county: 'Vermont'),
          (state: 'VT'; idnum: 1; county: 'Addison'),
          (state: 'VT'; idnum: 2; county: 'Bennington'),
          (state: 'VT'; idnum: 3; county: 'Caledonia'),
          (state: 'VT'; idnum: 4; county: 'Chittenden'),
          (state: 'VT'; idnum: 5; county: 'Essex'),
          (state: 'VT'; idnum: 6; county: 'Franklin'),
          (state: 'VT'; idnum: 7; county: 'Grand Isle'),
          (state: 'VT'; idnum: 8; county: 'Lamoille'),
          (state: 'VT'; idnum: 9; county: 'Orange'),
          (state: 'VT'; idnum: 10; county: 'Orleans'),
          (state: 'VT'; idnum: 11; county: 'Rutland'),
          (state: 'VT'; idnum: 12; county: 'Washington'),
          (state: 'VT'; idnum: 13; county: 'Windham'),
          (state: 'VT'; idnum: 14; county: 'Windsor'),
          (state: 'WA'; idnum: 0; county: 'Washington'),
          (state: 'WA'; idnum: 1; county: 'Adams'),
          (state: 'WA'; idnum: 2; county: 'Asotin'),
          (state: 'WA'; idnum: 3; county: 'Benton'),
          (state: 'WA'; idnum: 4; county: 'Chelan'),
          (state: 'WA'; idnum: 5; county: 'Clallam'),
          (state: 'WA'; idnum: 6; county: 'Clark'),
          (state: 'WA'; idnum: 7; county: 'Columbia'),
          (state: 'WA'; idnum: 8; county: 'Cowlitz'),
          (state: 'WA'; idnum: 9; county: 'Douglas'),
          (state: 'WA'; idnum: 10; county: 'Ferry'),
          (state: 'WA'; idnum: 11; county: 'Franklin'),
          (state: 'WA'; idnum: 12; county: 'Garfield'),
          (state: 'WA'; idnum: 13; county: 'Grant'),
          (state: 'WA'; idnum: 14; county: 'Grays Harbor'),
          (state: 'WA'; idnum: 15; county: 'Island'),
          (state: 'WA'; idnum: 16; county: 'Jefferson'),
          (state: 'WA'; idnum: 17; county: 'King'),
          (state: 'WA'; idnum: 18; county: 'Kitsap'),
          (state: 'WA'; idnum: 19; county: 'Kittitas'),
          (state: 'WA'; idnum: 20; county: 'Klickitat'),
          (state: 'WA'; idnum: 21; county: 'Lewis'),
          (state: 'WA'; idnum: 22; county: 'Lincoln'),
          (state: 'WA'; idnum: 23; county: 'Mason'),
          (state: 'WA'; idnum: 24; county: 'Okanogan'),
          (state: 'WA'; idnum: 25; county: 'Pacific'),
          (state: 'WA'; idnum: 26; county: 'Pend Oreille'),
          (state: 'WA'; idnum: 27; county: 'Pierce'),
          (state: 'WA'; idnum: 28; county: 'San Juan'),
          (state: 'WA'; idnum: 29; county: 'Skagit'),
          (state: 'WA'; idnum: 30; county: 'Skamania'),
          (state: 'WA'; idnum: 31; county: 'Snohomish'),
          (state: 'WA'; idnum: 32; county: 'Spokane'),
          (state: 'WA'; idnum: 33; county: 'Stevens'),
          (state: 'WA'; idnum: 34; county: 'Thurston'),
          (state: 'WA'; idnum: 35; county: 'Wahkiakum'),
          (state: 'WA'; idnum: 36; county: 'Walla Walla'),
          (state: 'WA'; idnum: 37; county: 'Whatcom'),
          (state: 'WA'; idnum: 38; county: 'Whitman'),
          (state: 'WA'; idnum: 39; county: 'Yakima'),
          (state: 'WI'; idnum: 0; county: 'Wisconsin'),
          (state: 'WI'; idnum: 1; county: 'Adams'),
          (state: 'WI'; idnum: 2; county: 'Ashland'),
          (state: 'WI'; idnum: 3; county: 'Barron'),
          (state: 'WI'; idnum: 4; county: 'Bayfield'),
          (state: 'WI'; idnum: 5; county: 'Brown'),
          (state: 'WI'; idnum: 6; county: 'Buffalo'),
          (state: 'WI'; idnum: 7; county: 'Burnett'),
          (state: 'WI'; idnum: 8; county: 'Calumet'),
          (state: 'WI'; idnum: 9; county: 'Chippewa'),
          (state: 'WI'; idnum: 10; county: 'Clark'),
          (state: 'WI'; idnum: 11; county: 'Crawford'),
          (state: 'WI'; idnum: 12; county: 'Columbia'),
          (state: 'WI'; idnum: 13; county: 'Dane'),
          (state: 'WI'; idnum: 14; county: 'Dodge'),
          (state: 'WI'; idnum: 15; county: 'Door'),
          (state: 'WI'; idnum: 16; county: 'Douglas'),
          (state: 'WI'; idnum: 17; county: 'Dunn'),
          (state: 'WI'; idnum: 18; county: 'Eau Claire'),
          (state: 'WI'; idnum: 19; county: 'Florence'),
          (state: 'WI'; idnum: 20; county: 'Fond du Lac'),
          (state: 'WI'; idnum: 21; county: 'Forest'),
          (state: 'WI'; idnum: 22; county: 'Grant'),
          (state: 'WI'; idnum: 23; county: 'Green'),
          (state: 'WI'; idnum: 24; county: 'Green Lake'),
          (state: 'WI'; idnum: 25; county: 'Iowa'),
          (state: 'WI'; idnum: 26; county: 'Iron'),
          (state: 'WI'; idnum: 27; county: 'Jackson'),
          (state: 'WI'; idnum: 28; county: 'Jefferson'),
          (state: 'WI'; idnum: 29; county: 'Juneau'),
          (state: 'WI'; idnum: 30; county: 'Kenosha'),
          (state: 'WI'; idnum: 31; county: 'Kewaunee'),
          (state: 'WI'; idnum: 32; county: 'La Crosse'),
          (state: 'WI'; idnum: 33; county: 'Lafayette'),
          (state: 'WI'; idnum: 34; county: 'Langlade'),
          (state: 'WI'; idnum: 35; county: 'Lincoln'),
          (state: 'WI'; idnum: 36; county: 'Manitowoc'),
          (state: 'WI'; idnum: 37; county: 'Marathon'),
          (state: 'WI'; idnum: 38; county: 'Marinette'),
          (state: 'WI'; idnum: 39; county: 'Marquette'),
          (state: 'WI'; idnum: 40; county: 'Menominee'),
          (state: 'WI'; idnum: 41; county: 'Milwaukee'),
          (state: 'WI'; idnum: 42; county: 'Monroe'),
          (state: 'WI'; idnum: 43; county: 'Oconto'),
          (state: 'WI'; idnum: 44; county: 'Oneida'),
          (state: 'WI'; idnum: 45; county: 'Outagamie'),
          (state: 'WI'; idnum: 46; county: 'Ozaukee'),
          (state: 'WI'; idnum: 47; county: 'Pepin'),
          (state: 'WI'; idnum: 48; county: 'Pierce'),
          (state: 'WI'; idnum: 49; county: 'Polk'),
          (state: 'WI'; idnum: 50; county: 'Portage'),
          (state: 'WI'; idnum: 51; county: 'Price'),
          (state: 'WI'; idnum: 52; county: 'Racine'),
          (state: 'WI'; idnum: 53; county: 'Richland'),
          (state: 'WI'; idnum: 54; county: 'Rock'),
          (state: 'WI'; idnum: 55; county: 'Rusk'),
          (state: 'WI'; idnum: 56; county: 'Sauk'),
          (state: 'WI'; idnum: 57; county: 'Sawyer'),
          (state: 'WI'; idnum: 58; county: 'Shawano'),
          (state: 'WI'; idnum: 59; county: 'Sheboygan'),
          (state: 'WI'; idnum: 60; county: 'St. Croix'),
          (state: 'WI'; idnum: 61; county: 'Taylor'),
          (state: 'WI'; idnum: 62; county: 'Trempealeau'),
          (state: 'WI'; idnum: 63; county: 'Vernon'),
          (state: 'WI'; idnum: 64; county: 'Vilas'),
          (state: 'WI'; idnum: 65; county: 'Walworth'),
          (state: 'WI'; idnum: 66; county: 'Washburn'),
          (state: 'WI'; idnum: 67; county: 'Washington'),
          (state: 'WI'; idnum: 68; county: 'Waukesha'),
          (state: 'WI'; idnum: 69; county: 'Waupaca'),
          (state: 'WI'; idnum: 70; county: 'Waushara'),
          (state: 'WI'; idnum: 71; county: 'Winnebago'),
          (state: 'WI'; idnum: 72; county: 'Wood'),
          (state: 'WV'; idnum: 0; county: 'West Virginia'),
          (state: 'WV'; idnum: 1; county: 'Barbour'),
          (state: 'WV'; idnum: 2; county: 'Berkeley'),
          (state: 'WV'; idnum: 3; county: 'Boone'),
          (state: 'WV'; idnum: 4; county: 'Braxton'),
          (state: 'WV'; idnum: 5; county: 'Brooke'),
          (state: 'WV'; idnum: 6; county: 'Cabell'),
          (state: 'WV'; idnum: 7; county: 'Calhoun'),
          (state: 'WV'; idnum: 8; county: 'Clay'),
          (state: 'WV'; idnum: 9; county: 'Doddridge'),
          (state: 'WV'; idnum: 10; county: 'Fayette'),
          (state: 'WV'; idnum: 11; county: 'Gilmer'),
          (state: 'WV'; idnum: 12; county: 'Grant'),
          (state: 'WV'; idnum: 13; county: 'Greenbrier'),
          (state: 'WV'; idnum: 14; county: 'Hampshire'),
          (state: 'WV'; idnum: 15; county: 'Hancock'),
          (state: 'WV'; idnum: 16; county: 'Hardy'),
          (state: 'WV'; idnum: 17; county: 'Harrison'),
          (state: 'WV'; idnum: 18; county: 'Jackson'),
          (state: 'WV'; idnum: 19; county: 'Jefferson'),
          (state: 'WV'; idnum: 20; county: 'Kanawha'),
          (state: 'WV'; idnum: 21; county: 'Lewis'),
          (state: 'WV'; idnum: 22; county: 'Lincoln'),
          (state: 'WV'; idnum: 23; county: 'Logan'),
          (state: 'WV'; idnum: 24; county: 'Marion'),
          (state: 'WV'; idnum: 25; county: 'Marshall'),
          (state: 'WV'; idnum: 26; county: 'Mason'),
          (state: 'WV'; idnum: 27; county: 'McDowell'),
          (state: 'WV'; idnum: 28; county: 'Mercer'),
          (state: 'WV'; idnum: 29; county: 'Mineral'),
          (state: 'WV'; idnum: 30; county: 'Mingo'),
          (state: 'WV'; idnum: 31; county: 'Monongalia'),
          (state: 'WV'; idnum: 32; county: 'Monroe'),
          (state: 'WV'; idnum: 33; county: 'Morgan'),
          (state: 'WV'; idnum: 34; county: 'Nicholas'),
          (state: 'WV'; idnum: 35; county: 'Ohio'),
          (state: 'WV'; idnum: 36; county: 'Pendleton'),
          (state: 'WV'; idnum: 37; county: 'Pleasants'),
          (state: 'WV'; idnum: 38; county: 'Pocahontas'),
          (state: 'WV'; idnum: 39; county: 'Preston'),
          (state: 'WV'; idnum: 40; county: 'Putnam'),
          (state: 'WV'; idnum: 41; county: 'Raleigh'),
          (state: 'WV'; idnum: 42; county: 'Randolph'),
          (state: 'WV'; idnum: 43; county: 'Ritchie'),
          (state: 'WV'; idnum: 44; county: 'Roane'),
          (state: 'WV'; idnum: 45; county: 'Summers'),
          (state: 'WV'; idnum: 46; county: 'Taylor'),
          (state: 'WV'; idnum: 47; county: 'Tucker'),
          (state: 'WV'; idnum: 48; county: 'Tyler'),
          (state: 'WV'; idnum: 49; county: 'Upshur'),
          (state: 'WV'; idnum: 50; county: 'Wayne'),
          (state: 'WV'; idnum: 51; county: 'Webster'),
          (state: 'WV'; idnum: 52; county: 'Wetzel'),
          (state: 'WV'; idnum: 53; county: 'Wirt'),
          (state: 'WV'; idnum: 54; county: 'Wood'),
          (state: 'WV'; idnum: 55; county: 'Wyoming'),
          (state: 'WY'; idnum: 0; county: 'Wyoming'),
          (state: 'WY'; idnum: 1; county: 'Albany'),
          (state: 'WY'; idnum: 2; county: 'Big Horn'),
          (state: 'WY'; idnum: 3; county: 'Campbell'),
          (state: 'WY'; idnum: 4; county: 'Carbon'),
          (state: 'WY'; idnum: 5; county: 'Converse'),
          (state: 'WY'; idnum: 6; county: 'Crook'),
          (state: 'WY'; idnum: 7; county: 'Fremont'),
          (state: 'WY'; idnum: 8; county: 'Goshen'),
          (state: 'WY'; idnum: 9; county: 'Hot Springs'),
          (state: 'WY'; idnum: 10; county: 'Johnson'),
          (state: 'WY'; idnum: 11; county: 'Laramie'),
          (state: 'WY'; idnum: 12; county: 'Lincoln'),
          (state: 'WY'; idnum: 13; county: 'Natrona'),
          (state: 'WY'; idnum: 14; county: 'Niobrara'),
          (state: 'WY'; idnum: 15; county: 'Park'),
          (state: 'WY'; idnum: 16; county: 'Platte'),
          (state: 'WY'; idnum: 17; county: 'Sheridan'),
          (state: 'WY'; idnum: 18; county: 'Sublette'),
          (state: 'WY'; idnum: 19; county: 'Sweetwater'),
          (state: 'WY'; idnum: 20; county: 'Teton'),
          (state: 'WY'; idnum: 21; county: 'Uinta'),
          (state: 'WY'; idnum: 22; county: 'Washakie'),
          (state: 'WY'; idnum: 23; county: 'Weston'));

type
  TStatesAndCounties = class(TComponent)
  public
    function GetStates(aList: TStrings): boolean;
    function GetCounties(aState: string; aList: TStrings): boolean;
    function GetStateName(aState: string): string;
    function GetStateAbbrev(aState: string): string;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TStatesAndCounties]);
end;

function TStatesAndCounties.GetStates(aList: TStrings): boolean;
{ populates a TStrings with the list of all state abbreviations }
var
 i, c: integer;
begin
c := 0;
aList.Clear;
for i := 1 to SCRecordCount do with SCData[i] do
  begin
  if idnum = 0 then
    begin
    aList.Append(state);
    inc(c);
    end;
  end;
result := (c > 0);
end;

function TStatesAndCounties.GetCounties(aState: string; aList: TStrings): boolean;
{ populates a TStrings with the list of all counties for the specified state }
var
 i, c: integer;
begin
c := 0;
aList.Clear;
for i := 1 to SCRecordCount do with SCData[i] do
  begin
  if (state = aState) and (idnum > 0) then
    begin
    aList.Append(county);
    inc(c);
    end;
  end;
result := (c > 0);
end;

function TStatesAndCounties.GetStateName(aState: string): string;
{ returns state name from supplied abbreviation }
var
 i: integer;
begin
result := EmptyStr;
for i := 1 to SCRecordCount do with SCData[i] do
  begin
  if (state = aState) and (idnum = 0) then
    begin
    result := county;
    break;
    end;
  end;
end;

function TStatesAndCounties.GetStateAbbrev(aState: string): string;
{ returns state abbreviation from supplied state name }
var
 i: integer;
begin
result := EmptyStr;
for i := 1 to SCRecordCount do with SCData[i] do
  begin
  if (county = aState) and (idnum = 0) then
    begin
    result := state;
    break;
    end;
  end;
end;

end.
